#include "RTE_GPIO.h"
#include "TYW_stdint.h"
#include "GPIO.h"
#include "Simulated_8080.h"
#include "TM035HFZGZx.h"
#include "RTE_WDT.h"

void RTE_GPIO_SET_WakeUp(void)
{
    GPIO_Config_st_t gpio_temp;
    gpio_temp.enGPIOPort      = GPIO_PORT_GROUP_8;
    gpio_temp.enGPIOPIN       = GPIO_PIN_3;
    gpio_temp.enGPIODir       = GPIO_DIR_IN;
    gpio_temp.enGPIOCharacter = GPIO_Char_Schmitt4;
    gpio_temp.enGPIOMode      = GPIO_MODE_ALTER_SOFTWARE;
    gpio_temp.enGPIOAltFun    = GPIO_ALTER_FUN_3;

    GPIO_Config(&gpio_temp);

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_0;
    gpio_temp.enGPIOPIN    = GPIO_PIN_9;
    gpio_temp.enGPIOMode   = GPIO_MODE_ALTER_SOFTWARE;
    gpio_temp.enGPIODir    = GPIO_DIR_IN;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_5;
    GPIO_Config(&gpio_temp);

    STBC_WUF0WUFC0 = 0xFFFFFFFFUL;
    RESCTLRESFC    = 0X47FFUL;
}
/******************************************************************************
函数名：GPIO_30_Init
功   能：GPIO30初始化，设置GPIO输入/输出方向，初始值及上/下拉
参   数：无
返回值：无
******************************************************************************/
void RTE_GPIO_30_Init(void)
{
}

/******************************************************************************
函数名：RTE_GPIO_Sleep_Init
功   能：GPIOSleep初始化，设置GPIO输入/输出方向，初始值及上/下拉
参   数：无
返回值：无
******************************************************************************/
void RTE_GPIO_Sleep_Init(void)
{
    GPIO_Init(GPIO_SLEEP_MODE);
}

/******************************************************************************
函数名：RTE_GPIO_Wakeup_Init
功   能：唤醒初始化，设置GPIO输入/输出方向，初始值及上/下拉
参   数：无
返回值：无
******************************************************************************/
void RTE_GPIO_Wakeup_Init(void)
{
    GPIO_Init(GPIO_WAKEUP_MODE);
}

/******************************************************************************
函数名：RTE_GPIO_Init
功   能：GPIO初始化，设置GPIO输入/输出方向，初始值及上/下拉
参   数：无
返回值：无
******************************************************************************/
void RTE_GPIO_Init(void)
{
    GPIO_Config_st_t gpio_temp;

    GPIO_Init(GPIO_WAKEUP_MODE);

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_0;
    gpio_temp.enGPIOPIN    = GPIO_PIN_13;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);
    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_8;
    gpio_temp.enGPIOPIN    = GPIO_PIN_10;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);
    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_8;
    gpio_temp.enGPIOPIN    = GPIO_PIN_11;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);
    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_8;
    gpio_temp.enGPIOPIN    = GPIO_PIN_12;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);

    /*******************LiJianshuang 增加10个正控，10个负控的IO口初始化配置************************************/
    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_10;
    gpio_temp.enGPIOPIN    = GPIO_PIN_6;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--正控1

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_9;
    gpio_temp.enGPIOPIN    = GPIO_PIN_0;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--正控2

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_AP0;
    gpio_temp.enGPIOPIN    = GPIO_PIN_4;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--正控3

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_AP0;
    gpio_temp.enGPIOPIN    = GPIO_PIN_5;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--正控4

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_AP0;
    gpio_temp.enGPIOPIN    = GPIO_PIN_6;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--正控5

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_AP0;
    gpio_temp.enGPIOPIN    = GPIO_PIN_13;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--正控6

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_AP0;
    gpio_temp.enGPIOPIN    = GPIO_PIN_14;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--正控7

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_8;
    gpio_temp.enGPIOPIN    = GPIO_PIN_9;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--正控8

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_8;
    gpio_temp.enGPIOPIN    = GPIO_PIN_8;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--正控9

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_0;
    gpio_temp.enGPIOPIN    = GPIO_PIN_7;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--正控10

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_9;
    gpio_temp.enGPIOPIN    = GPIO_PIN_6;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--负控1

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_9;
    gpio_temp.enGPIOPIN    = GPIO_PIN_5;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--负控2

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_9;
    gpio_temp.enGPIOPIN    = GPIO_PIN_4;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--负控3

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_9;
    gpio_temp.enGPIOPIN    = GPIO_PIN_3;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--负控4

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_9;
    gpio_temp.enGPIOPIN    = GPIO_PIN_2;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--负控5

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_9;
    gpio_temp.enGPIOPIN    = GPIO_PIN_1;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--负控6

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_10;
    gpio_temp.enGPIOPIN    = GPIO_PIN_7;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--负控7

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_10;
    gpio_temp.enGPIOPIN    = GPIO_PIN_3;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--负控8

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_10;
    gpio_temp.enGPIOPIN    = GPIO_PIN_4;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--负控9

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_0;
    gpio_temp.enGPIOPIN    = GPIO_PIN_8;
    gpio_temp.enGPIOMode   = GPIO_MODE_PORT;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&gpio_temp);//--负控10

 /*******************增加2个PWM输出的初始化配置************************************/
    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_0;
    gpio_temp.enGPIOPIN    = GPIO_PIN_12;
    gpio_temp.enGPIOMode   = GPIO_MODE_ALTER_SOFTWARE;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_3;
    gpio_temp.enGPIOCharacter = GPIO_Char_Schmitt1;
    GPIO_Config(&gpio_temp);//转速

    gpio_temp.enGPIOPort   = GPIO_PORT_GROUP_0;
    gpio_temp.enGPIOPIN    = GPIO_PIN_14;
    gpio_temp.enGPIOMode   = GPIO_MODE_ALTER_SOFTWARE;
    gpio_temp.enGPIODir    = GPIO_DIR_OUT;
    gpio_temp.enGPIOAltFun = GPIO_ALTER_FUN_3;
    gpio_temp.enGPIOCharacter = GPIO_Char_Schmitt1;
    GPIO_Config(&gpio_temp);//车速
}
