

#include "r_typedefs.h"
#include "dr7f701684.dvf.h"

/*-----------------use for RH850_F1KM_S1 --------------------*/
#include "rh850_macros.h"
#include "RSCAN.h"
#include "RSCAN_Table.h"

#define RSCAN_CKSCLK_IPERI2_CLKC 40000000UL		   /*PPLLCLK2*/
#define RSCAN_CKSCLK_ICANOSC_CLK_XIN_CAN 8000000UL /*MainOSC*/
#define RSCAN_F_CAN RSCAN_CKSCLK_IPERI2_CLKC

#define RSCAN0_BASE_ADDRESS 0xFFD00000UL

/*********************************************************/
/*--------------500K-----------------------------*/
#define RSCAN0_500K_BAUD_RATE 500U //波特率,单位kbps
#define RSCAN0_500K_T_SEG1 31U	   //时间段1的Tq数
#define RSCAN0_500K_T_SEG2 8U	   //时间段2的Tq数
#define RSCAN0_500K_SJW 1U		   //同步跳转宽度

#define RSCAN_500K_BIT_RATE_DIV (RSCAN_F_CAN / (RSCAN0_500K_BAUD_RATE) / (RSCAN0_500K_T_SEG1 + RSCAN0_500K_T_SEG2 + 1UL) / 1000UL)

/*-----------------250K---------------------------------*/
#define RSCAN0_250K_BAUD_RATE 250U //波特率,单位kbps
#define RSCAN0_250K_T_SEG1 127U	   //时间段1的Tq数
#define RSCAN0_250K_T_SEG2 32U	   //时间段2的Tq数
#define RSCAN0_250K_SJW 3U

#define RSCAN_250K_BIT_RATE_DIV (RSCAN_F_CAN / (RSCAN0_250K_BAUD_RATE) / (RSCAN0_250K_T_SEG1 + RSCAN0_250K_T_SEG2 + 1UL) / 1000UL)

/*-----------------125K---------------------------------*/
#define RSCAN0_125K_BAUD_RATE 125U //波特率,单位kbps
#define RSCAN0_125K_T_SEG1 127U	   //时间段1的Tq数
#define RSCAN0_125K_T_SEG2 32U	   //时间段2的Tq数
#define RSCAN0_125K_SJW 3U

#define RSCAN_125K_BIT_RATE_DIV (RSCAN_F_CAN / (RSCAN0_125K_BAUD_RATE) / (RSCAN0_125K_T_SEG1 + RSCAN0_125K_T_SEG2 + 1UL) / 1000UL)
/*------------------------------------------------*/

/*-----------------2M---------------------------------*/
#define RSCAN0_2M_BAUD_RATE 2000U //波特率,单位kbps
#define RSCAN0_2M_T_SEG1 13U	  //时间段1的Tq数
#define RSCAN0_2M_T_SEG2 6U		  //时间段2的Tq数
#define RSCAN0_2M_SJW 1U

#define RSCAN_2M_BIT_RATE_DIV (RSCAN_F_CAN / (RSCAN0_2M_BAUD_RATE) / (RSCAN0_2M_T_SEG1 + RSCAN0_2M_T_SEG2 + 1UL) / 1000UL)

/*-----------------5M---------------------------------*/
#define RSCAN0_5M_BAUD_RATE 5000U //波特率,单位kbps
#define RSCAN0_5M_T_SEG1 5U		  //时间段1的Tq数
#define RSCAN0_5M_T_SEG2 2U		  //时间段2的Tq数
#define RSCAN0_5M_SJW 1U

#define RSCAN_5M_BIT_RATE_DIV (RSCAN_F_CAN / (RSCAN0_5M_BAUD_RATE) / (RSCAN0_5M_T_SEG1 + RSCAN0_5M_T_SEG2 + 1UL) / 1000UL)
/*------------------------------------------------*/

#if ((RSCAN0_500K_T_SEG2 < 2U) || (RSCAN0_250K_T_SEG2 < 2U) || (RSCAN0_125K_T_SEG2 < 2U) || (RSCAN0_500K_T_SEG2 > 32U) || (RSCAN0_250K_T_SEG2 > 32U) || (RSCAN0_125K_T_SEG2 > 32U))
#error RSCAN0 Time Segment 2 error!!!
#endif
#if ((RSCAN0_500K_T_SEG1 < 4U) || (RSCAN0_250K_T_SEG1 < 4U) || (RSCAN0_125K_T_SEG1 < 4U) || (RSCAN0_500K_T_SEG1 > 128U) || (RSCAN0_250K_T_SEG1 > 128U) || (RSCAN0_125K_T_SEG1 > 128U))
#error RSCAN0 Time Segment 1 error!!!
#endif
#if ((RSCAN0_500K_SJW < 1U) || (RSCAN0_250K_SJW < 1U) || (RSCAN0_125K_SJW < 1U) || (RSCAN0_500K_SJW > 32U) || (RSCAN0_250K_SJW > 32U) || (RSCAN0_125K_SJW > 32U))
#error RSCAN0 Resynchronization Jump Width error!!!
#endif
#if ((RSCAN_500K_BIT_RATE_DIV < 1U) || (RSCAN_250K_BIT_RATE_DIV < 1U) || (RSCAN_125K_BIT_RATE_DIV < 1U) || (RSCAN_500K_BIT_RATE_DIV > 1024U) || (RSCAN_250K_BIT_RATE_DIV > 1024U) || (RSCAN_125K_BIT_RATE_DIV > 1024U))
#error RSCAN0 Communication speed  error!!!
#endif

#if ((RSCAN0_2M_T_SEG2 < 2U) || (RSCAN0_5M_T_SEG2 < 2U) || (RSCAN0_2M_T_SEG2 > 8U) || (RSCAN0_5M_T_SEG2 > 8U))
#error RSCAN0 Time Segment 2 error!!!
#endif
#if ((RSCAN0_2M_T_SEG1 < 2U) || (RSCAN0_5M_T_SEG1 < 2U) || (RSCAN0_2M_T_SEG1 > 16U) || (RSCAN0_5M_T_SEG1 > 16U))
#error RSCAN0 Time Segment 1 error!!!
#endif
#if ((RSCAN0_2M_SJW < 1U) || (RSCAN0_5M_SJW < 1U) || (RSCAN0_2M_SJW > 8U) || (RSCAN0_5M_SJW > 8U))
#error RSCAN0 Resynchronization Jump Width error!!!
#endif
#if ((RSCAN_2M_BIT_RATE_DIV < 1U) || (RSCAN_5M_BIT_RATE_DIV < 1U) || (RSCAN_2M_BIT_RATE_DIV > 256U) || (RSCAN_5M_BIT_RATE_DIV > 256U))
#error RSCAN0 Communication speed  error!!!
#endif
#if (((RSCAN_2M_BIT_RATE_DIV != 1U) && (RSCAN_2M_BIT_RATE_DIV != 2)) || ((RSCAN_5M_BIT_RATE_DIV != 1U) && (RSCAN_5M_BIT_RATE_DIV != 2)))
#error RSCAN0 Communication speed  error!!!
#endif

/*---------------------------------------*/

#define RSCAN_TIME_OUT_MAX 0X0000FFFFUL

/*---------------------------------------*/

/***************************************************/
/**COMPLETE**/
#define RSCAN_ABORT_CPLT_AND 0X06U
#define RSCAN_ABORT_CPLT 0X02U
#define RSCAN_TX_CPLT_AND 0X04U
#define RSCAN_TX_CPLT 0X04U
/***************************************************/

/*RCFDC0CFDGCFG*/
/*CMPOC*/
#define RSCAN_OVERFLOW_NO_STORED (0U << 5U)
#define RSCAN_OVERFLOW_STORED (1U << 5U)
/*DCS*/
#define RSCAN_CLOCK_SOURCE_CLKC (0U << 4U)
#define RSCAN_CLOCK_SOURCE_CLK_XINCAN (1U << 4U)
/*TPRI*/
#define RSCAN_TX_PRIORITY_ID (0U)
#define RSCAN_TX_PRIORITY_BUFFER_NUM (1U)

/*RCFDC0CFDC0NCFG*/
#define RSCAN_500K_NTSEG2 ((RSCAN0_500K_T_SEG2 - 1U) << 24U)
#define RSCAN_500K_NTSEG1 ((RSCAN0_500K_T_SEG1 - 1U) << 16U)
#define RSCAN_500K_NSJW ((RSCAN0_500K_SJW - 1U) << 11U)
#define RSCAN_500K_NBRP (RSCAN_500K_BIT_RATE_DIV - 1U)

#define RSCAN_250K_NTSEG2 ((RSCAN0_250K_T_SEG2 - 1U) << 24U)
#define RSCAN_250K_NTSEG1 ((RSCAN0_250K_T_SEG1 - 1U) << 16U)
#define RSCAN_250K_NSJW ((RSCAN0_250K_SJW - 1U) << 11U)
#define RSCAN_250K_NBRP (RSCAN_250K_BIT_RATE_DIV - 1U)

#define RSCAN_125K_NTSEG2 ((RSCAN0_125K_T_SEG2 - 1U) << 24U)
#define RSCAN_125K_NTSEG1 ((RSCAN0_125K_T_SEG1 - 1U) << 16U)
#define RSCAN_125K_NSJW ((RSCAN0_125K_SJW - 1U) << 11U)
#define RSCAN_125K_NBRP (RSCAN_125K_BIT_RATE_DIV - 1U)

/**RCFDC0CFDC0DCFG**/
#define RSCAN_2M_NTSEG2 ((RSCAN0_2M_T_SEG2 - 1U) << 20U)
#define RSCAN_2M_NTSEG1 ((RSCAN0_2M_T_SEG1 - 1U) << 16U)
#define RSCAN_2M_NSJW ((RSCAN0_2M_SJW - 1U) << 24U)
#define RSCAN_2M_NBRP (RSCAN_2M_BIT_RATE_DIV - 1U)

#define RSCAN_5M_NTSEG2 ((RSCAN0_5M_T_SEG2 - 1U) << 20U)
#define RSCAN_5M_NTSEG1 ((RSCAN0_5M_T_SEG1 - 1U) << 16U)
#define RSCAN_5M_NSJW ((RSCAN0_5M_SJW - 1U) << 24U)
#define RSCAN_5M_NBRP (RSCAN_5M_BIT_RATE_DIV - 1U)

/*RCFDCnCFDCFCCk*/

/*Transmit/Receive FIFO Buffer Depth Configuration*/
#define RSCAN_TR_FIFO_DEPTH_0 (0UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_4 (1UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_8 (2UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_16 (3UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_32 (4UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_48 (5UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_64 (6UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_128 (7UL << 21UL)
/*Transmit/Receive FIFO Mode Select*/
#define RSCAN_TR_FIFO_MODE_RX (0UL << 8UL)
#define RSCAN_TR_FIFO_MODE_TX (1UL << 8UL)
/*Transmit/Receive FIFO Transmit Interrupt Enable*/
#define RSCAN_TR_FIFO_TX_INT_DIS (0UL << 2UL)
#define RSCAN_TR_FIFO_TX_INT_EN (1UL << 2UL)
/*Transmit/Receive FIFO Receive Interrupt Enable*/
#define RSCAN_TR_FIFO_RX_INT_DIS (0UL << 1UL)
#define RSCAN_TR_FIFO_RX_INT_EN (1UL << 1UL)
/*Transmit/Receive FIFO Buffer Enable*/
#define RSCAN_TR_FIFO_DIS (0UL)
#define RSCAN_TR_FIFO_EN (1UL)

/*RCFDCnCFDCmCTR*/
/*Transmit Abort Interrupt Enable*/
#define RSCAN_ABORT_INT_DIS (0UL << 16U)
#define RSCAN_ABORT_INT_EN (1UL << 16U)
/*Bus Off Recovery Mode Select*/
#define RSCAN_RECOVER_11898 (0UL << 21U)
#define RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_ENTRY (1UL << 21U)
#define RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END (1UL << 21U)
#define RSCAN_RECOVER_ENTRY_HALT_BY_PROGRAM_REQUEST (1UL << 21U)

/*RCFDCnCFDCmFDCFG*/

typedef struct
{

	/*具体接收内容*/
	CAN_Frame_st_t stReceiveContent;
	/*是否接收到新数据
    0：数据没有更新
    1：接收到新数据，已更新*/
	uint8_t u8CANReceiveStatus;

} CAN_Frame_Receive_st_t;

/*------------------------------------------------------------*/
RSCAN0_Config_st_t g_stRSCAN0Config;
/*------------------------------------------------------------*/

static uint32_t RSCAN0_CH_Baud_Rate_Cal(RSCAN_Channel_Config_st_t *pstRSCANChannelConfig)
{
	uint32_t u32RegisterBuf = 0UL;
	if (pstRSCANChannelConfig->enRSCANChMode)
	{
		if (pstRSCANChannelConfig->enRSCANChBps == RSCAN_Baud_Rate_500K)
		{
			u32RegisterBuf = (RSCAN_500K_NTSEG2 | RSCAN_500K_NTSEG1 | RSCAN_500K_NSJW | RSCAN_500K_NBRP);
		}
		else if (pstRSCANChannelConfig->enRSCANChBps == RSCAN_Baud_Rate_250K)
		{
			u32RegisterBuf = (RSCAN_250K_NTSEG2 | RSCAN_250K_NTSEG1 | RSCAN_250K_NSJW | RSCAN_250K_NBRP);
		}
		else if (pstRSCANChannelConfig->enRSCANChBps == RSCAN_Baud_Rate_125K)
		{
			u32RegisterBuf = (RSCAN_125K_NTSEG2 | RSCAN_125K_NTSEG1 | RSCAN_125K_NSJW | RSCAN_125K_NBRP);
		}
	}

	return u32RegisterBuf;
}

static uint32_t RSCAN0FD_CH_Baud_Rate_Cal(RSCAN_Channel_Config_st_t *pstRSCANChannelConfig)
{
	uint32_t u32RegisterBuf = 0UL;
	if (pstRSCANChannelConfig->enRSCANChMode == RSCAN_MODE_CANFD)
	{
		if (pstRSCANChannelConfig->enRSCANFDChBps == RSCANFD_Baud_Rate_2M)
		{
			u32RegisterBuf = (RSCAN_2M_NTSEG2 | RSCAN_2M_NTSEG1 | RSCAN_2M_NSJW | RSCAN_2M_NBRP);
		}
		else if (pstRSCANChannelConfig->enRSCANFDChBps == RSCANFD_Baud_Rate_5M)
		{
			u32RegisterBuf = (RSCAN_5M_NTSEG2 | RSCAN_5M_NTSEG1 | RSCAN_5M_NSJW | RSCAN_5M_NBRP);
		}
	}

	return u32RegisterBuf;
}

static uint32_t RSCAN0FD_CH_Compensation_Offset(RSCAN_Channel_Config_st_t *pstRSCANChannelConfig)
{
	uint32_t u32RegisterBuf = 0UL;
	if (pstRSCANChannelConfig->enRSCANChMode == RSCAN_MODE_CANFD)
	{
		if (pstRSCANChannelConfig->enRSCANFDChBps == RSCANFD_Baud_Rate_2M)
		{
			u32RegisterBuf = (0x200UL | (RSCAN0_2M_T_SEG1 << 16U));
		}
		else if (pstRSCANChannelConfig->enRSCANFDChBps == RSCANFD_Baud_Rate_5M)
		{
			u32RegisterBuf = (0x200UL | (RSCAN0_5M_T_SEG1 << 16U));
		}
	}

	return u32RegisterBuf;
}

RSCAN_InitState_en_t RSCAN0_CH_Init(const RSCANFD_Filter_st_t pstRSCANFilter[], RSCAN0_Config_st_t *pstRSCANConfig)
{
	uint32_t i = 0UL;
	uint8_t j = 0UL;
	uint32_t u32CANFDCalBuf = 0UL;
	RSCAN_InitState_en_t enInitStatus = RSCAN_INIT_COMPLETE;
	uint32_t u32RSCANChannelRuleTotal = 0UL;
	uint32_t u32RSCANTimeCount = 0UL;

	volatile RSCANFD_Filter_st_t *pstCANFDRule;

	if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
	{
		if (pstRSCANConfig->stRSCANCh0.u32RSCANChRuleSize > 255)
		{
			enInitStatus = RSCAN_INIT_ERROR_PARAMETER;
		}
	}
	if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
	{
		if (pstRSCANConfig->stRSCANCh1.u32RSCANChRuleSize > 255)
		{
			enInitStatus = RSCAN_INIT_ERROR_PARAMETER;
		}
	}
	if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
	{
		if (pstRSCANConfig->stRSCANCh2.u32RSCANChRuleSize > 255)
		{
			enInitStatus = RSCAN_INIT_ERROR_PARAMETER;
		}
	}
	if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
	{
		if (pstRSCANConfig->stRSCANCh3.u32RSCANChRuleSize > 255)
		{
			enInitStatus = RSCAN_INIT_ERROR_PARAMETER;
		}
	}
	if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
	{
		if (pstRSCANConfig->stRSCANCh4.u32RSCANChRuleSize > 255)
		{
			enInitStatus = RSCAN_INIT_ERROR_PARAMETER;
		}
	}
	if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
	{
		if (pstRSCANConfig->stRSCANCh5.u32RSCANChRuleSize > 255)
		{
			enInitStatus = RSCAN_INIT_ERROR_PARAMETER;
		}
	}
	if (enInitStatus == RSCAN_INIT_COMPLETE)
	{
		u32RSCANChannelRuleTotal = pstRSCANConfig->stRSCANCh0.u32RSCANChRuleSize + pstRSCANConfig->stRSCANCh1.u32RSCANChRuleSize + pstRSCANConfig->stRSCANCh2.u32RSCANChRuleSize + pstRSCANConfig->stRSCANCh3.u32RSCANChRuleSize + pstRSCANConfig->stRSCANCh4.u32RSCANChRuleSize + pstRSCANConfig->stRSCANCh5.u32RSCANChRuleSize;
		if (u32RSCANChannelRuleTotal > 1024)
		{
			enInitStatus = RSCAN_INIT_ERROR_PARAMETER;
		}
	}

	if (enInitStatus == RSCAN_INIT_COMPLETE)
	{
		/* Waiting for CAN RAM initialization is completed */
		u32RSCANTimeCount = 0UL;
		while ((RCFDC0CFDGSTS & 0x08UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
		{
			u32RSCANTimeCount++;
		}
		if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
		{
			enInitStatus = RSCAN_INIT_ERROR;
		}
		/* Waiting for CAN entry global reset mdoe */
		RCFDC0CFDGCTR &= 0xfffffff9UL;
		RCFDC0CFDGCTR |= 0x01UL;

		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDGSTS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
		{
			u32RSCANTimeCount++;
		}
		if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
		{
			enInitStatus = RSCAN_INIT_ERROR;
		}
		/* Waiting for CAN entry channel reset mdoe */
		/*CAN0   CHANNEL 0*/
		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
		{
			RCFDC0CFDC0CTR &= 0xfffffff9UL;
			RCFDC0CFDC0CTR |= 0x01UL;
		}
		/*CAN0   CHANNEL 1*/
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
		{
			RCFDC0CFDC1CTR &= 0xfffffff9UL;
			RCFDC0CFDC1CTR |= 0x01UL;
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
		{
			RCFDC0CFDC2CTR &= 0xfffffff9UL;
			RCFDC0CFDC2CTR |= 0x01UL;
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
		{
			RCFDC0CFDC3CTR &= 0xfffffff9UL;
			RCFDC0CFDC3CTR |= 0x01UL;
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
		{
			RCFDC0CFDC4CTR &= 0xfffffff9UL;
			RCFDC0CFDC4CTR |= 0x01UL;
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
		{
			RCFDC0CFDC5CTR &= 0xfffffff9UL;
			RCFDC0CFDC5CTR |= 0x01UL;
		}

		/*  waiting */
		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC0STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_0;
			}
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC1STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_1;
			}
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC2STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_2;
			}
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC3STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_3;
			}
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC4STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_4;
			}
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC5STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_5;
			}
		}

		/* Select the channel mode */
		RCFDC0CFDC0FDCFG = 0UL;
		RCFDC0CFDC1FDCFG = 0UL;
		RCFDC0CFDC2FDCFG = 0UL;
		RCFDC0CFDC3FDCFG = 0UL;
		RCFDC0CFDC4FDCFG = 0UL;
		RCFDC0CFDC5FDCFG = 0UL;

		/* Global Configuration Register*/
		RCFDC0CFDGCFG = (RSCAN_OVERFLOW_NO_STORED | RSCAN_CLOCK_SOURCE_CLKC | RSCAN_TX_PRIORITY_ID);

		/*Channel Nominal Bit Rate Configuration Register*/

		RCFDC0CFDC0NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh0));
		RCFDC0CFDC1NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh1));
		RCFDC0CFDC2NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh2));
		RCFDC0CFDC3NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh3));
		RCFDC0CFDC4NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh4));
		RCFDC0CFDC5NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh5));

		RCFDC0CFDC0DCFG = RSCAN0FD_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh0));
		RCFDC0CFDC1DCFG = RSCAN0FD_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh1));
		RCFDC0CFDC2DCFG = RSCAN0FD_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh2));
		RCFDC0CFDC3DCFG = RSCAN0FD_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh3));
		RCFDC0CFDC4DCFG = RSCAN0FD_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh4));
		RCFDC0CFDC5DCFG = RSCAN0FD_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh5));

		/*-------Receive rule setting----*/

		pstCANFDRule = (volatile RSCANFD_Filter_st_t *)(&(RCFDC0CFDGAFLID0));

		/*Receive Rule Configuration Register */
		RCFDC0CFDGAFLCFG0 = 0UL;
		RCFDC0CFDGAFLCFG1 = 0UL;

		u32CANFDCalBuf = 0UL;

		u32CANFDCalBuf |= (uint32_t)(pstRSCANConfig->stRSCANCh0.u32RSCANChRuleSize << 24U); /* Channel0 Filter num */
		u32CANFDCalBuf |= (uint32_t)(pstRSCANConfig->stRSCANCh1.u32RSCANChRuleSize << 16U); /* Channel1 Filter num */
		u32CANFDCalBuf |= (uint32_t)(pstRSCANConfig->stRSCANCh2.u32RSCANChRuleSize << 8U);	/* Channel2 Filter num */
		u32CANFDCalBuf |= (uint32_t)(pstRSCANConfig->stRSCANCh3.u32RSCANChRuleSize << 0U);	/* Channel3 Filter num */

		RCFDC0CFDGAFLCFG0 = u32CANFDCalBuf;

		u32CANFDCalBuf = 0UL;
		u32CANFDCalBuf |= (uint32_t)(pstRSCANConfig->stRSCANCh4.u32RSCANChRuleSize << 24U); /* Channel4 Filter num */
		u32CANFDCalBuf |= (uint32_t)(pstRSCANConfig->stRSCANCh5.u32RSCANChRuleSize << 16U); /* Channel5 Filter num */
		u32CANFDCalBuf |= (uint32_t)(0UL << 8U);											/* Channel6 Filter num */
		u32CANFDCalBuf |= (uint32_t)(0UL << 0U);											/* Channel7 Filter num */

		RCFDC0CFDGAFLCFG1 = u32CANFDCalBuf;

		/*Receive Rule Entry Control Register*/
		RCFDC0CFDGAFLECTR |= 0x00000100UL; /* Enable receive rule */

		for (i = 0UL; i < u32RSCANChannelRuleTotal; i++)
		{
			j = (uint8_t)(i & 0x0FUL);
			if (j == 0UL)
			{
				RCFDC0CFDGAFLECTRLL = (i >> 4U); /* Configuration Page  AFLPN[5:0]*/
			}
			pstCANFDRule[j] = pstRSCANFilter[i];
		}
		/*disable writing data to the receive rule table.*/
		RCFDC0CFDGAFLECTR &= 0xFFFFFEFFUL;

		/*-------Buffer setting----*/
		/*receive buffer*/
		RCFDC0CFDRMNB = 0x00UL; /*no use*/
		/*receive FIFO buffer*/
		RCFDC0CFDRFCC0 = 0x00UL; /*no use*/
		RCFDC0CFDRFCC1 = 0x00UL;
		RCFDC0CFDRFCC2 = 0x00UL;
		RCFDC0CFDRFCC3 = 0x00UL;
		RCFDC0CFDRFCC4 = 0x00UL;
		RCFDC0CFDRFCC5 = 0x00UL;
		RCFDC0CFDRFCC6 = 0x00UL;
		RCFDC0CFDRFCC7 = 0x00UL;

		/*transmit/receive FIFO buffer*/
		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
		{
			RCFDC0CFDCFCC0 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC1 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC2 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1070UL | RSCAN_TR_FIFO_MODE_RX);
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
		{
			RCFDC0CFDCFCC3 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC4 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC5 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1070UL | RSCAN_TR_FIFO_MODE_RX);
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
		{
			RCFDC0CFDCFCC6 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC7 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC8 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1070UL | RSCAN_TR_FIFO_MODE_RX);
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
		{
			RCFDC0CFDCFCC9 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC10 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC11 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1070UL | RSCAN_TR_FIFO_MODE_RX);
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
		{
			RCFDC0CFDCFCC12 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC13 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC14 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1070UL | RSCAN_TR_FIFO_MODE_RX);
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
		{
			RCFDC0CFDCFCC15 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC16 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1070UL | RSCAN_TR_FIFO_MODE_TX);

			RCFDC0CFDCFCC17 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1070UL | RSCAN_TR_FIFO_MODE_RX);
		}

		/* transmit queue*/
		RCFDC0CFDTXQCC0 = 0UL; /*no use*/
		RCFDC0CFDTXQCC1 = 0UL;
		RCFDC0CFDTXQCC2 = 0UL;
		RCFDC0CFDTXQCC3 = 0UL;
		RCFDC0CFDTXQCC4 = 0UL;
		RCFDC0CFDTXQCC5 = 0UL;
		RCFDC0CFDTXQCC6 = 0UL;
		RCFDC0CFDTXQCC7 = 0UL;

		/*transmit history buffer*/
		RCFDC0CFDTHLCC0 = 0UL; /*no use*/
		RCFDC0CFDTHLCC1 = 0UL;
		RCFDC0CFDTHLCC2 = 0UL;
		RCFDC0CFDTHLCC3 = 0UL;
		RCFDC0CFDTHLCC4 = 0UL;
		RCFDC0CFDTHLCC5 = 0UL;

		/*Enable interrupt of buffer to be used*/
		/*transmit/receive FIFO */
		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
		{
			RCFDC0CFDCFCC0 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC1 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC2 |= RSCAN_TR_FIFO_RX_INT_EN;
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
		{
			RCFDC0CFDCFCC3 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC4 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC5 |= RSCAN_TR_FIFO_RX_INT_EN;
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
		{
			RCFDC0CFDCFCC6 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC7 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC8 |= RSCAN_TR_FIFO_RX_INT_EN;
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
		{
			RCFDC0CFDCFCC9 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC10 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC11 |= RSCAN_TR_FIFO_RX_INT_EN;
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
		{
			RCFDC0CFDCFCC12 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC13 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC14 |= RSCAN_TR_FIFO_RX_INT_EN;
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
		{
			RCFDC0CFDCFCC15 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC16 |= RSCAN_TR_FIFO_TX_INT_EN;
			RCFDC0CFDCFCC17 |= RSCAN_TR_FIFO_RX_INT_EN;
		}
		/** transmit abort interrupts**/
		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
		{
			RCFDC0CFDC0CTR |= RSCAN_ABORT_INT_EN;
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
		{
			RCFDC0CFDC1CTR |= RSCAN_ABORT_INT_EN;
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
		{
			RCFDC0CFDC2CTR |= RSCAN_ABORT_INT_EN;
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
		{
			RCFDC0CFDC3CTR |= RSCAN_ABORT_INT_EN;
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
		{
			RCFDC0CFDC4CTR |= RSCAN_ABORT_INT_EN;
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
		{
			RCFDC0CFDC5CTR |= RSCAN_ABORT_INT_EN;
		}

		/* transmit complete interrupts */
		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
		{
			RCFDC0CFDTMIEC0 = 0xFFFFFFFFUL;
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
		{
			RCFDC0CFDTMIEC1 = 0xFFFFFFFFUL;
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
		{
			RCFDC0CFDTMIEC2 = 0xFFFFFFFFUL;
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
		{
			RCFDC0CFDTMIEC3 = 0xFFFFFFFFUL;
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
		{
			RCFDC0CFDTMIEC4 = 0xFFFFFFFFUL;
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
		{
			RCFDC0CFDTMIEC5 = 0xFFFFFFFFUL;
		}

		/*Global interrupt*/
		/*	RCFDC0CFDGCTR = 0UL;*/

		/*Channel interrupt, bus off recovery, error indication*/
		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
		{
			RCFDC0CFDC0CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
		{
			RCFDC0CFDC1CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
		{
			RCFDC0CFDC2CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
		{
			RCFDC0CFDC3CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
		{
			RCFDC0CFDC4CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
		{
			RCFDC0CFDC5CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
		}

		/*Gateway, transmitter delay compensation, error state display, error occurrence counter*/

		RCFDC0CFDC0FDCFG = RSCAN0FD_CH_Compensation_Offset(&(pstRSCANConfig->stRSCANCh0));
		RCFDC0CFDC1FDCFG = RSCAN0FD_CH_Compensation_Offset(&(pstRSCANConfig->stRSCANCh1));
		RCFDC0CFDC2FDCFG = RSCAN0FD_CH_Compensation_Offset(&(pstRSCANConfig->stRSCANCh2));
		RCFDC0CFDC3FDCFG = RSCAN0FD_CH_Compensation_Offset(&(pstRSCANConfig->stRSCANCh3));
		RCFDC0CFDC4FDCFG = RSCAN0FD_CH_Compensation_Offset(&(pstRSCANConfig->stRSCANCh4));
		RCFDC0CFDC5FDCFG = RSCAN0FD_CH_Compensation_Offset(&(pstRSCANConfig->stRSCANCh5));

		/*Interrupt control register of interrupt controller*/

		//INTC1ICRCANGRECC0 = 0X4FUL;
		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
		{
			peripheral_IRQ_enable(INTRCAN0REC);
			peripheral_IRQ_enable(INTRCAN0TRX);
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
		{
			peripheral_IRQ_enable(INTRCAN1REC);
			peripheral_IRQ_enable(INTRCAN1TRX);
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
		{
			peripheral_IRQ_enable(INTRCAN2REC);
			peripheral_IRQ_enable(INTRCAN2TRX);
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
		{
			peripheral_IRQ_enable(INTRCAN3REC);
			peripheral_IRQ_enable(INTRCAN3TRX);
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
		{
			peripheral_IRQ_enable(INTRCAN4REC);
			peripheral_IRQ_enable(INTRCAN4TRX);
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
		{
			peripheral_IRQ_enable(INTRCAN5REC);
			peripheral_IRQ_enable(INTRCAN5TRX);
		}

		/*Transition to global operating mode*/
		RCFDC0CFDGCTR &= 0xFFFFFFFCUL;
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDGSTS & 0x07UL) != 0X00UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
		{
			u32RSCANTimeCount++;
		}

		if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
		{
			enInitStatus = RSCAN_INIT_ERROR;
		}
		/******Channel halt mode*******/
		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			RCFDC0CFDC0CTR &= 0xFFFFFFFAUL;
			RCFDC0CFDC0CTR |= 0x02UL;
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			RCFDC0CFDC1CTR &= 0xFFFFFFFAUL;
			RCFDC0CFDC1CTR |= 0x02UL;
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			RCFDC0CFDC2CTR &= 0xFFFFFFFAUL;
			RCFDC0CFDC2CTR |= 0x02UL;
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			RCFDC0CFDC3CTR &= 0xFFFFFFFAUL;
			RCFDC0CFDC3CTR |= 0x02UL;
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			RCFDC0CFDC4CTR &= 0xFFFFFFFAUL;
			RCFDC0CFDC4CTR |= 0x02UL;
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			RCFDC0CFDC5CTR &= 0xFFFFFFFAUL;
			RCFDC0CFDC5CTR |= 0x02UL;
		}

		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC0STS & 0x02UL) != 0x02UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_0;
			}
			RCFDC0CFDC0CTR &= 0XFBFFFFFFUL;
			RCFDC0CFDC0CTR |= 0X03000000UL;
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC1STS & 0x02UL) != 0x02UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_1;
			}
			RCFDC0CFDC1CTR &= 0XFBFFFFFFUL;
			RCFDC0CFDC1CTR |= 0X03000000UL;
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC2STS & 0x02UL) != 0x02UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_2;
			}
			RCFDC0CFDC2CTR &= 0XFBFFFFFFUL;
			RCFDC0CFDC2CTR |= 0X03000000UL;
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC3STS & 0x02UL) != 0x02UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_3;
			}
			RCFDC0CFDC3CTR &= 0XFBFFFFFFUL;
			RCFDC0CFDC3CTR |= 0X03000000UL;
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC4STS & 0x02UL) != 0x02UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_4;
			}
			RCFDC0CFDC4CTR &= 0XFBFFFFFFUL;
			RCFDC0CFDC4CTR |= 0X03000000UL;
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode == RSCAN_MODE_LISTEN)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC5STS & 0x02UL) != 0x02UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_5;
			}
			RCFDC0CFDC5CTR &= 0XFBFFFFFFUL;
			RCFDC0CFDC5CTR |= 0X03000000UL;
		}

		/*Transition to channel communication mode*/
		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
		{
			RCFDC0CFDC0CTR &= 0xFFFFFFFCUL;
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
		{
			RCFDC0CFDC1CTR &= 0xFFFFFFFCUL;
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
		{
			RCFDC0CFDC2CTR &= 0xFFFFFFFCUL;
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
		{
			RCFDC0CFDC3CTR &= 0xFFFFFFFCUL;
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
		{
			RCFDC0CFDC4CTR &= 0xFFFFFFFCUL;
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
		{
			RCFDC0CFDC5CTR &= 0xFFFFFFFCUL;
		}

		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC0STS & 0x80UL) == 0x0UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_0;
			}
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC1STS & 0x80UL) == 0x0UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_1;
			}
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC2STS & 0x80UL) == 0x0UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_2;
			}
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC3STS & 0x80UL) == 0x0UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}

			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_3;
			}
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC4STS & 0x80UL) == 0x0UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_4;
			}
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
		{
			u32RSCANTimeCount = 0UL;
			while (((RCFDC0CFDC5STS & 0x80UL) == 0x0UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
			{
				u32RSCANTimeCount++;
			}
			if (u32RSCANTimeCount >= RSCAN_TIME_OUT_MAX)
			{
				enInitStatus = RSCAN_INIT_ERROR_CHANNEL_5;
			}
		}

		/*Enable the applied receive FIFO buffer, transmit/receive
		FIFO, transmit queue or transmit history buffer*/

		/*transmit/receive FIFO */
		if (pstRSCANConfig->stRSCANCh0.enRSCANChMode)
		{
			RCFDC0CFDCFCC0 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC1 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC2 |= RSCAN_TR_FIFO_EN;
		}
		if (pstRSCANConfig->stRSCANCh1.enRSCANChMode)
		{
			RCFDC0CFDCFCC3 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC4 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC5 |= RSCAN_TR_FIFO_EN;
		}
		if (pstRSCANConfig->stRSCANCh2.enRSCANChMode)
		{
			RCFDC0CFDCFCC6 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC7 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC8 |= RSCAN_TR_FIFO_EN;
		}
		if (pstRSCANConfig->stRSCANCh3.enRSCANChMode)
		{
			RCFDC0CFDCFCC9 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC10 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC11 |= RSCAN_TR_FIFO_EN;
		}
		if (pstRSCANConfig->stRSCANCh4.enRSCANChMode)
		{
			RCFDC0CFDCFCC12 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC13 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC14 |= RSCAN_TR_FIFO_EN;
		}
		if (pstRSCANConfig->stRSCANCh5.enRSCANChMode)
		{
			RCFDC0CFDCFCC15 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC16 |= RSCAN_TR_FIFO_EN;
			RCFDC0CFDCFCC17 |= RSCAN_TR_FIFO_EN;
		}

		g_stRSCAN0Config = *pstRSCANConfig;
	}
	return enInitStatus;
}

void RSCAN0_CH0_Receive(CAN_Frame_st_t *pstCANFrame)
{
	if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANReadMsgCallBack)
	{
		g_stRSCAN0Config.stRSCANCh0.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
	}
}
void RSCAN0_CH1_Receive(CAN_Frame_st_t *pstCANFrame)
{
	if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANReadMsgCallBack)
	{
		g_stRSCAN0Config.stRSCANCh1.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
	}
}
void RSCAN0_CH2_Receive(CAN_Frame_st_t *pstCANFrame)
{
	if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANReadMsgCallBack)
	{
		g_stRSCAN0Config.stRSCANCh2.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
	}
}
void RSCAN0_CH3_Receive(CAN_Frame_st_t *pstCANFrame)
{
	if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANReadMsgCallBack)
	{
		g_stRSCAN0Config.stRSCANCh3.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
	}
}
void RSCAN0_CH4_Receive(CAN_Frame_st_t *pstCANFrame)
{
	if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANReadMsgCallBack)
	{
		g_stRSCAN0Config.stRSCANCh4.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
	}
}
void RSCAN0_CH5_Receive(CAN_Frame_st_t *pstCANFrame)
{
	if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANReadMsgCallBack)
	{
		g_stRSCAN0Config.stRSCANCh5.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
	}
}

/***u32CANFrameType:  0:CAN   1:CANFD***/
/***use for transmit  ***/
static uint32_t RSCAN0_FD_DLC_ChangeTo_Register(uint32_t u32CANFrameType, uint32_t u32CANFDLen)
{
	uint32_t u32CANFDResult = u32CANFDLen;
	if (u32CANFrameType)
	{
		switch (u32CANFDLen)
		{
		case 12:
			u32CANFDResult = 9U;
			break;
		case 16:
			u32CANFDResult = 10U;
			break;
		case 20:
			u32CANFDResult = 11U;
			break;
		case 24:
			u32CANFDResult = 12U;
			break;
		case 32:
			u32CANFDResult = 13U;
			break;
		case 48:
			u32CANFDResult = 14U;
			break;
		case 64:
			u32CANFDResult = 15U;
			break;
		case 8:
		case 7:
		case 6:
		case 5:
		case 4:
		case 3:
		case 2:
		case 1:
			u32CANFDResult = u32CANFDLen;
			break;
		default:
			u32CANFDResult = 0x10U;
			break;
		}
	}
	else
	{
		if (u32CANFDLen > 8)
		{
			u32CANFDResult = 0x10U;
		}
	}

	return u32CANFDResult;
}
/***u32CANFrameType:  0:CAN   1:CANFD***/
static uint32_t RSCAN0_FD_Register_ChangeTo_DLC(uint32_t u32CANFrameType, uint32_t u32CANFDLen)
{
	uint32_t u32CANFDResult = u32CANFDLen;
    if (u32CANFrameType)
    {
        if(u32CANFDLen < 8)
        {
            u32CANFDResult = u32CANFDLen;
        }
        else
        {
            switch (u32CANFDLen)
            {
                case 8:
                    u32CANFDResult = 8U;
                    break;
                case 9:
                    u32CANFDResult = 12U;
                    break;
                case 10:
                    u32CANFDResult = 16U;
                    break;
                case 11:
                    u32CANFDResult = 20U;
                    break;
                case 12:
                    u32CANFDResult = 24U;
                    break;
                case 13:
                    u32CANFDResult = 32U;
                    break;
                case 14:
                    u32CANFDResult = 48U;
                    break;
                case 15:
                    u32CANFDResult = 64U;
                    break;
                default:
                    u32CANFDResult = 0U; //
                    break;
            }
        }
    }
    else
    {
        if (u32CANFDLen > 8)
        {
            u32CANFDResult = 8;
        }
    }

    return u32CANFDResult;
}
/**********************************************************/

RSCAN_SetState_en_t RSCAN0_CH0_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexK = (0UL + 3UL * 0UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x10U) || (pstCANFrame == 0UL))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}

	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

		if (((*((uint32_t *)(u32RSCANAddress))) & 0x00000002UL) == 0x0U)
		//if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
		{

			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = u32RSCANDataBuf;
			//RCFDC0CFDCFID3 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = ((u32RSCANLen) << 28U);
			//RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0UL;
			}
			//RCFDC0CFDCFFDCSTS3 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = 0XFFUL;
			//RCFDC0CFDCFPCTR3 = 0XFFUL;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}

	return enRSCANStatus;
}

RSCAN_SetState_en_t RSCAN0_CH1_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexK = (0UL + 3UL * 1UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x10U) || (pstCANFrame == 0UL))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}

	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

		if (((*((uint32_t *)(u32RSCANAddress))) & 0x00000002UL) == 0x0U)
		//if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
		{

			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = u32RSCANDataBuf;
			//RCFDC0CFDCFID3 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = ((u32RSCANLen) << 28U);
			//RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0UL;
			}
			//RCFDC0CFDCFFDCSTS3 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = 0XFFUL;
			//RCFDC0CFDCFPCTR3 = 0XFFUL;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}

	return enRSCANStatus;
}

RSCAN_SetState_en_t RSCAN0_CH2_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexK = (0UL + 3UL * 2UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x10U) || (pstCANFrame == 0UL))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}

	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

		if (((*((uint32_t *)(u32RSCANAddress))) & 0x00000002UL) == 0x0U)
		//if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
		{

			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = u32RSCANDataBuf;
			//RCFDC0CFDCFID3 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = ((u32RSCANLen) << 28U);
			//RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0UL;
			}
			//RCFDC0CFDCFFDCSTS3 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = 0XFFUL;
			//RCFDC0CFDCFPCTR3 = 0XFFUL;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}

	return enRSCANStatus;
}

RSCAN_SetState_en_t RSCAN0_CH3_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexK = (0UL + 3UL * 3UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x10U) || (pstCANFrame == 0UL))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}

	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

		if (((*((uint32_t *)(u32RSCANAddress))) & 0x00000002UL) == 0x0U)
		//if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
		{

			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = u32RSCANDataBuf;
			//RCFDC0CFDCFID3 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = ((u32RSCANLen) << 28U);
			//RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0UL;
			}
			//RCFDC0CFDCFFDCSTS3 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = 0XFFUL;
			//RCFDC0CFDCFPCTR3 = 0XFFUL;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}

	return enRSCANStatus;
}

RSCAN_SetState_en_t RSCAN0_CH4_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexK = (0UL + 3UL * 4UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x15U) || (pstCANFrame == 0UL))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}

	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

		if (((*((uint32_t *)(u32RSCANAddress))) & 0x00000002UL) == 0x0U)
		//if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
		{

			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = u32RSCANDataBuf;
			//RCFDC0CFDCFID3 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = ((u32RSCANLen) << 28U);
			//RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0UL;
			}
			//RCFDC0CFDCFFDCSTS3 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = 0XFFUL;
			//RCFDC0CFDCFPCTR3 = 0XFFUL;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}

	return enRSCANStatus;
}

RSCAN_SetState_en_t RSCAN0_CH5_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexK = (0UL + 3UL * 5UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x10U) || (pstCANFrame == 0UL))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}

	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

		if (((*((uint32_t *)(u32RSCANAddress))) & 0x00000002UL) == 0x0U)
		//if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
		{

			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = u32RSCANDataBuf;
			//RCFDC0CFDCFID3 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = ((u32RSCANLen) << 28U);
			//RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0UL;
			}
			//RCFDC0CFDCFFDCSTS3 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)(u32RSCANAddress))) = 0XFFUL;
			//RCFDC0CFDCFPCTR3 = 0XFFUL;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}

	return enRSCANStatus;
}

/*********************************************************/

RSCAN_SetState_en_t RSCAN0_CH0_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
	uint8_t i;
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 0UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x10U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
		if (((*((uint8_t *)u32RSCANAddress)) & 0x08U) == 0x0U)
		//if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
		{
			(*((uint8_t *)u32RSCANAddress)) = 0UL;
			//RCFDC0CFDTMSTS0 = 0UL;
			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = u32RSCANDataBuf;
			//RCFDC0CFDTMID0 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = (uint32_t)((u32RSCANLen) << 28U);
			//RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)u32RSCANAddress)) = 0UL;
			}
			//RCFDC0CFDTMFDCTR0 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{

				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
			(*((uint8_t *)u32RSCANAddress)) |= 0X01;
			//RCFDC0CFDTMC0 |= 0X01;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}
	return enRSCANStatus;
}

RSCAN_SetState_en_t RSCAN0_CH1_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
	uint8_t i;
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 1UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x10U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
		if (((*((uint8_t *)u32RSCANAddress)) & 0x08U) == 0x0U)
		//if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
		{
			(*((uint8_t *)u32RSCANAddress)) = 0UL;
			//RCFDC0CFDTMSTS0 = 0UL;
			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = u32RSCANDataBuf;
			//RCFDC0CFDTMID0 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = (uint32_t)((u32RSCANLen) << 28U);
			//RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)u32RSCANAddress)) = 0UL;
			}
			//RCFDC0CFDTMFDCTR0 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{

				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
			(*((uint8_t *)u32RSCANAddress)) |= 0X01;
			//RCFDC0CFDTMC0 |= 0X01;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}
	return enRSCANStatus;
}

RSCAN_SetState_en_t RSCAN0_CH2_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
	uint8_t i;
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 2UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x10U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
		if (((*((uint8_t *)u32RSCANAddress)) & 0x08U) == 0x0U)
		//if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
		{
			(*((uint8_t *)u32RSCANAddress)) = 0UL;
			//RCFDC0CFDTMSTS0 = 0UL;
			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = u32RSCANDataBuf;
			//RCFDC0CFDTMID0 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = (uint32_t)((u32RSCANLen) << 28U);
			//RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)u32RSCANAddress)) = 0UL;
			}
			//RCFDC0CFDTMFDCTR0 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{

				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
			(*((uint8_t *)u32RSCANAddress)) |= 0X01;
			//RCFDC0CFDTMC0 |= 0X01;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}
	return enRSCANStatus;
}

RSCAN_SetState_en_t RSCAN0_CH3_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
	uint8_t i;
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 3UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x10U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
		if (((*((uint8_t *)u32RSCANAddress)) & 0x08U) == 0x0U)
		//if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
		{
			(*((uint8_t *)u32RSCANAddress)) = 0UL;
			//RCFDC0CFDTMSTS0 = 0UL;
			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = u32RSCANDataBuf;
			//RCFDC0CFDTMID0 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = (uint32_t)((u32RSCANLen) << 28U);
			//RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)u32RSCANAddress)) = 0UL;
			}
			//RCFDC0CFDTMFDCTR0 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{

				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
			(*((uint8_t *)u32RSCANAddress)) |= 0X01;
			//RCFDC0CFDTMC0 |= 0X01;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}
	return enRSCANStatus;
}

RSCAN_SetState_en_t RSCAN0_CH4_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
	uint8_t i;
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 4UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x10U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
		if (((*((uint8_t *)u32RSCANAddress)) & 0x08U) == 0x0U)
		//if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
		{
			(*((uint8_t *)u32RSCANAddress)) = 0UL;
			//RCFDC0CFDTMSTS0 = 0UL;
			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = u32RSCANDataBuf;
			//RCFDC0CFDTMID0 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = (uint32_t)((u32RSCANLen) << 28U);
			//RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)u32RSCANAddress)) = 0UL;
			}
			//RCFDC0CFDTMFDCTR0 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{

				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
			(*((uint8_t *)u32RSCANAddress)) |= 0X01;
			//RCFDC0CFDTMC0 |= 0X01;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}
	return enRSCANStatus;
}

RSCAN_SetState_en_t RSCAN0_CH5_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
	uint8_t i;
	uint32_t u32RSCANDataBuf = 0UL;
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 5UL);
	uint32_t u32RSCANAddress = 0UL;
	uint32_t u32RSCANLen = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	u32RSCANLen = RSCAN0_FD_DLC_ChangeTo_Register(pstCANFrame->u8CANFrameType, pstCANFrame->u8CANLEN);

	if ((u32RSCANLen >= 0x10U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
		if (((*((uint8_t *)u32RSCANAddress)) & 0x08U) == 0x0U)
		//if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
		{
			(*((uint8_t *)u32RSCANAddress)) = 0UL;
			//RCFDC0CFDTMSTS0 = 0UL;
			u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
			u32RSCANDataBuf = u32RSCANDataBuf << 31U;
			u32RSCANDataBuf |= pstCANFrame->u32CANID;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = u32RSCANDataBuf;
			//RCFDC0CFDTMID0 = u32RSCANDataBuf;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = (uint32_t)((u32RSCANLen) << 28U);
			//RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
			if (pstCANFrame->u8CANFrameType)
			{
				(*((uint32_t *)(u32RSCANAddress))) = 0x06UL;
			}
			else
			{
				(*((uint32_t *)u32RSCANAddress)) = 0UL;
			}
			//RCFDC0CFDTMFDCTR0 = 0UL;

			u32RSCANAddress = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[0U];
			//RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
			u32RSCANAddress += 0X04UL;
			(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[1U];
			//RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];
			if (pstCANFrame->u8CANFrameType)
			{

				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[2U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[3U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[4U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[5U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[6U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[7U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[8U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[9U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[10U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[11U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[12U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[13U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[14U];
				u32RSCANAddress += 0X04UL;
				(*((uint32_t *)u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData[15U];
			}
			u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
			(*((uint8_t *)u32RSCANAddress)) |= 0X01;
			//RCFDC0CFDTMC0 |= 0X01;

			enRSCANStatus = RSCAN_SET_COMPLETE;
		}
		else
		{
			enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
		}
	}
	return enRSCANStatus;
}

/********************************************************/
/*
0: Not in bus off state
1: In bus off state
*/
uint8_t RSCAN0_CH0_Get_Busoff_Status(void)
{
	uint8_t u8BusoffStatus = 0U;
	if (RCFDC0CFDC0ERFL & 0x08UL)
	{
		u8BusoffStatus = 1U;
	}

	return u8BusoffStatus;
}

uint8_t RSCAN0_CH1_Get_Busoff_Status(void)
{
	uint8_t u8BusoffStatus = 0U;

	if (RCFDC0CFDC1ERFL & 0x08UL)
	{
		u8BusoffStatus = 1U;
	}

	return u8BusoffStatus;
}
uint8_t RSCAN0_CH2_Get_Busoff_Status(void)
{
	uint8_t u8BusoffStatus = 0U;
	if (RCFDC0CFDC2ERFL & 0x08UL)
	{
		u8BusoffStatus = 1U;
	}

	return u8BusoffStatus;
}
uint8_t RSCAN0_CH3_Get_Busoff_Status(void)
{
	uint8_t u8BusoffStatus = 0U;
	if (RCFDC0CFDC3ERFL & 0x08UL)
	{
		u8BusoffStatus = 1U;
	}

	return u8BusoffStatus;
}
uint8_t RSCAN0_CH4_Get_Busoff_Status(void)
{
	uint8_t u8BusoffStatus = 0U;
	if (RCFDC0CFDC4ERFL & 0x08UL)
	{
		u8BusoffStatus = 1U;
	}

	return u8BusoffStatus;
}
uint8_t RSCAN0_CH5_Get_Busoff_Status(void)
{
	uint8_t u8BusoffStatus = 0U;
	if (RCFDC0CFDC5ERFL & 0x08UL)
	{
		u8BusoffStatus = 1U;
	}

	return u8BusoffStatus;
}

void RSCAN0_CH0_Busoff_Recover(void)
{
	if (RSCAN0_CH0_Get_Busoff_Status())
	{
		uint32_t u32RSCANTimeCount;
		RCFDC0CFDC0ERFL &= 0xFFFFFFF7UL;
		RCFDC0CFDC0CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDC0STS & 0x87UL) != 0x80UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
		{
			u32RSCANTimeCount++;
		}
	}
}
void RSCAN0_CH1_Busoff_Recover(void)
{
	if (RSCAN0_CH1_Get_Busoff_Status())
	{
		uint32_t u32RSCANTimeCount;
		RCFDC0CFDC1ERFL &= 0xFFFFFFF7UL;
		RCFDC0CFDC1CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDC1STS & 0x87UL) != 0x80UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
		{
			u32RSCANTimeCount++;
		}
	}
}
void RSCAN0_CH2_Busoff_Recover(void)
{
	if (RSCAN0_CH2_Get_Busoff_Status())
	{
		uint32_t u32RSCANTimeCount;
		RCFDC0CFDC2ERFL &= 0xFFFFFFF7UL;
		RCFDC0CFDC2CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDC2STS & 0x87UL) != 0x80UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
		{
			u32RSCANTimeCount++;
		}
	}
}
void RSCAN0_CH3_Busoff_Recover(void)
{
	if (RSCAN0_CH3_Get_Busoff_Status())
	{
		uint32_t u32RSCANTimeCount;
		RCFDC0CFDC3ERFL &= 0xFFFFFFF7UL;
		RCFDC0CFDC3CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDC3STS & 0x87UL) != 0x80UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
		{
			u32RSCANTimeCount++;
		}
	}
}
void RSCAN0_CH4_Busoff_Recover(void)
{
	if (RSCAN0_CH4_Get_Busoff_Status())
	{
		uint32_t u32RSCANTimeCount;
		RCFDC0CFDC4ERFL &= 0xFFFFFFF7UL;
		RCFDC0CFDC4CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDC4STS & 0x87UL) != 0x80UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
		{
			u32RSCANTimeCount++;
		}
	}
}
void RSCAN0_CH5_Busoff_Recover(void)
{
	if (RSCAN0_CH5_Get_Busoff_Status())
	{
		uint32_t u32RSCANTimeCount;
		RCFDC0CFDC5ERFL &= 0xFFFFFFF7UL;
		RCFDC0CFDC5CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDC5STS & 0x87UL) != 0x80UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
		{
			u32RSCANTimeCount++;
		}
	}
}

void RSCAN0_CH0_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 0UL);
	uint32_t u32RSCANAddress = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	if ((enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
		(*((uint8_t *)u32RSCANAddress)) |= 0X02U;
		//RCFDC0CFDTMC0 |= 0X02;
	}
}
void RSCAN0_CH1_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 1UL);
	uint32_t u32RSCANAddress = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	if ((enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
		(*((uint8_t *)u32RSCANAddress)) |= 0X02U;
		//RCFDC0CFDTMC0 |= 0X02;
	}
}
void RSCAN0_CH2_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 2UL);
	uint32_t u32RSCANAddress = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	if ((enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
		(*((uint8_t *)u32RSCANAddress)) |= 0X02U;
		//RCFDC0CFDTMC0 |= 0X02;
	}
}
void RSCAN0_CH3_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 3UL);
	uint32_t u32RSCANAddress = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	if ((enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
		(*((uint8_t *)u32RSCANAddress)) |= 0X02U;
		//RCFDC0CFDTMC0 |= 0X02;
	}
}
void RSCAN0_CH4_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 4UL);
	uint32_t u32RSCANAddress = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	if ((enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
		(*((uint8_t *)u32RSCANAddress)) |= 0X02U;
		//RCFDC0CFDTMC0 |= 0X02;
	}
}
void RSCAN0_CH5_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
	uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 5UL);
	uint32_t u32RSCANAddress = 0UL;

	RSCAN_SetState_en_t enRSCANStatus = RSCAN_SET_COMPLETE;

	if ((enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
	{
		enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
	}
	if (enRSCANStatus == RSCAN_SET_COMPLETE)
	{
		u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
		(*((uint8_t *)u32RSCANAddress)) |= 0X02U;
		//RCFDC0CFDTMC0 |= 0X02;
	}
}
/*
如果CAN模块休眠了，但是芯片没休眠，CAN报文无法唤醒CAN模块。
*/
void RSCAN0_CH0_Sleep_Init(void)
{
	uint32_t u32RSCANTimeCount;
	RCFDC0CFDC0CTR &= 0xfffffff9UL;
	RCFDC0CFDC0CTR |= 0x01UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC0STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
	RCFDC0CFDC0CTR |= 0x04UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC0STS & 0x04UL) != 0X04UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
}
void RSCAN0_CH1_Sleep_Init(void)
{
	uint32_t u32RSCANTimeCount;
	RCFDC0CFDC1CTR &= 0xfffffff9UL;
	RCFDC0CFDC1CTR |= 0x01UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC1STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
	RCFDC0CFDC1CTR |= 0x04UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC1STS & 0x04UL) != 0X04UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
}
void RSCAN0_CH2_Sleep_Init(void)
{
	uint32_t u32RSCANTimeCount;
	RCFDC0CFDC2CTR &= 0xfffffff9UL;
	RCFDC0CFDC2CTR |= 0x01UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC2STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
	RCFDC0CFDC2CTR |= 0x04UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC2STS & 0x04UL) != 0X04UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
}
void RSCAN0_CH3_Sleep_Init(void)
{
	uint32_t u32RSCANTimeCount;
	RCFDC0CFDC3CTR &= 0xfffffff9UL;
	RCFDC0CFDC3CTR |= 0x01UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC3STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
	RCFDC0CFDC3CTR |= 0x04UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC3STS & 0x04UL) != 0X04UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
}
void RSCAN0_CH4_Sleep_Init(void)
{
	uint32_t u32RSCANTimeCount;
	RCFDC0CFDC4CTR &= 0xfffffff9UL;
	RCFDC0CFDC4CTR |= 0x01UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC4STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
	RCFDC0CFDC4CTR |= 0x04UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC4STS & 0x04UL) != 0X04UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
}
void RSCAN0_CH5_Sleep_Init(void)
{
	uint32_t u32RSCANTimeCount;
	RCFDC0CFDC5CTR &= 0xfffffff9UL;
	RCFDC0CFDC5CTR |= 0x01UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC5STS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
	RCFDC0CFDC5CTR |= 0x04UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDC5STS & 0x04UL) != 0X04UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
}

void RSCAN0_Sleep_Init(void)
{
	uint32_t u32RSCANTimeCount;
	RCFDC0CFDGCTR &= 0xfffffff9UL;
	RCFDC0CFDGCTR |= 0x01UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDGSTS & 0x07UL) != 0X01UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}

	RCFDC0CFDGCTR |= 0x04UL;
	u32RSCANTimeCount = 0UL;
	while (((RCFDC0CFDGSTS & 0x04UL) != 0X04UL) && (u32RSCANTimeCount < RSCAN_TIME_OUT_MAX))
	{
		u32RSCANTimeCount++;
	}
}

uint8_t RSCAN0_CH0_TX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC0STS >> 24U);
	return u8ErrorCount;
}
uint8_t RSCAN0_CH1_TX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC1STS >> 24U);
	return u8ErrorCount;
}
uint8_t RSCAN0_CH2_TX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC2STS >> 24U);
	return u8ErrorCount;
}
uint8_t RSCAN0_CH3_TX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC3STS >> 24U);
	return u8ErrorCount;
}
uint8_t RSCAN0_CH4_TX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC4STS >> 24U);
	return u8ErrorCount;
}
uint8_t RSCAN0_CH5_TX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC5STS >> 24U);
	return u8ErrorCount;
}

uint8_t RSCAN0_CH0_RX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC0STS >> 16U);
	return u8ErrorCount;
}
uint8_t RSCAN0_CH1_RX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC1STS >> 16U);
	return u8ErrorCount;
}
uint8_t RSCAN0_CH2_RX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC2STS >> 16U);
	return u8ErrorCount;
}
uint8_t RSCAN0_CH3_RX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC3STS >> 16U);
	return u8ErrorCount;
}
uint8_t RSCAN0_CH4_RX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC4STS >> 16U);
	return u8ErrorCount;
}
uint8_t RSCAN0_CH5_RX_Error_Count(void)
{
	uint8_t u8ErrorCount = 0U;
	u8ErrorCount = (uint8_t)(RCFDC0CFDC5STS >> 16U);
	return u8ErrorCount;
}
/*
RSCAN_Com_Status_en_t RSCAN0_CH0_Get_Communication_Status(void)
{
	RSCAN_Com_Status_en_t enRSCANComStatus = RSCAN_BUS_IDLE;

	if (RCFDC0CFDC0STS & 0x40UL)
	{
		enRSCANComStatus = RSCAN_BUS_RX;
	}
	if (RCFDC0CFDC0STS & 0x20UL)
	{
		enRSCANComStatus = RSCAN_BUS_TX;
	}
	if (RCFDC0CFDC0STS & 0x10UL)
	{
		enRSCANComStatus = RSCAN_BUS_OFF;
	}
	return enRSCANComStatus;
}
*/
/****************************************************/

/******************************************************************/

void RSCAN0_CH0_RX_ISR(void)
{
	if (RCFDC0CFDCFSTS2 & 0X08UL)
	{
		CAN_Frame_Receive_st_t stCANFrameReceive;
		uint32_t u32RSCANTimeCount;
		RCFDC0CFDCFSTS2 &= 0xFFFFFFF7UL;

		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDCFSTS2 & 0x01UL) == 0U) && (u32RSCANTimeCount < 128U))
		{
			u32RSCANTimeCount++;
			stCANFrameReceive.stReceiveContent.u32CANID = (uint32_t)(RCFDC0CFDCFID2 & 0x1FFFFFFFUL);
			stCANFrameReceive.stReceiveContent.u8CANFrameIDE = (uint8_t)((RCFDC0CFDCFID2 >> 31U));
			stCANFrameReceive.stReceiveContent.u8CANFrameType = (uint8_t)((RCFDC0CFDCFFDCSTS2 >> 2U));
			stCANFrameReceive.stReceiveContent.u8CANLEN = RSCAN0_FD_Register_ChangeTo_DLC(stCANFrameReceive.stReceiveContent.u8CANFrameType, ((uint8_t)(RCFDC0CFDCFPTR2 >> 28U)));
			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[0U] = RCFDC0CFDCFDF0_2;
			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[1U] = RCFDC0CFDCFDF1_2;

			if (stCANFrameReceive.stReceiveContent.u8CANFrameType)
			{
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[2U] = RCFDC0CFDCFDF2_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[3U] = RCFDC0CFDCFDF3_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[4U] = RCFDC0CFDCFDF4_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[5U] = RCFDC0CFDCFDF5_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[6U] = RCFDC0CFDCFDF6_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[7U] = RCFDC0CFDCFDF7_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[8U] = RCFDC0CFDCFDF8_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[9U] = RCFDC0CFDCFDF9_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[10U] = RCFDC0CFDCFDF10_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[11U] = RCFDC0CFDCFDF11_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[12U] = RCFDC0CFDCFDF12_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[13U] = RCFDC0CFDCFDF13_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[14U] = RCFDC0CFDCFDF14_2;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[15U] = RCFDC0CFDCFDF15_2;
			}

			RCFDC0CFDCFPCTR2 = 0xFFU;

			RSCAN0_CH0_Receive(&stCANFrameReceive.stReceiveContent);
		}
	}
}

void RSCAN0_CH1_RX_ISR(void)
{
	if (RCFDC0CFDCFSTS5 & 0X08UL)
	{
		uint32_t u32RSCANTimeCount;
		CAN_Frame_Receive_st_t stCANFrameReceive;
		RCFDC0CFDCFSTS5 &= 0xFFFFFFF7UL;
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDCFSTS5 & 0x01UL) == 0U) && (u32RSCANTimeCount < 128U))
		{
			u32RSCANTimeCount++;
			stCANFrameReceive.stReceiveContent.u32CANID = (uint32_t)(RCFDC0CFDCFID5 & 0x1FFFFFFFUL);
			stCANFrameReceive.stReceiveContent.u8CANFrameIDE = (uint8_t)((RCFDC0CFDCFID5 >> 31U));
			stCANFrameReceive.stReceiveContent.u8CANFrameType = (uint8_t)((RCFDC0CFDCFFDCSTS5 >> 2U));
			stCANFrameReceive.stReceiveContent.u8CANLEN = RSCAN0_FD_Register_ChangeTo_DLC(stCANFrameReceive.stReceiveContent.u8CANFrameType, ((uint8_t)(RCFDC0CFDCFPTR5 >> 28U)));

			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[0U] = RCFDC0CFDCFDF0_5;
			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[1U] = RCFDC0CFDCFDF1_5;
			if (stCANFrameReceive.stReceiveContent.u8CANFrameType)
			{

				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[2U] = RCFDC0CFDCFDF2_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[3U] = RCFDC0CFDCFDF3_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[4U] = RCFDC0CFDCFDF4_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[5U] = RCFDC0CFDCFDF5_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[6U] = RCFDC0CFDCFDF6_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[7U] = RCFDC0CFDCFDF7_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[8U] = RCFDC0CFDCFDF8_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[9U] = RCFDC0CFDCFDF9_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[10U] = RCFDC0CFDCFDF10_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[11U] = RCFDC0CFDCFDF11_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[12U] = RCFDC0CFDCFDF12_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[13U] = RCFDC0CFDCFDF13_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[14U] = RCFDC0CFDCFDF14_5;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[15U] = RCFDC0CFDCFDF15_5;
			}
			RCFDC0CFDCFPCTR5 = 0xFFU;

			RSCAN0_CH1_Receive(&stCANFrameReceive.stReceiveContent);
		}
	}
}

void RSCAN0_CH2_RX_ISR(void)
{
	if (RCFDC0CFDCFSTS8 & 0X08UL)
	{
		uint32_t u32RSCANTimeCount;
		CAN_Frame_Receive_st_t stCANFrameReceive;
		RCFDC0CFDCFSTS8 &= 0xFFFFFFF7UL;
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDCFSTS8 & 0x01UL) == 0U) && (u32RSCANTimeCount < 128U))
		{
			u32RSCANTimeCount++;
			stCANFrameReceive.stReceiveContent.u32CANID = (uint32_t)(RCFDC0CFDCFID8 & 0x1FFFFFFFUL);
			stCANFrameReceive.stReceiveContent.u8CANFrameIDE = (uint8_t)((RCFDC0CFDCFID8 >> 31U));
			stCANFrameReceive.stReceiveContent.u8CANFrameType = (uint8_t)((RCFDC0CFDCFFDCSTS8 >> 2U));
			stCANFrameReceive.stReceiveContent.u8CANLEN = RSCAN0_FD_Register_ChangeTo_DLC(stCANFrameReceive.stReceiveContent.u8CANFrameType, ((uint8_t)(RCFDC0CFDCFPTR8 >> 28U)));

			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[0U] = RCFDC0CFDCFDF0_8;
			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[1U] = RCFDC0CFDCFDF1_8;
			if (stCANFrameReceive.stReceiveContent.u8CANFrameType)
			{

				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[2U] = RCFDC0CFDCFDF2_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[3U] = RCFDC0CFDCFDF3_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[4U] = RCFDC0CFDCFDF4_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[5U] = RCFDC0CFDCFDF5_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[6U] = RCFDC0CFDCFDF6_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[7U] = RCFDC0CFDCFDF7_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[8U] = RCFDC0CFDCFDF8_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[9U] = RCFDC0CFDCFDF9_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[10U] = RCFDC0CFDCFDF10_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[11U] = RCFDC0CFDCFDF11_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[12U] = RCFDC0CFDCFDF12_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[13U] = RCFDC0CFDCFDF13_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[14U] = RCFDC0CFDCFDF14_8;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[15U] = RCFDC0CFDCFDF15_8;
			}
			RCFDC0CFDCFPCTR8 = 0xFFU;

			RSCAN0_CH2_Receive(&stCANFrameReceive.stReceiveContent);
		}
	}
}

void RSCAN0_CH3_RX_ISR(void)
{
	if (RCFDC0CFDCFSTS11 & 0X08UL)
	{
		uint32_t u32RSCANTimeCount;
		CAN_Frame_Receive_st_t stCANFrameReceive;
		RCFDC0CFDCFSTS11 &= 0xFFFFFFF7UL;
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDCFSTS11 & 0x01UL) == 0U) && (u32RSCANTimeCount < 128U))
		{
			u32RSCANTimeCount++;
			stCANFrameReceive.stReceiveContent.u32CANID = (uint32_t)(RCFDC0CFDCFID11 & 0x1FFFFFFFUL);
			stCANFrameReceive.stReceiveContent.u8CANFrameIDE = (uint8_t)((RCFDC0CFDCFID11 >> 31U));
			stCANFrameReceive.stReceiveContent.u8CANFrameType = (uint8_t)((RCFDC0CFDCFFDCSTS11 >> 2U));
			stCANFrameReceive.stReceiveContent.u8CANLEN = RSCAN0_FD_Register_ChangeTo_DLC(stCANFrameReceive.stReceiveContent.u8CANFrameType, ((uint8_t)(RCFDC0CFDCFPTR11 >> 28U)));

			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[0U] = RCFDC0CFDCFDF0_11;
			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[1U] = RCFDC0CFDCFDF1_11;
			if (stCANFrameReceive.stReceiveContent.u8CANFrameType)
			{

				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[2U] = RCFDC0CFDCFDF2_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[3U] = RCFDC0CFDCFDF3_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[4U] = RCFDC0CFDCFDF4_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[5U] = RCFDC0CFDCFDF5_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[6U] = RCFDC0CFDCFDF6_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[7U] = RCFDC0CFDCFDF7_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[8U] = RCFDC0CFDCFDF8_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[9U] = RCFDC0CFDCFDF9_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[10U] = RCFDC0CFDCFDF10_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[11U] = RCFDC0CFDCFDF11_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[12U] = RCFDC0CFDCFDF12_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[13U] = RCFDC0CFDCFDF13_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[14U] = RCFDC0CFDCFDF14_11;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[15U] = RCFDC0CFDCFDF15_11;
			}
			RCFDC0CFDCFPCTR11 = 0xFFU;

			RSCAN0_CH3_Receive(&stCANFrameReceive.stReceiveContent);
		}
	}
}

void RSCAN0_CH4_RX_ISR(void)
{
	if (RCFDC0CFDCFSTS14 & 0X08UL)
	{
		uint32_t u32RSCANTimeCount;
		CAN_Frame_Receive_st_t stCANFrameReceive;
		RCFDC0CFDCFSTS14 &= 0xFFFFFFF7UL;
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDCFSTS14 & 0x01UL) == 0U) && (u32RSCANTimeCount < 128U))
		{
			u32RSCANTimeCount++;
			stCANFrameReceive.stReceiveContent.u32CANID = (uint32_t)(RCFDC0CFDCFID14 & 0x1FFFFFFFUL);
			stCANFrameReceive.stReceiveContent.u8CANFrameIDE = (uint8_t)((RCFDC0CFDCFID14 >> 31U));
			stCANFrameReceive.stReceiveContent.u8CANFrameType = (uint8_t)((RCFDC0CFDCFFDCSTS14 >> 2U));
			stCANFrameReceive.stReceiveContent.u8CANLEN = RSCAN0_FD_Register_ChangeTo_DLC(stCANFrameReceive.stReceiveContent.u8CANFrameType, ((uint8_t)(RCFDC0CFDCFPTR14 >> 28U)));

			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[0U] = RCFDC0CFDCFDF0_14;
			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[1U] = RCFDC0CFDCFDF1_14;
			if (stCANFrameReceive.stReceiveContent.u8CANFrameType)
			{

				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[2U] = RCFDC0CFDCFDF2_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[3U] = RCFDC0CFDCFDF3_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[4U] = RCFDC0CFDCFDF4_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[5U] = RCFDC0CFDCFDF5_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[6U] = RCFDC0CFDCFDF6_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[7U] = RCFDC0CFDCFDF7_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[8U] = RCFDC0CFDCFDF8_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[9U] = RCFDC0CFDCFDF9_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[10U] = RCFDC0CFDCFDF10_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[11U] = RCFDC0CFDCFDF11_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[12U] = RCFDC0CFDCFDF12_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[13U] = RCFDC0CFDCFDF13_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[14U] = RCFDC0CFDCFDF14_14;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[15U] = RCFDC0CFDCFDF15_14;
			}
			RCFDC0CFDCFPCTR14 = 0xFFU;

			RSCAN0_CH4_Receive(&stCANFrameReceive.stReceiveContent);
		}
	}
}

void RSCAN0_CH5_RX_ISR(void)
{
	if (RCFDC0CFDCFSTS17 & 0X08UL)
	{
		uint32_t u32RSCANTimeCount;
		CAN_Frame_Receive_st_t stCANFrameReceive;
		RCFDC0CFDCFSTS17 &= 0xFFFFFFF7UL;
		u32RSCANTimeCount = 0UL;
		while (((RCFDC0CFDCFSTS17 & 0x01UL) == 0U) && (u32RSCANTimeCount < 128U))
		{
			u32RSCANTimeCount++;
			stCANFrameReceive.stReceiveContent.u32CANID = (uint32_t)(RCFDC0CFDCFID17 & 0x1FFFFFFFUL);
			stCANFrameReceive.stReceiveContent.u8CANFrameIDE = (uint8_t)((RCFDC0CFDCFID17 >> 31U));
			stCANFrameReceive.stReceiveContent.u8CANFrameType = (uint8_t)((RCFDC0CFDCFFDCSTS17 >> 2U));
			stCANFrameReceive.stReceiveContent.u8CANLEN = RSCAN0_FD_Register_ChangeTo_DLC(stCANFrameReceive.stReceiveContent.u8CANFrameType, ((uint8_t)(RCFDC0CFDCFPTR17 >> 28U)));

			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[0U] = RCFDC0CFDCFDF0_17;
			stCANFrameReceive.stReceiveContent.unCANData.u32CANData[1U] = RCFDC0CFDCFDF1_17;
			if (stCANFrameReceive.stReceiveContent.u8CANFrameType)
			{

				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[2U] = RCFDC0CFDCFDF2_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[3U] = RCFDC0CFDCFDF3_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[4U] = RCFDC0CFDCFDF4_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[5U] = RCFDC0CFDCFDF5_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[6U] = RCFDC0CFDCFDF6_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[7U] = RCFDC0CFDCFDF7_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[8U] = RCFDC0CFDCFDF8_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[9U] = RCFDC0CFDCFDF9_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[10U] = RCFDC0CFDCFDF10_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[11U] = RCFDC0CFDCFDF11_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[12U] = RCFDC0CFDCFDF12_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[13U] = RCFDC0CFDCFDF13_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[14U] = RCFDC0CFDCFDF14_17;
				stCANFrameReceive.stReceiveContent.unCANData.u32CANData[15U] = RCFDC0CFDCFDF15_17;
			}

			RCFDC0CFDCFPCTR17 = 0xFFU;

			RSCAN0_CH5_Receive(&stCANFrameReceive.stReceiveContent);
		}
	}
}

void RSCAN0_CH0_TX_ISR(void)
{

	if (RCFDC0CFDCFSTS0 & 0X10UL)
	{
		RCFDC0CFDCFSTS0 &= 0XFFFFFFEFUL;
	}
	if (RCFDC0CFDCFSTS1 & 0X10UL)
	{
		RCFDC0CFDCFSTS1 &= 0XFFFFFFEFUL;
	}

	if ((RCFDC0CFDTMSTS0 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS0 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(0, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS0 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS0 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(0U);
		}
	}
	if ((RCFDC0CFDTMSTS1 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS1 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(1, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS1 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS1 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(1U);
		}
	}
	if ((RCFDC0CFDTMSTS2 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS2 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(2, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS2 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS2 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(2U);
		}
	}
	if ((RCFDC0CFDTMSTS3 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS3 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(3, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS3 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS3 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(3U);
		}
	}
	if ((RCFDC0CFDTMSTS4 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS4 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(4, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS4 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS4 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(4U);
		}
	}
	if ((RCFDC0CFDTMSTS5 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS5 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(5, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS5 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS5 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(5U);
		}
	}
	if ((RCFDC0CFDTMSTS6 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS6 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(6, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS6 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS6 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(6U);
		}
	}
	if ((RCFDC0CFDTMSTS7 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS7 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(7, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS7 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS7 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(7U);
		}
	}
	if ((RCFDC0CFDTMSTS8 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS8 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(8, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS8 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS8 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(8U);
		}
	}
	if ((RCFDC0CFDTMSTS9 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS9 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(9, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS9 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS9 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(9U);
		}
	}
	if ((RCFDC0CFDTMSTS10 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS10 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(10, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS10 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS10 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(10U);
		}
	}
	if ((RCFDC0CFDTMSTS11 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS11 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(11, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS11 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS11 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(11U);
		}
	}
	if ((RCFDC0CFDTMSTS12 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS12 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(12, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS12 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS12 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(12U);
		}
	}
	if ((RCFDC0CFDTMSTS13 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS13 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(13, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS13 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS13 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(13U);
		}
	}
	if ((RCFDC0CFDTMSTS14 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS14 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(14, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS14 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS14 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(14U);
		}
	}
	if ((RCFDC0CFDTMSTS15 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS15 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(15, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS15 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS15 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(15U);
		}
	}
	if ((RCFDC0CFDTMSTS16 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS16 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(16, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS16 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS16 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(16U);
		}
	}
	if ((RCFDC0CFDTMSTS17 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS17 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(17, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS17 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS17 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(17U);
		}
	}
	if ((RCFDC0CFDTMSTS18 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS18 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(18, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS18 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS18 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(18U);
		}
	}
	if ((RCFDC0CFDTMSTS19 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS19 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(19, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS19 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS19 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(19U);
		}
	}
	if ((RCFDC0CFDTMSTS20 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS20 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(20, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS20 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS20 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(20U);
		}
	}
	if ((RCFDC0CFDTMSTS21 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS21 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(21, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS21 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS21 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(21U);
		}
	}
	if ((RCFDC0CFDTMSTS22 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS22 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(22, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS22 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS22 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(22U);
		}
	}
	if ((RCFDC0CFDTMSTS23 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS23 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(23, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS23 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS23 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(23U);
		}
	}
	if ((RCFDC0CFDTMSTS24 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS24 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(24, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS24 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS24 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(24U);
		}
	}
	if ((RCFDC0CFDTMSTS25 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS25 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(25, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS25 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS25 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(25U);
		}
	}
	if ((RCFDC0CFDTMSTS26 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS26 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(26, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS26 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS26 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(26U);
		}
	}
	if ((RCFDC0CFDTMSTS27 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS27 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(27, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS27 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS27 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(27U);
		}
	}
	if ((RCFDC0CFDTMSTS28 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS28 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(28, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS28 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS28 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(28U);
		}
	}
	if ((RCFDC0CFDTMSTS29 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS29 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(29, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS29 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS29 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(29U);
		}
	}
	if ((RCFDC0CFDTMSTS30 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS30 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(30, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS30 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS30 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(30U);
		}
	}
	if ((RCFDC0CFDTMSTS31 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS31 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(31, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS31 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS31 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(31U);
		}
	}
}

void RSCAN0_CH1_TX_ISR(void)
{

	if (RCFDC0CFDCFSTS3 & 0X10UL)
	{
		RCFDC0CFDCFSTS3 &= 0XFFFFFFEFUL;
	}
	if (RCFDC0CFDCFSTS4 & 0X10UL)
	{
		RCFDC0CFDCFSTS4 &= 0XFFFFFFEFUL;
	}

	if ((RCFDC0CFDTMSTS32 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS32 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(0, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS32 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS32 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(0U);
		}
	}

	if ((RCFDC0CFDTMSTS33 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS33 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(1U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS33 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS33 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(1U);
		}
	}

	if ((RCFDC0CFDTMSTS34 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS34 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(2U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS34 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS34 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(2U);
		}
	}

	if ((RCFDC0CFDTMSTS35 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS35 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(3U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS35 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS35 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(3U);
		}
	}

	if ((RCFDC0CFDTMSTS36 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS36 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(4U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS36 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS36 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(4U);
		}
	}
	if ((RCFDC0CFDTMSTS37 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS37 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(5U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS37 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS37 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(5U);
		}
	}
	if ((RCFDC0CFDTMSTS38 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS38 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(6U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS38 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS38 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(6U);
		}
	}
	if ((RCFDC0CFDTMSTS39 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS39 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(7U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS39 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS39 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(7U);
		}
	}
	if ((RCFDC0CFDTMSTS40 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS40 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(8U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS40 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS40 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(8U);
		}
	}
	if ((RCFDC0CFDTMSTS41 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS41 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(9U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS41 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS41 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(9U);
		}
	}
	if ((RCFDC0CFDTMSTS42 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS42 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(10U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS42 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS42 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(10U);
		}
	}
	if ((RCFDC0CFDTMSTS43 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS43 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(11U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS43 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS43 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(11U);
		}
	}
	if ((RCFDC0CFDTMSTS44 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS44 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(12U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS44 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS44 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(12U);
		}
	}
	if ((RCFDC0CFDTMSTS45 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS45 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(13U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS45 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS45 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(13U);
		}
	}
	if ((RCFDC0CFDTMSTS46 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS46 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(14U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS46 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS46 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(14U);
		}
	}
	if ((RCFDC0CFDTMSTS47 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS47 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(15U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS47 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS47 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(15U);
		}
	}
	if ((RCFDC0CFDTMSTS48 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS48 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(16U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS48 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS48 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(16U);
		}
	}
	if ((RCFDC0CFDTMSTS49 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS49 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(17U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS49 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS49 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(17U);
		}
	}
	if ((RCFDC0CFDTMSTS50 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS50 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(18U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS50 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS50 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(18U);
		}
	}
	if ((RCFDC0CFDTMSTS51 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS51 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(19U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS51 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS51 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(19U);
		}
	}
	if ((RCFDC0CFDTMSTS52 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS52 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(20U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS52 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS52 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(20U);
		}
	}
	if ((RCFDC0CFDTMSTS53 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS53 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(21U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS53 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS53 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(21U);
		}
	}
	if ((RCFDC0CFDTMSTS54 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS54 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(22U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS54 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS54 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(22U);
		}
	}
	if ((RCFDC0CFDTMSTS55 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS55 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(23U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS55 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS55 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(23U);
		}
	}

	if ((RCFDC0CFDTMSTS56 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS56 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(24U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS56 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS56 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(24U);
		}
	}
	if ((RCFDC0CFDTMSTS57 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS57 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(25U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS57 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS57 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(25U);
		}
	}
	if ((RCFDC0CFDTMSTS58 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS58 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(26U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS58 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS58 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(26U);
		}
	}
	if ((RCFDC0CFDTMSTS59 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS59 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(27U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS59 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS59 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(27U);
		}
	}
	if ((RCFDC0CFDTMSTS60 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS60 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(28U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS60 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS60 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(28U);
		}
	}
	if ((RCFDC0CFDTMSTS61 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS61 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(29U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS61 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS61 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(29U);
		}
	}
	if ((RCFDC0CFDTMSTS62 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS62 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(30U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS62 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS62 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(30U);
		}
	}

	if ((RCFDC0CFDTMSTS63 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS63 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(31U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS63 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS63 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(31U);
		}
	}
}

void RSCAN0_CH2_TX_ISR(void)
{
	if (RCFDC0CFDCFSTS6 & 0X10UL)
	{
		RCFDC0CFDCFSTS6 &= 0XFFFFFFEFUL;
	}
	if (RCFDC0CFDCFSTS7 & 0X10UL)
	{
		RCFDC0CFDCFSTS7 &= 0XFFFFFFEFUL;
	}

	if ((RCFDC0CFDTMSTS64 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS64 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(0, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS64 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS64 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(0U);
		}
	}

	if ((RCFDC0CFDTMSTS65 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS65 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(1U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS65 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS65 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(1U);
		}
	}

	if ((RCFDC0CFDTMSTS66 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS66 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(2U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS66 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS66 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(2U);
		}
	}

	if ((RCFDC0CFDTMSTS67 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS67 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(3U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS67 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS67 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(3U);
		}
	}

	if ((RCFDC0CFDTMSTS68 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS68 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(4U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS68 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS68 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(4U);
		}
	}
	if ((RCFDC0CFDTMSTS69 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS69 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(5U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS69 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS69 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(5U);
		}
	}
	if ((RCFDC0CFDTMSTS70 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS70 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(6U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS70 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS70 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(6U);
		}
	}
	if ((RCFDC0CFDTMSTS71 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS71 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(7U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS71 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS71 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(7U);
		}
	}
	if ((RCFDC0CFDTMSTS72 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS72 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(8U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS72 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS72 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(8U);
		}
	}
	if ((RCFDC0CFDTMSTS73 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS73 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(9U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS73 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS73 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(9U);
		}
	}
	if ((RCFDC0CFDTMSTS74 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS74 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(10U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS74 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS74 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(10U);
		}
	}
	if ((RCFDC0CFDTMSTS75 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS75 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(11U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS75 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS75 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(11U);
		}
	}
	if ((RCFDC0CFDTMSTS76 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS76 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(12U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS76 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS76 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(12U);
		}
	}
	if ((RCFDC0CFDTMSTS77 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS77 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(13U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS77 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS77 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(13U);
		}
	}
	if ((RCFDC0CFDTMSTS78 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS78 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(14U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS78 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS78 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(14U);
		}
	}
	if ((RCFDC0CFDTMSTS79 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS79 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(15U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS79 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS79 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(15U);
		}
	}
	if ((RCFDC0CFDTMSTS80 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS80 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(16U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS80 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS80 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(16U);
		}
	}
	if ((RCFDC0CFDTMSTS81 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS81 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(17U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS81 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS81 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(17U);
		}
	}
	if ((RCFDC0CFDTMSTS82 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS82 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(18U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS82 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS82 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(18U);
		}
	}
	if ((RCFDC0CFDTMSTS83 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS83 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(19U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS83 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS83 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(19U);
		}
	}
	if ((RCFDC0CFDTMSTS84 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS84 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(20U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS84 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS84 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(20U);
		}
	}
	if ((RCFDC0CFDTMSTS85 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS85 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(21U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS85 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS85 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(21U);
		}
	}
	if ((RCFDC0CFDTMSTS86 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS86 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(22U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS86 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS86 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(22U);
		}
	}
	if ((RCFDC0CFDTMSTS87 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS87 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(23U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS87 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS87 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(23U);
		}
	}

	if ((RCFDC0CFDTMSTS88 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS88 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(24U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS88 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS88 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(24U);
		}
	}
	if ((RCFDC0CFDTMSTS89 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS89 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(25U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS89 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS89 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(25U);
		}
	}
	if ((RCFDC0CFDTMSTS90 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS90 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(26U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS90 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS90 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(26U);
		}
	}
	if ((RCFDC0CFDTMSTS91 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS91 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(27U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS91 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS91 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(27U);
		}
	}
	if ((RCFDC0CFDTMSTS92 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS92 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(28U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS92 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS92 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(28U);
		}
	}
	if ((RCFDC0CFDTMSTS93 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS93 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(29U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS93 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS93 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(29U);
		}
	}
	if ((RCFDC0CFDTMSTS94 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS94 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(30U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS94 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS94 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(30U);
		}
	}

	if ((RCFDC0CFDTMSTS95 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS95 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(31U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS95 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS95 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(31U);
		}
	}
}

void RSCAN0_CH3_TX_ISR(void)
{

	if (RCFDC0CFDCFSTS9 & 0X10UL)
	{
		RCFDC0CFDCFSTS9 &= 0XFFFFFFEFUL;
	}
	if (RCFDC0CFDCFSTS10 & 0X10UL)
	{
		RCFDC0CFDCFSTS10 &= 0XFFFFFFEFUL;
	}

	if ((RCFDC0CFDTMSTS96 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS96 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(0, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS96 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS96 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(0U);
		}
	}

	if ((RCFDC0CFDTMSTS97 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS97 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(1U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS97 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS97 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(1U);
		}
	}

	if ((RCFDC0CFDTMSTS98 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS98 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(2U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS98 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS98 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(2U);
		}
	}

	if ((RCFDC0CFDTMSTS99 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS99 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(3U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS99 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS99 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(3U);
		}
	}

	if ((RCFDC0CFDTMSTS100 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS100 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(4U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS100 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS100 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(4U);
		}
	}
	if ((RCFDC0CFDTMSTS101 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS101 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(5U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS101 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS101 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(5U);
		}
	}
	if ((RCFDC0CFDTMSTS102 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS102 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(6U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS102 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS102 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(6U);
		}
	}
	if ((RCFDC0CFDTMSTS103 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS103 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(7U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS103 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS103 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(7U);
		}
	}
	if ((RCFDC0CFDTMSTS104 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS104 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(8U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS104 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS104 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(8U);
		}
	}
	if ((RCFDC0CFDTMSTS105 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS105 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(9U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS105 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS105 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(9U);
		}
	}
	if ((RCFDC0CFDTMSTS106 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS106 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(10U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS106 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS106 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(10U);
		}
	}
	if ((RCFDC0CFDTMSTS107 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS107 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(11U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS107 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS107 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(11U);
		}
	}
	if ((RCFDC0CFDTMSTS108 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS108 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(12U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS108 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS108 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(12U);
		}
	}
	if ((RCFDC0CFDTMSTS109 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS109 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(13U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS109 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS109 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(13U);
		}
	}
	if ((RCFDC0CFDTMSTS110 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS110 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(14U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS110 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS110 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(14U);
		}
	}
	if ((RCFDC0CFDTMSTS111 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS111 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(15U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS111 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS111 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(15U);
		}
	}
	if ((RCFDC0CFDTMSTS112 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS112 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(16U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS112 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS112 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(16U);
		}
	}
	if ((RCFDC0CFDTMSTS113 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS113 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(17U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS113 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS113 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(17U);
		}
	}
	if ((RCFDC0CFDTMSTS114 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS114 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(18U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS114 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS114 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(18U);
		}
	}
	if ((RCFDC0CFDTMSTS115 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS115 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(19U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS115 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS115 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(19U);
		}
	}
	if ((RCFDC0CFDTMSTS116 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS116 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(20U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS116 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS116 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(20U);
		}
	}
	if ((RCFDC0CFDTMSTS117 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS117 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(21U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS117 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS117 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(21U);
		}
	}
	if ((RCFDC0CFDTMSTS118 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS118 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(22U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS118 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS118 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(22U);
		}
	}
	if ((RCFDC0CFDTMSTS119 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS119 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(23U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS119 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS119 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(23U);
		}
	}

	if ((RCFDC0CFDTMSTS120 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS120 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(24U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS120 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS120 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(24U);
		}
	}
	if ((RCFDC0CFDTMSTS121 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS121 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(25U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS121 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS121 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(25U);
		}
	}
	if ((RCFDC0CFDTMSTS122 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS122 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(26U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS122 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS122 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(26U);
		}
	}
	if ((RCFDC0CFDTMSTS123 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS123 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(27U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS123 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS123 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(27U);
		}
	}
	if ((RCFDC0CFDTMSTS124 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS124 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(28U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS124 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS124 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(28U);
		}
	}
	if ((RCFDC0CFDTMSTS125 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS125 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(29U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS125 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS125 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(29U);
		}
	}
	if ((RCFDC0CFDTMSTS126 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS126 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(30U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS126 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS126 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(30U);
		}
	}

	if ((RCFDC0CFDTMSTS127 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS127 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(31U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS127 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS127 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh3.pfnRSCANAbortConfirmCallBack(31U);
		}
	}
}

void RSCAN0_CH4_TX_ISR(void)
{
	if (RCFDC0CFDCFSTS12 & 0X10UL)
	{
		RCFDC0CFDCFSTS12 &= 0XFFFFFFEFUL;
	}
	if (RCFDC0CFDCFSTS13 & 0X10UL)
	{
		RCFDC0CFDCFSTS13 &= 0XFFFFFFEFUL;
	}

	if ((RCFDC0CFDTMSTS128 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS128 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(0, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS128 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS128 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(0U);
		}
	}

	if ((RCFDC0CFDTMSTS129 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS129 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(1U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS129 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS129 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(1U);
		}
	}

	if ((RCFDC0CFDTMSTS130 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS130 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(2U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS130 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS130 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(2U);
		}
	}

	if ((RCFDC0CFDTMSTS131 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS131 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(3U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS131 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS131 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(3U);
		}
	}

	if ((RCFDC0CFDTMSTS132 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS132 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(4U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS132 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS132 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(4U);
		}
	}
	if ((RCFDC0CFDTMSTS133 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS133 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(5U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS133 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS133 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(5U);
		}
	}
	if ((RCFDC0CFDTMSTS134 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS134 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(6U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS134 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS134 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(6U);
		}
	}
	if ((RCFDC0CFDTMSTS135 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS135 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(7U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS135 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS135 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(7U);
		}
	}
	if ((RCFDC0CFDTMSTS136 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS136 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(8U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS136 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS136 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(8U);
		}
	}
	if ((RCFDC0CFDTMSTS137 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS137 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(9U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS137 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS137 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(9U);
		}
	}
	if ((RCFDC0CFDTMSTS138 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS138 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(10U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS138 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS138 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(10U);
		}
	}
	if ((RCFDC0CFDTMSTS139 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS139 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(11U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS139 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS139 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(11U);
		}
	}
	if ((RCFDC0CFDTMSTS140 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS140 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(12U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS140 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS140 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(12U);
		}
	}
	if ((RCFDC0CFDTMSTS141 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS141 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(13U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS141 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS141 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(13U);
		}
	}
	if ((RCFDC0CFDTMSTS142 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS142 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(14U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS142 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS142 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(14U);
		}
	}
	if ((RCFDC0CFDTMSTS143 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS143 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(15U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS143 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS143 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(15U);
		}
	}

	if ((RCFDC0CFDTMSTS144 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS144 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(16U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS144 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS144 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(16U);
		}
	}
	if ((RCFDC0CFDTMSTS145 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS145 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(17U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS145 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS145 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(17U);
		}
	}
	if ((RCFDC0CFDTMSTS146 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS146 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(18U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS146 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS146 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(18U);
		}
	}
	if ((RCFDC0CFDTMSTS147 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS147 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(19U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS147 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS147 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(19U);
		}
	}
	if ((RCFDC0CFDTMSTS148 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS148 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(20U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS148 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS148 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(20U);
		}
	}
	if ((RCFDC0CFDTMSTS149 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS149 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(21U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS149 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS149 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(21U);
		}
	}
	if ((RCFDC0CFDTMSTS150 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS150 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(22U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS150 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS150 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(22U);
		}
	}
	if ((RCFDC0CFDTMSTS151 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS151 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(23U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS151 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS151 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(23U);
		}
	}

	if ((RCFDC0CFDTMSTS152 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS152 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(24U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS152 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS152 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(24U);
		}
	}
	if ((RCFDC0CFDTMSTS153 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS153 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(25U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS153 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS153 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(25U);
		}
	}
	if ((RCFDC0CFDTMSTS154 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS154 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(26U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS154 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS154 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(26U);
		}
	}
	if ((RCFDC0CFDTMSTS155 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS155 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(27U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS155 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS155 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(27U);
		}
	}
	if ((RCFDC0CFDTMSTS156 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS156 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(28U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS156 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS156 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(28U);
		}
	}
	if ((RCFDC0CFDTMSTS157 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS157 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(29U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS157 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS157 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(29U);
		}
	}
	if ((RCFDC0CFDTMSTS158 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS158 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(30U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS158 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS158 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(30U);
		}
	}

	if ((RCFDC0CFDTMSTS159 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS159 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(31U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS159 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS159 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh4.pfnRSCANAbortConfirmCallBack(31U);
		}
	}
}
void RSCAN0_CH5_TX_ISR(void)
{
	if (RCFDC0CFDCFSTS15 & 0X10UL)
	{
		RCFDC0CFDCFSTS15 &= 0XFFFFFFEFUL;
	}
	if (RCFDC0CFDCFSTS16 & 0X10UL)
	{
		RCFDC0CFDCFSTS16 &= 0XFFFFFFEFUL;
	}

	if ((RCFDC0CFDTMSTS160 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS160 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(0, 0);
		}
	}
	else if ((RCFDC0CFDTMSTS160 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS160 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(0U);
		}
	}

	if ((RCFDC0CFDTMSTS161 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS161 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(1U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS161 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS161 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(1U);
		}
	}

	if ((RCFDC0CFDTMSTS162 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS162 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(2U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS162 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS162 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(2U);
		}
	}

	if ((RCFDC0CFDTMSTS163 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS163 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(3U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS163 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS163 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(3U);
		}
	}

	if ((RCFDC0CFDTMSTS164 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS164 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(4U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS164 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS164 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(4U);
		}
	}
	if ((RCFDC0CFDTMSTS165 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS165 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(5U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS165 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS165 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(5U);
		}
	}
	if ((RCFDC0CFDTMSTS166 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS166 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(6U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS166 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS166 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(6U);
		}
	}
	if ((RCFDC0CFDTMSTS167 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS167 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(7U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS167 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS167 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(7U);
		}
	}
	if ((RCFDC0CFDTMSTS168 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS168 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(8U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS168 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS168 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(8U);
		}
	}
	if ((RCFDC0CFDTMSTS169 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS169 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(9U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS169 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS169 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(9U);
		}
	}
	if ((RCFDC0CFDTMSTS170 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS170 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(10U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS170 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS170 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(10U);
		}
	}
	if ((RCFDC0CFDTMSTS171 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS171 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(11U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS171 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS171 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(11U);
		}
	}
	if ((RCFDC0CFDTMSTS172 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS172 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(12U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS172 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS172 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(12U);
		}
	}
	if ((RCFDC0CFDTMSTS173 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS173 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(13U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS173 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS173 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(13U);
		}
	}
	if ((RCFDC0CFDTMSTS174 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS174 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(14U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS174 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS174 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(14U);
		}
	}
	if ((RCFDC0CFDTMSTS175 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS175 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(15U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS175 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS175 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(15U);
		}
	}
	if ((RCFDC0CFDTMSTS176 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS176 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(16U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS176 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS176 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(16U);
		}
	}
	if ((RCFDC0CFDTMSTS177 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS177 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(17U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS177 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS177 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(17U);
		}
	}
	if ((RCFDC0CFDTMSTS178 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS178 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(18U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS178 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS178 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(18U);
		}
	}
	if ((RCFDC0CFDTMSTS179 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS179 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(19U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS179 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS179 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(19U);
		}
	}
	if ((RCFDC0CFDTMSTS180 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS180 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(20U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS180 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS180 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(20U);
		}
	}
	if ((RCFDC0CFDTMSTS181 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS181 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(21U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS181 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS181 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(21U);
		}
	}
	if ((RCFDC0CFDTMSTS182 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS182 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(22U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS182 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS182 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(22U);
		}
	}
	if ((RCFDC0CFDTMSTS183 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS183 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(23U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS183 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS183 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(23U);
		}
	}

	if ((RCFDC0CFDTMSTS184 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS184 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(24U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS184 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS184 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(24U);
		}
	}
	if ((RCFDC0CFDTMSTS185 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS185 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(25U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS185 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS185 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(25U);
		}
	}
	if ((RCFDC0CFDTMSTS186 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS186 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(26U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS186 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS186 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(26U);
		}
	}
	if ((RCFDC0CFDTMSTS187 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS187 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(27U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS187 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS187 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(27U);
		}
	}
	if ((RCFDC0CFDTMSTS188 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS188 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(28U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS188 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS188 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(28U);
		}
	}
	if ((RCFDC0CFDTMSTS189 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS189 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(29U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS189 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS189 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(29U);
		}
	}
	if ((RCFDC0CFDTMSTS190 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS190 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(30U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS190 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS190 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(30U);
		}
	}

	if ((RCFDC0CFDTMSTS191 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
	{
		RCFDC0CFDTMSTS191 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(31U, 0U);
		}
	}
	else if ((RCFDC0CFDTMSTS191 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
	{
		RCFDC0CFDTMSTS191 = 0X0U;
		if (g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack)
		{
			g_stRSCAN0Config.stRSCANCh5.pfnRSCANAbortConfirmCallBack(31U);
		}
	}
}

/*********************************************************************/
