#include "main.h"
#include "Task.h"
#include "TYW_stdint.h"
#include "GenDelay.h"
#include "COM_CAN.h"
#include "RTE_GPIO.h"
#include "DoCAN_ISO15765.h"
#include "Flash_synchronizer.h"
#include "RTE_ADC.h"
#include "init.h"
#include "TFT_LCD.h"
#include "TM035HFZGZx.h"
#include "UDS_ISO14229_Server.h"
#include "CANFD_Lib.h"
#include "Display_Info.h"
#include "Key.h"
#include "Check_Ctrl.h"
/*******************************************************************************
 *                                                                              *
 *   ϵͳ��������ģʽ(SYS_MODE_OFF / SYS_MODE_ON / SYS_MODE_STANDBY )�����б�   *
 *                                                                              *
 *******************************************************************************/

/*==============================================================================
αʵʱ����
------------------------------------------------------------------------------*/
void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{

    SD_FMQ = 1;
    DoCAN_Communication_Service( );
    UDS_Server_Application_Service( );
    TFT_LCD_Display_Update_Service( );
}
/*============================================================================*/

/*==============================================================================
2ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_2ms_Tasks_Group(void)
{
    //Can_Write_Fun(2);    //报文外发
    COM_TX_Process();

    COM_RX_Process( );
    RTE_ADC_Services( );
}

/*==============================================================================
2ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_5ms_Tasks_Group(void)
{
}

/*==============================================================================
10ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_10ms_Tasks_Group(void)
{
    BusOff_Service( );
    Key_Service( );
}

/*==============================================================================
20ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_20ms_Tasks_Group0(void)
{
    Total_Check( );
}

/*==============================================================================
50ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_50ms_Tasks_Group(void)
{
    static uint32_t timer_100ms = 0;

    timer_100ms++;

    if ( timer_100ms == 1 )
    {
        Read_IPK_Session_Type( );
    }
    else if ( timer_100ms == 2 )
    {
        timer_100ms = 0;
    }
}

/*==============================================================================
100ms����ִ������ ��0��
------------------------------------------------------------------------------*/

void Sys_Run_Mode_100ms_Tasks_Group(void)
{
    static uint32_t loc_timer = 0;
    loc_timer++;
    if ( loc_timer >= 15 )
    {
        loc_timer = 0;
        HW_CHECK_IPK_EXIST( );
    }
   SET_ODO_Clear_F();
   Get_ODO_Call();
}
/*=================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           ��ȷ��50us��ʱ�����б�                             *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
��ȷ��50us��ʱ���� ��ֹ�����޸��б��е�����
------------------------------------------------------------------------------*/
void Sys_Exact_50us_Tasks(void)
{
    GenDelay_Tick( );
    DoCAN_Timer_Update(50u);
    // COM_TX_Process();
}
/*============================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           ��ȷ��100ms��ʱ�����б�                            *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
��ȷ��100ms��ʱ���� ��ֹ�����޸��б��е�����
------------------------------------------------------------------------------*/
void Sys_Exact_100ms_Tasks(void)
{
    CHECK_IPK_COUNT( );
}
/*============================================================================*/
void Sys_Enter_Sleep_Mode(void)
{
    // Sys_Sleep_Init( );
}
