/******************************************************************************
  UDS_ISO14229_Server.c
ISO 14229 淶涨Ϸ˺ļ
    ߣ
    V1.0
    ڣ2016.11.1
******************************************************************************/
#include "UDS_ISO14229_Server.h"
#include "UDS_ISO14229_Client.h"

UDS_APP_RX_Union UDS_APP_RX;

extern uint8_t CAN_Current_state;

#define POSITIVE_RSP 0
#define NEGATIVE_RSP 1
/******************************************************************************
̨
******************************************************************************/
/******************************************************************************
UDS_Server_Application_Service
  ܣUDSӦòƷ
  
ֵ
*******************************************************************************
ע  ⣺÷뱻ʵʱ
******************************************************************************/
void UDS_Server_Application_Service(void)
{
    UDS_Process_Service_Request( );
}

/******************************************************************************
Ự²ӿڼʱʵ
******************************************************************************/

/******************************************************************************
UDS_N_USData_Request
  ܣ÷
        This service is used to request the transfer of data. If necessary, the
        network layer segments the data.
  N_TAtype    Ŀַ,ʹ DIAG_ID_Tx
        MessageData 
        Length      ݳ
ֵ
******************************************************************************/
void UDS_N_USData_Request(uint32_t N_TAtype, uint8_t *MessageData, uint16_t Length)
{
    DoCAN_N_USData_Request(N_TAtype, MessageData, Length);

    /*ʱ*/
}

/******************************************************************************
UDS_N_USData_Confirm
  ܣ÷㷢,ȷǰһʹN_USData.request
        N_TAtypeַ͵Ƿ
        The N_USData.confirm service is issued by the network layer. The service
        primitive confirms the completion of an N_USData.request service
        identified by the address information in N_TAtype.
  N_TAtype N_USData.confirmķ͵ַ
        N_Result N_USData.requestĴ״̬
ֵ
******************************************************************************/
extern void UDS_N_USData_Confirm(uint32_t N_TAtype, N_ResultEnum N_Result)
{
    if ( N_Result == N_OK )
    {
        UDS_S_Data_Confirm(N_TAtype, S_OK);
    }
    else
    {
        UDS_S_Data_Confirm(N_TAtype, S_NOK);
    }

    /*ʱ*/
}

/******************************************************************************
UDS_N_USData_FF_Indication
  ܣ÷㷢,ϲָʾַΪN_TAtypeһ֡ݵ֡
        ĵ
        The N_USData_FF.indication service is issued by the network layer. The
        service primitive indicates to the adjacent upper layer the arrival of
        a FirstFrame (FF) of a segmented message received from a peer protocol
        entity, identified by the address information N_TAtype.
  N_TAtype µĶ֡֡ĵַϢ
        Length   µĶ֡ݵܳ
ֵ
******************************************************************************/
extern void UDS_N_USData_FF_Indication(uint32_t N_TAtype, uint16_t Length)
{

    /*ʱ*/
}

/******************************************************************************
UDS_N_USData_Indication
  ܣ÷㷢,ϲָN_TAtypeַĳΪLength
        MessageDataݵĴͽN_Result,ͬʱһ
        The N_USData.indication service is issued by the network layer. The
        service primitive indicates <N_Result> events and delivers
        <MessageData> with <Length> bytes received from a peer protocol entity
        identified by the address information in N_TAtype to the adjacent upper
        layer.
  N_TAtype    յݵַϢ
        MessageData յ      (N_ResultΪN_OKʱЧ)
        Length      յݳ  (N_ResultΪN_OKʱЧ)
        N_Result    ݵĽս
ֵ
******************************************************************************/
void UDS_N_USData_Indication(uint32_t N_TAtype, uint8_t *MessageData, uint16_t Length, N_ResultEnum N_Result)
{
    if ( N_Result == N_OK )
    {
        UDS_S_Data_Indication(N_TAtype, MessageData, Length, S_OK);
    }
    else
    {
        UDS_S_Data_Indication(N_TAtype, MessageData, Length, S_NOK);
    }

    /*ʱ*/
}

/******************************************************************************
Ựϲӿ
******************************************************************************/

/******************************************************************************
UDS_S_Data_Request
  ܣ÷ĿַS_TAtypeͳΪS_LengthS_Data.
        The service primitive requests transmission of S_Data with S_Length
        number of bytes from the sender to the receiver peer entities
        identified by the address information in S_TAtype.
  S_TAtype ݵĿַ
        S_Data   ͵
        S_Length ݵĳ
ֵ
******************************************************************************/
void UDS_S_Data_Request(uint32_t S_TAtype, uint8_t *S_Data, uint16_t S_Length)
{
    UDS_N_USData_Request(S_TAtype, S_Data, S_Length);
}

/******************************************************************************
UDS_S_Data_Request
  ܣ÷ɻỰ㷢,ָS_TAtypeΪĿַS_Data.request
        Ƿ
        The S_Data.confirm service is issued by the session layer. The service
        primitive confirms the completion of an S_Data.request service
        identified by the address information in S_TAtype.
  S_TAtype ݵĿַ
        S_Result ݵķͽ
ֵ
******************************************************************************/
void UDS_S_Data_Confirm(uint32_t S_TAtype, S_Result_Enum S_Result)
{
    if ( S_TAtype == DIAG_ID_Tx )
    {
        if ( S_Result == S_NOK )
        {
            UDS_TP_ArTimeOutHandle( );
        }
    }
}

/******************************************************************************
UDS_S_Data_Request
  ܣ÷ɻỰ㷢,ϲָS_Result״̬ԼݴS_TAtypeַ
        յS_LengthȵS_Data

        The S_Data.indication service is issued by the session layer. The
        service primitive indicates S_Result events and delivers S_Data with
        S_Length bytes received from a peer protocol entity identified by the
        address information in S_TAtype to the adjacent upper layer.
  S_TAtype յݵַϢ
        S_Data   յ      (S_ResultΪS_OKʱЧ)
        S_Length յݳ  (S_ResultΪS_OKʱЧ)
        S_Result ݵĽս
ֵ
******************************************************************************/
void UDS_S_Data_Indication(uint32_t S_TAtype, uint8_t S_Data [], uint16_t S_Length, S_Result_Enum S_Result)
{
    uint16_t i;

    if ( S_Result == S_OK )
    {
        UDS_APP_RX.Data.New     = 1u;
        UDS_APP_RX.Data.TA_type = S_TAtype;
        UDS_APP_RX.Data.Length  = S_Length - 1u;

        for ( i = 0u; i < S_Length; i++ )
        {
            UDS_APP_RX.Data.A_Data [ i ] = S_Data [ i ];
        }
    }
    else if ( S_Result == S_NOK )
    {
        UDS_TP_ArTimeOutHandle( );
    }
    else
    {
    }
}

/******************************************************************************
Ӧò
******************************************************************************/

/******************************************************************************
UDS_Process_Service_Request
  ܣúڴԿͻ˵ķ,µķ󵽴ʱ,SIѡ
        Ӧķʵִֺз
  
ֵ  SYSC0_RUNPLL2CNTR
******************************************************************************/
void UDS_Process_Service_Request(void)
{
    uint8_t NRC = 0x7f;
    if ( UDS_APP_RX.A_PDU.New )
    {
        switch ( UDS_APP_RX.A_PDU.A_PCI.SI )
        {
            case 0x50:
                UDS_Service_50_Indication(UDS_APP_RX.A_PDU.TA_type, UDS_APP_RX.A_PDU.Length, UDS_APP_RX.A_PDU.Data);
                break;
            case 0x51:
                UDS_Service_51_Indication(UDS_APP_RX.A_PDU.TA_type, UDS_APP_RX.A_PDU.Length, UDS_APP_RX.A_PDU.Data);
                break;
            case 0x62:
                UDS_Service_62_Indication(UDS_APP_RX.A_PDU.TA_type, UDS_APP_RX.A_PDU.Length, UDS_APP_RX.A_PDU.Data);
                break;
            case 0x6E:
                UDS_Service_6E_Indication(UDS_APP_RX.A_PDU.TA_type, UDS_APP_RX.A_PDU.Length, UDS_APP_RX.A_PDU.Data);
                break;
            case 0x67:
                UDS_Service_67_Indication(UDS_APP_RX.A_PDU.TA_type, UDS_APP_RX.A_PDU.Length, UDS_APP_RX.A_PDU.Data);
                break;
            case 0x6F:
                UDS_Service_6F_Indication(UDS_APP_RX.A_PDU.TA_type, UDS_APP_RX.A_PDU.Length, UDS_APP_RX.A_PDU.Data);
            case 0x7E:
                UDS_Service_7E_Indication(UDS_APP_RX.A_PDU.TA_type, UDS_APP_RX.A_PDU.Length, UDS_APP_RX.A_PDU.Data);
                break;

            case 0x7F:
                UDS_Service_7F_Indication(UDS_APP_RX.A_PDU.TA_type, UDS_APP_RX.A_PDU.Length, UDS_APP_RX.A_PDU.Data);
                break;

            default:




                if ( UDS_APP_RX.A_PDU.TA_type != DIAG_ID_Rx_FUN )
                {
                    NRC = 0x7f; /*֧*/
                    UDS_Service_Response(UDS_APP_RX.A_PDU.A_PCI.SI, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
                }

                break;
        }
        UDS_APP_RX.A_PDU.New = 0u;
    }
}

/******************************************************************************
UDS_Service_Response
  ܣúݷӦķݴݸͻ,ͨڸķ
  si        ID
        RspType     POSITIVE_RSP 
                             NEGATIVE_RSP 
        A_TA_type Ŀַ
        A_Length  淴Яݵĳ(A_Dataĳ)
        A_Data    淴Я
ֵ
******************************************************************************/
void UDS_Service_Response(uint8_t si, uint8_t RspType, uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data [])
{
    uint16_t         i;
    UDS_APP_TX_Union UDS_APP_TX;
    if ( RspType )
    {
        UDS_APP_TX.A_PDU.TA_type    = A_TA_type;
        UDS_APP_TX.A_PDU.A_PCI.SI   = 0x7Fu;
        UDS_APP_TX.A_PDU.Data [ 0 ] = si;
        UDS_APP_TX.A_PDU.Length     = A_Length;

        for ( i = 0u; i < UDS_APP_TX.A_PDU.Length; i++ )
        {
            UDS_APP_TX.A_PDU.Data [ i + 1u ] = A_Data [ i ];
        }

        UDS_S_Data_Request(UDS_APP_TX.Data.TA_type, UDS_APP_TX.Data.A_Data, UDS_APP_TX.Data.Length + 2u);
    }
    else
    {
        UDS_APP_TX.A_PDU.TA_type  = A_TA_type;
        UDS_APP_TX.A_PDU.A_PCI.SI = si;    //| 0x40u;
        UDS_APP_TX.A_PDU.Length   = A_Length;

        for ( i = 0u; i < UDS_APP_TX.A_PDU.Length; i++ )
        {
            UDS_APP_TX.A_PDU.Data [ i ] = A_Data [ i ];
        }

        UDS_S_Data_Request(UDS_APP_TX.Data.TA_type, UDS_APP_TX.Data.A_Data, UDS_APP_TX.Data.Length + 1u);
    }
}
