#ifndef CANFD_CH0_CANFD_COMMUNICATION_MATRIX_H_
#define CANFD_CH0_CANFD_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CANFD_Lib.h"

extern st_CanFDMsgOp CANFD_CH0_CanFDMsgOp;

extern st_CanFDMsgTxOp CANFD_CH0_CanFDMsgTxOp;

typedef enum
{
    CANFD_CH0_ID_GW_50_Msg_Count,
    CANFD_CH0_ID_GW_180_Msg_Count,
    CANFD_CH0_ID_GW_190_Msg_Count,
    CANFD_CH0_ID_GW_244_Msg_Count,
    CANFD_CH0_ID_GW_247_Msg_Count,
    CANFD_CH0_ID_GW_249_Msg_Count,
    CANFD_CH0_ID_GW_262_Msg_Count,
    CANFD_CH0_ID_GW_278_Msg_Count,
    CANFD_CH0_ID_GW_298_Msg_Count,
    CANFD_CH0_ID_GW_304_Msg_Count,
    CANFD_CH0_ID_GW_307_Msg_Count,
    CANFD_CH0_ID_GW_312_Msg_Count,
    CANFD_CH0_ID_GW_319_Msg_Count,
    CANFD_CH0_ID_GW_337_Msg_Count,
    CANFD_CH0_ID_GW_340_Msg_Count,
    CANFD_CH0_ID_GW_346_Msg_Count,
    CANFD_CH0_ID_GW_347_Msg_Count,
    CANFD_CH0_ID_GW_352_Msg_Count,
    CANFD_CH0_ID_GW_366_Msg_Count,
    CANFD_CH0_ID_GW_382_Msg_Count,
    CANFD_CH0_ID_GW_387_Msg_Count,
    CANFD_CH0_ID_GW_390_Msg_Count,
    CANFD_CH0_ID_GW_396_Msg_Count,
    CANFD_CH0_ID_GW_518_Msg_Count,
    CANFD_CH0_ID_GW_572_Msg_Count,
    CANFD_CH0_ID_GW_17A_Msg_Count,
    CANFD_CH0_ID_GW_17C_Msg_Count,
    CANFD_CH0_ID_GW_17D_Msg_Count,
    CANFD_CH0_ID_GW_20B_Msg_Count,
    CANFD_CH0_ID_GW_24F_Msg_Count,
    CANFD_CH0_ID_GW_28B_Msg_Count,
    CANFD_CH0_ID_GW_2A4_Msg_Count,
    CANFD_CH0_ID_GW_2AD_Msg_Count,
    CANFD_CH0_ID_GW_2C6_Msg_Count,
    CANFD_CH0_ID_GW_2E6_Msg_Count,
    CANFD_CH0_ID_GW_31A_Msg_Count,
    CANFD_CH0_ID_GW_31E_Msg_Count,
    CANFD_CH0_ID_GW_33B_Msg_Count,
    CANFD_CH0_ID_GW_34C_Msg_Count,
    CANFD_CH0_ID_GW_39A_Msg_Count,
    CANFD_CH0_ID_GW_39B_Msg_Count,
    CANFD_CH0_ID_GW_3B3_Msg_Count,
    CANFD_CH0_ID_GW_3B7_Msg_Count,
    CANFD_CH0_ID_GW_3EE_Msg_Count,
    CANFD_CH0_ID_GW_3EF_Msg_Count,
    CANFD_CH0_ID_GW_3FC_Msg_Count,
    CANFD_CH0_ID_GW_3FD_Msg_Count,
    CANFD_CH0_ID_GW_3FE_Msg_Count,
    CANFD_CH0_ID_GW_3FF_Msg_Count,
    CANFD_CH0_ID_GW_51E_Msg_Count,
    CANFD_CH0_ID_GW_5FF_Msg_Count,
    CANFD_CH0_ID_GW_63A_Msg_Count,
    CANFD_CH0_ID_GW_331_Msg_Count,
    CANFD_CH0_ID_GW_1AF_Msg_Count,
    CANFD_CH0_ID_GW_320_Msg_Count,
    CANFD_CH0_ID_GW_351_Msg_Count,
    CANFD_CH0_ID_GW_38A_Msg_Count,
    CANFD_CH0_ID_GW_5A0_Msg_Count,
    CANFD_CH0_ID_GW_33A_Msg_Count,
    CANFD_CH0_ID_GW_3D9_Msg_Count,
    CANFD_CH0_ID_GW_3DB_Msg_Count,
    CANFD_CH0_ID_GW_371_Msg_Count,
    CANFD_CH0_ID_GW_10A_Msg_Count,
    CANFD_CH0_ID_GW_10C_Msg_Count,
    CANFD_CH0_ID_GW_53E_Msg_Count,
    CANFD_CH0_ID_GW_538_Msg_Count,
    CANFD_CH0_ID_GW_3DA_Msg_Count,
    CANFD_CH0_ID_THU_365_Msg_Count,
    CANFD_CH0_ID_THU_516_Msg_Count,
    CANFD_CH0_ID_THU_3AF_Msg_Count,
    CANFD_CH0_ID_THU_3BD_Msg_Count,
    CANFD_CH0_ID_THU_3E0_Msg_Count,
    CANFD_CH0_ID_THU_375_Msg_Count,
    CANFD_CH0_ID_THU_553_Msg_Count,
    CANFD_CH0_ID_BDC_2E0_Msg_Count,
    CANFD_CH0_ID_BDC_2E1_Msg_Count,
    CANFD_CH0_ID_BDC_2D1_Msg_Count,
    CANFD_CH0_ID_GW_505_Msg_Count,
    ID_GW_530_Msg_Count,

    CANFD_CH0_ID_TOTAL_MAX,
} CANFD_CH0_CAN_MSG_ID_t;


typedef enum
{
    ID_IP_28A_Msg,
    ID_IP_28E_Msg,
    ID_IP_2DE_Msg,
    ID_IP_3D5_Msg,
    ID_IP_50A_Msg,
    ID_IP_517_Msg,
    // ID_IP_52E_Msg,
    ID_IP_530_Msg,
    ID_IP_54B_Msg,
    ID_IP_5C6_Msg,
    ID_IP_69B_Msg,
    
    CANFD_CH0_ID_SEND_TOTAL,
} CANFD_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANFDMsgAttribute CANFD_CH0_CAN_MSG_CONST_ARRAY[CANFD_CH0_ID_TOTAL_MAX] ;
extern const st_CANFD_SendAttribute    CANFD_CH0_CANSendAttr[CANFD_CH0_ID_SEND_TOTAL] ;

#define  CANFD_CH0_ID_GW_50_Msg      0x050ul
#define  CANFD_CH0_ID_GW_180_Msg     0x180ul
#define  CANFD_CH0_ID_GW_190_Msg     0x190ul
#define  CANFD_CH0_ID_GW_244_Msg     0x244ul
#define  CANFD_CH0_ID_GW_247_Msg     0x247ul
#define  CANFD_CH0_ID_GW_249_Msg     0x249ul
#define  CANFD_CH0_ID_GW_262_Msg     0x262ul
#define  CANFD_CH0_ID_GW_278_Msg     0x278ul
#define  CANFD_CH0_ID_GW_298_Msg     0x298ul
#define  CANFD_CH0_ID_GW_304_Msg     0x304ul
#define  CANFD_CH0_ID_GW_307_Msg     0x307ul
#define  CANFD_CH0_ID_GW_312_Msg     0x312ul
#define  CANFD_CH0_ID_GW_319_Msg     0x319ul
#define  CANFD_CH0_ID_GW_337_Msg     0x337ul
#define  CANFD_CH0_ID_GW_340_Msg     0x340ul
#define  CANFD_CH0_ID_GW_346_Msg     0x346ul
#define  CANFD_CH0_ID_GW_347_Msg     0x347ul
#define  CANFD_CH0_ID_GW_352_Msg     0x352ul
#define  CANFD_CH0_ID_GW_366_Msg     0x366ul
#define  CANFD_CH0_ID_GW_382_Msg     0x382ul
#define  CANFD_CH0_ID_GW_387_Msg     0x387ul
#define  CANFD_CH0_ID_GW_390_Msg     0x390ul
#define  CANFD_CH0_ID_GW_396_Msg     0x396ul
#define  CANFD_CH0_ID_GW_518_Msg     0x518ul
#define  CANFD_CH0_ID_GW_572_Msg     0x572ul
#define  CANFD_CH0_ID_GW_17A_Msg     0x17Aul
#define  CANFD_CH0_ID_GW_17C_Msg     0x17Cul
#define  CANFD_CH0_ID_GW_17D_Msg     0x17Dul
#define  CANFD_CH0_ID_GW_20B_Msg     0x20Bul
#define  CANFD_CH0_ID_GW_24F_Msg     0x24Ful
#define  CANFD_CH0_ID_GW_28B_Msg     0x28Bul
#define  CANFD_CH0_ID_GW_2A4_Msg     0x2A4ul
#define  CANFD_CH0_ID_GW_2AD_Msg     0x2ADul
#define  CANFD_CH0_ID_GW_2C6_Msg     0x2C6ul
#define  CANFD_CH0_ID_GW_2E6_Msg     0x2E6ul
#define  CANFD_CH0_ID_GW_31A_Msg     0x31Aul
#define  CANFD_CH0_ID_GW_31E_Msg     0x31Eul
#define  CANFD_CH0_ID_GW_33B_Msg     0x33Bul
#define  CANFD_CH0_ID_GW_34C_Msg     0x34Cul
#define  CANFD_CH0_ID_GW_39A_Msg     0x39Aul
#define  CANFD_CH0_ID_GW_39B_Msg     0x39Bul
#define  CANFD_CH0_ID_GW_3B3_Msg     0x3B3ul
#define  CANFD_CH0_ID_GW_3B7_Msg     0x3B7ul
#define  CANFD_CH0_ID_GW_3EE_Msg     0x3EEul
#define  CANFD_CH0_ID_GW_3EF_Msg     0x3EFul
#define  CANFD_CH0_ID_GW_3FC_Msg     0x3FCul
#define  CANFD_CH0_ID_GW_3FD_Msg     0x3FDul
#define  CANFD_CH0_ID_GW_3FE_Msg     0x3FEul
#define  CANFD_CH0_ID_GW_3FF_Msg     0x3FFul
#define  CANFD_CH0_ID_GW_51E_Msg     0x51Eul
#define  CANFD_CH0_ID_GW_5FF_Msg     0x5FFul
#define  CANFD_CH0_ID_GW_63A_Msg     0x63Aul
#define  CANFD_CH0_ID_GW_331_Msg     0x331ul
#define  CANFD_CH0_ID_GW_1AF_Msg     0x1AFul
#define  CANFD_CH0_ID_GW_320_Msg     0x320ul
#define  CANFD_CH0_ID_GW_351_Msg     0x351ul
#define  CANFD_CH0_ID_GW_38A_Msg     0x38Aul
#define  CANFD_CH0_ID_GW_5A0_Msg     0x5A0ul
#define  CANFD_CH0_ID_GW_33A_Msg     0x33Aul
#define  CANFD_CH0_ID_GW_3D9_Msg     0x3D9ul
#define  CANFD_CH0_ID_GW_3DB_Msg     0x3DBul
#define  CANFD_CH0_ID_GW_371_Msg     0x371ul
#define  CANFD_CH0_ID_GW_10A_Msg     0x10Aul
#define  CANFD_CH0_ID_GW_10C_Msg     0x10Cul
#define  CANFD_CH0_ID_GW_53E_Msg     0x53Eul
#define  CANFD_CH0_ID_GW_538_Msg     0x538ul
#define  CANFD_CH0_ID_GW_3DA_Msg     0x3DAul
#define  CANFD_CH0_ID_THU_365_Msg    0x365ul
#define  CANFD_CH0_ID_THU_516_Msg    0x516ul
#define  CANFD_CH0_ID_THU_3AF_Msg    0x3AFul
#define  CANFD_CH0_ID_THU_3BD_Msg    0x3BDul
#define  CANFD_CH0_ID_THU_3E0_Msg    0x3E0ul
#define  CANFD_CH0_ID_THU_375_Msg    0x375ul
#define  CANFD_CH0_ID_THU_553_Msg    0x553ul
#define  CANFD_CH0_ID_BDC_2E0_Msg    0x2E0ul
#define  CANFD_CH0_ID_BDC_2E1_Msg    0x2E1ul
#define  CANFD_CH0_ID_BDC_2D1_Msg    0x2D1ul
#define  CANFD_CH0_ID_GW_505_Msg     0x505ul

extern uint32_t Get_ID_ODO(void);
extern uint8_t  Get_CANFD_CH0_ID_050_Sig_SRS_PassengerBuckleSwitchStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_050_Sig_SRS_RightRearBuckleSwitchSts(void);
extern uint8_t  Get_CANFD_CH0_ID_050_Sig_SRS_MiddleRearBuckleSwitchSts(void);
extern uint8_t  Get_CANFD_CH0_ID_050_Sig_SRS_LeftRearBuckleSwitchSts(void);
extern uint8_t  Get_CANFD_CH0_ID_050_Sig_SRS_FrontPsgOccupancy(void);
extern uint8_t  Get_CANFD_CH0_ID_050_Sig_SRS_WarningLampStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_050_Sig_SRS_DriverBuckleSwitchStatus(void);
extern uint16_t Get_CANFD_CH0_ID_180_Sig_SAS_SteeringAngle(void);
extern uint8_t  Get_CANFD_CH0_ID_180_Sig_SAS_SteeringAngleValid(void);
extern uint8_t  Get_CANFD_CH0_ID_190_Sig_BMS_HeatSftySts(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ADS_EOMTOReq(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_HandsOnReq(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_LatTakeoverReq(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_LngTakeOverReq(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_TextInfoForDriver(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_AEBCtrlType(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_FCWPreWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_FCWLatentWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_AWBActive(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_AEBActive(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_CRCCheck_24E(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_RollingCounter_24E(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_ACCMode(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_LKAStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_LDWVibrationWarningReq(void);
extern uint8_t  Get_CANFD_CH0_ID_244_Sig_ACC_LDWStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_247_Sig_APA_CRCCheck_264(void);
extern uint8_t  Get_CANFD_CH0_ID_247_Sig_APA_RollingCounter_264(void);
extern uint8_t  Get_CANFD_CH0_ID_247_Sig_APA_ParkNotice(void);
extern uint8_t  Get_CANFD_CH0_ID_247_Sig_APA_ButtonPress(void);
extern uint8_t  Get_CANFD_CH0_ID_247_Sig_APA_SlotNotice(void);
extern uint8_t  Get_CANFD_CH0_ID_247_Sig_APA_DynamicSlotWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_247_Sig_APA_Activation_Status(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_KeyStandbyPositionIndicator(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_PEPSFailStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_PowerDistributionFaultBit(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_PowerDistributionStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_UnallowStartSignal_Not_PN(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_IMMOFailedAlarmsignal(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_UnallowStart_ESCL_LOCK(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_UnallowStart_ESCL_Error(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_StartIndicatorSignal(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_APA_CloseWinFeedback(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_APA_Engine0ffFeedback(void);
extern uint8_t  Get_CANFD_CH0_ID_262_Sig_PEPS_APA_LockFeedback(void);
extern uint8_t  Get_CANFD_CH0_ID_278_Sig_ESP_RollingCounter_278(void);
extern uint16_t Get_CANFD_CH0_ID_278_Sig_ESP_LongAccel(void);
extern uint8_t  Get_CANFD_CH0_ID_278_Sig_ESP_LatAccel(void);
extern uint8_t  Get_CANFD_CH0_ID_278_Sig_ESP_CRCCheck_278(void);
extern uint8_t  Get_CANFD_CH0_ID_298_Sig_BCM_LeftRearDoorStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_298_Sig_PEPS_UnlockSignal(void);
extern uint8_t  Get_CANFD_CH0_ID_298_Sig_PEPS_LockSignal(void);
extern uint8_t  Get_CANFD_CH0_ID_298_Sig_PEPS_KeyNumber(void);
extern uint8_t  Get_CANFD_CH0_ID_304_Sig_APA_CRCCheck_304(void);
extern uint8_t  Get_CANFD_CH0_ID_304_Sig_APA_RollingCounter_304(void);
extern uint8_t  Get_CANFD_CH0_ID_304_Sig_LAS_FrontCameraCalibrationStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_304_Sig_LAS_FrontCameraFailureStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_304_Sig_ACC_LLaneMarkerType(void);
extern uint8_t  Get_CANFD_CH0_ID_304_Sig_ACC_HostLaneRightStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_304_Sig_ACC_HostLaneLeftStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_304_Sig_ACC_LDWStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_IACCProhibitionTime(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_RLaneDistanceFus(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_LLaneDistanceFus(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_RRLaneDis(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_LLLaneDis(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_Target7ZoneID(void);
extern uint16_t Get_CANFD_CH0_ID_307_Sig_ACC_Target7HeadingAngle(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_Target7Direction(void);
extern uint16_t Get_CANFD_CH0_ID_307_Sig_ACC_Target7LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_307_Sig_ACC_Target7LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_Target7Type(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_Target7ID(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_Target7Detection(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_Target6ZoneID(void);
extern uint16_t Get_CANFD_CH0_ID_307_Sig_ACC_Target6HeadingAngle(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_Target6Direction(void);
extern uint16_t Get_CANFD_CH0_ID_307_Sig_ACC_Target6LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_307_Sig_ACC_Target6LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_Target6Type(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_Target6ID(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_Target6Detection(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_VehicleStartRemindSts(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_CRCCheck_35F(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_RollingCounter_35F(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_CSLAEnableStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_CSLSetReq(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_CRCCheck_344(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_RollingCounter_344(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_CRCCheck_322(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_RollingCounter_322(void);
extern uint16_t Get_CANFD_CH0_ID_307_Sig_ACC_ACCTargetRelSpd(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_FRadarCalibrationStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_CRCCheck_35E(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_RollingCounter_35E(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_FCWSettingStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_AEBEnable(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_ObjValid(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_TimeGapSet(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_DistanceLevel(void);
extern uint8_t  Get_CANFD_CH0_ID_307_Sig_ACC_SetSpeed(void);
extern uint8_t  Get_CANFD_CH0_ID_312_Sig_ADS_EOMWarnning(void);
extern uint8_t  Get_CANFD_CH0_ID_312_Sig_ACC_CRCCheck_3E4(void);
extern uint8_t  Get_CANFD_CH0_ID_312_Sig_ACC_RollingCounter_3E4(void);
extern uint8_t  Get_CANFD_CH0_ID_312_Sig_ACC_AEBTargetDirection(void);
extern uint8_t  Get_CANFD_CH0_ID_312_Sig_ACC_AEBTargetDetection(void);
extern uint8_t  Get_CANFD_CH0_ID_312_Sig_ACC_AEBTargetType(void);
extern uint16_t Get_CANFD_CH0_ID_319_Sig_OBC_ObcChrgInpAcI(void);
extern uint16_t Get_CANFD_CH0_ID_319_Sig_OBC_ObcChrgInpAcU(void);
extern uint16_t Get_CANFD_CH0_ID_319_Sig_DCAC_DcacPwrCnseAct(void);
extern uint16_t Get_CANFD_CH0_ID_319_Sig_DCAC_DcacOutpPwrAvlMax(void);
extern uint8_t  Get_CANFD_CH0_ID_337_Sig_ESP_TPMSresetstatus(void);
extern uint8_t  Get_CANFD_CH0_ID_337_Sig_ESP_TPMS_WarningStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_337_Sig_ESP_TPMS_MalfunctionStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_337_Sig_ESP_RearRghtWheelStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_337_Sig_ESP_RearLeftWheelStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_337_Sig_ESP_FrontRightWheelStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_337_Sig_ESP_FrontLeftWheelStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_340_Sig_AC_FrBlowType(void);
extern uint8_t  Get_CANFD_CH0_ID_346_Sig_EMS_MILIndcdLightInfo(void);
extern uint8_t  Get_CANFD_CH0_ID_346_Sig_EMS_GPF_State(void);
extern uint8_t  Get_CANFD_CH0_ID_346_Sig_EMS_EngLoad(void);
extern uint8_t  Get_CANFD_CH0_ID_346_Sig_EMS_OilPressureSts(void);
extern uint8_t  Get_CANFD_CH0_ID_346_Sig_EMS_MILIndcd(void);
extern uint8_t  Get_CANFD_CH0_ID_346_Sig_EMS_FuelCapLeakDisplay(void);
extern uint16_t Get_CANFD_CH0_ID_346_Sig_EMS_FuCnse(void);
extern uint8_t  Get_CANFD_CH0_ID_346_Sig_EMS_LowPreOilPumpProRemind(void);
extern uint8_t  Get_CANFD_CH0_ID_346_Sig_EMS_EngProtectionRemind(void);
extern uint8_t  Get_CANFD_CH0_ID_347_Sig_TPMS_RRPressureWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_347_Sig_TPMS_LRPressureWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_347_Sig_TPMS_SystemFailureWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_347_Sig_BCM_TirePresureSignalStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_347_Sig_TPMS_LFPressureWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_347_Sig_TPMS_RFPressureWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_347_Sig_TPMS_LRTyrePressure(void);
extern uint8_t  Get_CANFD_CH0_ID_347_Sig_TPMS_RRTyrePressure(void);
extern uint8_t  Get_CANFD_CH0_ID_347_Sig_TPMS_RFTyrePressure(void);
extern uint8_t  Get_CANFD_CH0_ID_347_Sig_TPMS_LFTyrePressure(void);
extern uint8_t  Get_CANFD_CH0_ID_347_Sig_TPMS_SignalStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_352_Sig_DSM_MemorySetSwitch(void);
extern uint8_t  Get_CANFD_CH0_ID_352_Sig_DSM_MemoryAlarm(void);
extern uint8_t  Get_CANFD_CH0_ID_366_Sig_AC_FrReqWindLevel(void);
extern uint8_t  Get_CANFD_CH0_ID_366_Sig_AC_EnvironmentalTemp(void);
extern uint8_t  Get_CANFD_CH0_ID_366_Sig_AC_EnvironmentalTempVD(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target5ZoneID(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target5HeadingAngle(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target5Direction(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target5LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target5LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target5Type(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target5ID(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target5Detection(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target4ZoneID(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target4HeadingAngle(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target4Direction(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target4LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target4LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Targe4Type(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target4ID(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target4Detection(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target3ZoneID(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target3HeadingAngle(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target3Direction(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target3LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target3LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target3Type(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target3ID(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target3Detection(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target2ZoneID(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target2HeadingAngle(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target2Direction(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target2LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target2LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target2Type(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target2ID(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target2Detection(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target1ZoneID(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target1HeadingAngle(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target1Direction(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target1LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_Target1LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target1Type(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target1ID(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_Target1Detection(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_CRCCheck_3E6(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_RollingCounter_3E6(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_LaneEquationStatus(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_LaneEquationC3(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_LaneEquationC2(void);
extern uint16_t Get_CANFD_CH0_ID_382_Sig_ACC_LaneEquationC1(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_LaneQuality(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_CRCCheck_35C(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_RollingCounter_35C(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_CRCCheck_35D(void);
extern uint8_t  Get_CANFD_CH0_ID_382_Sig_ACC_RollingCounter_35D(void);
extern uint8_t  Get_CANFD_CH0_ID_387_Sig_BCM_BLEKeyIndicator(void);
extern uint8_t  Get_CANFD_CH0_ID_387_Sig_BCM_SaveEnergySetStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_387_Sig_BCM_BuzzerWarningMode(void);
extern uint8_t  Get_CANFD_CH0_ID_387_Sig_BCM_Statuslowbeam(void);
extern uint8_t  Get_CANFD_CH0_ID_387_Sig_BCM_DriveModeSet(void);
extern uint8_t  Get_CANFD_CH0_ID_387_Sig_BCM_DriveModeFeedback(void);
extern uint8_t  Get_CANFD_CH0_ID_387_Sig_BCM_DriveModeStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_390_Sig_BCM_BSNLevel(void);
extern uint8_t  Get_CANFD_CH0_ID_390_Sig_BCM_PMSLevel(void);
extern uint8_t  Get_CANFD_CH0_ID_390_Sig_BCM_LowPowerWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_396_Sig_BCM_RemoteWindowUpSetStaus(void);
extern uint8_t  Get_CANFD_CH0_ID_396_Sig_BCM_SunroofRainSetStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_396_Sig_BCM_Sunshade_Movement(void);
extern uint8_t  Get_CANFD_CH0_ID_396_Sig_BCM_Sunshade_POS_VIT_FL(void);
extern uint8_t  Get_CANFD_CH0_ID_396_Sig_BCM_Sunroof_POS_Direction(void);
extern uint8_t  Get_CANFD_CH0_ID_396_Sig_BCM_Sunroof_Movement(void);
extern uint8_t  Get_CANFD_CH0_ID_396_Sig_BCM_Sunroof_POS_VIT(void);
extern uint8_t  Get_CANFD_CH0_ID_396_Sig_BCM_SunroofStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_518_Sig_BCM_CarMode(void);
extern uint8_t  Get_CANFD_CH0_ID_572_Sig_PTS_SpoilerFailStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_17A_Sig_ESP_RollerbenchType(void);
extern uint8_t  Get_CANFD_CH0_ID_17A_Sig_IBCU_BrakeFluid_Warning(void);
extern uint8_t  Get_CANFD_CH0_ID_17A_Sig_ESP_EBDFailStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_17A_Sig_ESP_TCSFailStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_17A_Sig_ESP_ESPActiveStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_17A_Sig_ESP_VehicleSpeedValid(void);
extern uint16_t Get_CANFD_CH0_ID_17A_Sig_ESP_VehicleSpeed(void);
extern uint8_t  Get_CANFD_CH0_ID_17A_Sig_ESP_ESPFunctionStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_17A_Sig_ESP_ABSFailStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_17C_Sig_EMS_EngSts(void);
extern uint8_t  Get_CANFD_CH0_ID_17C_Sig_EMS_EngSpdErr(void);
extern uint16_t Get_CANFD_CH0_ID_17C_Sig_EMS_EngSpd(void);
extern uint16_t Get_CANFD_CH0_ID_17D_Sig_PCU_PwrIndcdRealTqFrontWhl(void);
extern uint8_t  Get_CANFD_CH0_ID_17D_Sig_PCU_PwrTrainSts(void);
extern uint8_t  Get_CANFD_CH0_ID_17D_Sig_PCU_BrkPedlSts(void);
extern uint8_t  Get_CANFD_CH0_ID_17D_Sig_PCU_AccPedlVld(void);
extern uint8_t  Get_CANFD_CH0_ID_17D_Sig_PCU_AccPedl(void);
extern uint8_t  Get_CANFD_CH0_ID_17D_Sig_PCU_StartStopActiveVld(void);
extern uint8_t  Get_CANFD_CH0_ID_20B_Sig_IBCU_precheckStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_20B_Sig_ESP_PrefillforAPA_Available(void);
extern uint8_t  Get_CANFD_CH0_ID_20B_Sig_ESP_PrefillforAPA_active(void);
extern uint8_t  Get_CANFD_CH0_ID_20B_Sig_IBCU_BrakeDiscHighTempWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_20B_Sig_ESP_HHC_Active(void);
extern uint8_t  Get_CANFD_CH0_ID_20B_Sig_ESP_HDC_STATUS(void);
extern uint8_t  Get_CANFD_CH0_ID_20B_Sig_ESP_BrakeLightOnRequest(void);
extern uint8_t  Get_CANFD_CH0_ID_20B_Sig_ESP_AutoHoldStandby(void);
extern uint8_t  Get_CANFD_CH0_ID_20B_Sig_ESP_AutoHoldAvailable(void);
extern uint8_t  Get_CANFD_CH0_ID_20B_Sig_ESP_AutoHoldActive(void);
extern uint8_t  Get_CANFD_CH0_ID_24F_Sig_EPS_TorqueAssistMode(void);
extern uint8_t  Get_CANFD_CH0_ID_24F_Sig_EPS_EPSFailed(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_LockTrigger(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_UnlockTrigger(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_TurnIndicatorLeft(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_TurnIndicatorRight(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_KeyAlarmStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_PEPS_RemoteStartReq(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_emergencylightstatus(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_PowerStatusFeedback(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_DriverDoorStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_HoodStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_LowBeamStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_HighBeamStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_28B_Sig_BCM_TurnLightSwitchSts(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_RCTBStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_CRCCheck_2AF(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_RollingCounter_2AF(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_RCTAStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_RCTAAlert(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_BSD_LCAStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_BSD_LCAAlert(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_SystemStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_Left_RCTAAlert(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_RCTAEnableStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_BSD_LCASoundWar(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_Left_BSD_LCAAlert(void);
extern uint8_t  Get_CANFD_CH0_ID_2A4_Sig_LCDAR_BSD_LCAEnableStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_CRCCheck_300(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RollingCounter_300(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_CRCCheck_2F7(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RollingCounter_2F7(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_CRCCheck_2EF(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RollingCounter_2EF(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_CRCCheck_2AE(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RollingCounter_2AE(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_BackTargetDirection(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RRTargetDirection(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RLTargetDirection(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RRTargetDetection(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_BackTargetID(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_BackTargetType(void);
extern uint16_t Get_CANFD_CH0_ID_2AD_Sig_LCDAL_BackTargetLatRange(void);
extern uint16_t Get_CANFD_CH0_ID_2AD_Sig_LCDAL_BackTargetLngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_BackTargetDetection(void);
extern uint16_t Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RRTargetLatRange(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RRTargetID(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_LRTargetID(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RRTargetType(void);
extern uint16_t Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RRTargetLngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RLTargetType(void);
extern uint16_t Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RLTargetLatRange(void);
extern uint16_t Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RLTargetLngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RLTargetDetection(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_Right_SEAAlert(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_Right_RCWAlert(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_AudioWarningEnableStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_SEAStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_SEAAlert(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_SEAEnableStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RCWStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RCWAlert(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_RCWEnableStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2AD_Sig_LCDAL_SystemStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2C6_Sig_APA_RADSNotice(void);
extern uint8_t  Get_CANFD_CH0_ID_2C6_Sig_APA_right_slot_2_available_sts(void);
extern uint8_t  Get_CANFD_CH0_ID_2C6_Sig_APA_right_slot_1_available_sts(void);
extern uint8_t  Get_CANFD_CH0_ID_2C6_Sig_APA_left_slot_2_available_sts(void);
extern uint8_t  Get_CANFD_CH0_ID_2C6_Sig_APA_left_slot_1_available_sts(void);
extern uint8_t  Get_CANFD_CH0_ID_2C6_Sig_APA_LAEBNotice(void);
extern uint8_t  Get_CANFD_CH0_ID_2C6_Sig_APA_FunctionOnOffSts(void);
extern uint8_t  Get_CANFD_CH0_ID_2C6_Sig_APA_ParkNotice_5(void);
extern uint8_t  Get_CANFD_CH0_ID_2E6_Sig_EMS_EngTCoolt(void);
extern uint8_t  Get_CANFD_CH0_ID_2E6_Sig_EMS_CooltTErr(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_ELKAlert(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_RoadCurvatureNear(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_RoadCurvatureFar(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_RoadCurvature(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_LaneChangeStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_CRCCheck_367(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_RollingCounter_367(void);
extern uint16_t Get_CANFD_CH0_ID_31A_Sig_ACC_LatPathHeadingAngle(void);
extern uint16_t Get_CANFD_CH0_ID_31A_Sig_ACC_LatPathDY(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_ELKEnableStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_ELKInterventionMode(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_ELKMode(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_CRCCheck_30D(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_RollingCounter_30D(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_RRLaneDetection(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_LLLaneDetection(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_HighBeamControl(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_TargetBasedLateralControl(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_IACCHWATextInfoForDriver(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_DriverHandsOffStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_IACCHWAMode(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_CRCCheck_30A(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_RollingCounter_30A(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_IACCHWAEnable(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_RLaneMarkerType(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_LLaneMarkerType(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_HostLaneRightStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_HostLaneLeftStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_CRCCheck_36D(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_RollingCounter_36D(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_FRadarFailureStatus(void);
extern uint16_t Get_CANFD_CH0_ID_31A_Sig_ACC_AEBTargetLatRange(void);
extern uint16_t Get_CANFD_CH0_ID_31A_Sig_ACC_AEBTargetRelSpeed(void);
extern uint16_t Get_CANFD_CH0_ID_31A_Sig_ACC_AEBTargetLngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_Voiceinfo(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_AEBTargetmode(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_AEBTextInfo(void);
extern uint8_t  Get_CANFD_CH0_ID_31A_Sig_ACC_AEBStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_APA_VoiceTipType(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_APA_RR_Rebuild_Target_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_APA_RF_Rebuild_Target_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_APA_LR_Rebuild_Target_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_APA_LF_Rebuild_Target_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_APA_SystemFailureFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_APA_CRCCheck_2A7(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_APA_RollingCounter_2A7(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RFS_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_LFS_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RFC_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_LFC_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RFM_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_LFM_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_APA_CRCCheck_2A6(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_APA_RollingCounter_2A6(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_LRS_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRC_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_LRC_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRM_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_LRM_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRF_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_LRF_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RFF_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_LFF_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_SystemFailureFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_ButtonPress(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_WarningType(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_WarningFrequency(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_LFSDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_LRSDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_RFSDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_RRSDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_LFMDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_RFMDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_RFCDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_LFCDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_RRCDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_LRCDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_RRMDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_31E_Sig_RRS_LRMDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_VehChrgDchaStsinfDis(void);
extern uint16_t Get_CANFD_CH0_ID_33B_Sig_PCU_EnergyAvgAftIgnON(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FuelAvgAftIgnON(void);
extern uint16_t Get_CANFD_CH0_ID_33B_Sig_PCU_EnergyAvgSubtotal(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FuelAvgSubtotal(void);
extern uint16_t Get_CANFD_CH0_ID_33B_Sig_PCU_ECnsAvgSubtotal(void);
extern uint16_t Get_CANFD_CH0_ID_33B_Sig_PCU_EnergyAvgLongTerm(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FuelAvgLongTerm(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_eDTEDesignformula_FB(void);
extern uint16_t Get_CANFD_CH0_ID_33B_Sig_PCU_DteDisp(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FuelLevelDiag(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FuelLeftover(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FuelLeftoverVD(void);
extern uint16_t Get_CANFD_CH0_ID_33B_Sig_PCU_ECnsAvgWholeTerm(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_ElectricLockMode(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_DisChrgSts(void);
extern uint16_t Get_CANFD_CH0_ID_33B_Sig_PCU_eDTEStd(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_SOColorReq(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_DrvFuCnsRenew(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_DisChrgeLamp(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_SysFltIndcnLi(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_SysEgyFlow(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_SOCDsp(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_RdyIndcnLi(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_PwrLimnTmp(void);
extern uint16_t Get_CANFD_CH0_ID_33B_Sig_PCU_eDTE(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_DrvMod(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_ChrgStsLamp_IP(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_ChrgCblConntd(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_Batt12VFltIndcnLi(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FltInfo_DrvAbltyInsuff(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FltInfo_OnlyEV(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FltInfo_DCACFlt(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FltInfo_TMSFlt(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FltInfo_HVPuPdFaild(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FltInfo_SysHiLvlFlt(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FltInfo_SysLoLvlFlt(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FltInfo_MotorFlt(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FltInfo_ELockRelsFlt(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_FltInfo_ChrgAbnorm(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_BattTLow(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_ChrgPwrLow(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_ELockUnclsdChrgn(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_BattChrgHeatg(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_SocLowChrgn(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_HldHevIacc(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_LowSocTryStrtEng(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_MotAdptnReq(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_DchaStrtEngIndcn(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_12VChrgClsd(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_LowSocStrtEng(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_InhbEV(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_LowSocReqChrg(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_ClsChrgCover(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_ChrgCfmPGear(void);
extern uint8_t  Get_CANFD_CH0_ID_33B_Sig_PCU_TipInfo_PullChrgrBefStrt(void);
extern uint16_t Get_CANFD_CH0_ID_33B_Sig_PCU_EcnsTotAftIgnOn(void);
extern uint16_t Get_CANFD_CH0_ID_33B_Sig_PCU_ECnsAvgShortTerm(void);
extern uint8_t  Get_CANFD_CH0_ID_34C_Sig_BMS_BcuBattSocUnderLamp(void);
extern uint16_t Get_CANFD_CH0_ID_34C_Sig_BMS_PredChrgTi(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TSRSpeedLimitType(void);
extern uint16_t Get_CANFD_CH0_ID_39A_Sig_LAS_RoadSignCenterLatRange_RLane(void);
extern uint16_t Get_CANFD_CH0_ID_39A_Sig_LAS_RoadSignCenterLngRange_RLane(void);
extern uint16_t Get_CANFD_CH0_ID_39A_Sig_LAS_RoadSignCenterLatRange_LLane(void);
extern uint16_t Get_CANFD_CH0_ID_39A_Sig_LAS_RoadSignCenterLngRange_LLane(void);
extern uint16_t Get_CANFD_CH0_ID_39A_Sig_LAS_RoadSignCenterLatRange_HLane(void);
extern uint16_t Get_CANFD_CH0_ID_39A_Sig_LAS_RoadSignCenterLngRange_HLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_CrosswalkLngRange_HLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_RoadSignType_RLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_RoadSignType_LLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_RoadSignType_HLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TSRRightLaneStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TSRLeftLaneStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_CRCCheck_3C0(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_RollingCounter_3C0(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TSRRightLaneSpdLimit(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TSRLeftLaneSpdLimit(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_CRCCheck_3D4(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_RollingCounter_3D4(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAStopLine_HostLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLADistance_HostLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLACountDownTime_HostLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TSRMandatorySign(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TSRWarningSign(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TSRProhibitionSign(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_CRCCheck_332(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_RollingCounter_332(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_OverspeedSoundWarningEnSt(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_HMALightDistribution(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_HMAStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TSRHostSpdLimitUnits(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TSRHostSpdLimit(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TSRStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_FrontCameraCalibrationStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_FrontCameraFailureStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_OverspeedWarningOffset(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_OverspeedWarningEnableStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_OverspeedSoundWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_OverspeedVisualWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_CRCCheck_37D(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_RollingCounter_37D(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAArrowDirection_RightLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectType_RightLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectStatus_RightLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectColour_RightLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectDetection_RightLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAArrowDirection_LeftLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectType_LeftLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectStatus_LeftLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectColour_LeftLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectDetection_LeftLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAArrowDirection_HostLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectStatus_HostLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectType_HostLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectColour_HostLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAObjectDetection_HostLane(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAWarninglevel(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_39A_Sig_LAS_TLAEnable(void);
extern uint8_t  Get_CANFD_CH0_ID_39B_Sig_AC_DriverReqTemp(void);
extern uint8_t  Get_CANFD_CH0_ID_3B3_Sig_BCM_FuelTankRefuelTextInfo(void);
extern uint8_t  Get_CANFD_CH0_ID_3B3_Sig_BCM_ReverseLampError(void);
extern uint8_t  Get_CANFD_CH0_ID_3B3_Sig_BCM_CHMLampError(void);
extern uint8_t  Get_CANFD_CH0_ID_3B3_Sig_BCM_BrakeLampError(void);
extern uint8_t  Get_CANFD_CH0_ID_3B3_Sig_BCM_RightRearFoglampError(void);
extern uint8_t  Get_CANFD_CH0_ID_3B3_Sig_BCM_LeftRearFoglampError(void);
extern uint8_t  Get_CANFD_CH0_ID_3B3_Sig_BCM_RearPositionLampError(void);
extern uint8_t  Get_CANFD_CH0_ID_3B3_Sig_BCM_RearFoglampStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3B7_Sig_AVM_DoorOpenWarningOnOff(void);
extern uint8_t  Get_CANFD_CH0_ID_3B7_Sig_AVM_FullSpeedPanoramicOnOff(void);
extern uint8_t  Get_CANFD_CH0_ID_3B7_Sig_AVM_RightCameraSts(void);
extern uint8_t  Get_CANFD_CH0_ID_3B7_Sig_AVM_LeftCameraSts(void);
extern uint8_t  Get_CANFD_CH0_ID_3B7_Sig_AVM_RearCameraSts(void);
extern uint8_t  Get_CANFD_CH0_ID_3B7_Sig_AVM_FrontCameraSts(void);
extern uint16_t Get_CANFD_CH0_ID_3B7_Sig_AVM_3DHorAngleStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3B7_Sig_AVM_LicenseNumberSetStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3B7_Sig_AVM_WheelHubSetSetStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3B7_Sig_AVM_AVMDVRReplayModeStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3B7_Sig_AVM_BodyColourSetStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3EE_Sig_GW_DigKeyTimWarn(void);
extern uint8_t  Get_CANFD_CH0_ID_3EF_Sig_BCM_RmoteUVLightFeedback(void);
extern uint8_t  Get_CANFD_CH0_ID_3EF_Sig_BCM_UV_LightStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3EF_Sig_BCM_LaneChangeTurnLightSetStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3EF_Sig_LCM_Dimmerlevel(void);
extern uint32_t Get_CANFD_CH0_ID_3FC_Sig_PCU_FltInfo_PartsFlt(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_ForceEVStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_SmareSceneSwitchStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_Breakscore(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_Quickscore(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_TotalDrivescore(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_TipInfo_12VChrgSysFlt(void);
extern uint16_t Get_CANFD_CH0_ID_3FC_Sig_PCU_IPDrvEgyValInd(void);
extern uint16_t Get_CANFD_CH0_ID_3FC_Sig_PCU_TarCruiseSpd(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_CruiseIndicate(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_FuelLevelPercent(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_CruiseActiveIndicate(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_CruiseUnavailDisplay(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_Evlamp(void);
extern uint16_t Get_CANFD_CH0_ID_3FC_Sig_PCU_PredDisChrgTi(void);
extern uint16_t Get_CANFD_CH0_ID_3FC_Sig_PCU_ECnsAvgAftRefuel(void);
extern uint16_t Get_CANFD_CH0_ID_3FC_Sig_PCU_ECnsAvgAftRechrg(void);
extern uint16_t Get_CANFD_CH0_ID_3FC_Sig_PCU_ECnsAvgAftIgnON(void);
extern uint8_t  Get_CANFD_CH0_ID_3FC_Sig_PCU_CoastLevel(void);
extern uint16_t Get_CANFD_CH0_ID_3FC_Sig_PCU_IPDrvEgyInd(void);
extern uint16_t Get_CANFD_CH0_ID_3FC_Sig_PCU_ECnsAvgLongTerm(void);
extern uint16_t Get_CANFD_CH0_ID_3FC_Sig_PCU_ExtChrgPwr(void);
extern uint8_t  Get_CANFD_CH0_ID_3FD_Sig_BCM_EPSTorqueMode(void);
extern uint8_t  Get_CANFD_CH0_ID_3FE_Sig_BuzzerStaus(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_TurnIndicatorRightError(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_TurnIndicatorLeftError(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_FollowMeHomeLightSetStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_RightDayLampError(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_LeftDayLampError(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_RightFrontFoglampError(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_LeftFrontFoglampError(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_RightLowBeamError(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_LeftLowBeamError(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_FrontPositionLampError(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_FrontFoglampStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_FollowMeTurnon(void);
extern uint8_t  Get_CANFD_CH0_ID_3FF_Sig_BCM_PositionLampStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_51E_Sig_TPMS_Commendatorypressure(void);
extern uint8_t  Get_CANFD_CH0_ID_51E_Sig_TPMS_AerateFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_51E_Sig_TPMS_Suggestion(void);
extern uint8_t  Get_CANFD_CH0_ID_51E_Sig_TPMS_LRLeakageWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_51E_Sig_TPMS_RRLeakageWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_51E_Sig_TPMS_RFLeakageWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_51E_Sig_TPMS_LFLeakageWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_51E_Sig_TPMS_LFTemperatureWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_51E_Sig_TPMS_RFTemperatureWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_51E_Sig_TPMS_RRTemperatureWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_51E_Sig_TPMS_LRTemperatureWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_5FF_Sig_PEPS_KeyInCarAlarmSignal(void);
extern uint8_t  Get_CANFD_CH0_ID_5FF_Sig_PEPS_KeyUndetectedAlarmSignal(void);
extern uint8_t  Get_CANFD_CH0_ID_5FF_Sig_PEPS_KeyBatteryStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_5FF_Sig_BCM_KeyInSignal(void);
extern uint8_t  Get_CANFD_CH0_ID_5FF_Sig_BCM_RKEUnlockDoorTypeSetStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_5FF_Sig_BCM_AutoIGNOFFUnlockSetStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_5FF_Sig_BCM_AutoSpeedLockSetStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_5FF_Sig_BCM_PowerOffDisplayReq(void);
extern uint8_t  Get_CANFD_CH0_ID_63A_Sig_BMS_ChrgModeDisp(void);
extern uint8_t  Get_CANFD_CH0_ID_331_Sig_TCU_DriverRemindIPReq(void);
extern uint8_t  Get_CANFD_CH0_ID_331_Sig_TCU_EPBFaultIPReq(void);
extern uint8_t  Get_CANFD_CH0_ID_331_Sig_TCU_TransTempWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_331_Sig_TCU_PowerplantStatusIPReq(void);
extern uint8_t  Get_CANFD_CH0_ID_331_Sig_TCU_ParkSelectIPReq(void);
extern uint8_t  Get_CANFD_CH0_ID_331_Sig_TCU_ParkRelMPosnIPReq(void);
extern uint8_t  Get_CANFD_CH0_ID_331_Sig_TCU_ParkRelAPosnIPReq(void);
extern uint8_t  Get_CANFD_CH0_ID_331_Sig_TCU_GearForDisplay(void);
extern uint8_t  Get_CANFD_CH0_ID_331_Sig_TCU_FailureLamp(void);
extern uint8_t  Get_CANFD_CH0_ID_331_Sig_TCU_ESLFaultIPReq(void);
extern uint8_t  Get_CANFD_CH0_ID_331_Sig_TCU_ARCFaultIPReq(void);
extern uint8_t  Get_CANFD_CH0_ID_1AF_Sig_TCU_ShiftPostionValid(void);
extern uint8_t  Get_CANFD_CH0_ID_1AF_Sig_TCU_GearShiftPosition(void);
extern uint8_t  Get_CANFD_CH0_ID_1AF_Sig_TCU_ActualDrivingGearValid(void);
extern uint8_t  Get_CANFD_CH0_ID_1AF_Sig_TCU_ActualDrivingGear(void);
extern uint8_t  Get_CANFD_CH0_ID_320_Sig_GW_OTAmode_Chks(void);
extern uint8_t  Get_CANFD_CH0_ID_320_Sig_GW_OTAmode_Cntr(void);
extern uint8_t  Get_CANFD_CH0_ID_320_Sig_GW_OTAmode(void);
extern uint8_t  Get_CANFD_CH0_ID_320_Sig_GW_ResetReq(void);
extern uint8_t  Get_CANFD_CH0_ID_320_Sig_GW_ADSSecOCVerifyFailureFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_351_Sig_PEPS_FISStartRequest(void);
extern uint8_t  Get_CANFD_CH0_ID_38A_Sig_GW_MFS_Answer_switch_signal(void);
extern uint8_t  Get_CANFD_CH0_ID_38A_Sig_GW_MFS_Hungup_switch_signal(void);
extern uint8_t  Get_CANFD_CH0_ID_38A_Sig_GW_MFS_DiagInfoSW_38A(void);
extern uint8_t  Get_CANFD_CH0_ID_38A_Sig_GW_MFS_OK_switch(void);
extern uint8_t  Get_CANFD_CH0_ID_38A_Sig_GW_MFS_Down_switch(void);
extern uint8_t  Get_CANFD_CH0_ID_38A_Sig_GW_MFS_UP_switch(void);
extern uint8_t  Get_CANFD_CH0_ID_38A_Sig_GW_MFS_Right_switch(void);
extern uint8_t  Get_CANFD_CH0_ID_38A_Sig_GW_MFS_Left_switch(void);
extern uint16_t Get_CANFD_CH0_ID_5A0_Sig_CHM_output_curr(void);
extern uint16_t Get_CANFD_CH0_ID_5A0_Sig_CHM_output_volt(void);
extern uint8_t  Get_CANFD_CH0_ID_33A_Sig_EMS_FuelTankLetOutSts(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget10ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget10Type(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget10LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget10LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget9ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget9Type(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget9LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget9LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget8ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget8Type(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget8LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget8LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget7ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget7Type(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget7LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget7LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget6ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget6Type(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget6LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget6LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget5ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget5Type(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget5LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget5LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget4ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget4Type(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget4LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget4LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget3ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget3Type(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget3LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget3LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget2ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget2Type(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget2LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget2LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget1ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget1Type(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget1LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3D9_Sig_ACC_ObsTarget1LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget20ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget20Type(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget20LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget20LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget19ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget19Type(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget19LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget19LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget18ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget18Type(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget18LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget18LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget17ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget17Type(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget17LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget17LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget16ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget16Type(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget16LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget16LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget15ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget15Type(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget15LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget15LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget14ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget14Type(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget14LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget14LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget13ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget13Type(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget13LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget13LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget12ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget12Type(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget12LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget12LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget11ID(void);
extern uint8_t  Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget11Type(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget11LatRange(void);
extern uint16_t Get_CANFD_CH0_ID_3DB_Sig_ACC_ObsTarget11LngRange(void);
extern uint8_t  Get_CANFD_CH0_ID_371_Sig_PCU_SOCSaveSts(void);
extern uint8_t  Get_CANFD_CH0_ID_371_Sig_PCU_DriveModeMemoryStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_371_Sig_PCU_Drivescore(void);
extern uint8_t  Get_CANFD_CH0_ID_371_Sig_PCU_chargSpeedFB(void);
extern uint8_t  Get_CANFD_CH0_ID_371_Sig_PCU_ParkingModeReminder(void);
extern uint8_t  Get_CANFD_CH0_ID_371_Sig_PCU_EnterParkingModeReminder(void);
extern uint8_t  Get_CANFD_CH0_ID_371_Sig_PCU_EmergencyModeReminder(void);
extern uint8_t  Get_CANFD_CH0_ID_371_Sig_PCU_SpecialModeSetFB(void);
extern uint8_t  Get_CANFD_CH0_ID_371_Sig_PCU_DrvMod2(void);
extern uint8_t  Get_CANFD_CH0_ID_10A_Sig_EPB_RollingCounter_10A(void);
extern uint8_t  Get_CANFD_CH0_ID_10A_Sig_EPB_CRCCheck_10A(void);
extern uint8_t  Get_CANFD_CH0_ID_10A_Sig_EPB_SwitchPosition(void);
extern uint8_t  Get_CANFD_CH0_ID_10A_Sig_EPB_SwitchPositionValid(void);
extern uint8_t  Get_CANFD_CH0_ID_10A_Sig_EPB_TextDisplay(void);
extern uint8_t  Get_CANFD_CH0_ID_10A_Sig_EPB_FunctionLamp(void);
extern uint8_t  Get_CANFD_CH0_ID_10A_Sig_EPB_FailureLamp(void);
extern uint16_t Get_CANFD_CH0_ID_10C_Sig_TM1_MotSpd(void);
extern uint8_t  Get_CANFD_CH0_ID_10C_Sig_TM1_Resolvercalibrstatus(void);
extern uint8_t  Get_CANFD_CH0_ID_53E_Sig_GM_Resolvercalibrstatus(void);
extern uint8_t  Get_CANFD_CH0_ID_538_Sig_TM2_Resolvercalibrstatus(void);
extern uint8_t  Get_CANFD_CH0_ID_3DA_Sig_DSM_FaceIDDriverSeatStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_365_Sig_IMS_DistractionWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_365_Sig_IMS_DrowsinessWarning(void);
extern uint32_t Get_CANFD_CH0_ID_516_Sig_HU_LeaveMaintainMileage(void);
extern uint16_t Get_CANFD_CH0_ID_516_Sig_HU_LeaveMaintainDay(void);
extern uint8_t  Get_CANFD_CH0_ID_516_Sig_HU_MaintainRemindReq(void);
extern uint8_t  Get_CANFD_CH0_ID_516_Sig_HU_LocalTimeSystem(void);
extern uint8_t  Get_CANFD_CH0_ID_516_Sig_HU_LocalTimeSecond(void);
extern uint8_t  Get_CANFD_CH0_ID_516_Sig_HU_LocalTimeMinute(void);
extern uint8_t  Get_CANFD_CH0_ID_516_Sig_HU_LocalTimeHour(void);
extern uint8_t  Get_CANFD_CH0_ID_516_Sig_HU_LocalTimeDate(void);
extern uint8_t  Get_CANFD_CH0_ID_516_Sig_HU_LocalTimeYear(void);
extern uint8_t  Get_CANFD_CH0_ID_516_Sig_HU_LocalTimeMonth(void);
extern uint8_t  Get_CANFD_CH0_ID_516_Sig_HU_LocalTimeValid(void);
extern uint8_t  Get_CANFD_CH0_ID_3AF_Sig_HU_IPHudHeightSw(void);
extern uint8_t  Get_CANFD_CH0_ID_3AF_Sig_HU_NavCurrentRoadType(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_DayNightTheme(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_SubtotalClrSw(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_EngDistSw(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_URSoundWarEnable(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_RaceModeRecord(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_DisplayModeSet_2(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_ThemeByDrivemode(void);
extern uint16_t Get_CANFD_CH0_ID_3BD_Sig_HU_Compass(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_VC_VR(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_Seeoffanimation(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_LanguageSync(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_NaviIconNumber_2(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_HU_NaviIconNumber(void);
extern uint32_t Get_CANFD_CH0_ID_3BD_Sig_HU_NaviDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_TBOX_ChrgStrtHour(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_TBOX_ChrgStrtDay(void);
extern uint8_t  Get_CANFD_CH0_ID_3BD_Sig_TBOX_ChrgStrtMin(void);
extern uint8_t  Get_CANFD_CH0_ID_3E0_Sig_AVM_MODAlert_Sound(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_FaceIDStartEngineSwitch(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_FaceIDDetectFailReason(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_FaceIDDetectErrorSts(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_FaceIDEntrySts(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_FaceIDDetectSts(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_IPDimmerLevel(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_FaceIDEnableStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_DistractionWarning(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_IPSoundStyleSetting(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_IPDimmingSetting(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_IPDimmingModeSet(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_ScreenPowerOn(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_ThemeChange(void);
extern uint8_t  Get_CANFD_CH0_ID_375_Sig_HU_CarWashModelRequest(void);
extern uint8_t  Get_CANFD_CH0_ID_553_Sig_HU_AlarmSoundSet(void);
extern uint8_t  Get_CANFD_CH0_ID_553_Sig_HU_WelcomeSoundSet(void);
extern uint8_t  Get_CANFD_CH0_ID_553_Sig_HU_MessageAlertSoundSet(void);
extern uint8_t  Get_CANFD_CH0_ID_553_Sig_HU_RearSeatbeltWarningEnable(void);
extern uint8_t  Get_CANFD_CH0_ID_553_Sig_HU_ACCPush(void);
extern uint8_t  Get_CANFD_CH0_ID_553_Sig_HU_IPWarningVolumeSetting(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_SwitchIndicatorError(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_SystemFailureFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_LFMSnsErrFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_RFMSnsErrFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_SpkErrFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_LFCSnsErrFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_RFCSnsErrFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_LRCSnsErrFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_RRCSnsErrFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_LRMidSnsErrFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_RRMidSnsErrFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_BattVoltErrFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_ctrlModulErrFlag(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_WarningType(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_FrontRadarActiveStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_WarningFrequency(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_RFCRealDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_LFMDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_RFMDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_RFCDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_LFCDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_RRCDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_LRCDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_RRMDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_2E0_Sig_RRS_LRMDistance(void);
extern uint8_t  Get_CANFD_CH0_ID_2E1_Sig_RRS_LoudspeakersPosition(void);
extern uint8_t  Get_CANFD_CH0_ID_2E1_Sig_RFM_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_2E1_Sig_LFM_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_2E1_Sig_RFC_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_2E1_Sig_LFC_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_2E1_Sig_RRC_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_2E1_Sig_LRC_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_2E1_Sig_RRM_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_2E1_Sig_LRM_Sector_Dist(void);
extern uint8_t  Get_CANFD_CH0_ID_2D1_Sig_BCM_ReversePosition(void);
extern uint8_t  Get_CANFD_CH0_ID_2D1_Sig_BCM_TrunkDoorStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2D1_Sig_BCM_RightRearDoorStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_2D1_Sig_BCM_PassengerDoorStatus(void);
extern uint8_t  Get_CANFD_CH0_ID_505_Sig_ESL_drvMod2SwSts(void);

extern uint8_t  Co_CanFD_ConvertSubID_CANFD_CH0(uint32_t MsgID);

#endif
