#ifndef RSCAN_TABLE_H
#define RSCAN_TABLE_H

#include "r_typedefs.h"


/* structure */
typedef struct
{
  uint32_t data[4];
} RSCANFD_Filter_st_t;

#define CANFD0_CH0_RX_RULE_SIZE 0U
#define CANFD0_CH1_RX_RULE_SIZE 0U
#define CANFD0_CH2_RX_RULE_SIZE 1U
#define CANFD0_CH3_RX_RULE_SIZE 0U
#define CANFD0_CH4_RX_RULE_SIZE 10U
#define CANFD0_CH5_RX_RULE_SIZE 0U
#define CANFD0_CH6_RX_RULE_SIZE 0U
#define CANFD0_CH7_RX_RULE_SIZE 0U

#define CANFD0_RX_RULE_SIZE (CANFD0_CH0_RX_RULE_SIZE + \
                             CANFD0_CH1_RX_RULE_SIZE + \
                             CANFD0_CH2_RX_RULE_SIZE + \
                             CANFD0_CH3_RX_RULE_SIZE + \
                             CANFD0_CH4_RX_RULE_SIZE + \
                             CANFD0_CH5_RX_RULE_SIZE + \
                             CANFD0_CH6_RX_RULE_SIZE + \
                             CANFD0_CH7_RX_RULE_SIZE)

extern const RSCANFD_Filter_st_t CANFD_RX_RULE_TABLE_LIST[CANFD0_RX_RULE_SIZE];

#endif
