#include "RTE_CAN.h"
#include "RTE_GPIO.h"
#include "CANFD_CH0_CANFD_Communication_Matrix.h"
#include "Diag_ID_Def.h"
#include "DoCAN_ISO15765.h"
#include "RSCAN.h"
#include "RSCAN_Table.h"
#include "Check_Ctrl.h"

BusOffMonitorStruct BusOffMonitor;    // BusOff监控结构体
static uint8_t      BusOffCnt = 0u;
//初始化Bus Off监控结构体
void BusOff_Init(void)
{
    //重置相关信息
    BusOffMonitor.Status = BUS_OFF_STATUS_STABLE;
    BusOffMonitor.Timer  = 0;
    BusOffMonitor.Cnt    = 0;
    BusOffCnt            = 0;
}

// OSEK BusOff的判断，只需判断无需进行恢复操作
void BusOff_Service(void)
{
    RSCAN0_CH4_Busoff_Recover( );
    RSCAN0_CH1_Busoff_Recover( );
    RSCAN0_CH2_Busoff_Recover( );
}
/***Middle***/
void Can_Init(void)
{
    CAN_Frame_st_t     stCANFrame;
    RSCAN0_Config_st_t loc_can                      = {0};
    loc_can.stRSCANCh2.enRSCANChMode                 = RSCAN_MODE_CANFD;
    loc_can.stRSCANCh2.enRSCANChBps                 = RSCAN_Baud_Rate_500K;
    loc_can.stRSCANCh2.enRSCANFDChBps                 = RSCANFD_Baud_Rate_2M;
    loc_can.stRSCANCh2.u32RSCANChRuleSize           = CANFD0_CH2_RX_RULE_SIZE;
    loc_can.stRSCANCh2.pfnRSCANConfirmCallBack      = Can_Confirm;
    loc_can.stRSCANCh2.pfnRSCANReadMsgCallBack      = Can_Read_Msg;
    loc_can.stRSCANCh2.pfnRSCANAbortConfirmCallBack = 0;

    loc_can.stRSCANCh4.enRSCANChMode                 = RSCAN_MODE_CANFD;
    loc_can.stRSCANCh4.enRSCANChBps                 = RSCAN_Baud_Rate_500K;
    loc_can.stRSCANCh4.enRSCANFDChBps                 = RSCANFD_Baud_Rate_2M;
    loc_can.stRSCANCh4.u32RSCANChRuleSize           = CANFD0_CH4_RX_RULE_SIZE;
    loc_can.stRSCANCh4.pfnRSCANConfirmCallBack      = Can_Confirm;
    loc_can.stRSCANCh4.pfnRSCANReadMsgCallBack      = Can_Read_Msg;
    loc_can.stRSCANCh4.pfnRSCANAbortConfirmCallBack = 0;

    RSCAN0_CH_Init(CANFD_RX_RULE_TABLE_LIST, &loc_can);


}

void Can_DeInit(void)
{
}

uint8_t Can_Write(_CAN_Msg *Msg)
{
    CAN_Frame_st_t m_msg;
    uint32_t       i;
    uint32_t       idx;
    m_msg.u32CANID      = Msg->MsgID;
    m_msg.u8CANLEN      = Msg->MsgDLC;
    m_msg.u8CANFrameIDE = 0;
    m_msg.u8CANFrameType = 1;
    for ( i = 0; i < m_msg.u8CANLEN; i++ )
    {
        m_msg.unCANData.u8CANData [ i ] = Msg->Msg [ i ];
    }
    if(CAN_Msg_Tx_Enable == 0)
    {
        return 0;
    }
    RSCAN0_CH4_Set_TXBUF_Data(Msg->MsgPro, &m_msg);

    return 0;
}

uint32_t CAN0_FD_DLC_ChangeTo_Register(uint32_t u32CANFDLen)
{
	uint32_t u32CANFDResult = u32CANFDLen;
		switch (u32CANFDLen)
		{
		case 9:
			u32CANFDResult = 12U;
			break;
		case 10:
			u32CANFDResult = 16U;
			break;
		case 11:
			u32CANFDResult = 20U;
			break;
		case 12:
			u32CANFDResult = 24U;
			break;
		case 13:
			u32CANFDResult = 32U;
			break;
		case 14:
			u32CANFDResult = 48U;
			break;
		case 15:
			u32CANFDResult = 64U;
			break;
		case 8:
		case 7:
		case 6:
		case 5:
		case 4:
		case 3:
		case 2:
		case 1:
			u32CANFDResult = 8;
			break;
		default:
			u32CANFDResult = 8U;
			break;
		}

	return u32CANFDResult;
}

uint8_t Can_Write_FIFO(_CAN_Msg *Msg)
{
     static CAN_Frame_st_t m_msg;
    uint32_t       i;
    uint32_t       idx;
    m_msg.u32CANID      = Msg->MsgID;
    m_msg.u8CANLEN      = Msg->MsgDLC; //CAN0_FD_DLC_ChangeTo_Register(Msg->MsgDLC);
    m_msg.u8CANFrameIDE = 0;
    m_msg.u8CANFrameType = 1;
    for ( i = 0; i < m_msg.u8CANLEN; i++ )
    {
        m_msg.unCANData.u8CANData [ i ] = Msg->Msg [ i ];
    }
    if(CAN_Msg_Tx_Enable == 0)
    {
        return 0;
    }
    RSCAN0_CH4_Set_FIFO0_Data(&m_msg);

    return 0;
}

void Can_Sleep_Fun(void)
{
}

void Can_SleepController_Fun(void)
{
}

void Can_Wakeup_Fun(void)
{
}

void Can_Uds_Abort(void)
{
}

void Can_Abort_All(void)
{
}

/*****Lower*******/
void Can_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg [])
{
    Co_CanFD_Buff_Set(&CANFD_CH0_CanFDMsgOp,Co_CanFD_ConvertSubID_CANFD_CH0(m_id), m_dlc, m_Msg);
    if ( (m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY) )
    {

        DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg);
    }
}

void Can_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
    uint32_t MSG_ID;
    MSG_ID = 0ul;
    switch ( Identifier )
    {
        case RSCAN_CHANNEL_BUF_2:
            MSG_ID = 0x401ul;
            break;
        case RSCAN_CHANNEL_BUF_3:
            MSG_ID = 0x260ul;

            break;
        case RSCAN_CHANNEL_BUF_4:
            MSG_ID = 0x280ul;

            break;
        case RSCAN_CHANNEL_BUF_5:
            MSG_ID = 0x380ul;

            break;
        case RSCAN_CHANNEL_BUF_6:
            MSG_ID = 0x385ul;
            break;
        case RSCAN_CHANNEL_BUF_7:
            MSG_ID = 0x69bul;
            break;
        case RSCAN_CHANNEL_BUF_8:
            MSG_ID = 0x28Aul;
            break;
        case RSCAN_CHANNEL_BUF_1:
            MSG_ID = 0x701ul;
            break;
        case RSCAN_CHANNEL_BUF_0:
            MSG_ID = 0x701ul;
            DoCAN_L_Data_Confirm(MSG_ID, TransferStatus);
            break;
        default:
            break;
    }

    if ( TransferStatus == 0x00 )
    {
        DoCAN_L_Data_Confirm(Identifier, 1);
    }
    else
    {
    }
}
