#ifndef FRE_IN_H__
#define FRE_IN_H__


/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
//#define FRE_IN_PLATFORM_16BIT
#ifdef FRE_IN_PLATFORM_16BIT
typedef unsigned char Fre_uint8_t;
typedef unsigned int Fre_uint16_t;
typedef unsigned long Fre_uint32_t;
#else
typedef unsigned char Fre_uint8_t;
typedef unsigned short Fre_uint16_t;
typedef unsigned int Fre_uint32_t;
typedef unsigned long long Fre_uint64_t;
#endif
/*所有需要采集的频率通道*/

typedef enum
{
    FRE_VEHICLE = 0U,
    FRE_ENGINE,
    FRE_CHANNEL_MAX,
} Fre_Channel_en_t;


/**************************Do not modify the following********************/
/**************************Do not modify the following********************/
/**************************Do not modify the following********************/
#define FRE_RAM_DATA_LEN (FRE_CHANNEL_MAX * 24U)
typedef enum
{
    FRE_SAMP_TIMER = 0U,    /*使用定时器中断进行采集*/
    FRE_SAMP_CAPTURE_ROLL,  /*使用捕获功能，滚动计数*/
    FRE_SAMP_CAPTURE_RESET, /*使用捕获功能，每次计数清零*/
    FRE_SAMP_MAX,
} Fre_Sample_Type_en_t;
typedef enum
{
    FRE_STATUS_INIT = 0U, /*初始状态，未采集判断完成*/
    FRE_STATUS_TIME_OUT,  /*输入信号异常，常高或者常低，*/
    FRE_STATUS_VALID,     /*采集完成有效*/
    FRE_STATUS_MAX,
} Fre_Status_en_t;
typedef Fre_uint8_t (*Fre_Status_Read)(void);
typedef struct
{
    /*不在设置的频率范围内（小于最小值或者大于最大值），认为信号无效。*/
    Fre_uint32_t u32FreMinHZ;                 /*输入信号的最小频率，单位0.1HZ。不可填0*/
    Fre_uint32_t u32FreMaxHZ;                 /*输入信号的最大频率，单位0.1HZ*/
    unsigned int FreMinDuty;                  /*输入信号的最小占空比，单位千分之一*/
    unsigned int FreMaxDuty;                  /*输入信号的最大占空比，单位千分之一*/
    Fre_uint32_t u32FreTimeOutTime;           /*输入信号异常检测时间 (ms)*/
    Fre_Sample_Type_en_t enFreSampType;       /*使用哪种采集方式  枚举类型 */
    Fre_Status_Read pfnFreReadStatusCallBack; /*获取引脚实时电平状态*/
    Fre_uint32_t u32FreClock;                 /*当使用捕获方式采集时，填写使用通道的时钟源频率 (HZ)。
                                                当使用定时器采集功能时，此处填定时器中断时间（us）*/
} Fre_Attribute_st_t;
/**********************以下为使用定时器中断方式采集时需调用的函数*************************************/
/*使用定时器中断进行采集，传入通道号*/
extern void Fre_In_Timer_ISR(Fre_Channel_en_t enFreChannel);
/**********************以下为使用捕获方式，捕获计数器每次清零时需调用的函数*************************************/
/*中断标志外部自行清除*/
/*传入通道号，计数器数值*/
extern void Fre_In_Channel_Capture_ISR_Reset_Count(Fre_Channel_en_t enFreChannel, Fre_uint32_t u32Count);
/**********************以下为使用捕获方式，捕获计数器滚动计数时需调用的函数*************************************/
/*中断标志外部自行清除*/
/*传入通道号，计数器数值*/
extern void Fre_In_Channel_Capture_ISR_Rolling_Count(Fre_Channel_en_t enFreChannel, Fre_uint16_t u16Count);
extern void Fre_In_Channel_Overflow_ISR(Fre_Channel_en_t enFreChannel);
/**********************以下为通用函数*************************************/
extern void Fre_In_Init(Fre_uint8_t *pu8FreRamData, const Fre_Attribute_st_t *pstFreAttribute, Fre_uint8_t u8FreChannelNum);
extern void Fre_In_Sleep_Init(void);
/*频率采集服务函数，主循环内实时调用*/
extern void Fre_In_Service(Fre_Channel_en_t enFreChannel);
/* 在多少MS中调用就传入多少，用于掉线计时使用 */
extern void Fre_In_Time_Out_Handle(Fre_uint32_t Time_Base);
/*计算结果为实时值，获取后需要根据实际使用工况不同，可能需要增加滤波处理后方可使用。*/
/*计算结果为实时值，获取后需要根据实际使用工况不同，可能需要增加滤波处理后方可使用。*/
/*计算结果为实时值，获取后需要根据实际使用工况不同，可能需要增加滤波处理后方可使用。*/
/* 获取信号当前状态 只有信号有效时才可获取频率及占空比信息*/
extern Fre_Status_en_t Fre_In_Get_Channel_Status(Fre_Channel_en_t enFreChannel);
/* 获取高电平占空比，单位千分之一(仅表示单位，不代表采集精度)*/
extern unsigned int Fre_In_Get_Channel_Duty(Fre_Channel_en_t enFreChannel);
/*获取频率，单位0.1HZ(仅表示单位，不代表采集精度)*/
extern unsigned int Fre_In_Get_Channel_HZ(Fre_Channel_en_t enFreChannel);
/*强制设置某个通道进入无效状态，一般IGOFF时，或者IGON初始化时调用*/
extern void Fre_In_Set_Channel_Invalid(Fre_Channel_en_t enFreChannel);
/*获取输入信号数据更新标志
0：no update
1：update  */
extern unsigned int Fre_In_Get_Update_Flag(Fre_Channel_en_t enFreChannel);
/*清除输入信号更新标志*/
extern void Fre_In_Reset_Update_Flag(Fre_Channel_en_t enFreChannel);
#endif
