#ifndef MCU_CORE_PROTOCOL__H_
#define MCU_CORE_PROTOCOL__H_

#include <stdio.h>
#include <string.h>
#include <stdbool.h>
#define LINE_DATA_PROTOCOL_ID 0x01
#define ANALOG_DATA_PROTOCOL_ID 0X02
#define MCU_DATA_PROTOCOL_ID 0X20


#define DATA_ID10   0x10U
#define DATA_ID12   0x12U
#define DATA_ID02   0x02U
#define DATA_ID04   0x04U




typedef union
{
    uint8_t Msg[1u];
    struct
    {
        uint8_t u8StartSta : 1;
        uint8_t u8Res      : 7;
    } Sig;
} _ID10_Data_un_t;

typedef union
{
    uint8_t Msg[1u];
    struct
    {
        uint8_t u8AutoConnectSta : 1;
        uint8_t u8Res            : 7;
    } Sig;
} _ID12_Data_un_t;

typedef union
{
    uint8_t Msg[25u];
    struct
    {
        uint8_t u8BluetoothSta : 2;
        uint8_t u8Res          : 6;

        uint8_t u8BtPhoneTimeH : 8;
        uint8_t u8BtPhoneTimeHM : 8;
        uint8_t u8BtPhoneTimeLM : 8;
        uint8_t u8BtPhoneTimeL : 8;

        uint8_t u8BtPhoneNum[20];
    } Sig;
} _ID02_Data_un_t;

typedef union
{
    uint8_t Msg[151u];
    struct
    {
        uint8_t u8MusicSta : 2;
        uint8_t u8Res      : 6;

        uint8_t u8MusicLyrics[50];
        uint8_t u8MusicActor[50];
        uint8_t u8MusicAlbum[50];
    } Sig;
} _ID04_Data_un_t;


extern void Set_BacklightEn(uint8_t onoff);
extern void Read_Line_Data(const uint8_t *data, uint8_t len);
extern void Read_AnaLog_Data(const uint8_t *data, uint8_t len);

extern bool Get_Line_LeftTurn(void);
extern bool Get_Line_RightTurn(void);
extern bool Get_Line_LowBeam(void);
extern bool Get_Line_HighBeam(void);
extern bool Get_Line_Position(void);
extern bool Get_Line_DoubleFlash(void);
extern bool Get_Line_Reset(void);
extern bool Get_Line_Bluetooth(void);
extern bool Get_Line_Right(void);
extern bool Get_Line_Left(void);
extern bool Get_Line_Up(void);
extern bool Get_Line_Down(void);
extern bool Get_Line_Cancel(void);
extern bool Get_Line_Confirm(void);

extern bool Get_Line_LightSensorEn(void);
extern bool Get_Line_Key_Subtract(void);
extern bool Get_Line_Key_Add(void);
extern uint8_t Get_Line_LcdTimerCtrl(void);
extern uint32_t Get_ACC_Value(void);
extern uint32_t Get_ACC1_Value(void);
extern uint32_t Get_DC12_Value(void);




extern void Send_MCU_ID10(uint8_t Flag);
extern void Set_LCD_EN(uint8_t FLAG);
extern uint8_t Get_PowerStatus(void);
extern void G031_Update_Service(void);
extern uint8_t Get_BackLightStatus(void);



extern void Btn_Event_Service(void);
extern void Menu_Set_Charge(uint8_t u8MenuData);
extern void Menu_Set_Music(uint8_t u8MenuData);
extern void Menu_Set_NAV(uint8_t u8MenuData);
extern void Menu_Time_Handle(uint8_t u8MenuTimeBase);


#endif
