#include "PowerManagement.h"
#include <stdint.h>
#include <stdio.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/queue.h"
#include "esp_sleep.h"
#include "bsp_Gpio.h"
#include "esp_err.h"
#include "esp_log.h"
#include "bsp_Timer.h"


#define tag "PM_User"


uint8_t u8WakeUpFlag = 0XFF;

// SemaphoreHandle_t g_SysWakeUp_Semaphore;
// uint8_t g_SysSleep;

static void Power_KL30_Init(void);
static void Power_Wakeup_Init(void);
static void Power_LVP_Init(void);
static void Power_OVP_Init(void);
static void Power_IG_OFF_Init(void);
static void Power_IG_ON_Init(void);
static void Power_Sleep_Init(void);

static Power_Status_em Power_Stay_ON(void);
static Power_Status_em Power_Stay_OFF(void);
static Power_Status_em Power_Stay_Protect(void);
static Power_Status_em Power_Stay_Sleep(void);

static const st_PowerGroup g_stPwrTasks = {
    Power_KL30_Init,
    Power_IG_OFF_Init,
    Power_Stay_OFF,
    Power_Sleep_Init,
    Power_Stay_Sleep,
    Power_Wakeup_Init,
    Power_IG_ON_Init,
    Power_Stay_ON,
    Power_LVP_Init,
    Power_OVP_Init,
    Power_Stay_Protect,
};

// static uint8_t  sleepFlag       = 0u;
// static uint16_t CANModeInitFlag = 0U;
PwrLib_uint32_t u32PwrOFFDelay = 0UL;
void PwrMemInit(void)
{
    PowerMemInit(&g_stPwrTasks);
}

// uint8_t MSCAN0_Is_Exist_Frame(void)
// {
//     uint8_t flag = 0U;

//     return flag;
// }

static void Power_KL30_Init(void)
{

    // Sys_KL30_Init();
    // Sys_On_Init();
    //   Popup_Scheduler_Init();

    
    // Common_DataInit();
    // u32PwrOFFDelay = 0UL;

    // ESP_LOGE(tag, "SV 1.01");


    // ESP_LOGI(tag, "KL30 INIT END !");
}

static void Power_Wakeup_Init(void)
{
//     Nfc_WakeUp_Init();
//     Sys_WakeUp_Init();
//     Sys_WAKEUP_Init();
//    // Sys_On_Init();

//     Common_DataInit();
//     u32PwrOFFDelay = 0UL;
//     u8WakeUpFlag = 1;
    //ESP_LOGE(tag, "WAKEUP INIT END !");
}

static void Power_LVP_Init(void)
{
}
static void Power_OVP_Init(void)
{
}

static void Power_IG_OFF_Init(void)
{
    //  Popup_Scheduler_OFF_Init();
    //  Popup_Scheduler_OFF();
    // Data_User_Mileage_OFF_Init();
    // Gui_Display_OFF_Init();
    // u32PwrOFFDelay = 0UL;
    // ESP_LOGI(tag, "IGOFF INIT END !");
}

static void Power_IG_ON_Init(void)
{
    // Telltales_KL15_Init();
    // Telltales_User_Init();
    // Gui_Display_KL15_Init();
    // DataProcess_Init();
    // Mileage_KL15_Init();
    //       Popup_Scheduler_ON_Init();
    // ESP_LOGI(tag, "IGON INIT END !");
}

static void Power_Sleep_Init(void)
{
// gpio_set_level(MCU_3_3V, 0);
    // Popup_Scheduler_OFF();
    // u8WakeUpFlag = 0;
    // Nfc_Sleep_Init();
    // Sys_Sleep_Init();
    // ESP_LOGE(tag, "SLEEP INIT END !");
    // bsp_GPIO_Sleep_Init();
}

static Power_Status_em Power_Stay_ON(void)
{
    Power_Status_em u8PowerSts;

    u8PowerSts = EM_IGN_ON;

    /*-关机模式-*/
    // if (SYS_OPR_STAT_IGN_OFF)
    // {
    //     u8PowerSts = EM_IGN_OFF_Init;
    // }

    // /*-停�?�模�???-*/
    // if (SYS_OPR_STAT_HALT)
    // {
    //     u8PowerSts = EM_IGN_LIMIT;
    // }

    return u8PowerSts;
}

static Power_Status_em Power_Stay_OFF(void)
{
    Power_Status_em u8PowerSts;

    uint8_t m_conditon_0;
    uint8_t m_conditon_1;

    u8PowerSts = EM_IGN_OFF;

    // m_conditon_0 = CanNm_GetMode( );
    // m_conditon_1 = Read_KL30_ConvertFinish( );
    //
    //
    //
    // if (SYS_OPR_STAT_IGN_ON)
    // {
    //     u32PwrOFFDelay = 0;
    //     u8PowerSts = EM_IGN_ON_Init;
    // }
    // else
    // {
    //     /*电源管理唤醒*/

    //     /// //printfprintf("u32KL15 %ld \r\n",u32KL15);("sleep_delay_t %d\r\n",sleep_delay_t);

    //     // printf("u32PwrOFFDelay %ld \r\n",u32PwrOFFDelay);
    //     if ((Common_GetIgnOffTime() >= 10000) && (gpio_get_level(N32G_INT) == 0))
    //     {
    //         printf("EM_IGN_Sleep_Init  \r\n");
    //         u8PowerSts = EM_IGN_Sleep_Init;
    //     }
    //     else
    //     {
    //         //printf("Common_GetIgnOffTime = %d\r\n",Common_GetIgnOffTime());
    //     }

    // }

    return u8PowerSts;
}

static Power_Status_em Power_Stay_Protect(void)
{
    if (/* SYS_OPR_STAT_RUN */1)
    {
        return EM_IGN_OFF_Init;
    }
    else
    {
        return EM_IGN_LIMIT;
    }
}

int64_t tywbefore_us;
int64_t tywafter_us;
uint32_t u32sleepCOunt = 0;
static Power_Status_em Power_Stay_Sleep(void)
{
    Power_Status_em u8PowerSts = EM_IGN_OFF_Init;
    uint32_t io_num;

    while (1)
    {

        /* Get timestamp before entering sleep */
        // int64_t tywbefore_us = esp_timer_get_time();//esp_log_timestamp

        // tywbefore_us = esp_log_timestamp();
        // printf("tywbefore_us %ld \r\n",tywbefore_us);
        // u32sleepCOunt++;
        // printf("u32sleepCOunt %ld \r\n",u32sleepCOunt);

        // vTaskDelay(pdMS_TO_TICKS(100));
        //     /* Enter sleep mode */
        // esp_light_sleep_start();
        // vTaskDelay(pdMS_TO_TICKS(100));
        // printf("tywbefore_us %ld \r\n",tywbefore_us);
        //     /* Get timestamp after waking up from sleep */
        // tywafter_us = esp_log_timestamp();

        // printf("tywafter_us %ld \r\n",tywafter_us);

        // int64_t sleep_us = tywafter_us - tywbefore_us;

        // printf("sleep us %ld \r\n",sleep_us);
        // if(xQueueReceive(gpio_evt_queue,&io_num,pdMS_TO_TICKS(100)) == pdTRUE)
        //{
        //    int level=gpio_get_level(B_CANRX_IO_NUM);
        //    if (level == 0){
        //        u8PowerSts = EM_IGN_Wakeup;
        //        Ble_User_Ctrl.WakeUp_En = 0;
        //        //printf("can rx io , into wakeup mode\r\n");
        //        break;
        //    }
        //}

        // if (gpio_get_level(N32G_INT) == 1)
        // {
        //     // ESP_LOGI(tag, "can rx io = %d, ign io = %d", gpio_get_level(B_CANRX_IO_NUM), gpio_get_level(IGN_IOIN_NUM));
        //     u8PowerSts = EM_IGN_Wakeup;

        //     // //printf("into wakeup mode\r\n");

        //     // printf("sts 3\r\n");
        //     break;
        // }

        // //printf("sts 2\r\n");

        // if(gpio_get_level(B_CANRX_IO_NUM) == 0 || gpio_get_level(IGN_IOIN_NUM) == 1 ||Ble_User_Ctrl.WakeUp_En/*|| gpio_get_level(DOOR_IO_NUM) == 0*/)
        // {
        //     // ESP_LOGI(tag, "can rx io = %d, ign io = %d", gpio_get_level(B_CANRX_IO_NUM), gpio_get_level(IGN_IOIN_NUM));
        //     u8PowerSts = EM_IGN_Wakeup;
        //     Ble_User_Ctrl.WakeUp_En = 0;
        //     // //printf("into wakeup mode\r\n");
        //     break;
        // }
        // else
        // {
        //     vTaskDelay(pdMS_TO_TICKS(100));
        // }
    }

    return u8PowerSts;
}

void APP_Sys_Startup_Init(void)
{
    uint8_t u8StartupMode = 0; // 0x55
    // esp_sleep_wakeup_cause_t enwakeupcause = esp_sleep_get_wakeup_cause();
    // if (enwakeupcause == ESP_SLEEP_WAKEUP_GPIO)
    // {
    //     u8StartupMode = 0x55; // wakeup
    // }
    // else
    // {
    //     u8StartupMode = 0;
    // }
    //ESP_LOGI(tag, "u8StartupMode = %d\r\n!",u8StartupMode);

    PwrMemInit();
    Power_Management_Init(u8StartupMode);
}

/**
 * @brief 获取唤醒标志
 * @return 1 唤醒 0 未唤醒 0XFF 无效
 */
uint8_t Get_WakeUp_Flag(void)
{
    return u8WakeUpFlag;
}
