
#include "Protocol_User.h"
#include "Protocol_Lib.h"
#include "bsp_Uart.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
// #include "MCU_Core_Protocol.h"
#include "esp_err.h"
#include "esp_log.h"
#include "MCU_Core_Protocol.h"
#define UART_TX_MAX_DEPTH 1024UL       //(2 * 1024UL)    // 4K
#define UART_RX_MAX_DEPTH (2 * 1024UL) // 4K
#define UART_DATA_BUF_LEN (2 * 1024UL) // 4K

Prot_State_st_t Prot_State;
_ID10_Data_un_t Data_Uart_SendID10;
_ID12_Data_un_t Data_Uart_SendID12;
_ID02_Data_un_t Data_Uart_SendID02;
_ID04_Data_un_t Data_Uart_SendID04;


static const char *ProtocolUser = "MCU_Core_Protocol";
typedef struct
{
    Protocol_uint32_t read_pos;
    Protocol_uint32_t write_pos;
    Protocol_uint8_t Rx_Buffer[UART_RX_MAX_DEPTH];
} UARTRxBuf_t;

typedef struct
{
    Protocol_uint32_t read_pos;
    Protocol_uint32_t write_pos;
    Protocol_uint8_t Tx_Buffer[UART_TX_MAX_DEPTH];
} UARTTxBuf_t;

static UARTRxBuf_t UARTRxBuf;
static UARTTxBuf_t UARTTxBuf;
static Protocol_uint8_t UsartDataBuf[256];
static Protocol_uint8_t mDataBufPtr[UART_DATA_BUF_LEN];

static Protocol_uint8_t Protocol_OpenUart(void);
static Protocol_uint32_t Protocol_UartRead(Protocol_uint8_t *pData, Protocol_uint32_t u32Len);
static Protocol_uint32_t Protocol_UartSend(const Protocol_uint8_t *pData, Protocol_uint32_t u32Len);
static void Protocol_UartHandle(const Protocol_Data_t *pData);

void Protocol_KL30_Wakeup_Init(void)
{
    Protocol_Func_t pFunc;

    pFunc.UARTOpen_Cbk = Protocol_OpenUart;
    pFunc.UARTSend_Cbk = Protocol_UartSend;
    pFunc.UARTRead_Cbk = Protocol_UartRead;
    pFunc.UARTClose_Cbk = Protocol_NULL;
    pFunc.ProcParseCbk = Protocol_NULL;
    pFunc.ProtocolSetData_Cbk = Protocol_UartHandle;
    UARTTxBuf.read_pos = 0;
    UARTTxBuf.write_pos = 0;
    UARTRxBuf.read_pos = 0;
    UARTRxBuf.write_pos = 0;

    Protocol_Init(mDataBufPtr, UART_DATA_BUF_LEN, &pFunc);
}

void Protocol_Send_Service(void)
{
    Protocol_uint32_t i = 0u;
    Protocol_uint32_t DataLen = 0u;
    Protocol_uint32_t SendLen = 0u;

    uart_wait_tx_done(ECHO_UART_PORT_NUM, (TickType_t)portMAX_DELAY); /* 等待数据发送完成 */

    // if ( /* UART_Ch1_Get_TX_Busy_Flag( ) == */ 0u )
    //{
    if (UARTTxBuf.write_pos == UARTTxBuf.read_pos)
    {
        return;
    }

    if (UARTTxBuf.write_pos > UARTTxBuf.read_pos)
    {
        DataLen = UARTTxBuf.write_pos - UARTTxBuf.read_pos;
    }
    else
    {
        DataLen = UART_TX_MAX_DEPTH - (UARTTxBuf.read_pos - UARTTxBuf.write_pos);
    }

    if (DataLen > 255)
    {
        SendLen = 255;
    }
    else
    {
        SendLen = DataLen;
    }

    for (i = 0u; i < SendLen; i++)
    {
        UsartDataBuf[i] = UARTTxBuf.Tx_Buffer[UARTTxBuf.read_pos];
        UARTTxBuf.read_pos = (UARTTxBuf.read_pos + 1) % UART_TX_MAX_DEPTH;
        //         }
        //  uart_write_bytes(ECHO_UART_PORT_NUM,UsartDataBuf,SendLen);

        // UART_Ch1_Send_Multiple_Byte(UsartDataBuf, SendLen);
    }
        int size = uart_write_bytes(ECHO_UART_PORT_NUM, UsartDataBuf, SendLen); /* send data  */
        // ESP_LOGI("SIZE", "SIZE %d", size);
}

static Protocol_uint8_t Protocol_OpenUart(void)
{
#if 0
    UART_Channel_Config_st_t loc_config;

    loc_config.u32UARTChEn            = 1;
    loc_config.u32UARTbps             = 115200;
    loc_config.pfnUARTConfirmCallBack = Protocol_NULL;
    loc_config.pfnUARTReadMsgCallBack = UART_Put;

    UART_Init(UART_RLIN31, &loc_config);
#endif
    return 1;
}

static Protocol_uint32_t Protocol_UartRead(Protocol_uint8_t *pData, Protocol_uint32_t len)
{
    Protocol_uint32_t i = 0;
    Protocol_uint32_t DataLen = 0u;
    Protocol_uint32_t ReadLen = 0u;

    if (UARTRxBuf.write_pos == UARTRxBuf.read_pos)
    {
        return 0; // 队列空
    }

    if (UARTRxBuf.write_pos > UARTRxBuf.read_pos)
    {
        DataLen = UARTRxBuf.write_pos - UARTRxBuf.read_pos;
    }
    else
    {
        DataLen = UART_RX_MAX_DEPTH - (UARTRxBuf.read_pos - UARTRxBuf.write_pos);
    }

    if (len > DataLen)
    {
        ReadLen = DataLen;
    }
    else
    {
        ReadLen = len;
    }

    for (i = 0u; i < ReadLen; i++)
    {
        pData[i] = UARTRxBuf.Rx_Buffer[UARTRxBuf.read_pos];
        UARTRxBuf.read_pos = (UARTRxBuf.read_pos + 1) % UART_RX_MAX_DEPTH;
    }

    return ReadLen;
}

static Protocol_uint32_t Protocol_UartSend(const Protocol_uint8_t *pData, Protocol_uint32_t u32Len)
{
    Protocol_uint32_t i = 0;
    Protocol_uint32_t RemainLen = 0u;

    if (UARTTxBuf.write_pos >= UARTTxBuf.read_pos)
    {
        RemainLen = UART_TX_MAX_DEPTH - (UARTTxBuf.write_pos - UARTTxBuf.read_pos);
    }
    else
    {
        RemainLen = UARTTxBuf.read_pos - UARTTxBuf.write_pos;
    }

    if (u32Len > RemainLen)
    {
        return 1; // 队列已满，无法插入队列
    }

    for (i = 0; i < u32Len; i++)
    {
        UARTTxBuf.Tx_Buffer[UARTTxBuf.write_pos] = pData[i];
        UARTTxBuf.write_pos = (UARTTxBuf.write_pos + 1) % UART_TX_MAX_DEPTH;
    }

    return 0;
}

static void Protocol_UartHandle(const Protocol_Data_t *pData)
{
    if (pData->CmdID == 0x20U)//esp收到底板发送20
    {
        if(Prot_State.u8State < PROT_START)
        {
            Prot_State.u8State = PROT_START;//esp停止发送10,开始发1帧12,底板收到12后,停发20
        }
    }
    else if (pData->CmdID == 0x03U)//底板控制蓝牙电话
    {
        if(pData->Data[0] == 1U)
        {
            Bt_Call_Auto_Answer();
        }
        else if(pData->Data[0] == 2U)
        {
            Bt_Call_Auto_Reject();
        }
        else
        {
            ;
        }

    }
    else if (pData->CmdID == 0x05U)//底板控制蓝牙音乐
    {
        if(pData->Data[0] == 1U)
        {
            Bt_Music_Play();
        }
        else if(pData->Data[0] == 2U)
        {
            Bt_Music_Stop();
        }
        else if(pData->Data[0] == 3U)
        {
            Bt_Music_Next();
        }
        else if(pData->Data[0] == 4U)
        {
            Bt_Music_Previous();
        }
        else if(pData->Data[0] == 5U)
        {
            Bt_Music_Volume_Up();
        }
        else if(pData->Data[0] == 6U)
        {
            Bt_Music_Volume_Down();
        }
        else
        {
            ;
        }
    }
    else
    {
        // ESP_LOGW(ProtocolUser, "Non-agreement data will not be processed !!!");
        // 非本协议数据，不处理
    }

}

void Protocol_User_Ctrl_Init(void)
{
    Prot_State.u8State = PROT_IDLE;
}

void Prot_Send_Msg_Process(void)
{
    if(Prot_State.u8State < PROT_START)
    {
        Core_ID10_Service();
    }
    
    if(Prot_State.u8State >= PROT_START)
    {
        if(Prot_State.u8TimeDelay == 0)
        {
            Core_ID12_Service();
            Prot_State.u8TimeDelay = 1;
        }
        Core_ID02_Service();
        Core_ID04_Service();
    }
}

void Core_ID10_Service(void)//esp32发送启动完成给底板
{
    memset(Data_Uart_SendID10.Msg, 0, sizeof(Data_Uart_SendID10.Msg));
    Data_Uart_SendID10.Sig.u8StartSta = 1;
    Protocol_Send(DATA_ID10, Data_Uart_SendID10.Msg, sizeof(Data_Uart_SendID10.Msg));
}

void Core_ID12_Service(void)//收到底板发送的20后发送12
{
    uint8_t u8AutoConnectBt = Auto_Connect_Bt();
    memset(Data_Uart_SendID12.Msg, 0, sizeof(Data_Uart_SendID12.Msg));
    Data_Uart_SendID12.Sig.u8AutoConnectSta = u8AutoConnectBt;
    Protocol_Send(DATA_ID12, Data_Uart_SendID12.Msg, sizeof(Data_Uart_SendID12.Msg));
}

void Core_ID02_Service(void)//esp32发送蓝牙电话状态
{
    uint8_t u8BtPhoneStatus = Get_Bt_Phone_Status();
    memset(Data_Uart_SendID02.Msg, 0, sizeof(Data_Uart_SendID02.Msg));
    Data_Uart_SendID02.Sig.u8BluetoothSta = u8BtPhoneStatus;
    Data_Uart_SendID02.Sig.u8BtPhoneTimeH = 1;
    Data_Uart_SendID02.Sig.u8BtPhoneTimeHM = 1;
    Data_Uart_SendID02.Sig.u8BtPhoneTimeLM = 1;
    Data_Uart_SendID02.Sig.u8BtPhoneTimeL = 1;
    Data_Uart_SendID02.Sig.u8BtPhoneNum[20] = Get_Bt_Phone_Num();
    Protocol_Send(DATA_ID02, Data_Uart_SendID02.Msg, sizeof(Data_Uart_SendID02.Msg));
}

void Core_ID04_Service(void)//esp32发送蓝牙音乐播放状态和音乐信息
{
    uint8_t u8BtMusicStatus = Get_Bt_Music_Status();
    memset(Data_Uart_SendID04.Msg, 0, sizeof(Data_Uart_SendID04.Msg));
    Data_Uart_SendID04.Sig.u8MusicSta = u8BtMusicStatus;
    Data_Uart_SendID04.Sig.u8MusicLyrics[50] = Get_BT_Music_Lyrics();
    Data_Uart_SendID04.Sig.u8MusicActor[50] = Get_BT_Music_Actor();
    Data_Uart_SendID04.Sig.u8MusicAlbum[50] = Get_BT_Music_Album();
    Protocol_Send(DATA_ID04, Data_Uart_SendID04.Msg, sizeof(Data_Uart_SendID04.Msg));
}

void UART_Put(Protocol_uint16_t Data)
{
    Protocol_uint32_t nextPos = 0u;

    nextPos = (UARTRxBuf.write_pos + 1) % UART_RX_MAX_DEPTH;

    if (nextPos == UARTRxBuf.read_pos)
    {
        // 队列已满，无法插入队列
    }
    else
    {
        UARTRxBuf.Rx_Buffer[UARTRxBuf.write_pos] = Data;
        UARTRxBuf.write_pos = (UARTRxBuf.write_pos + 1) % UART_RX_MAX_DEPTH;
    }

    return;
}


