
#include "System_Monitor.h"
#include "driver/gpio.h"
#include "bsp_Gpio.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/queue.h"
#include <stdint.h>
#include <stdio.h>
// #include "MCU_Core_Protocol.h"

#define u16Base_Vol           0u        // 0#define u16Base_Vol           0u        // 0
#define u16ENTER_LOW_N_RANGE  19995U     // 1#define u16ENTER_LOW_N_RANGE  6400U     // 1 6
#define u16EXIT_LOW_N_RANGE   19996U     // 2#define u16EXIT_LOW_N_RANGE   6800U     // 2 6.5
#define u16ENTER_LOW_Y_RANGE  19997U     // 3#define u16ENTER_LOW_Y_RANGE  6900U     // 3
#define u16EXIT_LOW_Y_RANGE   19998U     // 4#define u16EXIT_LOW_Y_RANGE   7200U     // 4

#define u16EXIT_HIGH_Y_RANGE  65530U    // 5#define u16EXIT_HIGH_Y_RANGE  14300U    // 5 15V
#define u16ENTER_HIGH_Y_RANGE 65531U    // 6#define u16ENTER_HIGH_Y_RANGE 14500U    // 6 15.5V
#define u16EXIT_HIGH_N_RANGE  65532U    // 7#define u16EXIT_HIGH_N_RANGE  15100U    // 7 16V
#define u16ENTER_HIGH_N_RANGE 65533U    // 8#define u16ENTER_HIGH_N_RANGE 15500U    // 8 16.5V
#define u16Top_Vol            0xffffu   // #define u16Top_Vol            0xffffu

// #pragma alignvar(8)
static const monitorlib_uint16_t SysFun_Range [ 26u ] = {
    u16Base_Vol,

    u16ENTER_LOW_N_RANGE,
    u16EXIT_LOW_N_RANGE,

    u16ENTER_LOW_Y_RANGE,
    u16EXIT_LOW_Y_RANGE,

    u16EXIT_HIGH_Y_RANGE,
    u16ENTER_HIGH_Y_RANGE,

    u16EXIT_HIGH_N_RANGE,
    u16ENTER_HIGH_N_RANGE,

    u16Top_Vol,
    30000,
    50u,
    u16Base_Vol,

    u16ENTER_LOW_N_RANGE,
    u16EXIT_LOW_N_RANGE,

    u16ENTER_LOW_Y_RANGE,
    u16EXIT_LOW_Y_RANGE,

    u16EXIT_HIGH_Y_RANGE,
    u16ENTER_HIGH_Y_RANGE,

    u16EXIT_HIGH_N_RANGE,
    u16ENTER_HIGH_N_RANGE,

    u16Top_Vol,
    2u,
    2u,

    2u,
    0u,
};

monitorlib_uint16_t Sys_Read_KL30_Voltage_F(void)
{
    monitorlib_uint16_t u16Voltage;
    // u16Voltage = (monitorlib_uint16_t)Get_ACC_Value();
    if(u16Voltage > 60000)
    {
        u16Voltage = 60000;
    }
    return 21000;
}

monitorlib_uint16_t Sys_Read_KL15_Voltage_F(void)
{
    monitorlib_uint16_t u16Voltage = 0;
   // u16Voltage = (monitorlib_uint16_t)Get_ACC_Value();;
    return 21000;
}

monitorlib_uint16_t Sys_Read_KL30_Voltage(void)
{
    monitorlib_uint16_t u16Voltage;
    // u16Voltage = (monitorlib_uint16_t)Get_ACC_Value();;
    if(u16Voltage > 60000)
    {
        u16Voltage = 60000;
    }
    return 21000;
}

monitorlib_uint16_t Sys_Read_KL15_Voltage(void)
{
    monitorlib_uint16_t u16Voltage = 0;
   // u16Voltage = (monitorlib_uint16_t)Get_ACC_Value();;
    return 21000;
}

monitorlib_uint8_t Sys_Read_KL30_Valid(void)
{
    monitorlib_uint8_t u8Valid;
   // u8Valid = Get_Ad_Valid();
   u8Valid =1U;
    return u8Valid;
}

monitorlib_uint8_t Sys_Read_KL15_Valid(void)
{
    monitorlib_uint8_t u8Valid;
   /// u8Valid = Get_Ad_Valid();
     u8Valid =1U;
    return u8Valid;
}

monitorlib_uint8_t System_LINE_KL15(void)
{
    monitorlib_uint8_t u8KL15=0;

    //if(Get_CAN_CH_ID_231_Sig_BCM1_PowerMode() == 2)
    //{
    //    u8KL15 = 0u;
//
    //    //printf("sts 1\r\n");
    //}
    //else
    //{
       if (1)
       {
           u8KL15 = 1u;
       }
      // printf("gpio_get_level(N32G_INT) %d Get_PowerStatus() = %d \r\n",gpio_get_level(N32G_INT),Get_PowerStatus());

       //printf("u8KL15 %d \r\n",u8KL15);

    //    else
    //    {
    //        if(Get_KL15_Raw() >= 5000)//
    //        {
    //            u8KL15 = 1u;
    //        }
    //        else
    //        {
    //            u8KL15 = 0u;
    //        }
    //    }
    //}
    //printf("u8KL15 %d  Get_PowerStatus % d \r\n",u8KL15,Get_PowerStatus());
    return u8KL15;
}

void Common_BlockDelay(monitorlib_uint32_t u32Ms)
{
    vTaskDelay(pdMS_TO_TICKS(1));
}

void Sys_LogicProcess(void)
{
}

void Sys_KL30_Init(void)
{
    MonitorExt_st m_st;
    m_st.COM_Delay               = Common_BlockDelay;
    m_st.SysGet_KL15Line         = System_LINE_KL15;
    m_st.SysGet_KL15_Valid       = Sys_Read_KL15_Valid;
    m_st.SysGet_KL30_Valid       = Sys_Read_KL30_Valid;
    m_st.SysGet_KL15_value       = Sys_Read_KL15_Voltage;
    m_st.SysGet_KL30_value       = Sys_Read_KL30_Voltage;
    m_st.SysGet_KL15_value_Force = Sys_Read_KL15_Voltage_F;
    m_st.SysGet_KL30_value_Force = Sys_Read_KL30_Voltage_F;
    m_st.SysMonitorLogic         = Sys_LogicProcess;
    Sys_Set_Pata(SysFun_Range, &m_st);
    System_Monitor_KL30Init( );
}

void Sys_WakeUp_Init(void)
{
    MonitorExt_st m_st;
    m_st.COM_Delay               = Common_BlockDelay;
    m_st.SysGet_KL15Line         = System_LINE_KL15;
    m_st.SysGet_KL15_Valid       = Sys_Read_KL15_Valid;
    m_st.SysGet_KL30_Valid       = Sys_Read_KL30_Valid;
    m_st.SysGet_KL15_value       = Sys_Read_KL15_Voltage;
    m_st.SysGet_KL30_value       = Sys_Read_KL30_Voltage;
    m_st.SysGet_KL15_value_Force = Sys_Read_KL15_Voltage_F;
    m_st.SysGet_KL30_value_Force = Sys_Read_KL30_Voltage_F;
    m_st.SysMonitorLogic         = Sys_LogicProcess;
    Sys_Set_Pata(SysFun_Range, &m_st);
    System_Monitor_WakeupInit( );
}
