#ifndef _A2DP_SINK_AND_HFP_H_
#define _A2DP_SINK_AND_HFP_H_

#include <stdint.h>



#define BTMUSICBUFFMAX  50
#define BTIPHONENUMBERMAX 20

typedef enum
{
    status_max = 0, /* 从未启动过蓝牙音乐 */
    Player,     /* 播放 */
    pause,      /* 暂停 */
}_music_status;


typedef struct
{
    uint8_t MusicLyrics[BTMUSICBUFFMAX];

    uint8_t MusicActor[BTMUSICBUFFMAX];

    uint8_t MusicAlbum[BTMUSICBUFFMAX];

    _music_status MusicStatus;
}BT_Music;


typedef enum
{
    Call_idel = 0,  /* 表示没有电话活动或者电话处于空闲状态。 */
    Call_Incoming,  /* 表示有来电正在呼入或者正在接听来电的状态。 */
    Call_Outgoing_Dialing,  /* 表示正在拨号或者电话呼出但对方尚未接听的状态。 */
    Call_OUtgoing_Alerting, /* 表示电话正在呼出并且对方正在响铃的状态。 */
    Call_In_Progress,   /* 表示当前存在电话通话正在进行的状态，即有电话通话正在进行中 */
    Call_Max,
}_phone_status;



typedef struct
{
    _phone_status Status;   /* 电话状态 */
    uint32_t Duration;  /* 通话时长 */
    uint8_t Number[BTIPHONENUMBERMAX];
}BT_Phone;



typedef enum
{
    Connect = 0,
    Disconnect,
    Max,
}_BT_status;


typedef struct
{
    _BT_status Status;
}BT_User;



/* -----------------------------------------蓝牙初始化相关-------------------------------------- */
/**
 * @brief BT初始化
 * @note 用于安装BT及音频相关
 */
extern void BT_KL30_Wakeup_Init(void);
/**
 * @brief BT休眠初始化
 * @note 用于卸载BT及音频相关
 */
extern void BT_Sleep_Init(void);

/* -----------------------------------------蓝牙连接相关-------------------------------------- */

/**
 * @brief 本函数用于检查是否有已配对的蓝牙设备，并尝试自动连接到该设备。如果存在已配对的设备，且尚未连接，则函数将发起连接。
 * @return - 0：没有执行连接操作或连接操作失败或已连接；
 *         - 1：发起连接操作。
 */
extern uint8_t Auto_Connect_Bt(void);//握手成功就开始调用


/* -----------------------------------------蓝牙电话相关-------------------------------------- */


/**
 * @brief 自动断开蓝牙电话连接函数
 *
 * 该函数用于在特定条件下自动断开与蓝牙设备的音频连接。
 * 主要用于当系统检测到需要断开连接的情况时，主动发起断开操作。
 *
 * @return uint8_t 返回执行结果，1表示成功发起断开连接操作，0表示未执行断开操作。
 */
extern uint8_t Bt_AutoCut_Phone(void);//蓝牙音频切换到手机音频
/**
 * @brief 自动接听蓝牙电话
 * 该函数用于配置蓝牙耳机自动接听电话。当有来电时，无需用户操作，耳机将自动接听电话。
 * @note 该功能需要蓝牙耳机支持，并且在配对时已正确配置了相关蓝牙属性。
 */
extern void Bt_Call_Auto_Answer(void);
/**
 * @brief 自动拒绝来电函数
 *
 * 该函数用于在蓝牙 Hands-Free 模式下自动拒绝来电。
 * 当应用程序或系统需要自动拒绝来电时，可以调用此函数。
 *
 * @note 调用此函数将导致当前来电被拒绝。
 */
extern void Bt_Call_Auto_Reject(void);

/**
 * @brief 获取蓝牙电话状态
 * @return 详见枚举 _phone_status
 */
extern _phone_status Get_Bt_Phone_Status(void);
/**
 * @brief 获取电话号码
 * @return 最大长度为20，0XFF为无效值；
 */
extern uint8_t *Get_Bt_Phone_Num(void);

/* -----------------------------------------蓝牙音乐相关-------------------------------------- */

/**
 * @brief 控制蓝牙音乐播放函数
 * @return uint8_t 返回值为1表示音乐播放已启动，返回值为0表示未启动音乐播放。
 */
extern uint8_t Bt_Music_Play(void);

/**
 * @brief 控制蓝牙音乐暂停函数
 * @return 1 暂停成功 0 当前蓝牙未连接 暂停失败
 */
extern uint8_t Bt_Music_Stop(void);

/**
 * @brief 控制蓝牙音乐切换到下一曲目
 * @return 1 切换成功 0 当前蓝牙未连接 切换失败
 */
extern uint8_t Bt_Music_Next(void);

/**
 * @brief 控制蓝牙音乐切换到上一曲目
 * @return 1 切换成功 0 当前蓝牙未连接 切换失败
 */
extern uint8_t Bt_Music_Previous(void);

/**
 * @brief 增加蓝牙音乐音量
 * @return 1 增加成功 0 当前蓝牙未连接 增加失败
 */
extern uint8_t Bt_Music_Volume_Up(void);

/**
 * @brief 降低蓝牙音乐音量
 * @return uint8_t 操作结果，1表示音量降低操作成功，0表示操作未执行。
 */
extern uint8_t Bt_Music_Volume_Down(void);
/**
 * @brief  获取蓝牙歌词信息数据
 * @return 数据长度最大50,0XFF为无效数据
 */
extern uint8_t *Get_BT_Music_Lyrics(void);
/**
 * @brief 获取蓝牙音乐作者
 * @return 数据长度最大50，0XFF为无效数据
 */
extern uint8_t *Get_BT_Music_Actor(void);

/**
 * @brief 获取蓝牙音乐专辑信息
 * @return 数据长度最大50，0XFF为无效数据
 */
extern uint8_t *Get_BT_Music_Album(void);

/**
 * @brief 获取蓝牙播放状态
 * @return 详见枚举_music_status
 */
extern _music_status Get_Bt_Music_Status(void);



#endif
