# BSP: ESP-WROVER-KIT

[![Component Registry](https://components.espressif.com/components/espressif/esp_wrover_kit/badge.svg)](https://components.espressif.com/components/espressif/esp_wrover_kit)

### Overview

ESP-WROVER-KIT is an ESP32-based development board produced by Espressif.

* [Hardware Reference](https://www.espressif.com/en/products/hardware/esp-wrover-kit/overview)

![](https://docs.espressif.com/projects/esp-idf/en/latest/esp32/_images/esp-wrover-kit-v4.1-layout-front.png)

**ESP-WROVER-KIT features the following integrated components:**
* ESP32-WROVER-E module
* LCD screen
* microSD card slot
* RGB LED

Its another distinguishing feature is the embedded FTDI FT2232HL chip - an advanced multi-interface USB bridge. This chip enables to use JTAG for direct debugging of ESP32 through the USB interface without a separate JTAG debugger. ESP-WROVER-KIT makes development convenient, easy, and cost-effective.

Most of the ESP32 I/O pins are broken out to the board’s pin headers for easy access.

<!-- Autogenerated start: Dependencies -->
### Capabilities and dependencies
|  Capability |     Available    |                                           Component                                          |  Version |
|-------------|------------------|----------------------------------------------------------------------------------------------|----------|
|   DISPLAY   |:heavy_check_mark:|                                              idf                                             |  >=4.4.5 |
|  LVGL_PORT  |:heavy_check_mark:|[espressif/esp_lvgl_port](https://components.espressif.com/components/espressif/esp_lvgl_port)|    ^2    |
|    TOUCH    |        :x:       |                                                                                              |          |
|   BUTTONS   |:heavy_check_mark:|       [espressif/button](https://components.espressif.com/components/espressif/button)       |>=2.5,<4.0|
|    AUDIO    |        :x:       |                                                                                              |          |
|AUDIO_SPEAKER|        :x:       |                                                                                              |          |
|  AUDIO_MIC  |        :x:       |                                                                                              |          |
|     LED     |:heavy_check_mark:|                                              idf                                             |  >=4.4.5 |
|    SDCARD   |:heavy_check_mark:|                                              idf                                             |  >=4.4.5 |
|     IMU     |        :x:       |                                                                                              |          |
<!-- Autogenerated end: Dependencies -->
