#ifndef _COMMON_INTERFACE_H_
#define _COMMON_INTERFACE_H_
#include <stdio.h>
typedef enum
{
    CAN_SIG_NORMAL = 0u,
    CAN_SIG_LOST = 0x55U,
} CAN_MSG_Status_t;

typedef enum
{
    EX_OK = 0u,
    EX_ERR,
} _Fun_Res;

typedef enum
{
    COMMON_POWER_OFF = 0x00u,
    COMMON_POWER_ON = 0x01u,
    COMMON_POWER_UNKNOW = 0xFFu,
} COMMON_PowerStatus_t;

typedef enum
{
    COMMON_InValid = 0X00U,
    COMMON_Valid = 0X01U,
    COMMON_Valid_UNKNOW = 0XFFU,
} DataValid_t;

typedef enum
{
    CAN_MSG_TX_CYCLE = 0u,
    CAN_MSG_TX_CYCKE_EVENT,
} CAN_TX_Type_t;

typedef enum
{
    MSG_STD = 0u,
    MSG_EXT,
} CAN_MSG_FORMAT_t;
void Common_DataInit(void);
void Common_Input_Para(void);

uint8_t Common_Get_IG_Sts(void);
DataValid_t Common_Get_IG_Sts_Valid(void);

void Common_Set_IG_Sts(COMMON_PowerStatus_t Val);
void Common_Set_IG_Sts_Valid(DataValid_t Val);

uint16_t Common_Get_Act_V_Speed(void);
uint16_t Common_Get_Disp_V_Speed(void);

DataValid_t Common_Get_Act_V_Speed_Valid(void);
DataValid_t Common_Get_Disp_V_Speed_Valid(void);

void Common_Set_Act_V_Speed(uint16_t Val);
void Common_Set_Disp_V_Speed(uint16_t Val);
uint16_t Common_Get_TireSize(void);

void Common_Set_Act_V_Speed_Valid(DataValid_t Val);
void Common_Set_Disp_V_Speed_Valid(DataValid_t Val);

uint16_t Common_Get_DispSpeed(void);

uint32_t Common_GetIgnOnTime(void);  /*ms*/
uint32_t Common_GetIgnOffTime(void); /*ms*/

extern void U16_Data_Gradient(uint16_t *cur, uint16_t dest, uint16_t step, uint16_t *timer, const uint16_t timedelay);
extern void App_SortNWord_u16(uint16_t *SortData,uint8_t len);
extern uint16_t App_Average_u16(uint16_t *SortData,uint8_t len);
extern void Common_Set_V_Speed_Valid(DataValid_t Valid);


extern uint16_t Comm_Make_Word(uint8_t low, uint8_t high);
extern uint32_t Comm_Make_Long(uint8_t low, uint8_t mid, uint8_t high);
extern uint32_t Comm_Make_LongLong(uint8_t low, uint8_t ml, uint8_t mh, uint8_t hi);

#endif
