#include <dirent.h>
#include <stdbool.h>
#include <stdint.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/semphr.h"
#include "esp_err.h"
#include "esp_partition.h"
#include "spi_flash_mmap.h"
#include "bsp/esp-bsp.h"
#include "bsp/display.h"
#include "lv_demos.h"
#include "lv_examples.h"
#include "esp_jpeg_dec.h"
#include "lvgl.h"
#include "nvs_flash.h"
#include "nvs.h"
#include "esp_spiffs.h"
#include "assets_generate.h"
#include "esp_log.h"
#include <string.h>
#include <inttypes.h>
#include "lv_esp_jpg.h"
#include "Gui_Display_priv.h"
#include "esp_mmap_assets.h"
#include "a2dp_sink_and_hfp.h"
#include "Lvgl_User.h"
#include <stdbool.h>
#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "MCU_Core_Protocol.h"
static const char *TAG = "Gui_Display";

static mmap_assets_handle_t asset_handle;
extern void Lvgl_On_Timer(lv_timer_t *timer);
#define TYPE_PNG "png.png"
#define TYPE_JPG "jpg.jpg"
#define TYPE_TTF "Yedea_Font.ttf"

// uint8_t *img_data[TOTAL_MMAP_FILES];

// void image_mmap_init(const esp_partition_t *partition)
// {
//     const void *root;

//     int free_pages = spi_flash_mmap_get_free_pages(ESP_PARTITION_MMAP_DATA);
//     uint32_t storage_size = free_pages * 64 * 1024; // Byte
//     ESP_LOGI(TAG, "The storage free size is %ld KB", storage_size / 1024);
//     ESP_LOGI(TAG, "The partition size is %ld KB", partition->size / 1024);
//     if (storage_size < partition->size)
//     {
//         ESP_LOGE(TAG, "The storage free size of this board is less than %s partition required size", partition->label);
//     }
//     void *mmap_handle = (esp_partition_mmap_handle_t *)malloc(sizeof(esp_partition_mmap_handle_t));
//     ESP_ERROR_CHECK(esp_partition_mmap(partition, 0, partition->size, ESP_PARTITION_MMAP_DATA, &root, mmap_handle));

//     for (int i = 0; i < TOTAL_MMAP_FILES; i++)
//     {
//         img_data[i] = (void *)(root + 4 + mmap_table[i].offset);
//         // ESP_LOGI(TAG, "[%d], offset:[%07d], filesize:[%d], filename:%s, %p",
//         //          i,
//         //          mmap_table[i].offset,
//         //          mmap_table[i].file_size,
//         //          mmap_table[i].filename,
//         //          img_data[i]);
//     }
//     ESP_LOGI(TAG, "file_num: %" PRIu32, *(uint32_t *)root);
//     assert(TOTAL_MMAP_FILES == *(uint32_t *)root);
// }

// void mmap_assert_Init(void)
// {
//     const char *partition_label = "assert";
//     const esp_partition_t *img_partition = esp_partition_find_first(ESP_PARTITION_TYPE_DATA, ESP_PARTITION_SUBTYPE_ANY, partition_label);
//     if (img_partition)
//     {
//         image_mmap_init(img_partition);
//     }
//     else
//     {
//         ESP_LOGE(TAG, "Can not find %s in partition table", partition_label);
//     }
// }

void printf_stack()
{

    // MALLOC_CAP_INTERNAL 内部ram
    // MALLOC_CAP_SPIRAM 外部psram
    static char buffer[128];
    sprintf(buffer, "   Biggest /     Free /    Min/    Total\n"
                    "\t  SRAM : [%8d / %8d / %8d / %8d]",
            heap_caps_get_largest_free_block(MALLOC_CAP_SPIRAM),
            heap_caps_get_free_size(MALLOC_CAP_SPIRAM),
            heap_caps_get_minimum_free_size(MALLOC_CAP_SPIRAM),
            heap_caps_get_total_size(MALLOC_CAP_SPIRAM));

    ESP_LOGI("MEM", "%s", buffer);
}

static lv_ft_info_t info18 = {
    .weight = 18,
    .style = FT_FONT_STYLE_NORMAL,
    .name = "Yedea_Font.ttf",
    .mem = NULL,
};

static lv_ft_info_t info24 = {
    .weight = 24,
    .style = FT_FONT_STYLE_NORMAL,
    .name = "Yedea_Font.ttf",
    .mem = NULL,
};

static lv_ft_info_t info45 = {
    .weight = 45,
    .style = FT_FONT_STYLE_NORMAL,
    .name = "Yedea_Font.ttf",
    .mem = NULL,
};
static lv_ft_info_t info16 = {
    .weight = 16,
    .style = FT_FONT_STYLE_NORMAL,
    .name = "Yedea_Font.ttf",
    .mem = NULL,
};

static lv_ft_info_t info20 = {
    .weight = 20,
    .style = FT_FONT_STYLE_NORMAL,
    .name = "Yedea_Font.ttf",
    .mem = NULL,
};

/**
 * @brief 初始化freetype
 */
bool create_example_freetype(void)
{

    bool bRet = false;

    info24.mem = mmap_assets_get_mem(asset_handle, MMAP_YEDEA_FONT_TTF);
    info24.mem_size = mmap_assets_get_size(asset_handle, MMAP_YEDEA_FONT_TTF);
    info18.mem = mmap_assets_get_mem(asset_handle, MMAP_YEDEA_FONT_TTF);
    info18.mem_size = mmap_assets_get_size(asset_handle, MMAP_YEDEA_FONT_TTF);

    info45.mem = mmap_assets_get_mem(asset_handle, MMAP_YEDEA_FONT_TTF);
    info45.mem_size = mmap_assets_get_size(asset_handle, MMAP_YEDEA_FONT_TTF);
    info16.mem = mmap_assets_get_mem(asset_handle, MMAP_YEDEA_FONT_TTF);
    info16.mem_size = mmap_assets_get_size(asset_handle, MMAP_YEDEA_FONT_TTF);
    info20.mem = mmap_assets_get_mem(asset_handle, MMAP_YEDEA_FONT_TTF);
    info20.mem_size = mmap_assets_get_size(asset_handle, MMAP_YEDEA_FONT_TTF);

    bRet = lv_ft_font_init(&info24);
    ESP_ERROR_CHECK(((true == bRet) ? ESP_OK : ESP_FAIL));
    bRet = lv_ft_font_init(&info18);
    ESP_ERROR_CHECK(((true == bRet) ? ESP_OK : ESP_FAIL));
    bRet = lv_ft_font_init(&info45);
    ESP_ERROR_CHECK(((true == bRet) ? ESP_OK : ESP_FAIL));
    bRet = lv_ft_font_init(&info16);
    ESP_ERROR_CHECK(((true == bRet) ? ESP_OK : ESP_FAIL));
    bRet = lv_ft_font_init(&info20);
    ESP_ERROR_CHECK(((true == bRet) ? ESP_OK : ESP_FAIL));
    return true;
}

/**
 * @brief 此函数用于创建设置图像
 * @param obj 传入对象指针
 * @param Data 传入图片数据指针 如仅创建对象传入NULL
 * @param Img_Index 传入图片索引  MMAP_FILES
 * @param x_coord 传入图片x坐标
 * @param y_coord 传入图片y坐标
 * @param HideFlag 设置图片属性是否隐藏
 * @code Create_set_image(&UI_Lamp_01, &Lamp_01_Handle, MMAP_RAIN_JPG, 0, 0, 0);
 */
void Create_set_image(bool not_cache, lv_obj_t **obj, lv_img_dsc_t *Data, uint32_t Img_Index, uint32_t x_coord, uint32_t y_coord, uint8_t HideFlag)
{

    if (Data == NULL)
    {
        ESP_LOGW(TAG, "Create_set_image Input *Data NULL !!!!");
        return;
    }

    if (Img_Index >= TOTAL_MMAP_FILES)
    {
        ESP_LOGW(TAG, "Create_set_image Input Img_Index Over Max !!!!");
        return;
    }

    if (*obj == NULL)
    {
        *obj = lv_img_create(blackground_bg);
    }

    if ((Data != NULL) && (Img_Index < TOTAL_MMAP_FILES))
    {
        Data->header.reserved = not_cache;
        Data->header.w = mmap_assets_get_width(asset_handle, Img_Index);
        Data->header.h = mmap_assets_get_height(asset_handle, Img_Index);
        Data->header.always_zero = 0;
        Data->data_size = mmap_assets_get_size(asset_handle, Img_Index);
        Data->data = mmap_assets_get_mem(asset_handle, Img_Index);
        if (strstr(mmap_assets_get_name(asset_handle, Img_Index), ".png"))
        {
            Data->header.cf = LV_IMG_CF_RAW_ALPHA;
            printf("png \n");
        }
        else
        {
            printf("jpg \n");
            Data->header.cf = LV_IMG_CF_RAW;
        }

        lv_img_set_src(*obj, Data);
    }
    lv_obj_set_width(*obj, LV_SIZE_CONTENT);  /// 1
    lv_obj_set_height(*obj, LV_SIZE_CONTENT); /// 1
    lv_obj_set_pos(*obj, x_coord, y_coord);
    if (HideFlag)
    {
        lv_obj_add_flag(*obj, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
        lv_obj_clear_flag(*obj, LV_OBJ_FLAG_SCROLLABLE);
    }
}

void Create_Spiffs_image(lv_obj_t **obj, char *image, uint32_t x_coord, uint32_t y_coord, uint8_t HideFlag)
{
    if (image == NULL)
    {
        ESP_LOGW(TAG, "Create_set_image Input *Data NULL !!!!");
        return;
    }

    if (*obj == NULL)
    {
        *obj = lv_img_create(blackground_bg);
    }

    lv_img_set_src(*obj, image);

    lv_obj_set_pos(*obj, x_coord, y_coord);
    if (HideFlag)
    {
        lv_obj_add_flag(*obj, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
        lv_obj_clear_flag(*obj, LV_OBJ_FLAG_SCROLLABLE);
    }
}

/**
 * @brief 此函数用于更新控件图像信息
 * @param obj 传入控件指针
 * @param Data 图像数据
 * @param Img_Index 图片索引
 */
void Set_Image_Decode(lv_obj_t *obj, lv_img_dsc_t *Data, uint32_t Img_Index)
{
    Data->header.reserved = 0;
    Data->header.w = mmap_assets_get_width(asset_handle, Img_Index);
    Data->header.h = mmap_assets_get_height(asset_handle, Img_Index);
    Data->header.always_zero = 0;
    Data->data_size = mmap_assets_get_size(asset_handle, Img_Index);
    Data->data = mmap_assets_get_mem(asset_handle, Img_Index);

    // printf("width %d\n",mmap_assets_get_width(asset_handle, Img_Index));
    // printf("height %d\n",mmap_assets_get_height(asset_handle, Img_Index));
    // printf("Img_Index %d\n",Img_Index);

    if (strstr(mmap_assets_get_name(asset_handle, Img_Index), ".png"))
    {
        Data->header.cf = LV_IMG_CF_RAW_ALPHA;
    }
    else
    {
        Data->header.cf = LV_IMG_CF_RAW;
    }

    lv_img_set_src(obj, Data);
}

/**
 * @brief 此函数用于设置utf-8格式文本显示
 * @param obj 传入文本对象
 * @param Data 传入文本数据
 * @param Show_Hide_Flag 显隐标志 0 隐藏 1 显示
 */
void Gui_Set_Utf_8_Text_Disp(lv_obj_t *obj, uint8_t *Data, bool Show_Hide_Flag)
{

    //  ESP_LOGE("Gui_Set_Utf_8_Text_Disp","Start");
    //     for (int i = 0; i < sizeof(Data); i++)
    //     {
    //         ESP_LOGE("ui_Set_Utf_8_Text_Disp ","Data[%x]",Data[i]);
    //     }
    if ((Show_Hide_Flag) && (Data != NULL))
    {
        set_widget_show_or_hide(obj, 1);
        lv_label_set_text(obj, Data);
    }
    else
    {
        set_widget_show_or_hide(obj, 0);
    }

    free(Data);
    Data = NULL;
}

/**
 * @brief 此函数用于设置字符串格式文本显示
 * @param obj 传入文本对象
 * @param Data 传入文本数据
 * @param Show_Hide_Flag 显隐标志 0 隐藏 1 显示
 */
void Gui_Set_Char_Text_Disp(lv_obj_t *obj, char *Data, bool Show_Hide_Flag)
{
    if (Show_Hide_Flag)
    {
        set_widget_show_or_hide(obj, 1);
        lv_label_set_text(obj, Data);
    }
    else
    {
        set_widget_show_or_hide(obj, 0);
    }
}

static lv_obj_t *label_vector_font30 = NULL;

// const _St_Size18_Text Text_Size18[1] =
//     {
//         {
//             "倒车中\n松开按键退出",
//             0,
//             103,
//             320,
//         },

// };

const _St_Size18_Text Phone_Status[2] =
    {
        {"通话中", 0, 0},
        {"来电", 102, 210},
};

/**
 * @brief 此函数用于设置字符串格式文本显示
 * @param obj 传入文本对象
 * @param Data 传入文本数据
 * @param Show_Hide_Flag 显隐标志 0 隐藏 1 显示
 */

lv_timer_t *LvglTimer = NULL;
lv_obj_t *imgtest;

lv_obj_t *img;
/**
 * @brief 此函数用于初始化对象
 * 需注意，图像需要在顶层时，需要放到最下面初始化！！！！！
 */
void Lvgl_Contrl_Init(void)
{

    blackground_bg = lv_obj_create(lv_scr_act());
    // lv_obj_remove_style_all(blackground_bg);
    lv_obj_set_size(blackground_bg, LV_HOR_RES, LV_VER_RES);
    lv_obj_set_align(blackground_bg, LV_ALIGN_CENTER);
    lv_obj_set_style_bg_color(blackground_bg, lv_color_hex(0), 0);
    lv_obj_set_style_pad_all(blackground_bg, 0, 0);
    lv_obj_set_style_border_width(blackground_bg, 0, 0);          // set biankuang kuandu
    lv_obj_set_style_radius(blackground_bg, LV_STATE_DEFAULT, 0); // 设置对象obj的圆角半径为0个像素
    lv_obj_clear_flag(blackground_bg, LV_OBJ_FLAG_SCROLLABLE);

    PowerOnAnim = lv_img_create(blackground_bg);

    lv_obj_set_pos(PowerOnAnim, 0, 59);

    /* Set src of image with file name */
    //   lv_img_set_src(img, "S:/spiffs/emoji_u1f60f.png");

    /* Align object */
    // lv_obj_align(img, LV_ALIGN_CENTER, 0, 0);

    // Create_Spiffs_image(&Music_Icon_B,"S:/spiffs/music_p_01.jpg", 60, 67, 1);
    Music_Icon_B = lv_img_create(blackground_bg);
    lv_img_set_src(Music_Icon_B, "S:/spiffs/music_p_01.jpg");
    lv_obj_set_pos(Music_Icon_B, 60, 67);
    lv_obj_add_flag(Music_Icon_B, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Music_Icon_B, LV_OBJ_FLAG_SCROLLABLE);
    Music_Icon_S = lv_img_create(blackground_bg);
    lv_img_set_src(Music_Icon_S, "S:/spiffs/music_p_02.jpg");
    lv_obj_set_pos(Music_Icon_S, 88, 97);
    lv_obj_add_flag(Music_Icon_S, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Music_Icon_S, LV_OBJ_FLAG_SCROLLABLE);
    Music_Left = lv_img_create(blackground_bg);
    lv_img_set_src(Music_Left, "S:/spiffs/music_p_04.jpg");
    lv_obj_set_pos(Music_Left, 43, 285);
    lv_obj_add_flag(Music_Left, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Music_Left, LV_OBJ_FLAG_SCROLLABLE);
    Music_Right = lv_img_create(blackground_bg);
    lv_img_set_src(Music_Right, "S:/spiffs/music_p_05.jpg");
    lv_obj_set_pos(Music_Right, 111, 281);
    lv_obj_add_flag(Music_Right, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Music_Right, LV_OBJ_FLAG_SCROLLABLE);
    Music_Start = lv_img_create(blackground_bg);
    lv_img_set_src(Music_Start, "S:/spiffs/music_p_06.jpg");
    lv_obj_set_pos(Music_Start, 176, 281);
    lv_obj_add_flag(Music_Start, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Music_Start, LV_OBJ_FLAG_SCROLLABLE);

    // Create_set_image(0, &Music_Icon_B, &Music_Icon_B_Hdl, MMAP_MUSIC_P_01_JPG, 60, 67, 1);
    // Create_set_image(0, &Music_Icon_S, &Music_Icon_S_Hdl, MMAP_MUSIC_P_02_JPG, 88, 97, 1);
    // Create_set_image(0, &Music_Left, &Music_Left_Hdl, MMAP_MUSIC_P_04_JPG, 43, 285, 1);
    // Create_set_image(0, &Music_Right, &Music_Right_Hdl, MMAP_MUSIC_P_05_JPG, 111, 281, 1);
    // Create_set_image(0, &Music_Start, &Music_Start_Hdl, MMAP_MUSIC_P_06_JPG, 176, 285, 1);

    Music_Text = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Music_Text, info18.font, 0);           /* 设置字体 */
    lv_obj_set_style_text_align(Music_Text, LV_TEXT_ALIGN_CENTER, 0); /* 设置文本水平居中  */
    lv_obj_set_pos(Music_Text, 28, 212);
    lv_obj_set_size(Music_Text, 196, 28);
    lv_obj_set_style_text_color(Music_Text, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_label_set_long_mode(Music_Text, LV_LABEL_LONG_SCROLL);                  /* 设置长文本模式 */
    lv_obj_add_flag(Music_Text, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Music_Text, LV_OBJ_FLAG_SCROLLABLE);
    Music_Composer = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Music_Composer, info18.font, 0);           /* 设置字体 */
    lv_obj_set_style_text_align(Music_Composer, LV_TEXT_ALIGN_CENTER, 0); /* 设置文本水平居中  */
    lv_obj_set_pos(Music_Composer, 91, 235);
    lv_obj_set_size(Music_Composer, 59, 18);
    lv_obj_set_style_text_color(Music_Composer, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_label_set_long_mode(Music_Composer, LV_LABEL_LONG_SCROLL);                  /* 设置长文本模式 */
    lv_obj_add_flag(Music_Composer, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Music_Composer, LV_OBJ_FLAG_SCROLLABLE);
    Music_InValid = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Music_InValid, info20.font, 0);           /* 设置字体 */
    lv_obj_set_style_text_align(Music_InValid, LV_TEXT_ALIGN_CENTER, 0); /* 设置文本水平居中  */
    lv_label_set_text(Music_InValid, "来听首歌吧");
    lv_obj_set_pos(Music_InValid, 70, 212);
    lv_obj_set_size(Music_InValid, 100, 30);
    lv_obj_set_style_text_color(Music_InValid, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_label_set_long_mode(Music_InValid, LV_LABEL_LONG_SCROLL);                  /* 设置长文本模式 */
    lv_obj_add_flag(Music_InValid, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Music_InValid, LV_OBJ_FLAG_SCROLLABLE);

    // Create_set_image(0, &Iphone_Icon, &Iphone_Icon_Hdl, MMAP_PHONE_P_01_JPG, 90, 92, 1);

    Iphone_Icon = lv_img_create(blackground_bg);
    lv_img_set_src(Iphone_Icon, "S:/spiffs/phone_p_01.jpg");
    lv_obj_set_pos(Iphone_Icon, 90, 92);
    lv_obj_add_flag(Iphone_Icon, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Iphone_Icon, LV_OBJ_FLAG_SCROLLABLE);

    Iphone_Status = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Iphone_Status, info18.font, 0); /* 设置字体 */
    // lv_obj_align(Iphone_Status, LV_ALIGN_CENTER, 0, 0);
    lv_obj_set_pos(Iphone_Status, Phone_Status[1].StartX, Phone_Status[1].StartY);
    lv_obj_set_size(Iphone_Status, 60, 25);
    lv_obj_set_style_text_color(Iphone_Status, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Iphone_Status, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Iphone_Status, LV_OBJ_FLAG_SCROLLABLE);

    Iphone_Timer = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Iphone_Timer, info24.font, 0); /* 设置字体 */
    lv_obj_set_pos(Iphone_Timer, 93, 290);
    lv_obj_set_size(Iphone_Timer, 100, 24);
    lv_obj_set_style_text_color(Iphone_Timer, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Iphone_Timer, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Iphone_Timer, LV_OBJ_FLAG_SCROLLABLE);

    Iphone_Reminder = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Iphone_Reminder, info18.font, 0); /* 设置字体 */
    lv_obj_set_pos(Iphone_Reminder, 57, 293);
    lv_obj_set_size(Iphone_Reminder, 126, 18);
    lv_label_set_text(Iphone_Reminder, "请使用手机接听");
    lv_obj_set_style_text_color(Iphone_Reminder, lv_color_make(0xff, 0x00, 0x00), 0);
    lv_obj_add_flag(Iphone_Reminder, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Iphone_Reminder, LV_OBJ_FLAG_SCROLLABLE);

    Iphone_Num = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Iphone_Num, info18.font, 0);           /* 设置字体 */
    lv_obj_set_style_text_align(Iphone_Num, LV_TEXT_ALIGN_CENTER, 0); /* 设置文本水平居中  */
    lv_obj_set_style_text_letter_space(Iphone_Num, 2, 0);             /* 设置字间距 */
    lv_obj_set_pos(Iphone_Num, 48, 182);
    lv_obj_set_size(Iphone_Num, 144, 18);
    lv_obj_set_style_text_color(Iphone_Num, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_align(Iphone_Num, LV_ALIGN_CENTER, 0, 0);
    lv_obj_add_flag(Iphone_Num, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Iphone_Num, LV_OBJ_FLAG_SCROLLABLE);

    // Create_set_image(1, &anim, &animhdl, MMAP_TO_001_JPG, 0, 59, 1);

    // Create_set_image(0, &Build, &Build_Hdl, MMAP_BUI_ECO_JPG, 76, 253, 1);
    // Create_set_image(0, &Power_Bg, &Power_Bg_Hdl, MMAP_CLU_CITY_JPG, 17, 68, 1);
    // Create_set_image(0, &Main_Road, &Main_Road_Hdl, MMAP_ROAD_CITY_JPG, 0, 239, 1);

    Build = lv_img_create(blackground_bg);
    lv_img_set_src(Build, "S:/spiffs/bui_eco.jpg");
    lv_obj_set_pos(Build, 76, 253);
    lv_obj_add_flag(Build, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Build, LV_OBJ_FLAG_SCROLLABLE);

    Power_Bg = lv_img_create(blackground_bg);
    lv_img_set_src(Power_Bg, "S:/spiffs/clu_city.jpg");
    lv_obj_set_pos(Power_Bg, 17, 68);
    lv_obj_add_flag(Power_Bg, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Power_Bg, LV_OBJ_FLAG_SCROLLABLE);

    Main_Road = lv_img_create(blackground_bg);
    lv_img_set_src(Main_Road, "S:/spiffs/road_city.jpg");
    lv_obj_set_pos(Main_Road, 0, 239);
    lv_obj_add_flag(Main_Road, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Main_Road, LV_OBJ_FLAG_SCROLLABLE);

    Power_NumOne = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Power_NumOne, info45.font, 0); /* 设置字体 */
    lv_obj_set_pos(Power_NumOne, 58, 167);
    lv_obj_set_size(Power_NumOne, 101, 45);
    lv_obj_set_style_text_color(Power_NumOne, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Power_NumOne, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Power_NumOne, LV_OBJ_FLAG_SCROLLABLE);
    Power_NumTen = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Power_NumTen, info45.font, 0); /* 设置字体 */
    lv_obj_set_pos(Power_NumTen, 58, 167);
    lv_obj_set_size(Power_NumTen, 101, 45);
    lv_obj_set_style_text_color(Power_NumTen, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Power_NumTen, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Power_NumTen, LV_OBJ_FLAG_SCROLLABLE);
    Power_NumDot = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Power_NumTen, info45.font, 0); /* 设置字体 */
    lv_obj_set_pos(Power_NumDot, 58, 167);
    lv_obj_set_size(Power_NumDot, 101, 45);
    lv_obj_set_style_text_color(Power_NumDot, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Power_NumDot, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Power_NumDot, LV_OBJ_FLAG_SCROLLABLE);

    Power_NumHundred = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Power_NumHundred, info45.font, 0); /* 设置字体 */
    lv_obj_set_pos(Power_NumHundred, 58, 167);
    lv_obj_set_size(Power_NumHundred, 101, 45);
    lv_obj_set_style_text_color(Power_NumHundred, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Power_NumHundred, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Power_NumHundred, LV_OBJ_FLAG_SCROLLABLE);

    // Create_set_image(0, &Tbox, &Tbox_Hdl, MMAP_STA_ICON_04_JPG, 198, 12, 1);
    // Create_set_image(0, &Gps, &Gps_Hdl, MMAP_STA_ICON_02_JPG, 158, 12, 1);
    // Create_set_image(0, &Iphone, &Iphone_Hdl, MMAP_STA_ICON_01_JPG, 122, 10, 1);
    // Create_set_image(0, &Temp, &Temp_Hdl, MMAP_STA_ICON_06_JPG, 7, 7, 1);

    Tbox = lv_img_create(blackground_bg);
    lv_img_set_src(Tbox, "S:/spiffs/sta_icon_04.jpg");
    lv_obj_set_pos(Tbox, 198, 12);
    lv_obj_add_flag(Tbox, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Tbox, LV_OBJ_FLAG_SCROLLABLE);

    Gps = lv_img_create(blackground_bg);
    lv_img_set_src(Gps, "S:/spiffs/sta_icon_02.jpg");
    lv_obj_set_pos(Gps, 158, 12);
    lv_obj_add_flag(Gps, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Gps, LV_OBJ_FLAG_SCROLLABLE);

    Iphone = lv_img_create(blackground_bg);
    lv_img_set_src(Iphone, "S:/spiffs/sta_icon_01.jpg");
    lv_obj_set_pos(Iphone, 122, 10);
    lv_obj_add_flag(Iphone, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Iphone, LV_OBJ_FLAG_SCROLLABLE);

    Temp = lv_img_create(blackground_bg);
    lv_img_set_src(Temp, "S:/spiffs/sta_icon_07.jpg");
    lv_obj_set_pos(Temp, 7, 7);
    lv_obj_add_flag(Temp, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Temp, LV_OBJ_FLAG_SCROLLABLE);

    TempNum = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(TempNum, info16.font, 0); /* 设置字体 */
    lv_obj_set_pos(TempNum, 53, 19);
    lv_obj_set_size(TempNum, 42, 22);
    lv_obj_set_style_text_color(TempNum, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(TempNum, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(TempNum, LV_OBJ_FLAG_SCROLLABLE);

    Nav_Icon = lv_img_create(blackground_bg);
    lv_obj_set_pos(Nav_Icon, 60, 62);
    lv_obj_add_flag(Nav_Icon, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Nav_Icon, LV_OBJ_FLAG_SCROLLABLE);

    NavText = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(NavText, info18.font, 0);   /* 设置字体 */
    lv_label_set_long_mode(NavText, LV_LABEL_LONG_SCROLL); /* 设置长文本模式 */
    lv_obj_set_scroll_dir(NavText, LV_DIR_HOR);
    lv_obj_set_pos(NavText, 23, 258);  /* 设置坐标 */
    lv_obj_set_size(NavText, 195, 25); /* 设置控件大小 */
    lv_obj_set_style_text_color(NavText, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(NavText, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(NavText, LV_OBJ_FLAG_SCROLLABLE);

    NavTimeText = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(NavTimeText, info18.font, 0);   /* 设置字体 */
    lv_label_set_long_mode(NavTimeText, LV_LABEL_LONG_SCROLL); /* 设置长文本模式 */
    lv_obj_set_scroll_dir(NavTimeText, LV_DIR_HOR);
    lv_obj_set_pos(NavTimeText, 100, 299); /* 设置坐标 */
    lv_obj_set_size(NavTimeText, 140, 28); /* 设置控件大小 */
    lv_obj_set_style_text_color(NavTimeText, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(NavTimeText, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(NavTimeText, LV_OBJ_FLAG_SCROLLABLE);

    NavDistance = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(NavDistance, info18.font, 0);   /* 设置字体 */
    lv_label_set_long_mode(NavDistance, LV_LABEL_LONG_SCROLL); /* 设置长文本模式 */
    lv_obj_set_scroll_dir(NavDistance, LV_DIR_HOR);
    lv_obj_set_pos(NavDistance, 15, 297); /* 设置坐标 */
    lv_obj_set_size(NavDistance, 80, 28); /* 设置控件大小 */
    lv_obj_set_style_text_color(NavDistance, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(NavDistance, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(NavDistance, LV_OBJ_FLAG_SCROLLABLE);

    PowerIcon = lv_img_create(blackground_bg);
    // lv_img_set_src(PowerIcon, "S:/spiffs/sta_icon_07.jpg");
    // lv_obj_set_pos(PowerIcon, 7, 7);
    lv_obj_add_flag(PowerIcon, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(PowerIcon, LV_OBJ_FLAG_SCROLLABLE);

    PowerSeg = lv_img_create(blackground_bg);
    // lv_img_set_src(PowerIcon, "S:/spiffs/sta_icon_07.jpg");
    lv_obj_set_pos(PowerSeg, 108, 348);
    lv_obj_add_flag(PowerSeg, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(PowerSeg, LV_OBJ_FLAG_SCROLLABLE);

    PowerBackGround = lv_img_create(blackground_bg);
    lv_img_set_src(PowerBackGround, "S:/spiffs/pwr_bot.jpg");
    lv_obj_set_pos(PowerBackGround, 64, 353);
    lv_obj_add_flag(PowerBackGround, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(PowerBackGround, LV_OBJ_FLAG_SCROLLABLE);

    PowerBackLine = lv_img_create(blackground_bg);
    lv_img_set_src(PowerBackLine, "S:/spiffs/pwr_line.jpg");
    lv_obj_set_pos(PowerBackLine, 112, 348);
    lv_obj_add_flag(PowerBackLine, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(PowerBackLine, LV_OBJ_FLAG_SCROLLABLE);

    Ui_NatInfoOne = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_NatInfoOne, info45.font, 0); /* 设置字体 */
                                                               //  lv_obj_set_pos(Ui_NatInfoOne, 100, 198);
    lv_obj_set_size(Ui_NatInfoOne, 32, 35);
    lv_obj_set_style_text_color(Ui_NatInfoOne, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_NatInfoOne, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_NatInfoOne, LV_OBJ_FLAG_SCROLLABLE);

    Ui_NatInfoTen = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_NatInfoTen, info45.font, 0); /* 设置字体 */
                                                               //  lv_obj_set_pos(Ui_NatInfoTen, 100, 198);
    lv_obj_set_size(Ui_NatInfoTen, 32, 35);
    lv_obj_set_style_text_color(Ui_NatInfoTen, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_NatInfoTen, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_NatInfoTen, LV_OBJ_FLAG_SCROLLABLE);

    Ui_NatInfoHundredsPlace = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_NatInfoHundredsPlace, info45.font, 0); /* 设置字体 */
                                                                         //  lv_obj_set_pos(Ui_NatInfoHundredsPlace, 100, 198);
    lv_obj_set_size(Ui_NatInfoHundredsPlace, 32, 35);
    lv_obj_set_style_text_color(Ui_NatInfoHundredsPlace, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_NatInfoHundredsPlace, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_NatInfoHundredsPlace, LV_OBJ_FLAG_SCROLLABLE);

    Ui_NatInfoUnit = lv_img_create(blackground_bg);
    lv_img_set_src(Ui_NatInfoUnit, "S:/spiffs/num45_12.jpg");
    // lv_obj_set_pos(Ui_NatInfoUnit, 14, 343);
    lv_obj_add_flag(Ui_NatInfoUnit, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_NatInfoUnit, LV_OBJ_FLAG_SCROLLABLE);

    // Create_set_image(0, &Alarm_BG, &Alarm_BG_Hdl, MMAP_POP_JPG, 15, 280, 1);
    // Create_set_image(0, &AralmIcon, &AralmIcon_Hdl, MMAP_POP_P_01_JPG, 29, 300, 1);
    AralmText = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(AralmText, info45.font, 0); /* 设置字体 */
    lv_obj_set_pos(AralmText, 103, 100);                   /* 设置坐标 */
    lv_obj_set_size(AralmText, 108, 100);                  /* 设置控件大小 */
    lv_obj_set_style_text_color(AralmText, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(AralmText, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(AralmText, LV_OBJ_FLAG_SCROLLABLE);

    DownText = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(DownText, info18.font, 0); /* 设置字体 */
    // lv_obj_set_pos(AralmText, 103, 100);                   /* 设置坐标 */
    lv_obj_set_size(DownText, 162, 30); /* 设置控件大小 */
    lv_obj_set_style_text_color(DownText, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(DownText, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(DownText, LV_OBJ_FLAG_SCROLLABLE);

    DownIcon = lv_img_create(blackground_bg);
    lv_img_set_src(DownIcon, "S:/spiffs/bot_p_01.jpg");
    lv_obj_set_pos(DownIcon, 14, 343);
    lv_obj_add_flag(DownIcon, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(DownIcon, LV_OBJ_FLAG_SCROLLABLE);

    Ui_Soc_BackGround = lv_img_create(blackground_bg);
    lv_img_set_src(Ui_Soc_BackGround, "S:/spiffs/bui_eco.jpg");
    lv_obj_set_pos(Ui_Soc_BackGround, 0, 224);
    lv_obj_add_flag(Ui_Soc_BackGround, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_Soc_BackGround, LV_OBJ_FLAG_SCROLLABLE);

    Ui_Soc_Road = lv_img_create(blackground_bg);
    lv_img_set_src(Ui_Soc_Road, "S:/spiffs/road_eco.jpg");
    lv_obj_set_pos(Ui_Soc_Road, 0, 241);
    lv_obj_add_flag(Ui_Soc_Road, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_Soc_Road, LV_OBJ_FLAG_SCROLLABLE);

    Ui_Soc_Round = lv_arc_create(blackground_bg);
    // lv_obj_center(Ui_Soc_Round);
    lv_arc_set_range(Ui_Soc_Round, 0, 100); // 设置圆弧的范围
    lv_arc_set_bg_start_angle(Ui_Soc_Round, 0);
    lv_arc_set_bg_end_angle(Ui_Soc_Round, 360);
    lv_arc_set_rotation(Ui_Soc_Round, 90);
    lv_obj_set_size(Ui_Soc_Round, 180, 180);
    lv_obj_set_style_arc_color(Ui_Soc_Round, lv_color_make(0x17, 0xEF, 0xA1), LV_PART_MAIN);
    lv_obj_set_style_arc_opa(Ui_Soc_Round, LV_OPA_10, LV_PART_MAIN);
    lv_obj_set_style_arc_color(Ui_Soc_Round, lv_color_make(0x17, 0xEF, 0xA1), LV_PART_INDICATOR);
    lv_obj_set_style_arc_width(Ui_Soc_Round, 18, LV_PART_MAIN);
    lv_obj_set_style_arc_width(Ui_Soc_Round, 18, LV_PART_INDICATOR);
    lv_obj_remove_style(Ui_Soc_Round, NULL, LV_PART_KNOB);
    lv_obj_set_pos(Ui_Soc_Round, 30, 66);
    lv_obj_add_flag(Ui_Soc_Round, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_Soc_Round, LV_OBJ_FLAG_SCROLLABLE);
    Ui_Soc_Icon = lv_img_create(blackground_bg);
    lv_img_set_src(Ui_Soc_Icon, "S:/spiffs/icon_03.jpg");
    lv_obj_set_pos(Ui_Soc_Icon, 113, 99);
    lv_obj_add_flag(Ui_Soc_Icon, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_Soc_Icon, LV_OBJ_FLAG_SCROLLABLE);

    Ui_Soc_One = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_Soc_One, info45.font, 0); /* 设置字体 */
    lv_obj_set_pos(Ui_Soc_One, 26, 100);                    /* 设置坐标 */
    lv_obj_set_size(Ui_Soc_One, 126, 50);                   /* 设置控件大小 */
    lv_obj_set_style_text_color(Ui_Soc_One, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_Soc_One, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_Soc_One, LV_OBJ_FLAG_SCROLLABLE);
    Ui_Soc_Ten = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_Soc_Ten, info45.font, 0); /* 设置字体 */
    lv_obj_set_pos(Ui_Soc_Ten, 26, 100);                    /* 设置坐标 */
    lv_obj_set_size(Ui_Soc_Ten, 126, 50);                   /* 设置控件大小 */
    lv_obj_set_style_text_color(Ui_Soc_Ten, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_Soc_Ten, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_Soc_Ten, LV_OBJ_FLAG_SCROLLABLE);
    Ui_Soc_Hundred = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_Soc_Hundred, info45.font, 0); /* 设置字体 */
    lv_obj_set_pos(Ui_Soc_Hundred, 26, 100);                    /* 设置坐标 */
    lv_obj_set_size(Ui_Soc_Hundred, 126, 50);                   /* 设置控件大小 */
    lv_obj_set_style_text_color(Ui_Soc_Hundred, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_Soc_Hundred, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags

    Ui_Soc_Text = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_Soc_Text, info18.font, 0); /* 设置字体 */
    lv_obj_set_pos(Ui_Soc_Text, 83, 293);                    /* 设置坐标 */
    lv_obj_set_size(Ui_Soc_Text, 80, 24);                    /* 设置控件大小 */
    lv_obj_set_style_text_color(Ui_Soc_Text, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_Soc_Text, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags

    Ui_Soc_TimeText = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_Soc_TimeText, info18.font, 0); /* 设置字体 */
    lv_label_set_text(Ui_Soc_TimeText, "预计\n充电时间");
    lv_obj_set_pos(Ui_Soc_TimeText, 14, 337); /* 设置坐标 */
    lv_obj_set_size(Ui_Soc_TimeText, 72, 44); /* 设置控件大小 */
    lv_obj_set_style_text_color(Ui_Soc_TimeText, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_Soc_TimeText, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags

    Ui_Soc_Time = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_Soc_Time, info18.font, 0); /* 设置字体 */
    lv_obj_set_pos(Ui_Soc_Time, 108, 361);                   /* 设置坐标 */
    lv_obj_set_size(Ui_Soc_Time, 150, 22);                   /* 设置控件大小 */
    lv_obj_set_style_text_color(Ui_Soc_Time, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_Soc_Time, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags

    Ui_Soc_Symbol = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_Soc_Symbol, info45.font, 0); /* 设置字体 */
    lv_obj_set_pos(Ui_Soc_Symbol, 114, 185);
    // lv_label_set_text(Ui_Soc_Symbol, "%");
    lv_obj_set_size(Ui_Soc_Symbol, 50, 50);
    lv_obj_set_style_text_color(Ui_Soc_Symbol, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_Soc_Symbol, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_Soc_Symbol, LV_OBJ_FLAG_SCROLLABLE);
    lv_obj_clear_flag(Ui_Soc_Symbol, LV_OBJ_FLAG_SCROLLABLE);

    Ui_WeatherText = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_WeatherText, info18.font, 0);           /* 设置字体 */
    lv_obj_set_style_text_align(Ui_WeatherText, LV_TEXT_ALIGN_CENTER, 0); /* 设置文本水平居中  */
    // lv_label_set_text(Ui_WeatherText, "预计\n充电时间");
    lv_obj_set_pos(Ui_WeatherText, 0, 260);   /* 设置坐标 */
    lv_obj_set_size(Ui_WeatherText, 240, 44); /* 设置控件大小 */
    lv_obj_set_style_text_color(Ui_WeatherText, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_WeatherText, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags

    Ui_WeatherIcon = lv_img_create(blackground_bg);
    lv_img_set_src(Ui_WeatherIcon, "S:/spiffs/road_eco.jpg");
    lv_obj_set_pos(Ui_WeatherIcon, 57, 84);
    lv_obj_add_flag(Ui_WeatherIcon, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_WeatherIcon, LV_OBJ_FLAG_SCROLLABLE);

    Ui_WeatherRemind = lv_label_create(blackground_bg);
    lv_obj_set_style_text_font(Ui_WeatherRemind, info18.font, 0);           /* 设置字体 */
    lv_obj_set_style_text_align(Ui_WeatherRemind, LV_TEXT_ALIGN_CENTER, 0); /* 设置文本水平居中  */
    lv_label_set_text(Ui_WeatherRemind, "异常天气， 请注意安全");
    lv_obj_set_pos(Ui_WeatherRemind, 30, 290);  /* 设置坐标 */
    lv_obj_set_size(Ui_WeatherRemind, 200, 44); /* 设置控件大小 */
    lv_obj_set_style_text_color(Ui_WeatherRemind, lv_color_make(0xff, 0xff, 0xff), 0);
    lv_obj_add_flag(Ui_WeatherRemind, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags

    Ui_Gear = lv_img_create(blackground_bg);
    // lv_img_set_src(Ui_Gear, "S:/spiffs/dt.jpg");
    // lv_obj_set_pos(Ui_Gear, 0, 0);
    lv_obj_add_flag(Ui_Gear, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_Gear, LV_OBJ_FLAG_SCROLLABLE);

    Ui_FullAlarm = lv_img_create(blackground_bg);
    lv_img_set_src(Ui_FullAlarm, "S:/spiffs/dt.jpg");
    lv_obj_set_pos(Ui_FullAlarm, 0, 0);
    lv_obj_add_flag(Ui_FullAlarm, LV_OBJ_FLAG_HIDDEN | LV_OBJ_FLAG_ADV_HITTEST); /// Flags
    lv_obj_clear_flag(Ui_FullAlarm, LV_OBJ_FLAG_SCROLLABLE);

    ESP_LOGI(TAG, "Lvgl_Contrl_Init END.....");
}

void mmap_Init(void)
{

    /* partitions.csv
     * --------------------------------------------------------
     * | Name   | Type | SubType | Offset | Size  | Flags     |
     * --------------------------------------------------------
     * | assets | data | spiffs  |        | 6000K |           |
     * --------------------------------------------------------
     */
    const mmap_assets_config_t config = {
        .partition_label = "assets",
        .max_files = TOTAL_MMAP_FILES,
        .checksum = MMAP_CHECKSUM,
    };

    mmap_assets_new(&config, &asset_handle);

    /* Index from the enum MMAP_FILES(generated by esp_mmap_assets)
     * Used to reference specific files in the mmap table.
     */

    // for (int i = 0; i < TOTAL_MMAP_FILES; i++) {
    //     const char* name = mmap_assets_get_name(asset_handle, i);
    //     const uint8_t* mem = mmap_assets_get_mem(asset_handle, i);
    //     int size = mmap_assets_get_size(asset_handle, i);
    //     int width = mmap_assets_get_width(asset_handle, i);
    //     int height = mmap_assets_get_height(asset_handle, i);

    //     ESP_LOGI(TAG, "Name:[%s], Memory:[%p], Size:[%d bytes], Width:[%d], Height:[%d]", name, mem, size, width, height);
    // }

    // mmap_assets_del(asset_handle);
}
int piccount = 0;
void app_Read_Spiffs(void)
{
    struct dirent *p_dirent = NULL;
    DIR *p_dir_stream = opendir("/spiffs");

    /* Scan files in storage */
    while (true)
    {
        p_dirent = readdir(p_dir_stream);
        if (NULL != p_dirent)
        {
            //   ESP_LOGI(TAG, "d_name:%s", p_dirent->d_name);
            piccount++;
        }
        else
        {
            closedir(p_dir_stream);
            break;
        }
    }
    ESP_LOGI("test ", "count %d", piccount);
}
static lv_group_t *g_btn_op_group = NULL;

static void btn_event_cb(lv_event_t *event)
{
    lv_obj_t *img = (lv_obj_t *)event->user_data;
    const char *file_name = lv_list_get_btn_text(lv_obj_get_parent(event->target), event->target);
    char *file_name_with_path = (char *)heap_caps_malloc(256, MALLOC_CAP_INTERNAL | MALLOC_CAP_8BIT);

    if (NULL != file_name_with_path)
    {
        /* Get full file name with mount point and folder path */
        strcpy(file_name_with_path, "S:/spiffs/");
        strcat(file_name_with_path, file_name);

        ESP_LOGI(TAG, "test \n");

        /* Set src of image with file name */
        lv_img_set_src(img, "S:/spiffs/emoji_u1f60f.png");

        /* Align object */
        lv_obj_align(img, LV_ALIGN_CENTER, 80, 0);

        /* Only for debug */
        ESP_LOGI(TAG, "Display image file : %s", file_name_with_path);

        /* Don't forget to free allocated memory */
        free(file_name_with_path);
    }
}

static void image_display(void)
{
    lv_indev_t *indev = lv_indev_get_next(NULL);

    if ((lv_indev_get_type(indev) == LV_INDEV_TYPE_KEYPAD) ||
        lv_indev_get_type(indev) == LV_INDEV_TYPE_ENCODER)
    {
        ESP_LOGI(TAG, "Input device type is keypad");
        g_btn_op_group = lv_group_create();
        lv_indev_set_group(indev, g_btn_op_group);
    }

    lv_obj_t *list = lv_list_create(lv_scr_act());
    lv_obj_set_size(list, 170, 220);
    lv_obj_set_style_border_width(list, 0, LV_STATE_DEFAULT);
    lv_obj_align(list, LV_ALIGN_LEFT_MID, -15, 0);

    lv_obj_t *img = lv_img_create(lv_scr_act());
    /* Set src of image with file name */
    lv_img_set_src(img, "S:/spiffs/emoji_u1f60f.png");

    /* Align object */
    lv_obj_align(img, LV_ALIGN_CENTER, 0, 0);
    /* Get file name in storage */
    struct dirent *p_dirent = NULL;
    DIR *p_dir_stream = opendir("/spiffs");

    /* Scan files in storage */
    // while (true) {
    //     p_dirent = readdir(p_dir_stream);
    //     if (NULL != p_dirent) {
    //         lv_obj_t *btn = lv_list_add_btn(list, LV_SYMBOL_IMAGE, p_dirent->d_name);
    //         lv_group_add_obj(g_btn_op_group, btn);
    //         lv_obj_add_event_cb(btn, btn_event_cb, LV_EVENT_CLICKED, (void *) img);

    //     } else {
    //         closedir(p_dir_stream);
    //         break;
    //     }
    // }
}

void Gui_Display_Init(void)
{
    // mmap_assert_Init();

    bsp_spiffs_mount();
    // app_Read_Spiffs();
    // bsp_display_start();
    bsp_display_cfg_t cfg = {
        .lvgl_port_cfg = ESP_LVGL_PORT_INIT_CONFIG(),
        .buffer_size = BSP_LCD_V_RES * BSP_LCD_H_RES,
        .double_buffer = 1,
        .flags = {
            .buff_dma = 0,
            .buff_spiram = 1,
        }};
    bsp_display_start_with_config(&cfg);
    // image_display();
    lv_esp_jpg_init();

    mmap_Init();

    if (lvgl_port_lock(-1))
    {
        create_example_freetype();

        Lvgl_Contrl_Init();
        LvglTimer = lv_timer_create(Lvgl_On_Timer, 50, NULL);
        lvgl_port_unlock();
    }

    // if(mmap_assets_get_name(asset_handle,MMAP_NUM16_07_JPG) == PNG)
    // {
    //     printf("PNG ! \n");
    // }
    // else if (mmap_assets_get_name(asset_handle,MMAP_NUM16_07_JPG) == TYPE_JPG)
    // {
    //     printf("JPG ! \n");
    // }
    // else if (mmap_assets_get_name(asset_handle,MMAP_NUM16_07_JPG) == TYPE_TTF)
    // {
    //     printf("TTF ! \n");
    // }

    printf_stack();

    ESP_LOGE(TAG, "Init Kl30");
}

// 将数据转换为十六进制字符串并过滤掉无效值
char *ConvertToHexString(uint8_t *data, int length)
{
    static char hexString[BTMUSICBUFFMAX + 1]; // 每个字节转换为一个字符

    int index = 0;
    for (int i = 0; i < length; i++)
    {
        if (data[i] != 0xFF)
        {
            hexString[index] = data[i]; // 将有效字节直接复制到字符串中
            index++;
        }
    }
    hexString[index] = '\0'; // 添加字符串结尾

    return hexString;
}

void Gui_BT_Music_Display(bool show_hide)
{

    if (show_hide)
    {

        if (Get_Bt_Music_Status() == status_max)
        {
            lv_img_set_src(Music_Left, "S:/spiffs/music_p_07.jpg");
            lv_img_set_src(Music_Right, "S:/spiffs/music_p_08.jpg");
            lv_img_set_src(Music_Start, "S:/spiffs/music_p_09.jpg");
            set_widget_show_or_hide(Music_Left, 1);
            set_widget_show_or_hide(Music_Right, 1);
            set_widget_show_or_hide(Music_Start, 1);
            set_widget_show_or_hide(Music_InValid, 1);
            set_widget_show_or_hide(Music_Icon_B, 1);
            set_widget_show_or_hide(Music_Icon_S, 1);
        }
        else
        {
            lv_img_set_src(Music_Left, "S:/spiffs/music_p_04.jpg");
            lv_img_set_src(Music_Right, "S:/spiffs/music_p_05.jpg");
            lv_img_set_src(Music_Start, "S:/spiffs/music_p_06.jpg");
            set_widget_show_or_hide(Music_Icon_B, 1);
            set_widget_show_or_hide(Music_Icon_S, 1);
            set_widget_show_or_hide(Music_Left, 1);
            set_widget_show_or_hide(Music_Right, 1);
            set_widget_show_or_hide(Music_Start, 1);
            uint8_t *Text = Get_BT_Music_Lyrics();

            char *Lyric = ConvertToHexString(Text, BTMUSICBUFFMAX);
            lv_label_set_text(Music_Text, Lyric);
            set_widget_show_or_hide(Music_Text, 1);

            uint8_t *Temp = Get_BT_Music_Actor();
            char *composer = ConvertToHexString(Temp, BTMUSICBUFFMAX);
            lv_label_set_text(Music_Composer, Lyric);
            set_widget_show_or_hide(Music_Composer, 1);
            set_widget_show_or_hide(Music_InValid, 0);
        }
    }
    else
    {
        set_widget_show_or_hide(Music_Icon_B, 0);
        set_widget_show_or_hide(Music_Icon_S, 0);
        set_widget_show_or_hide(Music_Left, 0);
        set_widget_show_or_hide(Music_Right, 0);
        set_widget_show_or_hide(Music_Start, 0);
        set_widget_show_or_hide(Music_Composer, 0);
        set_widget_show_or_hide(Music_Text, 0);
        set_widget_show_or_hide(Music_InValid, 0);
    }
}

char *seconds_to_mmss(int total_seconds)
{
    static char buffer[6];
    int minutes = total_seconds / 60;
    int seconds = total_seconds % 60;

    // Format the time as mm:ss
    snprintf(buffer, sizeof(buffer), "%01d:%02d", minutes, seconds);
    return buffer;
}

void Gui_BT_Phone_Display(bool show_hide)
{

    // 获取电话号码数据
    uint8_t *phoneNum = Get_Bt_Phone_Num();

    // 转换为十六进制字符串并过滤掉无效值
    char *hexString = ConvertToHexString(phoneNum, BTIPHONENUMBERMAX);

    if (show_hide)
    {

        switch (Get_Bt_Phone_Status())
        {
        case Call_Incoming:
            lv_label_set_text(Iphone_Status, "来电");
            lv_obj_set_pos(Iphone_Status, 102, 210);
            set_widget_show_or_hide(Iphone_Status, 1);
            lv_label_set_text(Iphone_Num, hexString);
            set_widget_show_or_hide(Iphone_Num, 1);
            set_widget_show_or_hide(Iphone_Reminder, 1);
            set_widget_show_or_hide(Iphone_Icon, 1);
            break;
        case Call_In_Progress:
            lv_label_set_text(Iphone_Status, "通话中");
            set_widget_show_or_hide(Iphone_Status, 1);
            lv_obj_set_pos(Iphone_Status, 93, 210);
            lv_label_set_text(Iphone_Num, hexString);
            lv_label_set_text(Iphone_Timer, seconds_to_mmss(Get_Iphone_Timer()));
            set_widget_show_or_hide(Iphone_Num, 1);
            set_widget_show_or_hide(Iphone_Icon, 1);
            set_widget_show_or_hide(Iphone_Timer, 1);
            set_widget_show_or_hide(Iphone_Reminder, 0);
            break;
        default:
            set_widget_show_or_hide(Iphone_Num, 0);
            set_widget_show_or_hide(Iphone_Icon, 0);
            set_widget_show_or_hide(Iphone_Status, 0);
            set_widget_show_or_hide(Iphone_Reminder, 0);
            set_widget_show_or_hide(Iphone_Timer, 0);
            break;
        }
    }
    else
    {
        set_widget_show_or_hide(Iphone_Num, 0);
        set_widget_show_or_hide(Iphone_Icon, 0);
        set_widget_show_or_hide(Iphone_Status, 0);
        set_widget_show_or_hide(Iphone_Reminder, 0);
        set_widget_show_or_hide(Iphone_Timer, 0);
    }
}

void Gui_Alarm_Display(int index)
{

    set_widget_show_or_hide(Alarm_BG, 1);
    set_widget_show_or_hide(AralmIcon, 1);
    set_widget_show_or_hide(AralmText, 1);
    // lv_label_set_text(AralmText, Alarm_Dis[index].Text);

    // Set_Image_Decode(AralmIcon, &AralmIcon_Hdl, Alarm_Dis[index].Index);
}

void Gui_Main_Display(uint16_t Power)
{
    uint16_t test = 123;
    uint8_t Power_Num_digits = calculate_digits(Power);
    uint8_t Power_Num_digits_array[3] = {0, 0, 0};
    take_out_number(Power_Num_digits_array, Power, Power_Num_digits);

    set_widget_show_or_hide(Power_Bg, 1);
    set_widget_show_or_hide(Main_Road, 1);
    set_widget_show_or_hide(Build, 1);

    if (Power == 39)
    {

        set_widget_show_or_hide(Ui_FullAlarm, 1);
    }
    else
    {

        set_widget_show_or_hide(Ui_FullAlarm, 0);
    }

    if (Power <= 10)
    {
        set_widget_show_or_hide(Ui_Gear, 1);
        lv_img_set_src(Ui_Gear, "S:/spiffs/gear_01.png");
        lv_obj_set_pos(Ui_Gear, 63, 83);
    }
    else if (Power <= 20)
    {
        lv_obj_set_pos(Ui_Gear, 74, 83);
        set_widget_show_or_hide(Ui_Gear, 1);
        lv_img_set_src(Ui_Gear, "S:/spiffs/gear_02.png");
    }

    // switch (Power_Num_digits)
    // {
    // case 1:
    // case 2:

    //     lv_label_set_text(Power_NumOne, Common_number[Power_Num_digits_array[0]]);
    //     lv_obj_set_pos(Power_NumOne, 126, 167);
    //     set_widget_show_or_hide(Power_NumOne, 1);
    //     lv_label_set_text(Power_NumDot, Common_number[10]);
    //     lv_obj_set_pos(Power_NumDot, 116, 194);
    //     set_widget_show_or_hide(Power_NumDot, 1);

    //     lv_label_set_text(Power_NumTen, Common_number[Power_Num_digits_array[1]]);
    //     lv_obj_set_pos(Power_NumTen, 85, 167);
    //     set_widget_show_or_hide(Power_NumTen, 1);
    //     set_widget_show_or_hide(Ui_NatInfoHundredsPlace, 0);
    //     break;
    // case 3:
    //     lv_label_set_text(Power_NumOne, Common_number[Power_Num_digits_array[0]]);
    //     lv_obj_set_pos(Power_NumOne, 141, 167);
    //     set_widget_show_or_hide(Power_NumOne, 1);
    //     lv_label_set_text(Power_NumDot, Common_number[10]);
    //     lv_obj_set_pos(Power_NumDot, 131, 194);
    //     set_widget_show_or_hide(Power_NumDot, 1);

    //     lv_label_set_text(Power_NumTen, Common_number[Power_Num_digits_array[1]]);
    //     lv_obj_set_pos(Power_NumTen, 99, 167);
    //     set_widget_show_or_hide(Power_NumTen, 1);
    //     lv_label_set_text(Ui_NatInfoHundredsPlace, Common_number[Power_Num_digits_array[2]]);
    //     lv_obj_set_pos(Ui_NatInfoHundredsPlace, 70, 167);
    //     set_widget_show_or_hide(Ui_NatInfoHundredsPlace, 1);

    // default:
    //     break;
    // }

    // lv_img_set_src(Power_Bg, PowerImage[Power / 10]);
}

int temp = 20;

void Gui_Top_Display(uint8_t index)
{

    if (index <= 34)
    {
        lv_img_set_src(Temp, TopWeather[index]);
        set_widget_show_or_hide(Temp, 1);
    }
    else
    {

        set_widget_show_or_hide(Temp, 0);
    }

    set_widget_show_or_hide(Tbox, 1);
    set_widget_show_or_hide(Gps, 1);
    set_widget_show_or_hide(Iphone, 1);

    if (temp < 40)
    {
        temp--;
    }

    if (temp == -30)
    {
        temp = 39;
    }
    char buffer[20];
    sprintf(buffer, "%d", temp);

    lv_label_set_text(TempNum, buffer);
    set_widget_show_or_hide(TempNum, 1);
}

void hex_to_string(unsigned char *hex_data, size_t len, char *out_str)
{
    static const char *const lut = "0123456789abcdef";
    for (size_t i = 0; i < len; ++i)
    {
        unsigned char c = hex_data[i];
        *out_str++ = lut[c >> 4];
        *out_str++ = lut[c & 15];
    }
    *out_str = '\0'; // Null terminate the string
}
int testconut = 0;

uint32_t Get_Nav_Icon_Image_Indx(void)
{
    uint32_t Icon = 0X112233;

    if (Get_Nav_Turn_Data() != 0x88)
    {
        switch (Get_Nav_Turn_Data())
        {
        case 0:
            Icon = 2;
            break;
        case 1:
            Icon = 3;
            break;
        case 2:
            Icon = 9;
            break;
        case 3:
            Icon = 4;
            break;
        case 4:
            Icon = 5;
            break;
        case 5:
            Icon = 6;
            break;
        case 6:
            Icon = 7;
            break;
        case 7:
            Icon = 8;
            break;
        case 8:
            Icon = 61;
            break;
        case 9:
            Icon = 60;
            break;
        case 0XA:
            Icon = 51;
            break;
        case 0xB:
            Icon = 52;
            break;
        default:
            Icon = 2;
            break;
        }
    }
    else if (Get_Nav_Circumferential_Data() != 0x88)
    {
        switch (Get_Nav_Circumferential_Data())
        {
        case 0:
            Icon = 11;
            break;
        case 1:
            Icon = 12;
            break;
        case 2:
            Icon = 54;
            break;
        case 3:
            Icon = 55;
            break;
        case 4:
            Icon = 56;
            break;
        case 5:
            Icon = 57;
            break;
        case 6:
            Icon = 58;
            break;
        case 7:
            Icon = 59;
            break;
        case 8:
            Icon = 62;
            break;
        case 9:
            Icon = 63;
            break;
        case 0XA:
            Icon = 64;
            break;
        case 0xB:
            Icon = 65;
            break;
        default:
            Icon = 11;
            break;
        }
    }
    else if (Get_Nav_Path_Region_Data() != 0X88)
    {
        switch (Get_Nav_Path_Region_Data())
        {
        case 0:
            Icon = 17;
            break;
        case 1:
            Icon = 18;
            break;
        case 2:
            Icon = 19;
            break;
        case 3:
            Icon = 20;
            break;
        case 4:
            Icon = 21;
            break;
        case 5:
            Icon = 2;
            break;
        case 6:
            Icon = 23;
            break;
        case 7:
            Icon = 24;
            break;
        case 8:
            Icon = 30;
            break;
        case 9:
            Icon = 31;
            break;
        case 0XA:
            Icon = 66;
            break;
        case 0xB:
            Icon = 67;
            break;
        case 0xC:
            Icon = 68;
            break;
        case 0xD:
            Icon = 69;
            break;
        case 0xE:
            Icon = 25;
            break;
        case 0xF:
            Icon = 26;
            break;
        case 0x10:
            Icon = 27;
            break;
        case 0x11:
            Icon = 72;
            break;
        case 0x12:
            Icon = 73;
            break;
        case 0x13:
            Icon = 74;
            break;
        case 0x14:
            Icon = 75;
            break;
        case 0x15:
            Icon = 76;
            break;
        case 0x16:
            Icon = 53;
            break;
        case 0x17:
            Icon = 16;
            break;
        case 0x18:
            Icon = 13;
            break;
        case 0x19:
            Icon = 14;
            break;
        case 0x1a:
            Icon = 10;
            break;
        case 0x1b:
            Icon = 15;
            break;
        case 0x1c:
            Icon = 28;
            break;
        case 0x1d:
            Icon = 29;
            break;
        case 0x1e:
            Icon = 70;
            break;
        case 0x1f:
            Icon = 71;
            break;
        default:
            Icon = 17;
            break;
        }
    }

    return Icon;
}

void Gui_Navigation_Display(bool show_hide)
{
    uint16_t DistanceInto = Get_Nav_Turn_Distance();
    uint8_t DistanceInto_Num_digits = calculate_digits(DistanceInto);
    uint8_t DistanceInto_Num_digits_array[3] = {0, 0, 0};
    take_out_number(DistanceInto_Num_digits_array, DistanceInto, DistanceInto_Num_digits);
    uint8_t Hour = Get_Nav_Time_Hour();
    uint8_t Minute = Get_Nav_Time_Minute();
    uint16_t Distance = Get_Nav_Remain_Distance();
    uint8_t *Navdata = Get_Nav_name_Data();

    if (show_hide)
    {

        if ((Hour != 0x88) || (Minute != 0x88))
        {
            char TimeData[25];
            sprintf(TimeData, "%01d小时%02d分钟", Hour, Minute);
            lv_label_set_text(NavTimeText, TimeData);
            set_widget_show_or_hide(NavTimeText, 1);
        }
        else
        {
            set_widget_show_or_hide(NavTimeText, 0);
        }

        if (Distance != 0X1234)
        {
            char DistanceData[20];
            sprintf(DistanceData, "%01dKm", Distance);
            lv_label_set_text(NavDistance, DistanceData);
            set_widget_show_or_hide(NavDistance, 1);
        }
        else
        {
            set_widget_show_or_hide(NavDistance, 0);
        }

        if (Navdata != NULL)
        {
            Gui_Set_Utf_8_Text_Disp(NavText, Navdata, 1);
        }
        else
        {
            Gui_Set_Utf_8_Text_Disp(NavText, Navdata, 0);
        }

        // if(index == 1)
        // {

        if (Get_TelltalesLedSts(LED_TPower))
        {
            lv_obj_set_pos(PowerIcon, 19, 348);
            lv_img_set_src(PowerIcon, "S:/spiffs/tpwr_p_01.jpg");
            set_widget_show_or_hide(PowerIcon, 1);
            if (testconut != 0)
            {

                char Pwr[50];
                sprintf(Pwr, "S:/spiffs/pw_t_%02d.jpg", testconut % 10);
                lv_obj_set_pos(PowerSeg, 64, 353);
                lv_img_set_src(PowerSeg, Pwr);
                set_widget_show_or_hide(PowerSeg, 1);
                set_widget_show_or_hide(PowerBackGround, 0);
            }
            else
            {
                set_widget_show_or_hide(PowerBackGround, 1);
                set_widget_show_or_hide(PowerSeg, 0);
            }
        }
        else
        {
            set_widget_show_or_hide(PowerBackLine, 1);
            set_widget_show_or_hide(PowerBackGround, 1);
            if (Get_Power_Percent() != 0)
            {
                char Pwr[50];
                sprintf(Pwr, "S:/spiffs/pw_n_%03d.jpg", Get_Power_Percent());
                lv_obj_set_pos(PowerSeg, 108, 348);
                lv_img_set_src(PowerSeg, Pwr);
                set_widget_show_or_hide(PowerSeg, 1);
            }
            else
            {
                set_widget_show_or_hide(PowerSeg, 0);
            }
        }

        // }
        // else if (index == 2)
        // {
        //     lv_obj_set_pos(PowerIcon, 17, 347);
        //         lv_img_set_src(PowerIcon, "S:/spiffs/icon_02.jpg");
        //         set_widget_show_or_hide(PowerIcon, 1);
        // }
        // else
        // {
        //     lv_obj_set_pos(PowerIcon, 19, 348);
        //         lv_img_set_src(PowerIcon, "S:/spiffs/tpwr_p_01.jpg");
        //         set_widget_show_or_hide(PowerIcon, 1);
        // }

        // esp_log_buffer_hex("test", DistanceInto_Num_digits_array, sizeof(DistanceInto_Num_digits_array));

        if (DistanceInto != 0X1234)
        {

            switch (DistanceInto_Num_digits)
            {
            case 1:
                lv_label_set_text(Ui_NatInfoOne, Common_number[DistanceInto_Num_digits_array[0]]);
                lv_obj_set_pos(Ui_NatInfoOne, 100, 196);
                set_widget_show_or_hide(Ui_NatInfoOne, 1);
                set_widget_show_or_hide(Ui_NatInfoTen, 0);
                set_widget_show_or_hide(Ui_NatInfoHundredsPlace, 0);
                lv_obj_set_pos(Ui_NatInfoUnit, 131, 236);
                set_widget_show_or_hide(Ui_NatInfoUnit, 1);

                break;
            case 2:
                lv_label_set_text(Ui_NatInfoOne, Common_number[DistanceInto_Num_digits_array[0]]);
                set_widget_show_or_hide(Ui_NatInfoOne, 1);
                lv_obj_set_pos(Ui_NatInfoOne, 115, 196);
                lv_label_set_text(Ui_NatInfoTen, Common_number[DistanceInto_Num_digits_array[1]]);
                set_widget_show_or_hide(Ui_NatInfoTen, 1);
                lv_obj_set_pos(Ui_NatInfoTen, 86, 196);
                set_widget_show_or_hide(Ui_NatInfoHundredsPlace, 0);
                lv_obj_set_pos(Ui_NatInfoUnit, 146, 236);
                set_widget_show_or_hide(Ui_NatInfoUnit, 1);
                break;
            case 3:
                lv_label_set_text(Ui_NatInfoOne, Common_number[DistanceInto_Num_digits_array[0]]);
                set_widget_show_or_hide(Ui_NatInfoOne, 1);
                lv_obj_set_pos(Ui_NatInfoOne, 129, 196);
                lv_label_set_text(Ui_NatInfoTen, Common_number[DistanceInto_Num_digits_array[1]]);
                set_widget_show_or_hide(Ui_NatInfoTen, 1);
                lv_obj_set_pos(Ui_NatInfoTen, 100, 196);
                lv_label_set_text(Ui_NatInfoHundredsPlace, Common_number[DistanceInto_Num_digits_array[2]]);
                set_widget_show_or_hide(Ui_NatInfoHundredsPlace, 1);
                lv_obj_set_pos(Ui_NatInfoHundredsPlace, 71, 196);
                lv_obj_set_pos(Ui_NatInfoUnit, 160, 236);
                set_widget_show_or_hide(Ui_NatInfoUnit, 1);
                break;
            default:
                break;
            }
        }
        else
        {
            set_widget_show_or_hide(Ui_NatInfoOne, 0);
            set_widget_show_or_hide(Ui_NatInfoTen, 0);
            set_widget_show_or_hide(Ui_NatInfoHundredsPlace, 0);
            set_widget_show_or_hide(Ui_NatInfoUnit, 0);
        }

        if (Get_Nav_Icon_Image_Indx() != 0X112233)
        {
            char NavIcon[25];
            sprintf(NavIcon, "S:/spiffs/navi_%02d.jpg", Get_Nav_Icon_Image_Indx());
            lv_img_set_src(Nav_Icon, NavIcon);
            set_widget_show_or_hide(Nav_Icon, 1);
        }
        else
        {
            set_widget_show_or_hide(Nav_Icon, 0);
        }
    }
    else
    {
        set_widget_show_or_hide(Ui_NatInfoOne, 0);
        set_widget_show_or_hide(Ui_NatInfoTen, 0);
        set_widget_show_or_hide(Ui_NatInfoHundredsPlace, 0);
        set_widget_show_or_hide(Ui_NatInfoUnit, 0);
        set_widget_show_or_hide(Nav_Icon, 0);
        set_widget_show_or_hide(PowerSeg, 0);
        set_widget_show_or_hide(PowerBackLine, 0);
        set_widget_show_or_hide(PowerBackGround, 0);
        set_widget_show_or_hide(NavTimeText, 0);
        set_widget_show_or_hide(NavDistance, 0);
        Gui_Set_Utf_8_Text_Disp(NavText, NULL, 0);
    }
}

lv_obj_t *img1;

// int indexanim = MMAP_TO_001_JPG;

int count = 0;
int alarmtest = 10;

void create_powerOn_Screen(uint32_t index)
{
    uint32_t timestamp = esp_log_timestamp();
    uint32_t tm_wait = 0;

    // ESP_LOGW(TAG, "timestamp:%d", timestamp);
    bsp_display_lock(0);
    // ESP_LOGE(TAG, "i: %s", mmap_assets_get_name(asset_handle, index));
    PowerOnAnim_Hdl.header.w = mmap_assets_get_width(asset_handle, index);
    PowerOnAnim_Hdl.header.h = mmap_assets_get_height(asset_handle, index);
    PowerOnAnim_Hdl.header.always_zero = 0;
    PowerOnAnim_Hdl.data_size = mmap_assets_get_size(asset_handle, index);
    PowerOnAnim_Hdl.data = mmap_assets_get_mem(asset_handle, index);
    if (strstr(mmap_assets_get_name(asset_handle, index), ".png"))
    {
        PowerOnAnim_Hdl.header.cf = LV_IMG_CF_RAW_ALPHA;
    }
    else
    {
        PowerOnAnim_Hdl.header.cf = LV_IMG_CF_RAW;
    }
    lv_img_set_src(PowerOnAnim, &PowerOnAnim_Hdl);
    // timestamp = esp_log_timestamp();
    lv_refr_now(NULL);
    bsp_display_unlock();

    ESP_LOGW(TAG, "tm_wait:%d", esp_log_timestamp() - timestamp);
    // if (tm_wait < 30)
    // {
    //     ESP_LOGW(TAG, "wait:%d, timestamp:%d", tm_wait, timestamp);
    //     //  vTaskDelay(pdMS_TO_TICKS((30 - tm_wait)));
    // }
}

void Gui_Down_Disp(uint32_t index, bool show_hide)
{

    if (show_hide)
    {
        lv_label_set_text(DownText, Down_Text[index].Text);
        // lv_label_set_text(DownText, "短按查看长按关闭");
        lv_obj_set_pos(DownText, Down_Text[index].StartX, Down_Text[index].StartY);
        set_widget_show_or_hide(DownText, 1);
        set_widget_show_or_hide(DownIcon, 1);
    }
    else
    {
        set_widget_show_or_hide(DownIcon, 0);
        set_widget_show_or_hide(DownText, 0);
    }
}

void Gui_Charge_Disp(uint8_t Soc)
{

    set_widget_show_or_hide(Ui_Soc_BackGround, 1);
    set_widget_show_or_hide(Ui_Soc_Road, 1);

    uint8_t Soc_Num_digits = calculate_digits(Soc);
    uint8_t Soc_Num_digits_array[3] = {0, 0, 0};
    take_out_number(Soc_Num_digits_array, Soc, Soc_Num_digits);

    lv_label_set_text(Ui_Soc_Text, "充电中...");
    set_widget_show_or_hide(Ui_Soc_Text, 1);
    set_widget_show_or_hide(Ui_Soc_TimeText, 1);

    char Data[11];

    sprintf(Data, "%02d小时%02d分钟", 3, 12);

    lv_label_set_text(Ui_Soc_Time, Data);

    set_widget_show_or_hide(Ui_Soc_Time, 1);

    switch (Soc_Num_digits)
    {
        uint8_t Symbol[1] = {37};
        set_widget_show_or_hide(Ui_Soc_Symbol, 1);
        lv_label_set_text(Ui_Soc_Symbol, Symbol);

    case 1:
        lv_label_set_text(Ui_Soc_One, Common_number[Soc_Num_digits_array[0]]);
        lv_obj_set_pos(Ui_Soc_One, 106, 140);
        set_widget_show_or_hide(Ui_Soc_One, 1);
        set_widget_show_or_hide(Ui_Soc_Ten, 0);
        set_widget_show_or_hide(Ui_Soc_Hundred, 0);
        break;
    case 2:
        lv_label_set_text(Ui_Soc_One, Common_number[Soc_Num_digits_array[0]]);
        lv_obj_set_pos(Ui_Soc_One, 121, 140);
        set_widget_show_or_hide(Ui_Soc_One, 1);
        lv_label_set_text(Ui_Soc_Ten, Common_number[Soc_Num_digits_array[1]]);
        lv_obj_set_pos(Ui_Soc_Ten, 91, 140);
        set_widget_show_or_hide(Ui_Soc_Ten, 1);
        set_widget_show_or_hide(Ui_Soc_Hundred, 0);
        break;
    case 3:
        lv_label_set_text(Ui_Soc_One, Common_number[Soc_Num_digits_array[0]]);
        lv_obj_set_pos(Ui_Soc_One, 135, 140);
        set_widget_show_or_hide(Ui_Soc_One, 1);
        lv_label_set_text(Ui_Soc_Ten, Common_number[Soc_Num_digits_array[1]]);
        lv_obj_set_pos(Ui_Soc_Ten, 106, 140);
        set_widget_show_or_hide(Ui_Soc_Ten, 1);
        lv_label_set_text(Ui_Soc_Hundred, Common_number[Soc_Num_digits_array[2]]);
        lv_obj_set_pos(Ui_Soc_Hundred, 76, 140);
        set_widget_show_or_hide(Ui_Soc_Hundred, 1);
        break;
    default:
        break;
    }

    if (Soc <= 10)
    {
        set_widget_show_or_hide(Ui_Soc_Round, 1);
        lv_arc_set_value(Ui_Soc_Round, Soc);
        lv_obj_set_style_arc_color(Ui_Soc_Round, lv_color_make(0xff, 0x00, 0x10), LV_PART_INDICATOR);
        lv_obj_set_style_arc_color(Ui_Soc_Round, lv_color_make(0xff, 0x00, 0x10), LV_PART_MAIN);

        lv_img_set_src(Ui_Soc_Icon, "S:/spiffs/icon_05.jpg");
        set_widget_show_or_hide(Ui_Soc_Icon, 1);
    }
    else if (Soc <= 20)
    {
        set_widget_show_or_hide(Ui_Soc_Round, 1);
        lv_arc_set_value(Ui_Soc_Round, Soc);
        lv_obj_set_style_arc_color(Ui_Soc_Round, lv_color_make(0xff, 0xE7, 0x00), LV_PART_INDICATOR);
        lv_obj_set_style_arc_color(Ui_Soc_Round, lv_color_make(0xff, 0xE7, 0x00), LV_PART_MAIN);
        lv_img_set_src(Ui_Soc_Icon, "S:/spiffs/icon_04.jpg");
        set_widget_show_or_hide(Ui_Soc_Icon, 1);
    }
    else
    {
        lv_img_set_src(Ui_Soc_Icon, "S:/spiffs/icon_03.jpg");
        set_widget_show_or_hide(Ui_Soc_Icon, 1);
        set_widget_show_or_hide(Ui_Soc_Round, 1);
        lv_arc_set_value(Ui_Soc_Round, Soc);
        lv_obj_set_style_arc_color(Ui_Soc_Round, lv_color_make(0x10, 0xEF, 0xA5), LV_PART_INDICATOR);
        lv_obj_set_style_arc_color(Ui_Soc_Round, lv_color_make(0x10, 0xEF, 0xA5), LV_PART_MAIN);
    }
}

int gsdtest = 0;
int gsdtest1 = 0;
void Gui_Weather_Disp(bool show_hide)
{

    if (gsdtest < 4)
    {
        gsdtest++;
    }
    else
    {
        gsdtest = 0;
    }

    if (gsdtest1 < 20)
    {
        gsdtest1++;
    }
    else
    {
        gsdtest1 = 0;
    }

    switch (gsdtest)
    {
    case Level_White:
        lv_obj_set_style_text_color(Ui_WeatherText, lv_color_make(0xff, 0xff, 0xff), 0);
        break;
    case Level_Blue:
        lv_obj_set_style_text_color(Ui_WeatherText, lv_color_make(0x35, 0x5F, 0xff), 0);
        break;
    case Level_Yellow:
        lv_obj_set_style_text_color(Ui_WeatherText, lv_color_make(0xff, 0xfD, 0x54), 0);
        break;
    case Level_Orange:
        lv_obj_set_style_text_color(Ui_WeatherText, lv_color_make(0xf4, 0x99, 0x02), 0);
        break;
    case Level_Red:
        lv_obj_set_style_text_color(Ui_WeatherText, lv_color_make(0xdc, 0x2e, 0x29), 0);
        break;
    default:
        lv_obj_set_style_text_color(Ui_WeatherText, lv_color_make(0xff, 0xff, 0xff), 0);
        break;
    }
    Gui_Set_Char_Text_Disp(Ui_WeatherText, WeatherText[gsdtest1][gsdtest], 1);

    lv_img_set_src(Ui_WeatherIcon, WeatherIcon[gsdtest1][gsdtest]);
    set_widget_show_or_hide(Ui_WeatherIcon, 1);
    set_widget_show_or_hide(Ui_WeatherRemind, 1);
}

void Lvgl_On_Timer(lv_timer_t *timer)
{

    // ESP_LOGW("GUI", "TIMER %d", esp_log_timestamp());

    //     if(count < 5)
    //     {

    //     count++;
    //     }
    //     else
    //     {
    //         count = 0;
    //     }

    //     switch (count)
    //     {
    //     case 1:
    // lv_img_set_src(img, "S:/spiffs/navi_01.jpg");
    //         break;
    //     case 2:
    //     lv_img_set_src(img, "S:/spiffs/navi_02.jpg");
    //         break;
    //     case 3:
    //     lv_img_set_src(img, "S:/spiffs/navi_03.jpg");
    //         break;
    //     case 4:
    //     lv_img_set_src(img, "S:/spiffs/navi_04.jpg");
    //         break;
    //     case 5:
    //     lv_img_set_src(img, "S:/spiffs/navi_05.jpg");

    //         break;
    //     default:
    //         break;
    //     }

    //     // lv_img_set_src(imgtest, "S:/spiffs/emoji_u1f914.png");

    // if (Get_Bt_Phone_Status() != Call_idel)
    // {

    //     Gui_BT_Phone_Display(true);
    //     Gui_Down_Disp(1, true);
    //     Gui_BT_Music_Display(false);
    // }
    // else
    // {
    //     Gui_Down_Disp(2, true);
    //     Gui_BT_Music_Display(true);
    //     Gui_BT_Phone_Display(false);
    // }

    //     // if(indexanim <] MMAP_TO_061_JPG)
    //     // {
    //     //     indexanim++;
    //     // }
    //     // else
    //     // {
    //     //     indexanim = MMAP_TO_001_JPG;
    //     // }
    //     // Set_Image_Decode(anim, &animhdl,indexanim);
    //     // set_widget_show_or_hide(anim,1);

    // create_powerOn_Screen(alarmtest);

    //     // set_widget_show_or_hide(img2, 1);

    //     //     img1 = lv_img_create(lv_scr_act());
    //     //  lv_img_set_src(img1, "/spiffs/music_p_02.jpg");
    //     //  lv_obj_align(img1, LV_ALIGN_CENTER, 0, 0);

    //  printf_stack();

    //     static char buffer[128];
    //     sprintf(buffer, "   Biggest /     Free /    Min/    Total\n"
    //                     "\t  SRAM : [%8d / %8d / %8d / %8d]",
    //             heap_caps_get_largest_free_block(MALLOC_CAP_INTERNAL),
    //             heap_caps_get_free_size(MALLOC_CAP_INTERNAL),
    //             heap_caps_get_minimum_free_size(MALLOC_CAP_INTERNAL),
    //             heap_caps_get_total_size(MALLOC_CAP_INTERNAL));

    //     ESP_LOGI("MEM", "%s", buffer);

    //  Gui_Alarm_Display(alarmtest / 20);

    //     // Create_set_image(1, &anim, &animhdl, indexanim, 0, 0, 0);
    //     // printf("test on timer\n");

    // Gui_Charge_Disp(alarmtest);s
    // Gui_Weather_Disp(1);
    // Gui_Main_Display(alarmtest);

    if (Get_Bt_Phone_Status() != Call_idel)
    {

        Gui_BT_Phone_Display(true);
        Gui_Down_Disp(1, true);

        Gui_Navigation_Display(false);

        Gui_BT_Music_Display(false);
    }
    else
    {

        if (Get_Current_Item() == MENU_ITEM_NAV)
        {
            Gui_BT_Music_Display(true);
            Gui_Down_Disp(2, false);
             Gui_Navigation_Display(true);
        }
        // else if (Get_Current_Item() == MENU_ITEM_CHARGE)
        // {
        //     Gui_Charge_Disp(alarmtest);
        // }
        else
        {
            Gui_Navigation_Display(false);
            Gui_Down_Disp(2, true);
            Gui_BT_Music_Display(true);
        }
        Gui_BT_Phone_Display(false);
    }

    // Gui_Down_Disp(1, true);
    // Gui_BT_Phone_Display(true);

    // Gui_Down_Disp(2, true);
    // Gui_BT_Music_Display(false);
    // Gui_Top_Display(alarmtest);
}
