#include "Lvgl_User.h"
#include "lvgl.h"
/**
 * @brief 用于控制控件显示或隐藏
 * @param p_st_obj 传入对象指针
 * @param b_visible_flag 显隐标志位 1 显示 0 隐藏
 */
void set_widget_show_or_hide(lv_obj_t *p_st_obj, bool b_visible_flag)
{
    /** 获取当前控件的显示状态 */
    uint32_t u32_display_status = p_st_obj->flags & 0x00000001;
    if ((!b_visible_flag) == u32_display_status) { /** 状态没有改变 */
   // printf("return \r\n");
        return;
    } else if (b_visible_flag) { /** 显示控件 */
        lv_obj_clear_flag(p_st_obj, LV_OBJ_FLAG_HIDDEN);
    } else if (!b_visible_flag) { /** 隐藏控件 */
        lv_obj_add_flag(p_st_obj, LV_OBJ_FLAG_HIDDEN);
    }
}

/**
 * @brief 设置控件显示图片
 * @param p_st_obj 传入对象指针
 * @param p_v_pic 传入图片数据
 */
void set_pic(lv_obj_t *p_st_obj, const void *p_v_pic)
{
    lv_img_set_src(p_st_obj, p_v_pic);
}

/**
 * @brief 设置一组控件的显示或隐藏
 * @param p_st_widget_array 控件指针数组
 * @param u8_array_length 数组长度
 * @param u8_dis_widget_num 最大显示长度
 * @param b_visible_flag 显隐标志 1 显示 0 隐藏
 */
void set_widgets_visible_list(lv_obj_t **p_st_widget_array, uint8_t u8_array_length, uint8_t u8_dis_widget_num, bool b_visible_flag)
{
    uint8_t u8_dis_widget_index = 0;
    for (; u8_dis_widget_index < u8_dis_widget_num; u8_dis_widget_index++) {
        // printf("u8_dis_widget_num %d\r\n",u8_dis_widget_num);
        //printf("u8_dis_widget_index %d\r\n",u8_dis_widget_index);
        set_widget_show_or_hide(p_st_widget_array[u8_dis_widget_index], b_visible_flag); /* 根据传入的显隐标志， 对一组控件的最大长度进行显示*/
    }
    for (; u8_dis_widget_index < u8_array_length; u8_dis_widget_index++) {
        //printf("u8_array_length %d\r\n",u8_array_length);
        set_widget_show_or_hide(p_st_widget_array[u8_dis_widget_index], 0); /* 对一组控件的 u8_array_length - u8_dis_widget_num 进行隐藏处理*/
    }
}

/**
 * @brief 传入设置数字指针
 * @code _Set_Num_st_t st_ODO_Set_Num
 *       Set_Num（@st_ODO_Set_Num）；
 */
void Set_Num(_Set_Num_st_t *p_st_set_num)
{
    for (uint8_t i = p_st_set_num->u8_start_num; i < p_st_set_num->u8_dis_num_max; i++) {
        p_st_set_num->SetTypeSize_Cbk(p_st_set_num->widgets_array[i], p_st_set_num->s8_num_array[i - p_st_set_num->u8_start_num], p_st_set_num->Handle_array[i]);
    }
}

/**
 * @brief 设置一组控件的坐标
 *
 */
void set_widgets_pos_list(_set_pos_st_t *p_st_set_pos)
{
    int16_t s16_x_coord = 0;
    int16_t s16_y_coord = 0;
    for (int i = p_st_set_pos->u8_start_num; i < p_st_set_pos->u8_widgets_array_length; i++) {
        s16_x_coord = p_st_set_pos->widgets_pos_array[i - p_st_set_pos->u8_start_num].s16_x_coord;
        s16_y_coord = p_st_set_pos->widgets_pos_array[i - p_st_set_pos->u8_start_num].s16_y_coord;
        //printf("p_st_set_pos->u8_widgets_array_length %d\r\n",p_st_set_pos->u8_widgets_array_length);
        if ((s16_x_coord != -1) && (s16_y_coord != -1)) {
            lv_obj_set_pos(p_st_set_pos->widgets_array[i], s16_x_coord, s16_y_coord);
        } else {

            break;
        }
    }
}

/**
 * @brief 用于计算数字长度
 * @param  u32_num 传入数据
 * @return 返回数字长度
 */
uint8_t calculate_digits(uint32_t u32_num)
{
    int8_t s8_digits = 0;
    if (u32_num == 0) {
        s8_digits = 1;
    } else {
        while (u32_num) {
            u32_num /= 10;
            s8_digits++;
        }
    }
    return s8_digits;
}

/**
 * @brief 分离数字，每位数字传入
 * @param p_s8_num_array 指向一个用于存储分离出来数字的数组
 * @param u32_num 传入数据
 * @param u8_digits 数字位数
 */
void take_out_number(int8_t *p_s8_num_array, uint32_t u32_num, uint8_t u8_digits)
{
    for (uint8_t i = 0; i < u8_digits; i++) {
        p_s8_num_array[i] = u32_num % 10;
        u32_num /= 10;
    }
}

/**
 * @brief 设置一组控件的显隐
 * @param widget_array 指向一个控件指针的数组
 * @param digits_num 显示数字的位数
 * @param b_visible_flag 显隐标志
 */
void set_widgets_show_or_hide_list(lv_obj_t** widget_array, uint8_t digits_num, bool b_visible_flag)
{
    for (int digit_index = 0; digit_index < digits_num; digit_index++) {
        set_widget_show_or_hide(widget_array[digit_index], b_visible_flag);
    }
}
