#ifndef _LVGL_USER_H_
#define _LVGL_USER_H_

#include "lvgl.h"



/* 用于计算数组长度*/
#define Array_Len(array)   (sizeof(array) / sizeof(*array))

typedef void (*SetTypeSize)(lv_obj_t *p_st_obj, int8_t num,lv_img_dsc_t *Data);
/**
 * @brief 设置数字的结构体
 * @param SetTypeSize           传入数字大小函数指针
 * @param widgets_array         数字图标控件指针数组
 * @param s8_num_array          数字数组
 * @param u8_start_num          开始显示的控件所在数组内的索引
 * @param u8_dis_num_max        最大显示位数
 */
typedef struct
{
    SetTypeSize SetTypeSize_Cbk; /* 设置数字大小函数指针 */
    lv_obj_t **widgets_array;    /** 数字图标控件指针数组 */
    int8_t *s8_num_array;        /** 数字数组 */
    uint8_t u8_start_num;        /** 开始显示的控件所在数组内的索引 */
    uint8_t u8_dis_num_max;      /** 最大显示位数 */
    lv_img_dsc_t **Handle_array;

} _Set_Num_st_t;


/**
 * @brief 坐标结构体
 * @param s16_x_coord x坐标
 * @param s16_y_coord y坐标
 */
typedef struct st_coordinate
{
    int16_t s16_x_coord; /** x坐标 */
    int16_t s16_y_coord; /** y坐标 */
} _coordinate_st_t;

/**
 * @brief 设置坐标
 * @param s16_widgets_pos_array     控件坐标数组
 * @param widgets_array             控件指针数组
 * @param u8_widgets_array_length   控件指针数组长度
 * @param u8_start_num              开始设置坐标的控件的索引
 */
typedef struct st_set_pos
{
    _coordinate_st_t *widgets_pos_array;
    lv_obj_t **widgets_array;
    uint8_t u8_widgets_array_length;
    uint8_t u8_start_num;
} _set_pos_st_t;




extern void set_widgets_visible_list(lv_obj_t **p_st_widget_array, uint8_t u8_array_length, uint8_t u8_dis_widget_num, bool b_visible_flag);
extern void set_pic(lv_obj_t *p_st_obj, const void *p_v_pic);
extern void set_widget_show_or_hide(lv_obj_t *p_st_obj, bool b_visible_flag);
extern void Set_Num(_Set_Num_st_t *p_st_set_num);
extern void set_widgets_pos_list(_set_pos_st_t *p_st_set_pos);
extern uint8_t calculate_digits(uint32_t u32_num);
extern void take_out_number(int8_t *p_s8_num_array, uint32_t u32_num, uint8_t u8_digits);
extern void set_widgets_show_or_hide_list(lv_obj_t** widget_array, uint8_t digits_num, bool b_visible_flag);

#endif
