#ifndef PROTOCOL_USER_H
#define PROTOCOL_USER_H
#include <stdio.h>
#include <string.h>
#include "Protocol_Lib.h"


typedef enum
{
    PROT_IDLE = 0, 
    PROT_STARTING,
    PROT_START,
    PROT_NORMAL,
}Prot_State_en_t;

typedef struct
{
    uint8_t u8State;
    uint8_t u8TimeDelay;
}Prot_State_st_t;


void Protocol_KL30_Wakeup_Init(void);
void Protocol_Send_Service(void);    // 10ms任务调用
void UART_Put(Protocol_uint16_t Data);
void Protocol_User_Ctrl_Init(void);
void Prot_Send_Msg_Process(void);

extern uint8_t Get_HandshakeFlag(void);

#endif
