
#ifndef SYSTEM__MONITOR__H
#define SYSTEM__MONITOR__H

/* #define Platform_16Bit
 #define Platform_32Bit*/

#ifdef Platform_16Bit
    #define monitorlib_uint8_t  unsigned char
    #define monitorlib_uint16_t unsigned int
    #define monitorlib_uint32_t unsigned long

#else

    #define monitorlib_uint8_t  unsigned char
    #define monitorlib_uint16_t unsigned short
    #define monitorlib_uint32_t unsigned int
    #define monitorlib_uint64_t unsigned long long
#endif

/*
     0 ----1st-------6500   不可运行   1
  6500 ----2st-------7000   回差段     2

  7000 ----3st-------9000   低压段     3
  9000 ----4st-------9500   回差段     4
  9500-----5st------16000   正常段     5
  16000----6st------16500   回差段     6

  16500----7st------18000   高压段     7
  18000----8st------18500   回差段     8
  18500----9st------65535   高压段     9

    0-----6.5   不可运行--ALL----------限制
  6.5-----9     除电机外均可运行--------正常
    9-----16.5  均可运行---------------正常
 16.5-----18.5  只有CAN可运行----------限制
 18.8-----65535 不可运行--ALL----------限制

6.5-18.5  CAN 可运行区间

*/
typedef monitorlib_uint8_t (*Get_Voltage_Vaild)(void);
typedef monitorlib_uint16_t (*Get_Voltage_Value)(void);
typedef monitorlib_uint8_t (*Get_LineInStatus)(void);
typedef void (*COMMON_Delay)(monitorlib_uint32_t mMs);
typedef void (*pfunLogic)(void);

typedef struct
{
    Get_Voltage_Vaild SysGet_KL30_Valid;
    Get_Voltage_Vaild SysGet_KL15_Valid;
    Get_Voltage_Value SysGet_KL30_value_Force;
    Get_Voltage_Value SysGet_KL15_value_Force;
    Get_Voltage_Value SysGet_KL30_value;
    Get_Voltage_Value SysGet_KL15_value;
    Get_LineInStatus  SysGet_KL15Line;
    COMMON_Delay      COM_Delay;
    pfunLogic         SysMonitorLogic;
} MonitorExt_st;

/* SYS RUN Status */
#define SYS_OPR_STAT_RUN  ((System_FUN_KL30_Status_Get( ) > 1u) && (System_FUN_KL30_Status_Get( ) < 7u))
#define SYS_OPR_STAT_HALT ((System_FUN_KL30_Status_Get( ) == 1u) || (System_FUN_KL30_Status_Get( ) > 7u))

#define SYS_OPR_STAT_LIM_LVP (System_FUN_KL30_Status_Get( ) == 1U)
#define SYS_OPR_STAT_LIM_OVP (System_FUN_KL30_Status_Get( ) > 7u)

/*fun status*/
#define SYS_OPR_STAT_IGN_ON  (System_FUN_KL15_Status_Get( ) == 1U)
#define SYS_OPR_STAT_IGN_OFF (System_FUN_KL15_Status_Get( ) == 0U)

/*nm run status*/
#define SYS_OPR_STAT_IGN_ON_NM  (System_NM_KL15_Status_Get( ) == 1U)
#define SYS_OPR_STAT_IGN_OFF_NM (System_NM_KL15_Status_Get( ) == 0U)

/*nm status*/
#define SYS_OPR_STAT_RUN_NM  ((System_NM_KL30_Status_Get( ) > 1u) && (System_NM_KL30_Status_Get( ) < 9u))
#define SYS_OPR_STAT_HALT_NM ((System_NM_KL30_Status_Get( ) == 9u) || (System_NM_KL30_Status_Get( ) == 1u))

monitorlib_uint8_t  Read_KL30_ConvertFinish(void);
monitorlib_uint16_t Get_Sysmonitor_Version(void);

void Sys_Status_Update_Service(void);
void Sys_Set_Pata(const monitorlib_uint16_t FUN_Vol [], MonitorExt_st *pfunc);
void System_Monitor_KL30Init(void);
void System_Monitor_WakeupInit(void);
void System_XHY_CheckWakeup(void);

monitorlib_uint8_t System_FUN_KL30_Status_Get(void);
monitorlib_uint8_t System_FUN_KL15_Status_Get(void);
monitorlib_uint8_t System_NM_KL15_Status_Get(void);
monitorlib_uint8_t System_NM_KL30_Status_Get(void);

#endif
