#include <time.h>
#include <sys/time.h>
#include "esp_log.h"
#include <stdint.h>
#include "bsp_SysTime.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/queue.h"
#include "freertos/semphr.h"

 static const char *TIMETAG = "systime";

int set_local_time(_st_Data_Time *Time,int timeoffest)
{
    struct tm timeinfo;
    struct timeval tv;
    time_t timep;

    int yr = 2020;
    int month = 1;
    int day = 1; // 年月日不变

    time(&timep);
    setenv("TZ", "CST-8", 1);
    tzset();
    localtime_r(&timep, &timeinfo); /* 获取当前时间 */

    timeinfo.tm_sec = Time->Second;
    timeinfo.tm_min = Time->Minute;
    timeinfo.tm_hour = Time->Hour;

    //printf("timeinfo.tm_hour %d\r\n",timeinfo.tm_hour);
    // yr = timeinfo.tm_year + 1900;
    // month = timeinfo.tm_mon + 1;
    // day = timeinfo.tm_mday;

    //

    timeinfo.tm_year = yr - 1900;
    timeinfo.tm_mon = month - 1;
    timeinfo.tm_mday = day;
//ESP_LOGI(TIMETAG, "hour is %d, minute is %d, sec is %d , year is %d, mounth is %d, day is %d", timeinfo.tm_hour, timeinfo.tm_min, timeinfo.tm_sec, timeinfo.tm_year, timeinfo.tm_mon, timeinfo.tm_mday );
    timep = mktime(&timeinfo); /* 转换为时间戳 */
    tv.tv_sec = timep;
    tv.tv_usec = timeoffest;
    if (settimeofday(&tv, (struct timezone *)0) < 0) /* 设置系统时间 */
    {
        return -1;
    }
    return 0;

}

typedef struct
{
    /* data */
    uint8_t dispYear;
    uint8_t dispmonth;
    uint8_t dispday;
    uint8_t dispHour;
    uint8_t dispMin;
    uint8_t dispsecond;
} _Time_Display_Struct;

_Time_Display_Struct TimeDisp;


void Time_Display_Init(int timeoffest)
{
    TimeDisp.dispYear = 0;
    TimeDisp.dispmonth = 0;
    TimeDisp.dispday = 0;
    TimeDisp.dispHour = 0;
    TimeDisp.dispMin = 0;
    TimeDisp.dispsecond = 0;

    _st_Data_Time Time = {
        .Year = 0,
        .Month = 0,
        .Day = 0,
        .Hour = 0,
        .Minute = 0,
        .Second = 0,
    };

    set_local_time(&Time,timeoffest);
}

void Time_Display_Update(void) // 100ms
{
    time_t now;
    struct tm timeinfo;
    time(&now);
    setenv("TZ", "CST-8", 1);
    tzset();
    localtime_r(&now, &timeinfo);

    TimeDisp.dispYear = timeinfo.tm_year;
    TimeDisp.dispmonth = timeinfo.tm_mon;
    TimeDisp.dispday = timeinfo.tm_mday;
    TimeDisp.dispHour = timeinfo.tm_hour;
    TimeDisp.dispMin = timeinfo.tm_min;
    TimeDisp.dispsecond = timeinfo.tm_sec;
    //ESP_LOGI(TIMETAG, "hour is %d, minute is %d, sec is %d , year is %d, mounth is %d, day is %d", TimeDisp.dispHour, TimeDisp.dispMin, TimeDisp.dispsecond, TimeDisp.dispYear, TimeDisp.dispmonth, TimeDisp.dispday );

    //printf("TimeDisp.dispHour = %d; TimeDisp.dispMin = %d; \r\n",timeinfo.tm_hour,timeinfo.tm_min);

    //printf("timeinfo.tm_year %d\r\n",timeinfo.tm_year);
}

uint8_t Get_dispHour(void)
{
    return TimeDisp.dispHour;
}

uint8_t Get_dispMin(void)
{
    return TimeDisp.dispMin;
}
