/*
 * SPDX-FileCopyrightText: 2010-2022 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: CC0-1.0
 */
#include "bsp_Timer.h"
#include <stdio.h>
#include "soc/soc.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/queue.h"
#include "driver/gptimer.h"
#include "esp_log.h"
#include "a2dp_sink_and_hfp.h"
static const char *TAG = "timer";
QueueHandle_t timer_que;
QueueHandle_t timer1_que;
uint16_t my_Timer_Cnt;

static bool IRAM_ATTR timer_on_alarm_isr(gptimer_handle_t timer, const gptimer_alarm_event_data_t *edata, void *user_data)
{

    BaseType_t high_task_awoken = pdFALSE;
    QueueHandle_t queue = (QueueHandle_t)user_data;
    xQueueSendFromISR(queue, NULL, &high_task_awoken);
    return (high_task_awoken == pdTRUE);
}

static bool IRAM_ATTR timer1_on_alarm_isr(gptimer_handle_t timer, const gptimer_alarm_event_data_t *edata, void *user_data)
{

    BaseType_t high_task_awoken = pdFALSE;
    QueueHandle_t queue = (QueueHandle_t)user_data;
    xQueueSendFromISR(queue, NULL, &high_task_awoken);
    return (high_task_awoken == pdTRUE);
}

uint8_t Timer_10ms_Cnt;
static void my_Timer_Process_Tasks(void *arg)
{
    while (1)
    {
        xQueueReceive(timer_que, NULL, portMAX_DELAY);

        if (Timer_10ms_Cnt < 9)
        {
            Timer_10ms_Cnt++;
        }
        else
        {

            Timer_10ms_Cnt = 0;
        }
        // printf("my_Timer_Process_Tasks \r\n");

        // ESP_LOGE(TAG, "1ms test");
        // COM_TX_Process();
    }
}
uint32_t IphoneTimer = 0;




static void my_Timer1_Process_Tasks(void *arg)
{
    while (1)
    {
        xQueueReceive(timer1_que, NULL, portMAX_DELAY);
        Data_User_Mileage_ISR();
        if (Get_Bt_Phone_Status() == Call_In_Progress)
        {
            IphoneTimer++;
        }
        else
        {
            IphoneTimer = 0;
        }

        // ESP_LOGE(TAG, "Data_ODO_Read %d",User_Data_ODO_Read());
        // printf("Data_ODO_Read %d\r\n",Data_ODO_Read());

    }
}

TaskHandle_t Timer_hdl;
TaskHandle_t Timer1_hdl;

void my_Timer_SysOn_Init(void)
{
    ESP_LOGW(TAG, "my_Timer_SysOn_Init");
    timer_que = xQueueCreate(1, 0);
    if (!timer_que)
    {
        ESP_LOGE(TAG, "Creating queue failed");
        return;
    }
    xTaskCreate(my_Timer_Process_Tasks, "my_Timer_Process", 4096, NULL, 13, &Timer_hdl);

    timer1_que = xQueueCreate(1, 0);
    if (!timer1_que)
    {
        ESP_LOGE(TAG, "Creating queue failed");
        return;
    }
    xTaskCreate(my_Timer1_Process_Tasks, "my_Timer1_Process", 4096, NULL, 14, &Timer1_hdl);
}

gptimer_handle_t gptimer_1ms_hd = NULL;
gptimer_handle_t gptimer_100ms_hd = NULL;
        void my_Timer_Driver_Init(void)
{

    /* Create timer handle */
    gptimer_config_t timer_config = {
        .clk_src = GPTIMER_CLK_SRC_DEFAULT,
        .direction = GPTIMER_COUNT_UP,
        .resolution_hz = 1000000, // 1MHz, 1 tick=1us
    };
    ESP_ERROR_CHECK(gptimer_new_timer(&timer_config, &gptimer_1ms_hd));

    gptimer_event_callbacks_t cbs = {
        .on_alarm = timer_on_alarm_isr,
    };

    ESP_ERROR_CHECK(gptimer_register_event_callbacks(gptimer_1ms_hd, &cbs, timer_que));
    /* Enable timer */
    ESP_ERROR_CHECK(gptimer_enable(gptimer_1ms_hd));
    /* Start timer, stop it at alarm event */
    gptimer_alarm_config_t alarm_config1 = {
        .reload_count = 0,
        .alarm_count = 1000, // period = 1ms
        .flags.auto_reload_on_alarm = true,
    };

    ESP_ERROR_CHECK(gptimer_set_alarm_action(gptimer_1ms_hd, &alarm_config1));
    ESP_ERROR_CHECK(gptimer_start(gptimer_1ms_hd));

    gptimer_config_t timer1_config = {
        .clk_src = GPTIMER_CLK_SRC_DEFAULT,
        .direction = GPTIMER_COUNT_UP,
        .resolution_hz = 1000000, // 1MHz, 1 tick=1us
    };
    ESP_ERROR_CHECK(gptimer_new_timer(&timer1_config, &gptimer_100ms_hd));

    gptimer_event_callbacks_t cbs1 = {
        .on_alarm = timer1_on_alarm_isr,
    };

    ESP_ERROR_CHECK(gptimer_register_event_callbacks(gptimer_100ms_hd, &cbs1, timer1_que));

    ESP_ERROR_CHECK(gptimer_enable(gptimer_100ms_hd));

    gptimer_alarm_config_t alarm_config2 = {
        .reload_count = 0,
        .alarm_count = 100000, // period = 100ms
        .flags.auto_reload_on_alarm = true,
    };

    ESP_ERROR_CHECK(gptimer_set_alarm_action(gptimer_100ms_hd, &alarm_config2));
    ESP_ERROR_CHECK(gptimer_start(gptimer_100ms_hd));
}

void GPTimer_Sleep_Init(void)
{

    // ESP_ERROR_CHECK(gptimer_stop(gptimer_1ms_hd));
    // ESP_ERROR_CHECK(gptimer_disable(gptimer_1ms_hd));
    // ESP_ERROR_CHECK(gptimer_del_timer(gptimer_1ms_hd));

    // ESP_ERROR_CHECK(gptimer_stop(gptimer_100ms_hd));
    // ESP_ERROR_CHECK(gptimer_disable(gptimer_100ms_hd));
    // ESP_ERROR_CHECK(gptimer_del_timer(gptimer_100ms_hd));

    ESP_ERROR_CHECK(gptimer_stop(gptimer_1ms_hd));
    ESP_ERROR_CHECK(gptimer_disable(gptimer_1ms_hd));
    ESP_ERROR_CHECK(gptimer_stop(gptimer_100ms_hd));
    ESP_ERROR_CHECK(gptimer_disable(gptimer_100ms_hd));
}

void GPTimer_WakeUp_Init(void)
{
    // my_Timer_Driver_Init();

    ESP_ERROR_CHECK(gptimer_enable(gptimer_1ms_hd));
    ESP_ERROR_CHECK(gptimer_enable(gptimer_100ms_hd));
    ESP_ERROR_CHECK(gptimer_start(gptimer_1ms_hd));
    ESP_ERROR_CHECK(gptimer_start(gptimer_100ms_hd));
}

uint32_t Get_Iphone_Timer(void)
{
    uint32_t Temp = IphoneTimer;

    if (Temp < 10)
    {
        return 0;
    }
    Temp = IphoneTimer / 10;

    return Temp;
}
