#include "eepromManage.h"
#include "eeManager_Interface.h"
#include <stdio.h>
#include "bsp_Gpio.h"
#include "driver/gpio.h"
//#include "bsp_port.h"
//#include "abstract.h"

/*-------------------------------------------------------------------------
* Function Name  : eeprom_StoreInfo_Init
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void eeprom_StoreInfo_Init(void)
{
    eeprom_SetParameter(AT24C16,distance_1m);
    EE_SCL_OutConfig();
    EE_SDA_OutConfig();
}

/*-------------------------------------------------------------------------
* Function Name  : eeprom_comm_DelayUs
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void eeprom_comm_DelayUs(ee_uint32_t time)
{
    ee_uint32_t i;
    ee_uint32_t dalayCnt = 0;
    dalayCnt = time;
    EE_FeedDog();
    for(i = 0;i < dalayCnt;i++)
    {
        EE_NOP();
    }
    EE_FeedDog();
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_InConfig
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_InConfig(void)
{
    gpio_set_direction(IIC_SDA, GPIO_MODE_INPUT);
}
/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_OutConfig
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_OutConfig(void)
{
    gpio_set_direction(IIC_SDA, GPIO_MODE_OUTPUT_OD);
}
/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_GetValue
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
ee_uint8_t EE_SDA_GetValue(void)
{
    return gpio_get_level(IIC_SDA);
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_OUT
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_OUT(ee_uint8_t data)
{
    gpio_set_direction(IIC_SDA, GPIO_MODE_OUTPUT_OD);
    gpio_set_level(IIC_SDA, data);
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_OutConfig
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SCL_OutConfig(void)
{
   gpio_set_direction(IIC_SCL, GPIO_MODE_OUTPUT_OD);
}
/*-------------------------------------------------------------------------
* Function Name  : EE_SCL_OUT
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SCL_OUT(ee_uint8_t data)
{
    gpio_set_direction(IIC_SCL, GPIO_MODE_OUTPUT_OD);
    gpio_set_level(IIC_SCL, data);
}

/*-------------------------------------------------------------------------
* Function Name  : EE_FeedDog
* Description    : ���� DOG
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_FeedDog(void)
{

    // bsp_HDOG_Feed();

}

/*-------------------------------------------------------------------------
* Function Name  : EE_NOP
* Description    : nop ָ��
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_NOP(void)
{

    // NOP();

}

