



#ifndef _S6J3360_EE_MANAGE_H_
    #define _S6J3360_EE_MANAGE_H_

#pragma pack(1)  /* 뱣 */

typedef unsigned char    ee_uint8_t;
typedef unsigned short   ee_uint16_t;
typedef unsigned int     ee_uint32_t;
    

#define    READ_FAIL                      0x0000
#define    READING                        0x0001
#define    READ_COMPLETE                  0x0002

#define    WRITE_FAIL                     0x0000
#define    WRITING                        0x0001 
#define    WRITE_COMPLETE                 0x0002



typedef enum
{
    distance_1m = 1,
    distance_10m = 10,
    distance_100m = 100,
    distance_1000m = 1000
}StorageDistance_t;


typedef enum
{
    AT24C04 = 4,
    AT24C16 = 16,
}DeviceNo_t;
      
typedef struct
{
    ee_uint32_t Odo;
    ee_uint32_t Trip;
    ee_uint8_t  IsTripClear;
}Mileage_t;

extern ee_uint16_t            OdoValidAddress;
/* ȡ汾 */
//extern        ee_uint8_t*       eeprom_getVersion(void);

/*-------------------------------------------------------------------------
* Function Name  : eeprom_1ms_timeCount
* Description    : же жʱ >= 1ms,ʱӰдٶ
* Input          : 
* Output         : 
* Return         :
* onther         :
--------------------------------------------------------------------------*/
extern        void                   eeprom_1ms_timeCount(void);  
    
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_SetParameter
* Description    :
* Input          : device_No:оƬͺ AT24C04 or AT24C16 
                   StorageDistance :δ洢ݼδ洢֮
                    distance_1m = 0,
                    distance_10m = 10,
                    distance_100m = 100,
                    distance_1000m = 1000
* Output         : 
* Return         :
* onther         :
--------------------------------------------------------------------------*/
extern        void                   eeprom_SetParameter(DeviceNo_t device_No,StorageDistance_t StorageDistance);
    
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_ClearOdoSection
* Description    : ODOɲ
* Input          : 
* Output         : 
* Return         :
* onther         :
--------------------------------------------------------------------------*/
extern        void                   eeprom_ClearOdoSection(void);
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_WriteRecord
* Description    :
* Input          : address ; 0~xxx
                   recordDatas:洢ָ
                   record_len : ¼
* Output         : 
* Return         :
                  #define    WRITE_FAIL                     0x0000
                  #define    WRITING                        0x0001 
                  #define    WRITE_COMPLETE                 0x0002
* onther         :
--------------------------------------------------------------------------*/
extern        ee_uint16_t        eeprom_WriteRecord(ee_uint16_t address,ee_uint8_t* recordDatas,ee_uint16_t record_len);
    
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_ReadRecord
* Description    :
* Input          : address ; 0~xxx
                   recordDatas:洢ָ
                   record_len : ¼
* Output         : 
* Return         :
                  #define    READ_FAIL                      0x0000
                  #define    READING                        0x0001
                  #define    READ_COMPLETE                  0x0002
* onther         :
--------------------------------------------------------------------------*/
extern        ee_uint16_t        eeprom_ReadRecord(ee_uint16_t address,ee_uint8_t* recordDatas,ee_uint16_t record_len);
    
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_WriteODO
* Description    :
* Input          : StorageDistance  eeprom_SetParameterõһ
                   u32_odo λ StorageDistance һ
                   ÿλѱִж eeprom_ReadODOΪЩϢ޷
* Output         : 
* Return         :
                  #define    WRITE_FAIL                     0x0000
                  #define    WRITING                        0x0001 
                  #define    WRITE_COMPLETE                 0x0002
* onther         :
--------------------------------------------------------------------------*/
extern        ee_uint16_t       eeprom_WriteODO(Mileage_t *MileageInfo,StorageDistance_t StorageDistance,ee_uint8_t ign); 
    
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_ReadODO
* Description    :
* Input          : 
* Output         : 
* Return         :
                  #define    READ_FAIL                      0x0000
                  #define    READING                        0x0001
                  #define    READ_COMPLETE                  0x0002
* onther         :
--------------------------------------------------------------------------*/
extern        ee_uint16_t       eeprom_ReadODO(Mileage_t *MileageInfo);


/*-------------------------------------------------------------------------
get state infomation
--------------------------------------------------------------------------*/
extern        ee_uint16_t         eeprom_getWriteState(void);
extern        ee_uint16_t         eeprom_getReadState(void);
extern        ee_uint16_t         eeprom_getOdoCurWriteAddress(void);
extern        ee_uint32_t         eeprom_getOdoLastWriteValue(void);


extern ee_uint16_t eeprom_getWriteDebugState(void);
extern ee_uint16_t eeprom_getReadDebugState(void);
extern char* eeprom_getVersion(void);

/***30ֻ洢һε**/
/*extern void SetEEWriteDressToLib(ee_uint16_t EEWriteDressDate);

extern ee_uint16_t GetEEWriteDressToRam(void);*/
    
#pragma pack () /* 뱣 */    
    
#endif /* _S6J3360_EE_MANAGE_H_ */

