#include "a2dp_sink_and_hfp.h"
#include "Gui_Display.h"
// #include "bsp_iic_aw8839.h"
#include <dirent.h>
#include <stdbool.h>
#include <stdint.h>

#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/semphr.h"
#include "esp_err.h"
#include "esp_log.h"
#include "bsp_Gpio.h"
#include "R485_User.h"
#include "bsp_Uart.h"
#include "bsp_Adc.h"
#include "bsp_R485.h"
#include "Protocol_User.h"
#include "Protocol_Lib.h"
#include "Services_Mileage_User.h"
#include "eepromManage.h"
#include "R485_User.h"
#include "gatts_table_creat_demo.h"
TaskHandle_t Sys_Run_hdl;
TaskHandle_t R485_RX_hdl;
TaskHandle_t adc_oneshot_read_hdl;
TaskHandle_t uart_event_hdl;
TaskHandle_t IIC_hdl;
TaskHandle_t BLE_hdl;
static uint32_t Sys_1ms_Cnt = 0;

static const char *TAGmain = "main";

#define SYS_RUN_TASK_1MS (1)
#define SYS_RU
void Sys_Run_Task(void *arg)
{

    while (1)
    {

        if (Sys_1ms_Cnt < 1000 * 10)
        {
            Sys_1ms_Cnt++;
        }
        else
        {
            Sys_1ms_Cnt = 0;
        }

        // static char buffer[128];
        // sprintf(buffer, "   Biggest /     Free /    Min/    Total\n"
        //                 "\t  SRAM : [%8d / %8d / %8d / %8d]",
        //         heap_caps_get_largest_free_block(MALLOC_CAP_INTERNAL),
        //         heap_caps_get_free_size(MALLOC_CAP_INTERNAL),
        //         heap_caps_get_minimum_free_size(MALLOC_CAP_INTERNAL),
        //         heap_caps_get_total_size(MALLOC_CAP_INTERNAL));

        // ESP_LOGI("MEM", "%s", buffer);

        // ESP_LOGI(TAGmain, "Sys_Run_Task");

        Power_Management_Service();
        if (SYS_RUN_TASK_1MS)
        {
            
        }

        if (SYS_RUN_TASK_2MS)
        {
            Sys_Status_Update_Service();
            Common_Input_Para();
        }

        if (SYS_RUN_TASK_10MS)
        {
            Protocol_Send_Service();
        }

        if (SYS_RUN_TASK_20MS)
        {
        }

        if (SYS_RUN_TASK_50MS)
        {
            Prot_Send_Msg_Process();
        }

        if (SYS_RUN_TASK_100MS)
        {
            
        }

        if (SYS_RUN_TASK_2S)
        {
            // task_list();
            // UART_TEST();
        }

        vTaskDelay(pdMS_TO_TICKS(1));
    }
}
static uint32_t IIC_1ms_Cnt = 0;
#define IIC_TASK_10MS ((IIC_1ms_Cnt + 2) % 10 == 0)
#define IIC_TASK_100MS ((IIC_1ms_Cnt + 5) % 100 == 0)
#define IIC_TASK_1S ((IIC_1ms_Cnt) % 1000 == 0)

uint8_t EETEST[8] = {0X11, 0X22, 0X33, 0X44, 0X55, 0X66, 0X77, 0X88};
uint8_t flag = 0;
uint8_t EEREADTEST[8] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

int EEIIC = 0;
int readiic = 0;
static void IIC_Service_task(void *arg)
{

    while (1)
    {

        if (IIC_1ms_Cnt < 10000)
        {
            IIC_1ms_Cnt++;
        }
        else
        {
            IIC_1ms_Cnt = 0;
        }



        if (IIC_TASK_10MS)
        {

        }

        if (IIC_TASK_100MS)
        {
        }

        if (IIC_TASK_1S)
        {

            // if (flag == 0)
            // {

            //     EEIIC = eeprom_WriteRecord(EEPROM_BLOCK_14, &EETEST[0], 8);
            //     printf("EEIIC %d \n",EEIIC);
            //     flag = 1;
            // }
            // else
            // {
            //    readiic =  eeprom_ReadRecord(EEPROM_BLOCK_14, &EEREADTEST[0], 8);
            //    printf("read %d \n",readiic);
            //     printf("EEREADTEST %d \n",EEREADTEST[0]);
            //     // esp_log_buffer_hex("EE READ ", EEREADTEST, 8);
            // }
        }

        vTaskDelay(pdMS_TO_TICKS(1));
    }
}

void APP_SYS_Init(void)
{
    APP_Sys_Startup_Init();
    Sys_KL30_Init();
    Protocol_KL30_Wakeup_Init();
    Protocol_User_Ctrl_Init();

}

void app_main(void)
{
    // ESP_LOGI("SYS", "Sys_On_Init");
    // // printf("free_heap_size = %d\n", esp_get_free_heap_size());
    int timeroffest = esp_log_timestamp();

    bsp_syson_gpio_init();

    adc_oneshot_read_init();

    Gui_Display_Init();
    // // // // vTaskDelay(pdMS_TO_TICKS(1000));
    BT_KL30_Wakeup_Init();
     BLE_Init();

    my_Timer_SysOn_Init();
    my_Timer_Driver_Init();


    // //     // esp_intr_dump(stdout);

    // //     //  vTaskDelay(pdMS_TO_TICKS(1000));
    Time_Display_Init(timeroffest * 1000);
    APP_SYS_Init();
    // // printf("free_heap_size = %d\n", esp_get_free_heap_size());

    xTaskCreatePinnedToCore(Sys_Run_Task, "Sys_Run_Task", 4096, NULL, 6, &Sys_Run_hdl, 1);
    xTaskCreate(adc_oneshot_read_task, "adc_oneshot_read_task", 4096, NULL, 5, &adc_oneshot_read_hdl);
    xTaskCreatePinnedToCore(R485_RX_task, "R485_RX_task", 1024 * 4, NULL, 6, &R485_RX_hdl, 1);
    xTaskCreatePinnedToCore(uart_event_task, "uart_event_task", 1024 * 4, NULL, 5, &uart_event_hdl, 1);
    xTaskCreatePinnedToCore(IIC_Service_task, "IIC_Task", 1024 * 4, NULL, 3, &IIC_hdl, 1);
    xTaskCreatePinnedToCore(ble_rx_analysis_tasks, "ble_rx_analysis_tasks", 1024 * 4, NULL, 1, &BLE_hdl, 1);
    // printf("free_heap_size = %d\n", esp_get_free_heap_size());
}
