#include "Common_Interface.h"
// #include "System_Monitor.h"


static uint32_t PowerIgnOnTimeLine;
static uint32_t PowerIgnOffTimeLine;

static uint32_t PowerSocTimeLine;

static COMMON_PowerStatus_t PowerSts;     /*1 ON ;  0 OFF*/
static uint16_t             Act_V_Speed;  /*实际值,十倍的*/
static uint16_t             Disp_V_Speed; /*显示值,十倍的*/
static DataValid_t          PowerSts_Valid;
static DataValid_t          Act_V_Speed_Valid;
static DataValid_t          Disp_V_Speed_Valid;


static uint16_t     u16SelfCheckTime;
/*每次唤醒调用*/
void Common_DataInit(void)
{
    PowerSts     = COMMON_POWER_UNKNOW;
    Act_V_Speed  = 0xffffu;
    Disp_V_Speed = 0xffffu;

    PowerSts_Valid      = COMMON_Valid_UNKNOW;
    Act_V_Speed_Valid   = COMMON_Valid_UNKNOW;
    Disp_V_Speed_Valid  = COMMON_Valid_UNKNOW;
    PowerIgnOnTimeLine  = 0x0ul;
    PowerIgnOffTimeLine = 0x0ul;
    PowerSocTimeLine = 0x0ul;
    // u16SelfCheckTime = DisplaySelfCheckTime;
}

/*以下由各个处理模块按需调用*/
/*使用数据之前,需要先判断数据是否有效,如果无效,则不可以使用*/

uint8_t Common_Get_IG_Sts(void)
{
    return 1;
}

uint16_t Common_Get_Act_V_Speed(void)
{
}
uint16_t Common_Get_Disp_V_Speed(void)
{
    return Disp_V_Speed;
}

uint16_t Common_Get_TireSize(void)
{
    return 1u;
}

void Common_Set_IG_Sts(COMMON_PowerStatus_t Val)
{
    PowerSts = Val;
}
void Common_Set_Act_V_Speed(uint16_t Val)
{
    Act_V_Speed = Val;
}
void Common_Set_Disp_V_Speed(uint16_t Val)
{
    Disp_V_Speed = Val;
}

void Common_Set_V_Speed_Valid(DataValid_t Valid)
{
    Act_V_Speed_Valid = Valid;
}


DataValid_t Common_Get_IG_Sts_Valid(void)
{
    return PowerSts_Valid;
}
DataValid_t Common_Get_Act_V_Speed_Valid(void)
{
    return 1;
}
DataValid_t Common_Get_Disp_V_Speed_Valid(void)
{
    return Disp_V_Speed_Valid;
}

void Common_Set_IG_Sts_Valid(DataValid_t Val)
{
    PowerSts_Valid = Val;
}
void Common_Set_Act_V_Speed_Valid(DataValid_t Val)
{
    Act_V_Speed_Valid = Val;
}
void Common_Set_Disp_V_Speed_Valid(DataValid_t Val)
{
    Disp_V_Speed_Valid = Val;
}

uint16_t Common_Get_DispSpeed(void)
{
    uint16_t m_Res;
    return m_Res;
}

void Common_Input_Para(void)
{
    if ( 1 )
    {
        Common_Set_IG_Sts(COMMON_POWER_ON);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        // // Common_Set_Act_V_Speed(Get_Act_Vspeed( ));
        // // Common_Set_Disp_V_Speed(Get_Dis_Vspeed( ));
        // if ( Get_Vspeed_Valid( ) == COMMON_Valid )
        // {
        //    Common_Set_Act_V_Speed_Valid(COMMON_Valid);
        //    Common_Set_Disp_V_Speed_Valid(COMMON_Valid);
        // }
        // else
        // {
        //    Common_Set_Act_V_Speed_Valid(COMMON_InValid);
        //    Common_Set_Disp_V_Speed_Valid(COMMON_InValid);
        // }

        PowerIgnOffTimeLine = 0ul;

        if ( PowerIgnOnTimeLine < 0x7ffffffful )
        {
            PowerIgnOnTimeLine += 2u;
        }
        if ( PowerSocTimeLine < 0x7ffffffful )
        {
            PowerSocTimeLine += 2u;
        }
    }
    else
    {
        PowerIgnOnTimeLine = 0ul;
        PowerSocTimeLine = 0ul;
        if ( PowerIgnOffTimeLine < 0x7ffffffful )
        {
            PowerIgnOffTimeLine += 2u;
        }
    //     Common_Set_IG_Sts(COMMON_POWER_OFF);
    //     Common_Set_IG_Sts_Valid(COMMON_Valid);

    //     /*车转真实值OFF为0*/
    // //    Common_Set_Act_V_Speed(0u);
    // //    Common_Set_Disp_V_Speed(0u);
    //    Common_Set_V_Speed_Valid(COMMON_InValid);
    }
}

void Common_SelfCheckTime(void)
{
    if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {

    }
    else
    {
        u16SelfCheckTime = 0;
    }
}

uint32_t Get_HMI_SelfCheck_Timer(void)
{
    uint32_t SelfCheckTimer = 0;
    SelfCheckTimer          = u16SelfCheckTime * 10;
    return SelfCheckTimer;
}

uint32_t Common_GetIgnOnTime(void)
{
    return PowerIgnOnTimeLine;
}

uint32_t Common_GetIgnOffTime(void)
{
    return PowerIgnOffTimeLine;
}

uint32_t Common_GetSocTime(void)
{
    return PowerSocTimeLine;
}

void Common_GetSocTime_Clear(void)
{
     PowerSocTimeLine = 0;
}


void U16_Data_Gradient(uint16_t *cur, uint16_t dest, uint16_t step, uint16_t *timer, const uint16_t timedelay)
{
    if(*cur > dest)
    {
        if((*cur - dest) > step)
        {
            if(*timer >= timedelay)
            {
                (*cur) -= step;
                (*timer) = 0;
            }
            else
            {
                (*timer)++;
            }
        }
        else
        {
            *cur = dest;
            *timer = 0;
        }
    }
    else
    {
        if((dest - *cur) > step)
        {
            if(*timer >= timedelay)
            {
                (*cur) += step;
                (*timer) = 0;
            }
            else
            {
                (*timer)++;
            }
        }
        else
        {
            *cur = dest;
            *timer = 0;
        }
    }
}

void App_SwapWord_u16(uint16_t *pData1,uint16_t *pData2)
{
    uint16_t psw;
    if((*pData1) > (*pData2))
    {
        psw = (*pData2);
        (*pData2) = (*pData1);
        (*pData1) = psw;
    }
}

void App_SortNWord_u16(uint16_t *SortData,uint8_t len)
{
    uint8_t n=0,m;
    for(;n < len-1;n++)
    {
        for(m = n+1;m < len;m++)
        {
            App_SwapWord_u16((SortData + n),(SortData + m));
        }
    }
}

uint16_t App_Average_u16(uint16_t *SortData,uint8_t len)
{
    uint8_t n=0;
    uint64_t ret = 0;
    for(; n < len; n++)
    {
        ret += SortData[n];
    }

    ret /= len;
    return (uint16_t)ret;
}









uint16_t Comm_Make_Word(uint8_t low, uint8_t high)
{
    uint16_t retValue;

    retValue = low | (high << 8);

    return retValue;
}

uint32_t Comm_Make_Long(uint8_t low, uint8_t mid, uint8_t high)
{
    uint32_t retValue;

    retValue = low | (mid << 8) | (high << 16);

    return retValue;
}

uint32_t Comm_Make_LongLong(uint8_t low, uint8_t ml, uint8_t mh, uint8_t hi)
{
    uint32_t retValue;

    retValue = low | (ml << 8) | (mh << 16) | (hi << 24);

    return retValue;
}
