#include "a2dp_sink_and_hfp.h"
// #include "bsp_iic_aw8839.h"
#include <dirent.h>
#include <stdbool.h>
#include <stdint.h>
#include "bsp_Uart.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/semphr.h"
#include "esp_err.h"
#include "esp_log.h"
#include "bsp_Gpio.h"
#include "bsp_Uart.h"
// #include "bsp_Adc.h"
#include "Protocol_User.h"
#include "Protocol_Lib.h"
#include "gatts_table_creat_demo.h"
TaskHandle_t Sys_Run_hdl;
TaskHandle_t R485_RX_hdl;
TaskHandle_t adc_oneshot_read_hdl;
TaskHandle_t uart_event_hdl;
TaskHandle_t IIC_hdl;
TaskHandle_t BLE_hdl;
static uint32_t Sys_1ms_Cnt = 0;

static const char *TAGmain = "main";

#define SYS_RUN_TASK_1MS (1)
#define SYS_RUN_TASK_2MS ((Sys_1ms_Cnt + 1) % 2 == 0)
#define SYS_RUN_TASK_10MS ((Sys_1ms_Cnt + 2) % 10 == 0)
#define SYS_RUN_TASK_20MS ((Sys_1ms_Cnt + 3) % 20 == 0)
#define SYS_RUN_TASK_50MS ((Sys_1ms_Cnt + 4) % 50 == 0)
#define SYS_RUN_TASK_100MS ((Sys_1ms_Cnt + 5) % 100 == 0)
#define SYS_RUN_TASK_2S ((Sys_1ms_Cnt + 6) % (2 * 1000) == 0)
void Sys_Run_Task(void *arg)
{

    while (1)
    {

        if (Sys_1ms_Cnt < 1000 * 10)
        {
            Sys_1ms_Cnt++;
        }
        else
        {
            Sys_1ms_Cnt = 0;
        }

        if (SYS_RUN_TASK_1MS)
        {

        }

        if (SYS_RUN_TASK_2MS)
        {
            Common_Input_Para();
        }

        if (SYS_RUN_TASK_10MS)
        {
            Protocol_Send_Service();
        }

        if (SYS_RUN_TASK_20MS)
        {
        }

        if (SYS_RUN_TASK_50MS)
        {
            // Core_ID04_Service();
            // Prot_Send_Msg_Process();
        }

        if (SYS_RUN_TASK_100MS)
        {
            Core_ID12_Service();
            // Core_ID02_Service();

        }

        if (SYS_RUN_TASK_2S)
        {
            // task_list();
            // UART_TEST();
        }

        vTaskDelay(pdMS_TO_TICKS(1));
    }
}


void APP_SYS_Init(void)
{

    Protocol_KL30_Wakeup_Init();
    Protocol_User_Ctrl_Init();

}

void app_main(void)
{


    bsp_syson_gpio_init();


    BT_KL30_Wakeup_Init();
    BLE_Init();
    APP_SYS_Init();

    xTaskCreatePinnedToCore(Sys_Run_Task, "Sys_Run_Task", 4096, NULL, 6, &Sys_Run_hdl, 1);

    xTaskCreatePinnedToCore(uart_event_task, "uart_event_task", 1024 * 4, NULL, 5, &uart_event_hdl, 1);
}

