#ifndef _Data_Espeed_H_
#define _Data_Espeed_H_

#include "common.h"

/******************************************************************************
发动机转速
******************************************************************************/

/*** 参数设置 ***/
#define   DATA_ENGINE_RUNNING_THRESHOLD     400  //发动机运转阈值    
#define   DATA_ENGINE_STOP_THRESHOLD        300  //发动机停止阈值

#define   DATA_ESPEED_DAMPING_FACTOR        4    //阻尼系数
#define   DATA_ESPEED_INC_STEP              10   //速度增加时慢加速速度变化步长
#define   DATA_ESPEED_DEC_STEP              20   //方向改变时急减速速度变化步长
#define   DATA_ESPEED_APPR_SPEED_MIN        10   //最小逼近速度
#define   DATA_ESPEED_HYSTERESIS            80   //回差    

/*** 控制结构 ***/
typedef struct __attribute__((aligned(4)))
{
    uint16_t  Buffer[5];
    uint8_t   Cnt;
} DataESpeedSamplerStruct;            //转速采样结构

typedef struct __attribute__((aligned(4)))
{
    uint16_t  Speed;
    uint16_t  Delta;
    uint8_t   Dir;
} DataESPeedDampingStruct;            //转速阻尼结构

typedef struct __attribute__((aligned(4)))
{
    uint16_t  ESpeedBackup;
    uint16_t  Timer;
    uint8_t   Mode;
} DataESpeedIdleStruct;               //怠速处理结构

/******************************************************************************
函数名：Data_Engine_Speed_KL30_Wakeup_Init
功  能：发动机转速初始化函数
参  数：无
返回值：无
******************************************************************************
注  意：该函数KL30初始化/Wakeup初始化被调用一次
******************************************************************************/
void Data_Engine_Speed_KL30_Wakeup_Init (void);

/******************************************************************************
函数名：Data_Engine_Speed_Processing_Service
功  能：发动机转速数据处理函数
参  数：无
返回值：无
******************************************************************************
注  意：该函数必须每10ms被调用一次
******************************************************************************/
void Data_Engine_Speed_Processing_Service ( void );

uint8_t Get_EngineValid(void);

uint16_t Get_ActualEngineSpeed(void);

uint16_t Get_DispEngineSpeed(void);

#endif
