#include "GUI_Display\GUI_Display.h"
#include "SEG_DISPLAY\SEG_DISPLAY.h" 
#include "Application.h"

void Gauge_Clock_Display(void)
{
    uint8_t PageType_DIS = 0;
    if (Common_Get_IG_Sts( ) == COMMON_POWER_ON)
    {
        PageType_DIS = Get_Current_PageType();

        LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Screen_Time, LED_ON);
        
        if ( PageType_DIS == 1 )
        {
            if(FLASH_SYNC_1Hz)
            {
                SEG_SET_Clock(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), 1, 1, 1);
            }
            else
            {
                SEG_SET_Clock(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), 1, 0, 1);
            }
            
        }
        else if ( PageType_DIS == 2 )
        {
            if(FLASH_SYNC_1Hz)
            {
                SEG_SET_Clock(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), 1, 1, 1);
            }
            else
            {
                SEG_SET_Clock(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), 1, 1, 0);
            }
        }
        else 
        {
            SEG_SET_Clock(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), FLASH_SYNC_1Hz, 1, 1);
        }
    }
    else
    {
        SEG_SET_Clock(0, 0, 0, 0, 0);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Screen_Time, LED_OFF);
    }
}







void Clear_Bu98(void)
{
    uint8_t i = 0;
    for(i = 0; i < BU98R10_DDRAM_SIZE; i ++)
    {
        BU98R10Chip0DDRAM.Byte[i] = 0;
        BU98R10Chip1DDRAM.Byte[i] = 0;
    }
}


void Gauge_Service(void)
{
    static uint16_t VSpeed_Count = 0u;    
    uint8_t k = 0;
    if (ClearODO_Flag == 1)
    {
        if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
        {
            Check_SEG_Display();    
            for(k = 0; k < LampCh0_MAX; k ++)     
            {
                if (k == 24)
                {
                    k ++;
                }
                else
                {
                    LED_Driver_Channel_Set(LampChannel_0, k, LED_ON); 
                }
                
            }
            
        }
        else
        {
            Clear_Bu98();  
            for(k = 0; k < LampCh0_MAX; k ++)     
            {
                LED_Driver_Channel_Set(LampChannel_0, k, LED_OFF); 
            }
            //LED_Driver_Channel_Set(LampChannel_0, LampCh0_35_ODO, LED_OFF);
            //LED_Driver_Channel_Set(LampChannel_0, LampCh0_34_TRIP, LED_OFF);
            //LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Screen_Time, LED_OFF);
            //LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_KMH, LED_OFF);
            //LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_MPH, LED_OFF);         
        }
    }
    else
    {
        if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
        {
            if (Common_GetIgnOnTime() >= 3000)
            {
                //for(i = 0; i < BU98R10_DDRAM_SIZE; i ++)
                //{
                //    BU98R10Chip0DDRAM.Byte[i] = 0x77;
                //    BU98R10Chip1DDRAM.Byte[i] = 0x77;
                //}
                
                
                SEG_SET_VSpeed_NUM(1u, Get_DispVechileSpeed( ) / 10u,Get_Dis_KM_Unit());

                SEG_SET_ODO_TRIP_FAULTCODE_TCS_DIS(Get_Dis_KM_Unit(), Get_ODO_Value() / 10u, Get_Trip_Value());
                Gauge_Clock_Display();                
                SEG_SET_FuelDial(1, Get_CurFuelSetp());
                SEG_SET_EspeedDial(1,  Get_DispEngineSpeed()/500);
                SEG_SET_CoolantDial(1, GET_DataCoolantTempSegDisp(), GET_DataCoolantTempValueDisp(), GET_DataCollantTempSegValid());
                SEG_SET_Voltage_NUM(1, Get_Battery_Voltage());
            #if(IC_Current == TY200_080000b_ty) 
                SEG_SET_TPMS_DISPLAY(1, Get_Front_TPMS_Sig_Value(), Get_Rear_TPMS_Sig_Value(), 0 ,Get_Front_TPMS_Sig_Vaild(), Get_Rear_TPMS_Sig_Vaild());       
            #endif    
                SEG_SET_Navigation_STS(Get_Navigation_St_Dis(),Get_Navigation_Code_Dis(),Get_Navigation_Mileage_Dis());
          
            }
            else
            {            
                Checkself_SEG_Display();                
            }
        }
        else
        {
            Clear_Bu98();
           
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_35_ODO, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_34_TRIP, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Screen_Time, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_KMH, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_MPH, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_10_Navigator1, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_19_Navigator2, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_17_Length2, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_18_Length1, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_14_ARRIVED_SERVICE_AREA, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_15_ARRIVED_TOLLGATE, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_16_ARRIVED_TUNNEL, LED_OFF);
        }
    }    
        
}

