#ifndef PROTOCOL_LIB_H
#define PROTOCOL_LIB_H

/*
Platform_32Bit
Platform_16Bit
*/
#ifdef Platform_16Bit
    #define Protocol_uint8_t  unsigned char
    #define Protocol_uint16_t unsigned int
    #define Protocol_uint32_t unsigned long
#else
    #define Protocol_uint8_t  unsigned char
    #define Protocol_uint16_t unsigned short
    #define Protocol_uint32_t unsigned int
    #define Protocol_uint64_t unsigned long long
#endif

#ifndef Protocol_NULL
    #define Protocol_NULL ( void * )0u
#endif /* NULL */

/**<0xEB 0x90 长度 帧序号 命令字 DATA0-DATAN CRC16_1 CRC16_2*/
#define DATA_PACKAGE_MIN_LEN   7 /**< 0xEB 0x90 + 长度 + 数据包序号 + CMDID + CRC16_1 + CRC16_2 */
#define DATA_PACKAGE_FIXED_LEN 3 /**< 未计算在长度内的数据  0xEB 0x90 + 长度位 */

#define CMD_HEAD1 0xEB
#define CMD_HEAD2 0x90

/**@struct   Protocol_Data_t
 * @brief    解析后的协议数据
 */
typedef struct __attribute__((aligned(4)))
{
    Protocol_uint8_t FrameNo;      /**< 帧序号 */
    Protocol_uint8_t PowerSts;     /**< 电源状态 */
    Protocol_uint8_t CmdID;        /**< 命令字 */
    Protocol_uint8_t DataLen;      /**< 有效数据长度 DATA0-DATAN*/
    Protocol_uint8_t Data [ 256 ]; /**< 有效数据内容 DATA0-DATAN*/
} Protocol_Data_t;

typedef Protocol_uint8_t (*UARTOpen)(void);
typedef Protocol_uint32_t (*UARTSend)(const Protocol_uint8_t *pData, Protocol_uint32_t u32Len);
typedef Protocol_uint32_t (*UARTRead)(Protocol_uint8_t *pData, Protocol_uint32_t u32Len);
typedef void (*ProtocolSetData)(const Protocol_Data_t *pData);
typedef void (*ProcParse)(const Protocol_uint8_t *pData, Protocol_uint32_t u32Len);
typedef void (*UARTClose)(void);

/**@struct   Protocol_Func_t
 * @brief    协议解析回调函数
 */
typedef struct __attribute__((aligned(4)))
{
    UARTOpen        UARTOpen_Cbk;        /**< 串口打开回调 */
    UARTSend        UARTSend_Cbk;        /**< 串口发送回调 */
    UARTRead        UARTRead_Cbk;        /**< 串口读取回调 */
    UARTClose       UARTClose_Cbk;       /**< 串口关闭回调 */
    ProcParse       ProcParseCbk;        /**< 解析后的数据, 处理了数据包序号，命令字和电源状态，和ProcParse二选一 */
    ProtocolSetData ProtocolSetData_Cbk; /**< 不包含 0xEB 0x90 + 长度 + CRC16_1 + CRC16_2，和ProtocolSetData二选一 */
} Protocol_Func_t;

void              Protocol_Init(Protocol_uint8_t *pMemSpace, Protocol_uint32_t MemLen, Protocol_Func_t *pFunc);
void              Protocol_Service(void);
Protocol_uint32_t Protocol_Parse(const Protocol_uint8_t *pData, Protocol_uint32_t len);
Protocol_uint32_t Protocol_Send(const Protocol_uint16_t cmdID, const Protocol_uint8_t *pData, Protocol_uint8_t len);

#endif
