#ifndef SERVICE_INTERVAL_H
#define SERVICE_INTERVAL_H



/*
Platform_32Bit
Platform_16Bit
*/

#ifdef Platform_16Bit
    #define Intlib_uint8_t  unsigned char
    #define Intlib_uint16_t unsigned int
    #define Intlib_uint32_t unsigned long

#else
    #define Intlib_uint8_t  unsigned char
    #define Intlib_uint16_t unsigned short
    #define Intlib_uint32_t unsigned int
    #define Intlib_uint64_t unsigned long long
#endif

#ifndef Intlib_NULL
    #define Intlib_NULL ( void * )0u
#endif /* NULL */

#define Int_PowerON  1u /**< 电源状态  KL15 ON */
#define Int_PowerOFF 0u /**< 电源状态  KL15 ON */

typedef Intlib_uint8_t (*Int_PowerSts)(void);
typedef Intlib_uint32_t (*Int_ReadODO)(void);
typedef void (*Int_EEPromWrite)(Intlib_uint32_t u32Data [], Intlib_uint16_t u16Len);
typedef void (*Int_EEPromRead)(Intlib_uint32_t u32Data [], Intlib_uint16_t u16Len);

typedef struct __attribute__((aligned(4)))
{
    Int_PowerSts    PowerSts_Cbk;    /**< 获取系统电源状态回调 */
    Int_ReadODO     ReadODO_Cbk;     /**< 获取当前总计里程回调 */
    Int_EEPromWrite EEPromWrite_Cbk; /**< 写EEPROM回调函数 */
    Int_EEPromRead  EEPromRead_Cbk;  /**< 从EEPROM读取保养相关数据回调 */
} Maintain_Func_t;

typedef struct __attribute__((aligned(4)))
{
    Intlib_uint32_t IntervalDayEnable; /**< 保养天数功能使能，0:无此功能 1:使能 */
    Intlib_uint32_t IntervalKm;        /**< 系统设定的保养里程间隔，单位km，这里特指首次保养的里程间隔，如不区分首次，则为默认值 */
    Intlib_uint32_t IntervalDay;       /**< 系统设定的保养天数间隔，单位天，这里特指首次保养的天数间隔，如不区分首次，则为默认值 */
} Maintain_Init_t;

#define Data_MEM_Block_Maintain (( Intlib_uint8_t )32u) /**< 此功能库，需要的内存空间大小，此为最小值 */

void            Service_Interval_KL30_Init(Intlib_uint8_t *pMemSpace, Maintain_Init_t *pInitData, Maintain_Func_t *pFunc);
void            Service_Interval_Wakeup_Init(Intlib_uint8_t *pMemSpace, Maintain_Func_t *pFunc);
void            Service_Interval_Processing(void);
void            Service_Interval_TimerISR(void);
void            Service_Interval_TimerSleepFix(Intlib_uint32_t FixTimer);
void            Service_Interval_SetKm(Intlib_uint32_t IntervalKm);
void            Service_Interval_SetDay(Intlib_uint32_t IntervalDay);
Intlib_uint32_t Service_Interval_GetMil100m(void);
Intlib_uint32_t Service_Interval_GetDay(void);
Intlib_uint32_t Get_Interval_SetKm(void);

#endif
