#include "Can_App.h"
#include "Components.h"
#include "Application.h"


void Can_Set_Buff_220(canlib_uint8_t CopyData[])
{
    CANMsg220Union *p220;
    uint8_t i = 0;

    p220 = (CANMsg220Union *)CopyData;
    if ( p220 != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            p220->Msg [ i ] = 0xFFu;
        }
    }
    p220 -> Sig.TCS_TX = Get_Dis_Tcs_Val();
}
void Can_Set_Buff_6EE(canlib_uint8_t CopyData[])
{
    CANMsg6EEUnion *p6EE;
    uint8_t i = 0;
    uint16_t Vspeed_tx = 0;
    uint32_t ODO_tx = Data_ODO_Read() / 10;    
    Vspeed_tx = Get_DispVechileSpeed_TX()/10;
    p6EE = (CANMsg6EEUnion *)CopyData;
    
    if ( p6EE != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            p6EE->Msg [ i ] = 0xFFu;
        }
    } 
    p6EE -> Sig.Vsppe_H3_TX     = (Vspeed_tx >> 8) & 0x7u ;
    p6EE -> Sig.Vsppe_L8_TX     = Vspeed_tx & 0xFF ;
    p6EE -> Sig.ODO_TX_H        = (ODO_tx >> 16) & 0xFF ;
    p6EE -> Sig.ODO_TX_M        = (ODO_tx >> 8) & 0xFF ;
    p6EE -> Sig.ODO_TX_L        = ODO_tx & 0xFF ;
    p6EE -> Sig.Uint_TX         = Get_Dis_KM_Unit() ;
    p6EE -> Sig.Coolant_Seg_TX  = GET_DataCoolantTempSegDisp() ;
    if (GET_DataCollantTempWarnflg() == 2)
    {
        p6EE -> Sig.Coolant_Warn_TX = 1;
    }
    else
    {
        p6EE -> Sig.Coolant_Warn_TX = 0;
    }
    p6EE -> Sig.Fuel_Seg_TX  = Get_CurFuelSetp() ;
    if(Get_Fuel_RES() > 255)
    {
        p6EE -> Sig.Fuel_Res_TX  = 0xFF ; 
    }
    else
    {
        p6EE -> Sig.Fuel_Res_TX  = Get_Fuel_RES() ; 
    }
       
    
}
void Can_Set_Buff_6EF(canlib_uint8_t CopyData[])
{
    CANMsg6EFUnion *p6EF;
    uint8_t i = 0;
    uint16_t Espeed_tx = 0;
    uint16_t TripA_tx = 0;
    Espeed_tx = Get_DispEngineSpeed()/100;
    TripA_tx  = Data_Read_Trip(EM_TRIP_A);
    p6EF = (CANMsg6EFUnion *)CopyData;
    if ( p6EF != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            p6EF->Msg [ i ] = 0xFFu;
        }
    }
    p6EF -> Sig.Espeed_TX  = Espeed_tx;
    p6EF -> Sig.TripA_H    = (TripA_tx >> 8) & 0xFF;
    p6EF -> Sig.TripA_L    = TripA_tx  & 0xFF;
    p6EF -> Sig.Coolant_TX = GET_DataCoolantTempValueDisp() + 40;
}
void Can_Set_Buff_450(canlib_uint8_t CopyData[])
{
    CANMsg450Union *p450;
    uint8_t i = 0;

    p450 = (CANMsg450Union *)CopyData;
    if ( p450 != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            p450->Msg [ i ] = 0xFFu;
        }
    }
    p450 -> Sig.Front_Pressure_TX  = Get_Front_TPMS_TX();
    p450 -> Sig.Rear_Pressure_TX   = Get_Rear_TPMS_TX();
}

