
#include "Key\Key_user.h"
#include "Application.h"
#include "Components.h"
__align(4)

#define BACK_MENU_TIME		1000
_Menu_Infor MenuInfor;
_Menu_Data MenuData;
uint8_t PageType;
uint8_t Key_Right_Long_Press_Flag;
uint8_t Key_Left_Long_Press_Flag;

RTC_TimeTypeDef RTC_TimeStruct;
RTC_DateTypeDef RTC_DateStruct;
RTC_CounterTypeDef counter_val;

void Key_Operation_Left(Key_Event_en_t enKeyEvent)//Mode
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:
		Key_Left_Short_Press();
		break;
	case KEY_EVENT_SHORT_PRESS_2:	
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2
		Key_Left_Long_Press();
		Key_Left_Long_Press_Flag = 1;
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3
		break;
	case KEY_EVENT_LONG_PRESS_3:	//5s
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
	    KEY_LEFT_EVENT_NONE_Service();
		Key_Left_Long_Press_Flag = 0;
		break;
	default:
		break;
	}
}
void Key_Operation_Right(Key_Event_en_t enKeyEvent)//Set
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:	
		Key_Right_Short_Press();
		break;
	case KEY_EVENT_SHORT_PRESS_2:		
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2s
		Key_Right_Long_Press();
		Key_Right_Long_Press_Flag = 1;
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3s
		break;
	case KEY_EVENT_LONG_PRESS_3:	//5s
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		TYW_RESET_ODO();
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
		KEY_RIGHT_EVENT_NONE_Service();
		Key_Right_Long_Press_Flag = 0;
		break;
	default:		
		break;
	}
}


/*---------------------------------------------------------------------------------------*/
Key_Status_en_t Key_Status_Read_Left(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	if (SYS_OPR_STAT_IGN_ON)
	{
		//if (RTE_GPIO_Get_Level(MODE_P_IN))
		//{
		//	enKeyReal = KEY_REALTIME_LOOSEN;
		//}
		//else
		//{
		//	enKeyReal = KEY_REALTIME_PRESS;
		//}
	}
	return enKeyReal;
}
Key_Status_en_t Key_Status_Read_Right(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	if (SYS_OPR_STAT_IGN_ON)
	{
		//if (RTE_GPIO_Get_Level(SET_P_IN))
		//{
		//	enKeyReal = KEY_REALTIME_LOOSEN;
		//}
		//else
		//{
		//	enKeyReal = KEY_REALTIME_PRESS;
		//}
	}
	return enKeyReal;
}


/*---------------------------------------------------------------------------------------*/
const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX] =
{
	{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Left, Key_Operation_Left},
	{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Right, Key_Operation_Right},
	//{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_FLIP, Key_Operation_FLIP},
	//{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_ADJUST, Key_Operation_ADJUST},
};

/*---------------------------------------------------------------------------------------*/

Key_uint8_t u8KeyRamData[KEY_RAM_DATA_LEN];
void Key_KL30_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;
	Key_uint16_t i;
	for (i = 0; i < KEY_RAM_DATA_LEN; i++)
	{
		u8KeyRamData[i] = 0;
	}

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF;
	Key_KL30_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_1_Time(50U,1000U);
	Key_Parameter_Set_Short_Press_2_Time(1500U,2000U);

	Key_Parameter_Set_Long_Press_1_Time(2000U);
	Key_Parameter_Set_Long_Press_2_Time(3000U);
	Key_Parameter_Set_Long_Press_3_Time(5000U);
	Key_Parameter_Set_Long_Press_4_Time(10000U);	
}
void Key_Wakeup_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF; 
	Key_Wakeup_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_1_Time(50U,1000U);
	Key_Parameter_Set_Short_Press_2_Time(1500U,2000U);

	Key_Parameter_Set_Long_Press_1_Time(2000U);
	Key_Parameter_Set_Long_Press_2_Time(3000U);
	Key_Parameter_Set_Long_Press_3_Time(5000U);
	Key_Parameter_Set_Long_Press_4_Time(10000U);	
}


void KEY_LEFT_EVENT_NONE_Service(void)	
{
	MenuInfor.Back_Time_Left++;
	if(MenuInfor.Back_Time_Left > BACK_MENU_TIME)
	{
		MenuInfor.Back_Time_Left = BACK_MENU_TIME;
		MenuInfor.Back_Time_Left_Flag = 1;
	}
}

void KEY_RIGHT_EVENT_NONE_Service(void)	
{
	MenuInfor.Back_Time_Right++;
	if(MenuInfor.Back_Time_Right > BACK_MENU_TIME)
	{
		MenuInfor.Back_Time_Right = BACK_MENU_TIME;
		MenuInfor.Back_Time_Right_Flag = 1;
	}
}

void Key_Clear_Time(void)
{
	if(Key_Status_Read_Left() == KEY_REALTIME_PRESS)
	{
		MenuInfor.Back_Time_Left = 0;
		MenuInfor.Back_Time_Left_Flag = 0;
		MenuInfor.Back_Time_Right_Flag = 0;
	}
	if(Key_Status_Read_Right() == KEY_REALTIME_PRESS)
	{
		MenuInfor.Back_Time_Right = 0;
		MenuInfor.Back_Time_Left_Flag = 0;
		MenuInfor.Back_Time_Right_Flag = 0;
	}
}

void Key_Check_Service(void)
{
	if((Key_Right_Long_Press_Flag == 1)&&(Key_Left_Long_Press_Flag == 1)&&(PageType == Page_Time))
	{
		PageType = Page_Time_Set_Hour;
	}
}

void Key_Left_Short_Press(void)
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 0u;
	uint8_t datmin = 0u;

	if(PageType == Page_Time_Set_Hour)
	{
		updataDir = 1;
		datmax = 23u;
    	datmin = 0u; 
		Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(counter_val.time.RTC_Hours));
	}
	else if(PageType == Page_Time_Set_Minute)
	{
		updataDir = 1;
		datmax = 59u;
    	datmin = 0u; 
		Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(counter_val.time.RTC_Minutes));
	}
	else
	{
		if((PageType == Page_Time)&&(Key_Status_Read_Right() == KEY_REALTIME_LOOSEN)&&(Common_Get_IG_Sts( ) == COMMON_POWER_ON))
		{
			if(Get_Dis_Unit() == 0)
			{
				MenuData.Unit = 1;//mile
			}
			else
			{
				MenuData.Unit = 0;//km
			}
		}

		Unit_Convert_Service();
	}
}

void Key_Auto_Save(void)
{
	if((MenuInfor.Back_Time_Left_Flag == 1)&&(MenuInfor.Back_Time_Right_Flag == 1))
	{
		if(PageType == Page_Time_Set_Hour)
		{
			RTC_SetTime(&counter_val.time);
		}

		if(PageType == Page_Time_Set_Minute)
		{
			RTC_SetTime(&counter_val.time);
		}
		PageType = Page_Time;
	}
}

void Key_Right_Short_Press(void)
{
	if(PageType == Page_Time_Set_Hour)
	{
		PageType = Page_Time_Set_Minute;
	}
	else if(PageType == Page_Time_Set_Minute)
	{
		PageType = Page_Time_Set_Hour;
	}
	else
	{
		;
	}
}

void Key_Left_Long_Press(void)
{
	if((PageType == Page_Time)&&(Key_Status_Read_Right() == KEY_REALTIME_LOOSEN))
	{
		//Telltales_Auto_Start_Stop_Setting();
	}
}

void Key_Right_Long_Press(void)
{
	if(PageType == Page_Time)
	{
		if(Key_Status_Read_Left() == KEY_REALTIME_LOOSEN)
		{
			Data_Clear_Trip_All();
		}
	}
	else if(PageType == Page_Time_Set_Hour)
	{
	    RTC_SetTime(&counter_val.time);
		PageType = Page_Time;
	}
	else if(PageType == Page_Time_Set_Minute)
	{
	    RTC_SetTime(&counter_val.time);
		PageType = Page_Time;
	}
	else
	{
		;
	}
}

void Menu_u8Data_Updata_Process(uint8_t updateDir , uint8_t datMax, uint8_t datMin, uint8_t datStep, uint8_t *dat)
{
	uint8_t temp = *dat;
    if(datMax > datMin)
    {
        if(updateDir == 1u)
        {
            if(temp < datMax)
            {
                if((temp) <= (255u-datStep))
                {
                    temp += datStep;
                }
            } 
            else
            {
                temp = datMin;
            }        
        }
        else if(updateDir == 2u)
        {
            if(temp > datMin)
            {
                if(temp >= datStep)
                {
                    temp -= datStep;
                }
            } 
            else
            {
                temp = datMax;
            }
        }
        else
        {
        }
    }
    else
    {
    }

	*dat = temp;
}

void MenuData_Unit_Init(void)
{
	MenuData.Unit = 0;
}

uint8_t ClearODO_Flag = 0;
void TYW_RESET_ODO(void)
{
	if(SYS_OPR_STAT_IGN_ON)
    {
        if(ClearODO_Flag < 1)
        {
            if((Get_DispVechileSpeed() >= 1200)&&(Get_DispEngineSpeed() >= 11000))
            {
                ClearODO_Flag = 1;
                Data_Mileage_Clear();
            }
        }
    }
    else
    {
        ClearODO_Flag = 0;
    }
}

uint8_t Get_Dis_Hour_Time(void)
{
	return counter_val.time.RTC_Hours;
}

uint8_t Get_Dis_Minute_Time(void)
{
	return counter_val.time.RTC_Minutes;
}

uint8_t Get_Current_PageType(void)
{
	return PageType;
}

uint8_t Get_Dis_Unit(void)
{
	return MenuData.Unit; //0km,1mile
}
