#ifndef _SEG_DISPLAY_H_
#define _SEG_DISPLAY_H_

#include "SEG_Ref.h"
#include "Components.h"


typedef enum
{
    em_SEG_High_Beam, 
    em_SEG_FAULT_ELECTROSPRAY,
    em_SEG_ABS,
    em_SEG_Oil_Pressure,
    em_SEG_Bluetooth,
    em_SEG_TCS,
    em_SEG_Auto_Start_Stop,
    em_SEG_Keys,
    em_SEG_Upkeep,
    em_SEG_Low_Batt_Vol,
    em_SEG_Lateral_Strut,
    em_SEG_Tire_Pressure_Alarm,
    em_SEG_Turn_Left,
    em_SEG_Turn_Right,

    em_SEG_Coolant,
    em_SEG_Fuel,

    SEG_LED_MAX,
} SEG_LED_Idx_t;




void SEG_SET_DTC_NUM(uint16_t num);
void SEG_SET_LED_STS(uint8_t LED_NUM, uint8_t m_Flag);
void SEG_SET_FuelDial(uint8_t m_Flag, uint8_t m_SEG);
void SEG_SET_EspeedDial(uint8_t m_Flag, uint8_t m_SEG);
void SEG_SET_CoolantDial(uint8_t m_Flag, uint8_t m_SEG, uint16_t m_Num, uint8_t m_flash);
void SEG_SET_VSpeed_NUM(uint8_t m_Flag, uint16_t m_NUM, uint8_t m_Unit);
void SEG_SET_Voltage_NUM(uint8_t m_Flag, uint16_t m_NUM);
void SEG_SET_TPMS_NUM(uint8_t m_Flag, uint16_t m_NUM1, uint16_t m_NUM2, uint8_t m_Unit, uint8_t m_valid1, uint8_t m_valid2);
void SEG_SET_ODO_TRIP_FAULTCODE_TCS_DIS(uint8_t m_Uint, uint32_t m_NUM_ODO, uint32_t m_NUM_TRIP);
void SEG_SET_Clock(uint8_t m_hour, uint8_t m_minute, uint8_t m_icon, uint8_t m_Flag1, uint8_t m_Flag2);

void Check_SEG_Display(void);

extern uint8_t check_SEG_step;
extern uint8_t Espeed_check_SEG_step;


#define IC_SEG_OFF   0x00u
#define IC_SEG_ON    0x07u
#define IC_SEG_GREY  0x01u 


void SEG_Scan_SET_Fuel_Coolant_Dial(uint8_t coolant);
void SEG_Scan_SET_EspeedDial(void);

extern void Checkself_Init (void);
extern void Checkself_SEG_Display(void);
void TYW_Check_Count(void);




#endif
