#ifndef _DATA_Coolant_H_
#define _DATA_Coolant_H_
#include "common.h"


#define CoolantFlashtimer  250
#define CoolantSelfCheckFlashtimer  15




/*** 控制结构 ***/

typedef struct __attribute__((aligned(4)))
{   
  uint8_t Dis_Valid;  
  uint8_t u8_DestSeg;
  uint8_t u8_CurSeg;
  uint8_t u8_UpFlashtimer ;
  uint8_t u8_DownFlashtimer ;  
  uint8_t u8_Uptimer ;
  uint8_t u8_Downtimer ;  
  uint8_t u8_Flashflg;
  uint8_t u8_Warnflg;
  uint8_t u8_Flg;

}DataCoolantTempDisStruct;

extern DataCoolantTempDisStruct DataCoolantTemp_Dis;


typedef struct __attribute__((aligned(4)))
{
    uint16_t  Value;    
    uint8_t   Valid;    

}DataCoolantTempStruct;        //水温数据结构  





void Data_Coolant_Temp_KL30_Init(void);
void Data_Coolant_Temp_KL15_Init(void);
void Data_Coolant_Temp_Processing_Service(void);
void Get_Coolant_Temp_Seg(uint16_t Temp_Value);
void Data_Coolant_Temp_Display ( void );


uint8_t GET_DataCollantTempSegValid(void);
uint8_t GET_DataCoolantTempSegDisp(void);
uint16_t GET_DataCoolantTempValueDisp(void);
uint8_t GET_DataCollantTempWarnflg(void);

extern DataCoolantTempStruct DataCoolantTemp ;

#endif
