#ifndef _SEG_DISPLAY_H_
#define _SEG_DISPLAY_H_

#include "SEG_Ref.h"
#include "Components.h"


typedef enum
{
    em_SEG_High_Beam, 
    em_SEG_FAULT_ELECTROSPRAY,
    em_SEG_ABS,
    em_SEG_Oil_Pressure,
    em_SEG_Bluetooth,
    em_SEG_TCS,
    em_SEG_Auto_Start_Stop,
    //em_SEG_Keys,
    em_SEG_Upkeep,
    em_SEG_Low_Batt_Vol,
    em_SEG_Lateral_Strut,
    em_SEG_Tire_Pressure_Alarm,
    em_SEG_Turn_Left,
    em_SEG_Turn_Right,

    em_SEG_Coolant,
    em_SEG_Fuel,

    SEG_LED_MAX,
} SEG_LED_Idx_t;


enum ECNaviIcon
{
    EC_NAVI_ICON_NONE                          = 0,               
    EC_NAVI_ICON_DEFAULT                       = 1,               
    EC_NAVI_ICON_LEFT                          = 2,               
    EC_NAVI_ICON_RIGHT                         = 3,               
    EC_NAVI_ICON_LEFT_FRONT                    = 4,              
    EC_NAVI_ICON_RIGHT_FRONT                   = 5,               
    EC_NAVI_ICON_LEFT_BACK                     = 6,               
    EC_NAVI_ICON_RIGHT_BACK                    = 7,               
    EC_NAVI_ICON_LEFT_TURN_AROUND              = 8,               
    EC_NAVI_ICON_STRAIGHT                      = 9,               
    EC_NAVI_ICON_ARRIVED_WAYPOINT              = 10,              
    EC_NAVI_ICON_ENTER_ROUNDABOUT              = 11,              
    EC_NAVI_ICON_OUT_ROUNDABOUT                = 12,              
    EC_NAVI_ICON_ARRIVED_SERVICE_AREA          = 13,              
    EC_NAVI_ICON_ARRIVED_TOLLGATE              = 14,              
    EC_NAVI_ICON_ARRIVED_DESTINATION           = 15,             
    EC_NAVI_ICON_ARRIVED_TUNNEL                = 16,              
    EC_NAVI_ICON_CROSSWALK                     = 17,              
    EC_NAVI_ICON_OVERPASS                      = 18,              
    EC_NAVI_ICON_UNDERPASS                     = 19,              
    EC_NAVI_ICON_SQUARE                        = 20,              
    EC_NAVI_ICON_PARK                          = 21,              
    EC_NAVI_ICON_STAIRCASE                     = 22,              
    EC_NAVI_ICON_LIFT                          = 23,              
    EC_NAVI_ICON_CABLEWAY                      = 24,              
    EC_NAVI_ICON_SKY_CHANNEL                   = 25,              
    EC_NAVI_ICON_CHANNEL                       = 26,              
    EC_NAVI_ICON_WALK_ROAD                     = 27,              
    EC_NAVI_ICON_CRUISE_ROUTE                  = 28,              
    EC_NAVI_ICON_SIGHTSEEING_BUSLINE           = 29,              
    EC_NAVI_ICON_SLIDEWAY                      = 30,              
    EC_NAVI_ICON_LADDER                        = 31,             
    EC_NAVI_ICON_MERGE_LEFT                    = 51,              
    EC_NAVI_ICON_MERGE_RIGHT                   = 52,              
    EC_NAVI_ICON_SLOW                          = 53,             
    EC_NAVI_ICON_ENTRY_RING_LEFT               = 54,               
    EC_NAVI_ICON_ENTRY_RING_RIGHT              = 55,              
    EC_NAVI_ICON_ENTRY_RING_CONTINUE           = 56, 
    EC_NAVI_ICON_ENTRY_RING_UTURN              = 57, 
    EC_NAVI_ICON_ENTRY_LEFT_RING               = 58, 
    EC_NAVI_ICON_LEAVE_LEFT_RING               = 59, 
    EC_NAVI_ICON_UTURN_RIGHT                   = 60, 
    EC_NAVI_ICON_SPECIAL_CONTINUE              = 61, 
    EC_NAVI_ICON_ENTRY_LEFT_RING_LEFT          = 62, 
    EC_NAVI_ICON_ENTRY_LEFT_RING_RIGHT         = 63, 
    EC_NAVI_ICON_ENTRY_LEFT_RING_CONTINUE      = 64, 
    EC_NAVI_ICON_ENTRY_LEFT_RING_UTURN         = 65, 
    EC_NAVI_ICON_SLOPE                         = 66, 
    EC_NAVI_ICON_BRIDGE                        = 67, 
    EC_NAVI_ICON_FERRYBOAT                     = 68, 
    EC_NAVI_ICON_SUBWAY                        = 69, 
    EC_NAVI_ICON_ENTER_BUILDING                = 70, 
    EC_NAVI_ICON_LEAVE_BUILDING                = 71, 
    EC_NAVI_ICON_BY_ELEVATOR                   = 72, 
    EC_NAVI_ICON_BY_STAIR                      = 73, 
    EC_NAVI_ICON_ESCALATOR                     = 74, 
    EC_NAVI_ICON_LOW_TRAFFIC_CROSS             = 75, 
    EC_NAVI_ICON_LOW_CROSS                     = 76, 
    EC_NAVI_ICON_ROTARY_SHARP_LEFT             = 77, 
    EC_NAVI_ICON_ROTARY_SHARP_RIGHT            = 78, 
    EC_NAVI_ICON_ROTARY_SLIGHT_LEFT            = 79, 
    EC_NAVI_ICON_ROTARY_SLIGHT_RIGHT           = 80, 
    EC_NAVI_ICON_MAX
};



void SEG_SET_DTC_NUM(uint32_t num);
void SEG_SET_LED_STS(uint8_t LED_NUM, uint8_t m_Flag);
void SEG_SET_FuelDial(uint8_t m_Flag, uint8_t m_SEG);
void SEG_SET_EspeedDial(uint8_t m_Flag, uint8_t m_SEG);
void SEG_SET_CoolantDial(uint8_t m_Flag, uint8_t m_SEG, uint16_t m_Num, uint8_t m_flash);
void SEG_SET_VSpeed_NUM(uint8_t m_Flag, uint16_t m_NUM, uint8_t m_Unit);
void SEG_SET_Voltage_NUM(uint8_t m_Flag, uint16_t m_NUM);
void SEG_SET_TPMS_DISPLAY(uint8_t m_Flag, uint16_t m_NUM1, uint16_t m_NUM2, uint8_t m_Unit, uint8_t m_valid1, uint8_t m_valid2);
void SEG_SET_ODO_TRIP_FAULTCODE_TCS_DIS(uint8_t m_Uint, uint32_t m_NUM_ODO, uint32_t m_NUM_TRIP);
void SEG_SET_Clock(uint8_t m_hour, uint8_t m_minute, uint8_t m_icon, uint8_t m_Flag1, uint8_t m_Flag2);
void SEG_SET_Navigation_STS(uint8_t m_Flag, uint8_t m_Code, uint32_t m_Mileage);
void Check_SEG_Display(void);
void SEG_SET_FRONT_TPMS_NUM(uint8_t learnflag, uint16_t m_NUM1,uint8_t m_valid1);
void SEG_SET_Rear_TPMS_NUM(uint8_t learnflag, uint16_t m_NUM2,uint8_t m_valid2);

extern uint8_t check_SEG_step;
extern uint8_t Espeed_check_SEG_step;


#define IC_SEG_OFF   0x00u
#define IC_SEG_ON    0x07u
#define IC_SEG_GREY  0x01u 


void SEG_Scan_SET_Fuel_Coolant_Dial(uint8_t coolant);
void SEG_Scan_SET_EspeedDial(void);

extern void Checkself_Init (void);
extern void Checkself_SEG_Display(void);
void TYW_Check_Count(void);




#endif
