#ifndef KEY_USER_H__
#define KEY_USER_H__

#include "Key\Key.h"
#include "common.h"
#include "rtc.h"

typedef struct 
{
    uint16_t  Back_Time_Left;
    uint8_t   Back_Time_Left_Flag;
}_Menu_Infor;

typedef struct 
{
    uint8_t   Set_Hour;
    uint8_t   Set_Minute;
    uint8_t   Dis_Hour;
    uint8_t   Dis_Minute;
    uint8_t   KM_Unit;  // 0 km, 1 mile
    uint8_t   Tpms_Unit;// 0 bar, 1 psi
    uint32_t  Tcs_Val;  // 0 off, 1 on
    uint32_t  TPMS_Front_Learn;
    uint32_t  TPMS_Rear_Learn;
}_Menu_Data;

typedef enum
{
    Page_Menu = 0,
    Page_Time_Hour,
    Page_Time_Minute,
    Page_Km_Unit,
    Page_Tpms_Unit,
    Page_Front_Tpms,
    Page_Rear_Tpms,
	Page_Max,
}_Page_Type;

typedef enum
{
    Page_Odo = 0,
    Page_Trip,
    Page_DTC,
    Page_TCS,

	Page_Menu_Max,
}_Page_Menu_Type;


extern uint8_t PageType;
extern uint8_t ClearODO_Flag;
extern _Menu_Data MenuData;
extern RTC_CounterTypeDef counter_val;
extern void Key_KL30_Init_EXample(void);
extern void Key_Wakeup_Init_EXample(void);
void KEY_LEFT_EVENT_NONE_Service(void);	
void Key_Operation_Right(Key_Event_en_t enKeyEvent);
void Key_Operation_Left(Key_Event_en_t enKeyEvent);
Key_Status_en_t Key_Status_Read_Left(void);
Key_Status_en_t Key_Status_Read_Right(void);
void Key_Clear_Time(void);
void Menu_u8Data_Updata_Process(uint8_t updateDir , uint8_t datMax, uint8_t datMin, uint8_t datStep, uint8_t *dat);
void Key_Left_Short_Press(void);
void Key_Left_Long_Press(void);
void Key_Auto_Save(void);
uint8_t Get_Dis_Hour_Time(void);
uint8_t Get_Dis_Minute_Time(void);
uint8_t Get_Current_PageType(void);
uint8_t Get_Current_PageMenu(void);
void TYW_RESET_ODO(void);
uint8_t Get_Dis_KM_Unit(void);
uint8_t Get_Dis_Tpms_Unit(void);
uint8_t Get_Dis_Tcs_Val(void);
void Key_Check_Service(void);
void MenuData_Unit_Init(void);
void Maintain_Reset_Service(void);
void MenuData_TCS_Init(void);
void Data_TCS_Set_OnOff(uint32_t u32Data);
uint8_t Get_Tpms_TX_Flag(void);
#endif
