<?xml version="1.0" encoding="ISO-8859-1" standalone="yes" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">  
  <!-- Global Settings -->
  <!-- Name of subdirectory to place dependent files in. This variable      -->
  <!-- is automatically filled by the calling process when starting the     -->
  <!-- XSLT process. Don't modify it's value.                               -->
  <!-- This subdirectory must be used for any separate files generated by   -->
  <!-- the stylesheet. The batch job called by the EXECUTE PRE directive    -->
  <!-- creates this directory if it doesn't exist yet.                      -->

  <!-- Contains output folder for extended and multipage navigation         -->
  <xsl:param name="ReportPartsSubdir"/>
  <!-- Same content as previous parameter but with UTF8 enconding           -->
  <xsl:param name="ReportPartsSubdirUTF8">
    <xsl:value-of select="$ReportPartsSubdir"/>
  </xsl:param>
  <!-- Switch output of ident of structure elements depending on report type-->
  <!-- (would be true for testmodule reports)                               -->
  <xsl:variable name="StructureIdents" select="true()"/>
  
  <!-- Verbosity Level: Defines up to which level the details of teststeps -->
  <!-- are shown in the report                                             -->
  <xsl:variable name="TestStepMaxLevel">3</xsl:variable>
  
  <!-- Should failed test steps always be shown, independently of the      -->
  <!-- level on which they were reported?                                  -->
  <xsl:variable name="IncludeFailedStepsOnAnyLevel" select="true()"/>

  <!-- Depth of Indentation per level(in pixel) -->
  <xsl:variable name="IndentDepth">20</xsl:variable>    
  
  <!-- Should '\n' be transformed into linebreaks in the description texts? -->
  <!-- Set to true() to activate or false() to deactivate -->
  <xsl:variable name="DoLinebreakTransformation" select="true()"/>  
  
  <!-- Should images in the report which are scaled and link to the image   -->
  <!-- file itself for full size display be opened in the same or in a new  -->
  <!-- window? Set to false() to disable opening new windows for image links-->
  <xsl:variable name="LinkImageNewWindow" select="true()"/>
  
  <!-- Enable special handling for "Verdict Information" xinfo blocks -->
  <xsl:variable name="EnableSpecialVerdictInfo" select="count(//testcase/miscinfo/title[text()='Verdict Information']) > 0"/>

  <!-- Enable up-links between check statistics -->
  <xsl:variable name="CheckStatisticUpLinks" select="true()"/>
      
  <!-- Should the automatic numbering be available? Or should the idents of test groups and test cases be used instead? -->
  <!-- Set to true() to activate the automatic numbering or false() to deactivate -->
  <xsl:variable name="ShowAutomaticTestModuleNumbering" select="true()"/> 
  
  <!-- Controls the which details of test cases to report, depending on the test case verdict  -->
  <!-- and on the filter settings in the report file, if missing assume showtestcase='true'    -->
  <!-- showcase='true' means the test case will have full details                              -->
  <!-- showcase='false' means the test case does not contain any details                       -->
  <xsl:variable name="HideNoneTestCases" select="/*/showtestcase/none[text()='false']"/>
  <xsl:variable name="HidePassTestCases" select="/*/showtestcase/pass[text()='false']"/>
  <xsl:variable name="HideInconTestCases" select="/*/showtestcase/inconclusive[text()='false']"/>
  <xsl:variable name="HideFailTestCases" select="/*/showtestcase/fail[text()='false']"/>
  <xsl:variable name="HideErrorTestCases" select="/*/showtestcase/error[text()='false']"/>
  
  <!-- Controls wether the details of failed preconditions are reported or not -->
  <xsl:variable name="ShowFailedPreconditions" select="false()"/>
  
  <!-- Controls wether to display the testsequence as testgroup in overview section -->
  <xsl:variable name="ShowSequenceAsGroup" select="false()"/>
  
  <!-- Controls wether to display the testsequence/testcase list as testgroup in overview section -->
  <xsl:variable name="ShowTestListAsGroup" select="true()"/>
  
  <!-- Controls wether to display the additional warning column in the overview table -->
  <xsl:variable name="ShowWarningMessage" select="count(//teststep[@result='warn']) > 0"/>

  <!-- Controls wether to display the additional warning column in the overview table -->
  <xsl:variable name="ShowWarningsInStatistics" select="count(//teststep[@result='warn' and ancestor::testcase]) > 0"/>
  
  <!-- Number of columns in the overview table. Depends on the several variables -->
  <xsl:variable name="OverviewColumnCount" select="3 + $StructureIdents + $EnableSpecialVerdictInfo + $ShowWarningsInStatistics"/>

</xsl:stylesheet>