/******************************************************************************
文 件 名：Simulated_IIC_Master.h
功能描述：IO端口模拟的IIC(I2C)主机函数库头文件
作    者：张暄
版    本：V1.0
日    期：2016.12.21
******************************************************************************/

#ifndef SIMULATED_IIC_2_MASTER_H__
#define SIMULATED_IIC_2_MASTER_H__

#include "LED_Driver\LED_Driver.h"
//#include <stdint.h>
//#include "GPIO.h"

/******************************************************************************
1us延时校准
******************************************************************************/
#define SIMULATED_IIC_2_FREQ_CALIBRATION 40U

/******************************************************************************
确认信号
******************************************************************************/
#define SIMULATED_IIC_2_ACK 0U		   //肯定应答
#define SIMULATED_IIC_2_NAK 1U		   //否定应答
#define SIMULATED_IIC_2_INVALID_ACK 2U //无效的应答信号(应答信号还未收到)

/******************************************************************************
引脚定义
******************************************************************************/

#define SIMULATED_IIC_2_SCL GPIO_PORTC_OUT_PIN05	 //SCL信号
#define SIMULATED_IIC_2_SCL_DIR GPIO_PORTC_DIR_PIN05 //SCL方向
#define SIMULATED_IIC_2_OUT_SDA GPIO_PORTC_OUT_PIN06 //SDA信号
#define SIMULATED_IIC_2_IN_SDA GPIO_PORTC_IN_PIN06
#define SIMULATED_IIC_2_SDA_DIR GPIO_PORTC_DIR_PIN06 //SDA方向

/******************************************************************************
函数声明
******************************************************************************/
void Simulated_IIC_2_Init(void);
void Simulated_IIC_2_Start(void);
void Simulated_IIC_2_Stop(void);
void Simulated_IIC_2_Transmit_Data(unsigned char Data); 
unsigned char Simulated_IIC_2_Receive_Data(void);
void Simulated_IIC_2_Transmit_ACK(unsigned char ACK);
unsigned char Simulated_IIC_2_Receive_ACK(void);
void Simulated_IIC_2_Delay(void);

/*void Simulated_IIC_2_Slave_Service(void);*/

#endif
