#ifndef LIGHT_SENSOR_H__
#define LIGHT_SENSOR_H__
/*-------------------------------------------------------------------------------------------*/
// #define LIGHT_SENSOR_PLATFORM_16BIT
#ifdef LIGHT_SENSOR_PLATFORM_16BIT
typedef unsigned char ALS_uint8_t;
typedef unsigned int ALS_uint16_t;
typedef unsigned long ALS_uint32_t;
#else
typedef unsigned char ALS_uint8_t;
typedef unsigned short ALS_uint16_t;
typedef unsigned int ALS_uint32_t;
#endif
/*-------------------------------------------------------------------------------------------*/
#define ALS_VERSIONS 0X01U

typedef void (*ALS_Hanle)(void);
typedef void (*ALS_Hanle_Write)(ALS_uint8_t u8ALSData);
typedef ALS_uint8_t (*ALS_Hanle_Read)(void);

typedef struct
{

	ALS_Hanle_Write pfnALSDelay100usCB; /*100us 延时函数*/
	ALS_Hanle pfnALSIICStartCB;			/*start 函数接口*/
	ALS_Hanle pfnALSIICStopCB;			/*stop 函数接口*/
	ALS_Hanle_Write pfnALSIICTxDataCB;	/*发送数据 函数接口*/
	ALS_Hanle_Write pfnALSIICTxACKCB;	/*发送ACK 函数接口*/
	ALS_Hanle_Read pfnALSIICRxDataCB;	/*接收数据 函数接口*/
	ALS_Hanle_Read pfnALSIICRxACKCB;	/*接收ACK 函数接口*/

} Light_Sensor_Par_st_t;
/*-------------------------------------------------------------------------------------------*/
/*
返回0：初始化成功
返回1：初始化失败
*/
extern ALS_uint8_t ALS_Init(Light_Sensor_Par_st_t *pstALSInitPar);
/*根据需要的数据更新频率进行调用*/
extern void ALS_Service(void);
extern ALS_uint16_t ALS_Get_Data0(void);
extern ALS_uint16_t ALS_Get_Data1(void);
/*-------------------------------------------------------------------------------------------*/

#endif
