#ifndef __BLUE_TOOTH_H_
#define __BLUE_TOOTH_H_

#include "Protocol_Lib.h"
#include <stdio.h>
#include <stdint.h>
#include "Components.h"
#include "Application.h"
#define ESP32_MCU_0x10  0x10   //蓝牙模组启动发送ID
#define MCU_ESP32_0x20  0x20   //蓝牙模组启动后，MCU回复ID
#define ESP32_MCU_0x01  0x01   //ESP32发送蓝牙导航信息的ID
#define ESP32_MCU_0x12  0x12   //低功耗蓝牙启动状态及蓝牙名称
#define ESP32_MCU_0x05  0x05   //esp32版本号
#define MCU_ESP32_0x03  0x03   //MCU发送UUID
#define ESP32_MCU_0x02  0x02   //ESP32发送重启请求
#define MCU_ESP32_0x04  0x04   //MCU发送重启命令
enum
{
    BLUE_STATE_Starting,   //蓝牙模组启动中
    BLUE_STATE_ON,         //蓝牙模组启动完成
    BLUE_STATE_OFF,
};
typedef struct __attribute__((aligned(4)))
{
    uint8_t   BlueTooth_St; /*蓝牙模组启动状态  0启动中 1启动完成*/
    uint8_t   Navigation_St;/*导航状态   0x35 未导航或导航结束  0x33 正在导航*/
    uint8_t   Navigation_Code;/*蓝牙导向编码*/
    uint32_t  Navigation_Mileage;/*剩余里程*/
    uint8_t   BLE_St;  
    uint8_t   ESP32_Reset;  
    uint8_t   ESP32_SWV;   
} BlueTooth_t;

typedef enum __attribute__((aligned(4)))
{
    EM_ESP32_BT_STARTUP_ST_STANDBY = 0,
    EM_ESP32_BT_STARTUP_ST_SUCCESS,
} EM_ESP32_BT_STARTUP_ST_T;

typedef enum __attribute__((aligned(4)))
{
    EM_ESP32_NAVI_ST_STANDBY = 0,
    EM_ESP32_NAVI_ST_NAVIGATING,
} EM_ESP32_NAVI_ST_T;

typedef struct __attribute__((aligned(4)))
{
    EM_ESP32_BT_STARTUP_ST_T Startup;
    EM_ESP32_NAVI_ST_T NaviSt;
    uint8_t NaviCode;    
    uint8_t BlueToothConnectSt;
    uint32_t NaviMileage;
    uint8_t BlueName[6];
    
} ESP32_COMM_INFO_T;


extern BlueTooth_t  BlueTooth;
uint8_t Get_Navigation_St_Dis(void);
uint8_t Get_Navigation_Code_Dis(void);
uint32_t Get_Navigation_Mileage_Dis(void);
void Send_UUID_To_Esp32(void);
void BlueTooth_KL30_KL15_Wakeup_Init(void);

#endif


