
#include "Data_Coolant\Data_Coolant.h"
#include "Application.h"


DataCoolantTempStruct DataCoolantTemp ;
DataCoolantTempDisStruct DataCoolantTemp_Dis;




void Data_Coolant_Temp_KL30_Init ( void )
{
    DataCoolantTemp.Value = 0; 
    DataCoolantTemp.Valid = 0;      

    DataCoolantTemp_Dis.u8_CurSeg = 0;
    DataCoolantTemp_Dis.u8_DestSeg = 0;
    DataCoolantTemp_Dis.u8_UpFlashtimer = CoolantFlashtimer; 
    DataCoolantTemp_Dis.u8_DownFlashtimer = CoolantFlashtimer; 
    
      

    DataCoolantTemp_Dis.u8_Warnflg = 0;
    DataCoolantTemp_Dis.u8_Flg = 0;    

}

void Data_Coolant_Temp_KL15_Init ( void )
{
    DataCoolantTemp_Dis.u8_CurSeg = 0;
    DataCoolantTemp_Dis.u8_DestSeg = 0;
    DataCoolantTemp_Dis.u8_UpFlashtimer = 0; 
    DataCoolantTemp_Dis.u8_DownFlashtimer = 0; 

    
    DataCoolantTemp_Dis.u8_Warnflg = 0;
    DataCoolantTemp_Dis.u8_Flg = 0;   
}

void Data_Coolant_Temp_Processing_Service ( void )
{
    uint16_t  Coolant_Temperature;
    uint8_t   Coolant_Temperature_State;
    uint32_t  Temp;
    uint8_t   i;

    Coolant_Temperature = Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature();
    Coolant_Temperature_State = Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature_State();

    if (SYS_OPR_STAT_IGN_ON )
    {       
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x101_Msg_Count) == CAN_SIG_LOST)
        {
            DataCoolantTemp.Valid = 0;
            DataCoolantTemp.Value = 0;                       
        }
        else
        {
            if(Coolant_Temperature_State == 1)
            {
                DataCoolantTemp.Valid = 0;
                DataCoolantTemp.Value = 0; 
            }
            else
            {
                DataCoolantTemp.Valid = 1;
                if(Coolant_Temperature >= 2730)
                {
                    Coolant_Temperature -= 2730;                   
                }
                else
                {                    
                    Coolant_Temperature   = 0;  
                }

                if ((Coolant_Temperature % 10) >= 5)
                {
                    Coolant_Temperature += 5;
                }

                if(Coolant_Temperature > 1990) 
                {
                    Coolant_Temperature = 1990 ;    
                } 

                DataCoolantTemp.Value = Coolant_Temperature / 10;
            }
            
            
        }
    }
    else
    {
        DataCoolantTemp.Valid = 0;
        DataCoolantTemp.Value = 0;       
    }   

    //显示   
    Data_Coolant_Temp_Display();        

}


void Data_Coolant_Temp_Display ( void )
{    
    if(SYS_OPR_STAT_IGN_ON)
    {                
        if (Common_GetIgnOnTime() < 3000)
        {   
            DataCoolantTemp_Dis.u8_Uptimer = CoolantSelfCheckFlashtimer; 
            DataCoolantTemp_Dis.u8_Downtimer = CoolantSelfCheckFlashtimer; 
 
            if(DataCoolantTemp_Dis.u8_CurSeg == 0)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 5;    
            }
            if(DataCoolantTemp_Dis.u8_CurSeg == 5)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 0;    
            }
            DataCoolantTemp_Dis.u8_Warnflg = 0; 
            DataCoolantTemp_Dis.u8_Flg = 0;
            DataCoolantTemp_Dis.Dis_Valid = 0; 
        }
        else
        {
            DataCoolantTemp_Dis.u8_Uptimer = CoolantFlashtimer; 
            DataCoolantTemp_Dis.u8_Downtimer = CoolantFlashtimer;

            Get_Coolant_Temp_Seg(DataCoolantTemp.Value);

            if(DataCoolantTemp.Valid == 0)       
            {
                DataCoolantTemp_Dis.Dis_Valid = 0; 
                DataCoolantTemp_Dis.u8_UpFlashtimer = DataCoolantTemp_Dis.u8_Uptimer; 
                DataCoolantTemp_Dis.u8_DownFlashtimer = DataCoolantTemp_Dis.u8_Downtimer; 
                DataCoolantTemp_Dis.u8_CurSeg = 0;
                DataCoolantTemp_Dis.u8_DestSeg = 0 ;                            
                DataCoolantTemp_Dis.u8_Flg = 0;            
            } 
            else
            {  
                DataCoolantTemp_Dis.Dis_Valid = 1; 
                if(DataCoolantTemp_Dis.u8_Flg == 0)
                {
                    DataCoolantTemp_Dis.u8_Flg = 1;  
                    DataCoolantTemp_Dis.u8_CurSeg =  DataCoolantTemp_Dis.u8_DestSeg; 
                    DataCoolantTemp_Dis.u8_UpFlashtimer = DataCoolantTemp_Dis.u8_Uptimer; 
                    DataCoolantTemp_Dis.u8_DownFlashtimer = DataCoolantTemp_Dis.u8_Downtimer; 
                }   
            }
        }
        
        if(DataCoolantTemp_Dis.u8_CurSeg > DataCoolantTemp_Dis.u8_DestSeg )
        {
            DataCoolantTemp_Dis.u8_UpFlashtimer = 0; 
            DataCoolantTemp_Dis.u8_DownFlashtimer++;
            if(DataCoolantTemp_Dis.u8_DownFlashtimer >= DataCoolantTemp_Dis.u8_Downtimer)
            {
                DataCoolantTemp_Dis.u8_DownFlashtimer = 0;
                DataCoolantTemp_Dis.u8_CurSeg --;
            }                     
        }
        else if(DataCoolantTemp_Dis.u8_CurSeg < DataCoolantTemp_Dis.u8_DestSeg)
        {
            DataCoolantTemp_Dis.u8_DownFlashtimer = 0;   
            DataCoolantTemp_Dis.u8_UpFlashtimer++;  
            if(DataCoolantTemp_Dis.u8_UpFlashtimer >= DataCoolantTemp_Dis.u8_Uptimer)
            {
                DataCoolantTemp_Dis.u8_UpFlashtimer = 0;
                DataCoolantTemp_Dis.u8_CurSeg ++; 
            }                    
        }             
        //warning
        
        if( DataCoolantTemp.Valid == 0 )
        {
            DataCoolantTemp_Dis.u8_Warnflg = 1;
        }
        else
        {
            if (DataCoolantTemp.Value >= 115)
            {
                DataCoolantTemp_Dis.u8_Warnflg = 2;
            }
            else if(DataCoolantTemp.Value <= 112)
            {
                DataCoolantTemp_Dis.u8_Warnflg = 0;
            }
            else
            {
                ;
            }
            
        }
       
        
        
    }
    else 
    {
        DataCoolantTemp_Dis.Dis_Valid = 0; 
        DataCoolantTemp_Dis.u8_UpFlashtimer = DataCoolantTemp_Dis.u8_Uptimer; 
        DataCoolantTemp_Dis.u8_DownFlashtimer = DataCoolantTemp_Dis.u8_Downtimer; 
        DataCoolantTemp_Dis.u8_Warnflg = 0; 
        DataCoolantTemp_Dis.u8_Flg = 0;
    }      
   
}


        
void Get_Coolant_Temp_Seg(uint16_t Temp_Value)
{
    uint8_t TempSeg;
    uint8_t CurTempSeg;

    if(Temp_Value < 50)
    {
        if(DataCoolantTemp_Dis.u8_CurSeg > 1)
        {
            DataCoolantTemp_Dis.u8_DestSeg = 1; 
        }
        else if (DataCoolantTemp_Dis.u8_CurSeg > 0)
        {
            if(Temp_Value <= 47)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 0;
            }
        }
        else
        {
            DataCoolantTemp_Dis.u8_DestSeg = 0;
        }
    }
    else if((Temp_Value < 62)&&(Temp_Value >= 50))
    {
        if(DataCoolantTemp_Dis.u8_CurSeg > 2)
        {
            DataCoolantTemp_Dis.u8_DestSeg = 2; 
        }
        else if(DataCoolantTemp_Dis.u8_CurSeg > 1 )
        {  
            if(Temp_Value <= 59)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 1;
            }
        }
        else
        {
            DataCoolantTemp_Dis.u8_DestSeg = 1; 
        }    
    }
    else if((Temp_Value < 80)&&(Temp_Value >= 62))
    {
        if(DataCoolantTemp_Dis.u8_CurSeg > 3)
        {
            DataCoolantTemp_Dis.u8_DestSeg = 3;     
        }
        else if(DataCoolantTemp_Dis.u8_CurSeg > 2)
        {
            if(Temp_Value <= 77)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 2;   
            }
        }
        else
        {
            DataCoolantTemp_Dis.u8_DestSeg = 2;      
        }
    }
    else if((Temp_Value < 98)&&(Temp_Value >= 80))
    {
        if(DataCoolantTemp_Dis.u8_CurSeg > 4)
        {
            DataCoolantTemp_Dis.u8_DestSeg = 4;       
        }
        else if(DataCoolantTemp_Dis.u8_CurSeg > 3)
        {
            if(Temp_Value <= 95 )
            {
                DataCoolantTemp_Dis.u8_DestSeg = 3;           
            }
        }
        else
        {
            DataCoolantTemp_Dis.u8_DestSeg = 3;      
        }
    }
    else if((Temp_Value < 115)&&(Temp_Value >= 98))    
    {
        if(DataCoolantTemp_Dis.u8_CurSeg > 4)
        {
            if(Temp_Value <= 112)
            {
                DataCoolantTemp_Dis.u8_DestSeg = 4;          
            }
        }
        else
        {
            DataCoolantTemp_Dis.u8_DestSeg = 4;  
        }
    }       
    else
    {
        DataCoolantTemp_Dis.u8_DestSeg = 5;   
    }  
}


//水温显示格数
uint8_t GET_DataCoolantTempSegDisp(void)
{
   return DataCoolantTemp_Dis.u8_CurSeg;
}

//水温显示有效标志
uint8_t GET_DataCollantTempSegValid(void) 
{
   return DataCoolantTemp_Dis.Dis_Valid;
}

//水温数显。作为外发使用的时候+40
uint16_t GET_DataCoolantTempValueDisp(void)
{
   return DataCoolantTemp.Value ; 
}

uint8_t GET_DataCollantTempValueValid(void) 
{
   return DataCoolantTemp.Valid;
}

//水温灯及显示的报警信号  0:无报警，正常显示   1：掉线或者state无效，白色闪烁  2：高温，红色闪烁
uint8_t GET_DataCollantTempWarnflg(void) 
{
   return DataCoolantTemp_Dis.u8_Warnflg;         
}








