#include  "CAN_CH0_CAN_Communication_Matrix.h"
#include "Components.h"
#include "Application.h"
/* 2024/02/18 14:28:49 */
st_CanMsgOp CAN_CH0_CanMsgOp;
st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
extern void Can_ID_401(uint8_t CopyData []);
const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
{
    {0x500ul, 8ul * 1000ul,  7ul * 1000ul,    0u,  MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_500, (void *)0},
};

const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
{
    
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x402ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x401ul,
        (( void * )0),
        (Can_ID_401),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x101ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
};

//uint8_t  Get_CAN_CH0_ID_500_Sig_Key_ISTOP(void)
//{
//    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x500_Msg_Count, 0u) >> 0u) & 0x01u));
//}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_Warning_Lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x402_Msg_Count, 7u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Battery_Voltage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x401_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CAN_0x101_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_CAN_0x402_Msg:
        u8Result = CAN_CH0_ID_CAN_0x402_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x401_Msg:
        u8Result = CAN_CH0_ID_CAN_0x401_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x101_Msg:
        u8Result = CAN_CH0_ID_CAN_0x101_Msg_Count;
        break;
    default :
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}



