/**
 * @file        Protocol_CRC16.c
 * @brief       CRC16计算
 * @details     CRC16计算
 * @author      myliu
 * @date        2022.05.09
 * @version     V1.0
 * @copyright   myiu
 */
#include "Protocol_CRC16.h"

static const Protocol_uint8_t CRC16_TAB_H [ 256 ] = {0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u};

static const Protocol_uint8_t CRC16_TAB_L [ 256 ] = {0x00u, 0xC0u, 0xC1u, 0x01u, 0xC3u, 0x03u, 0x02u, 0xC2u, 0xC6u, 0x06u, 0x07u, 0xC7u, 0x05u, 0xC5u, 0xC4u, 0x04u, 0xCCu, 0x0Cu, 0x0Du, 0xCDu, 0x0Fu, 0xCFu, 0xCEu, 0x0Eu, 0x0Au, 0xCAu, 0xCBu, 0x0Bu, 0xC9u, 0x09u, 0x08u, 0xC8u, 0xD8u, 0x18u, 0x19u, 0xD9u, 0x1Bu, 0xDBu, 0xDAu, 0x1Au, 0x1Eu, 0xDEu, 0xDFu, 0x1Fu, 0xDDu, 0x1Du, 0x1Cu, 0xDCu, 0x14u, 0xD4u, 0xD5u, 0x15u, 0xD7u, 0x17u, 0x16u, 0xD6u, 0xD2u, 0x12u, 0x13u, 0xD3u, 0x11u, 0xD1u, 0xD0u, 0x10u, 0xF0u, 0x30u, 0x31u, 0xF1u, 0x33u, 0xF3u, 0xF2u, 0x32u, 0x36u, 0xF6u, 0xF7u, 0x37u, 0xF5u, 0x35u, 0x34u, 0xF4u, 0x3Cu, 0xFCu, 0xFDu, 0x3Du, 0xFFu, 0x3Fu, 0x3Eu, 0xFEu, 0xFAu, 0x3Au, 0x3Bu, 0xFBu, 0x39u, 0xF9u, 0xF8u, 0x38u, 0x28u, 0xE8u, 0xE9u, 0x29u, 0xEBu, 0x2Bu, 0x2Au, 0xEAu, 0xEEu, 0x2Eu, 0x2Fu, 0xEFu, 0x2Du, 0xEDu, 0xECu, 0x2Cu, 0xE4u, 0x24u, 0x25u, 0xE5u, 0x27u, 0xE7u, 0xE6u, 0x26u, 0x22u, 0xE2u, 0xE3u, 0x23u, 0xE1u, 0x21u, 0x20u, 0xE0u, 0xA0u, 0x60u, 0x61u, 0xA1u, 0x63u, 0xA3u, 0xA2u, 0x62u, 0x66u, 0xA6u, 0xA7u, 0x67u, 0xA5u, 0x65u, 0x64u, 0xA4u, 0x6Cu, 0xACu, 0xADu, 0x6Du, 0xAFu, 0x6Fu, 0x6Eu, 0xAEu, 0xAAu, 0x6Au, 0x6Bu, 0xABu, 0x69u, 0xA9u, 0xA8u, 0x68u, 0x78u, 0xB8u, 0xB9u, 0x79u, 0xBBu, 0x7Bu, 0x7Au, 0xBAu, 0xBEu, 0x7Eu, 0x7Fu, 0xBFu, 0x7Du, 0xBDu, 0xBCu, 0x7Cu, 0xB4u, 0x74u, 0x75u, 0xB5u, 0x77u, 0xB7u, 0xB6u, 0x76u, 0x72u, 0xB2u, 0xB3u, 0x73u, 0xB1u, 0x71u, 0x70u, 0xB0u, 0x50u, 0x90u, 0x91u, 0x51u, 0x93u, 0x53u, 0x52u, 0x92u, 0x96u, 0x56u, 0x57u, 0x97u, 0x55u, 0x95u, 0x94u, 0x54u, 0x9Cu, 0x5Cu, 0x5Du, 0x9Du, 0x5Fu, 0x9Fu, 0x9Eu, 0x5Eu, 0x5Au, 0x9Au, 0x9Bu, 0x5Bu, 0x99u, 0x59u, 0x58u, 0x98u, 0x88u, 0x48u, 0x49u, 0x89u, 0x4Bu, 0x8Bu, 0x8Au, 0x4Au, 0x4Eu, 0x8Eu, 0x8Fu, 0x4Fu, 0x8Du, 0x4Du, 0x4Cu, 0x8Cu, 0x44u, 0x84u, 0x85u, 0x45u, 0x87u, 0x47u, 0x46u, 0x86u, 0x82u, 0x42u, 0x43u, 0x83u, 0x41u, 0x81u, 0x80u, 0x40u};

/**
 * 获取CRC16校验和
 */
/**
 * @brief 计算传入数据的CRC16
 * @param[in] pData     计算的数据内容
 * @param[in] len       计算的数据长度
 *
 * @return    校验和
 *
 * @since 1.0.0
 */
Protocol_uint16_t getCheckSum(const Protocol_uint8_t *pData, int len)
{
    Protocol_uint8_t  u8_crc_h = 0xFFu;
    Protocol_uint8_t  u8_crc_l = 0xFFu;
    Protocol_uint8_t  u8_index = 0u;
    Protocol_uint8_t  i        = 0u;
    Protocol_uint16_t re_value;

    while ( len-- )
    {
        u8_index = u8_crc_h ^ (pData [ i++ ]);
        u8_crc_h = u8_crc_l ^ CRC16_TAB_H [ u8_index ];
        u8_crc_l = CRC16_TAB_L [ u8_index ];
    }

    re_value = ( Protocol_uint16_t )u8_crc_h << 8u;
    re_value |= u8_crc_l;

    return re_value;
}
