#include "Can_User.h"
#include "Diag_ID_Def.h"
#include "DoCAN_ISO15765.h"
#include <string.h>
#include "can.h"
#include "RTE.h"

__align(4)
    uint32_t pRXBuff[CAN_RX_MSG_Block * CAN_CH0_ID_TOTAL_MAX];
uint32_t pTXBuff[CAN_TX_MSG_Block * CAN_CH0_ID_SEND_TOTAL];
static RSCAN0BusoffMonitorStruct RSCAN0Busoff;
uint8_t CAN_Send_Cound = 0;

void Can_Init(void)
{
    CAN_TX_Count_Init();
    can_config_st_t Can_Config;
    Can_Config.ch = CAN_CH_0;
    Can_Config.freq = CAN_500Kbps;
    Can_Config.MASK[0] = 0x001fffffU;
    Can_Config.MASK[1] = 0x000fffffU;
    Can_Config.MASK[2] = 0x1fffffffU;
    Can_Config.MASK[3] = 0x1fffffffU;
    Can_Config.rx_callback = Read_RingBuff;//Can_Rx_Cak;
    COM_CAN_Init();
    rte_can_init(&Can_Config);

    Can_Tx_Apply_Buff();
    Can_RX_Apply_Buff();

    RTE_GPIO_Set_Level(RTE_GPIO_PORT05_PIN02, RTE_GPIO_LEVEL_LOW);
}

/**
 * @brief 用于申请RXBUFF CAN0MSG00~CAN0MSG07
 *
 */
void Can_RX_Apply_Buff(void)
{
    CAN_RecvMsg.DLC = 8;
    CAN_RecvMsg.Data[0] = 0;
    CAN_RecvMsg.Data[1] = 0;
    CAN_RecvMsg.Data[2] = 0;
    CAN_RecvMsg.Data[3] = 0;
    CAN_RecvMsg.Data[4] = 0;
    CAN_RecvMsg.Data[5] = 0;
    CAN_RecvMsg.Data[6] = 0;
    CAN_RecvMsg.Data[7] = 0;
    CAN_RecvMsg.OverWriteConfig = 0;

    CAN_RecvMsg.Id = 0x101;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG01);
    CAN_MessageCache_Init(CAN0MSG01, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG01, ENABLE);

    CAN_RecvMsg.Id = 0x402;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG02);
    CAN_MessageCache_Init(CAN0MSG02, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG02, ENABLE);

    CAN_RecvMsg.Id = 0x401;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG06);
    CAN_MessageCache_Init(CAN0MSG06, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG06, ENABLE);

    CAN_RecvMsg.Id = 0x341;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG05);
    CAN_MessageCache_Init(CAN0MSG05, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG05, ENABLE);

    CAN_RecvMsg.Id = 0x111;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG07);
    CAN_MessageCache_Init(CAN0MSG07, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG07, ENABLE);

    CAN_RecvMsg.Id = 0x120;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG11);
    CAN_MessageCache_Init(CAN0MSG11, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG11, ENABLE);

    CAN_RecvMsg.Id = 0x373;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG15);
    CAN_MessageCache_Init(CAN0MSG15, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG15, ENABLE);

    CAN_RecvMsg.Id = DIAG_ID_Rx_PHY;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG03);
    CAN_MessageCache_Init(CAN0MSG03, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG03, ENABLE);

    CAN_RecvMsg.Id = DIAG_ID_Rx_FUN;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG04);
    CAN_MessageCache_Init(CAN0MSG04, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG04, ENABLE);
}

/**
 * @brief 用于申请TXBUFF
 *
 */
void Can_Tx_Apply_Buff(void)
{
    CanTxRxMsg CAN_SendMsg;
    CanTxRxMsg CAN_SendMsg_Diag_Tx;
    CAN_SendMsg.Id = 0x6EE;
    CAN_SendMsg.IDE = CAN_Id_Standard;
    CAN_SendMsg.CacheType = CAN_CacheType_Tx;
    CAN_SendMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = DISABLE;
    CAN_SendMsg.DLC = 8;
    for (uint8_t i = 0; i < CAN_SendMsg.DLC; i++)
    {
        CAN_SendMsg.Data[i] = 0;
    }

    CAN_MessageCache_DeInit(CAN0MSG08);
    CAN_MessageCache_Init(CAN0MSG08, &CAN_SendMsg);

    CAN_SendMsg.Id = 0x6EF;
    CAN_SendMsg.IDE = CAN_Id_Standard;
    CAN_SendMsg.CacheType = CAN_CacheType_Tx;
    CAN_SendMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = DISABLE;
    CAN_SendMsg.DLC = 8;
    for (uint8_t i = 0; i < CAN_SendMsg.DLC; i++)
    {
        CAN_SendMsg.Data[i] = 0;
    }

    CAN_MessageCache_DeInit(CAN0MSG12);
    CAN_MessageCache_Init(CAN0MSG12, &CAN_SendMsg);

    CAN_SendMsg.Id = 0x450;
    CAN_SendMsg.IDE = CAN_Id_Standard;
    CAN_SendMsg.CacheType = CAN_CacheType_Tx;
    CAN_SendMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = DISABLE;
    CAN_SendMsg.DLC = 8;
    for (uint8_t i = 0; i < CAN_SendMsg.DLC; i++)
    {
        CAN_SendMsg.Data[i] = 0;
    }

    CAN_MessageCache_DeInit(CAN0MSG13);
    CAN_MessageCache_Init(CAN0MSG13, &CAN_SendMsg);

    CAN_SendMsg.Id = 0x220;
    CAN_SendMsg.IDE = CAN_Id_Standard;
    CAN_SendMsg.CacheType = CAN_CacheType_Tx;
    CAN_SendMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = DISABLE;
    CAN_SendMsg.DLC = 8;
    for (uint8_t i = 0; i < CAN_SendMsg.DLC; i++)
    {
        CAN_SendMsg.Data[i] = 0;
    }

    CAN_MessageCache_DeInit(CAN0MSG10);
    CAN_MessageCache_Init(CAN0MSG10, &CAN_SendMsg);

    CAN_SendMsg.Id = 0x580;
    CAN_SendMsg.IDE = CAN_Id_Standard;
    CAN_SendMsg.CacheType = CAN_CacheType_Tx;
    CAN_SendMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = DISABLE;
    CAN_SendMsg.DLC = 8;
    for (uint8_t i = 0; i < CAN_SendMsg.DLC; i++)
    {
        CAN_SendMsg.Data[i] = 0;
    }

    CAN_MessageCache_DeInit(CAN0MSG14);
    CAN_MessageCache_Init(CAN0MSG14, &CAN_SendMsg);

    CAN_SendMsg_Diag_Tx.Id = DIAG_ID_Tx;
    CAN_SendMsg_Diag_Tx.IDE = CAN_Id_Standard;
    CAN_SendMsg_Diag_Tx.CacheType = CAN_CacheType_Tx;
    CAN_SendMsg_Diag_Tx.RTR = CAN_RTR_Data;
    CAN_SendMsg_Diag_Tx.Interrupt = DISABLE;
    CAN_SendMsg_Diag_Tx.DLC = 8;
    for (uint8_t i = 0; i < CAN_SendMsg_Diag_Tx.DLC; i++)
    {
        CAN_SendMsg_Diag_Tx.Data[i] = 0;
    }

    CAN_MessageCache_DeInit(CAN0MSG09);
    CAN_MessageCache_Init(CAN0MSG09, &CAN_SendMsg_Diag_Tx);
}
/**
 * @brief 用于接收回调函数
 * @code
 */
void Can_Rx_Cak(CanTxRxMsg *Msg)
{
    Co_Can_Buff_Set(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(Msg->Id), Msg->DLC, Msg->Data);

    if ((Msg->Id == DIAG_ID_Rx_FUN) || (Msg->Id == DIAG_ID_Rx_PHY))
    {
        DoCAN_L_Data_Indication((uint16_t)(Msg->Id), Msg->DLC, Msg->Data);
    }
}
#if 1
/**
 * @brief CAN库初始化TX/RX
 *
 */
void COM_CAN_Init(void)
{
    memset(pRXBuff, 0, sizeof(pRXBuff));
    CAN_CH0_CanMsgOp.CAN_MSG_Analysis = (st_CANMsgStruct *)pRXBuff;
    CAN_CH0_CanMsgOp.pAttrubute = CAN_CH0_CAN_MSG_CONST_ARRAY;
    CAN_CH0_CanMsgOp.Total_Msg = CAN_CH0_ID_TOTAL_MAX;
    CAN_CH0_CanMsgOp.u8CAN_RX_ENABLE = CAN_N_RX_Enable;
    Can_RX_BuffInit(&CAN_CH0_CanMsgOp, CAN_CH0_CAN_MSG_CONST_ARRAY, CAN_CH0_ID_TOTAL_MAX);
    CAN_RX_SetEnable(&CAN_CH0_CanMsgOp, CAN_N_RX_Enable);


}


void CAN_TX_Init(void)
{

    memset(pTXBuff, 0, sizeof(pTXBuff));
    CAN_CH0_CanMsgTxOp.CanMsg = (st_CAN_SendOperation *)pTXBuff;
    CAN_CH0_CanMsgTxOp.pCAN_SendAttribute = CAN_CH0_CANSendAttr;
    CAN_CH0_CanMsgTxOp.Total_Msg = CAN_CH0_ID_SEND_TOTAL;
    CAN_CH0_CanMsgTxOp.Can_Write = COM_APP_Process;
    CAN_CH0_CanMsgTxOp.u8CAN_TX_ENABLE = CAN_N_TX_Disable;
    Can_TX_BuffInit(&CAN_CH0_CanMsgTxOp, CAN_CH0_CANSendAttr, CAN_CH0_ID_SEND_TOTAL, COM_APP_Process);
    CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable);

}
#endif
#if 0
/**
 * @brief CAN库初始化TX/RX
 *
 */
void COM_CAN_Init(void)
{
    memset(pRXBuff, 0, sizeof(pRXBuff));
    CAN_CH0_CanMsgOp.CAN_MSG_Analysis = (st_CANMsgStruct *)pRXBuff;
    CAN_CH0_CanMsgOp.pAttrubute = CAN_CH0_CAN_MSG_CONST_ARRAY;
    CAN_CH0_CanMsgOp.Total_Msg = CAN_CH0_ID_TOTAL_MAX;
    CAN_CH0_CanMsgOp.u8CAN_RX_ENABLE = CAN_N_RX_Enable;
    Can_RX_BuffInit(&CAN_CH0_CanMsgOp, CAN_CH0_CAN_MSG_CONST_ARRAY, CAN_CH0_ID_TOTAL_MAX);
    CAN_RX_SetEnable(&CAN_CH0_CanMsgOp, CAN_N_RX_Enable);

    memset(pTXBuff, 0, sizeof(pTXBuff));
    CAN_CH0_CanMsgTxOp.CanMsg = (st_CAN_SendOperation *)pTXBuff;
    Can_TX_BuffInit(&CAN_CH0_CanMsgTxOp, CAN_CH0_CANSendAttr, CAN_CH0_ID_SEND_TOTAL, COM_APP_Process);
    CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable);
}
#endif















void Can_QuickTimer_Init(void)
{
    uint32_t i = 0u;
    for (i = 0u; i < CAN_CH0_ID_SEND_TOTAL; i++)
    {
        Can_Msg_TX_FastInitCycle(&CAN_CH0_CanMsgTxOp, i, CAN_CH0_CANSendAttr[i].u32MsgCycleOffset);
    }
}

/**
 * @brief Buff恢复函数
 * @param deltaTime 调用时间 单位ms 10MS调用
 */

uint16_t CanRxInitflag = 0;
void Can_BusOff_Recover(uint8_t deltaTime)
{
    if (get_can_busoff(CAN_CH_0) == 2)
    {
        CanRxInitflag = 1;
        CAN_TX_Count_Init();
        if (RSCAN0Busoff.Status == RSCAN0_BUS_STABLE)
        {
            RSCAN0Busoff.Status = RSCAN0_BUS_OFF_LV1;
        }

        if (RSCAN0Busoff.Status == RSCAN0_BUS_OFF_LV1)
        {
            RSCAN0Busoff.Timer++;
            if (RSCAN0Busoff.Timer >= RSCAN0_BUS_OFF_LV1_RECOVERY_TIME / deltaTime)/**/
            {
                RSCAN0Busoff.Timer = 0U;

                RSCAN0Busoff.Cnt++;
                if (RSCAN0Busoff.Cnt >= 10U)/**/
                {

                    RSCAN0Busoff.Cnt = 0U;

                    RSCAN0Busoff.Status = RSCAN0_BUS_OFF_LV2;
                }
                //需调用CAN中止函数，中止所有硬件buf内要发送的数据
                CAN_TX_Count_Init();
                Can_QuickTimer_Init();
                reset_busoff(CAN_CH_0);
            }
        }
        else if (RSCAN0Busoff.Status == RSCAN0_BUS_OFF_LV2)
        {
            RSCAN0Busoff.Timer++;

            if (RSCAN0Busoff.Timer >= RSCAN0_BUS_OFF_LV2_RECOVERY_TIME / deltaTime)/**/
            {
                RSCAN0Busoff.Timer = 0U;
                //需调用CAN中止函数，中止所有硬件buf内要发送的数据
                CAN_TX_Count_Init();
                Can_QuickTimer_Init();
                reset_busoff(CAN_CH_0);
            }
        }
        else
        {
        }
    }
    else /* 总线正常,没有Bus-off发生*/
    {
        RSCAN0Busoff.RecoverTimer++;
        if (RSCAN0Busoff.RecoverTimer >= 4)
        {
            RSCAN0Busoff.RecoverTimer = 0;

            RSCAN0Busoff.Status = RSCAN0_BUS_STABLE;
            RSCAN0Busoff.Timer = 0;
            RSCAN0Busoff.Cnt = 0;
        }
        if(CanRxInitflag == 1)
        {
            CanRxInitflag = 0;
            Can_RX_Apply_Buff();
        }
    }
}

/**
 * @brief 获取busoff状态
 * @return 0 没有busoff
 *         1 错误的操作
 *         2 busoff
 */
uint8_t Get_Busoff_Status(void)
{
    return get_can_busoff(CAN_CH_0);
}



extern uint8_t Tpms_TX_Flag;
uint8_t COM_APP_Process(st_CAN_Msg *Msg)
{
    //     Can_Write((st_CAN_Msg *)Msg);
    //     return 0;
    // }

    // void Can_Write(st_CAN_Msg *Msg)
    // {
    uint32_t i = 0;
    CanTxRxMsg CAN_SendMsg;
    uint8_t CAN_result = 0;

    CAN_SendMsg.Id = Msg->MsgID;       /* ID */
    CAN_SendMsg.DLC = Msg->MsgDLC;     /* Len */
    CAN_SendMsg.RTR = Msg->MsgRTR;     /* Default 0 */
    CAN_SendMsg.IDE = CAN_Id_Standard; /* Stand 0 Ext 1 */
    CAN_SendMsg.CacheType = CAN_CacheType_Tx;

    for (i = 0; i < CAN_SendMsg.DLC; i++) /* 获取数据 */
    {
        CAN_SendMsg.Data[i] = Msg->Msg[i];
    }

    switch (CAN_SendMsg.Id)
    {
    case 0x6EE:
        CAN_result = CAN_Transmit(CAN0MSG08, &CAN_SendMsg);
        break;
    case 0x6EF:
        CAN_result = CAN_Transmit(CAN0MSG12, &CAN_SendMsg);
        break;
    case 0x450:

        // if(Can_341_Flg == 1 || Common_GetIgnOnTime() > 2000)
        {
            CAN_result = CAN_Transmit(CAN0MSG13, &CAN_SendMsg);
        }

        break;
    case 0x220:
        CAN_result = CAN_Transmit(CAN0MSG10, &CAN_SendMsg);
        if (AliveCountTimer < 7)
        {
            AliveCountTimer++;
        }
        else
        {
            AliveCountTimer = 0;
        }
        break; 
#if (IC_Current == TY200_080000b_ty)
    case 0x580:
        if (Get_Tpms_TX_Flag() != 0)
        {
            if(CAN_Send_Cound++ <= 2)
            {
                CAN_result = CAN_Transmit(CAN0MSG14, &CAN_SendMsg);
            }
            else
            {
                CAN_Send_Cound = 0;
                Tpms_TX_Flag = 0;
            }
            
            //Can_580Send_flag = 0;
        }

        break;
#endif
    default:
        break;
    }
    return (!CAN_result);
}
