#include "Can_App.h"
#include "Components.h"
#include "Application.h"

uint16_t CAN_TX_Count = 0;
uint16_t AliveCountTimer = 0;
uint8_t Power_KL30_Init_flag = 0;
uint8_t AliveCount_KL30_ResettingFlag = 0;

extern uint8_t Tpms_TX_Flag;


#define INVALID_VALUE   0x0

void CAN_TX_Flag_Init(void)
{
    Power_KL30_Init_flag = 0;
}

void CAN_TX_Count_Init(void)
{
    CAN_TX_Count = 0;
    if(AliveCount_KL30_ResettingFlag > 0)
    {
        AliveCount_KL30_ResettingFlag = 0;
    }
    else
    {
        AliveCountTimer = 0;
    }
    
}
void Can_Set_Buff_220(canlib_uint8_t CopyData[])
{
    CANMsg220Union *p220;
    uint8_t i = 0;
    uint8_t u8TCSVal = 0;
    u8TCSVal = Get_Dis_Tcs_Val();

    p220 = (CANMsg220Union *)CopyData;
    if ( p220 != ( void * )0 )
    {
                    for ( i = 0u; i < 8u; i++ )
            {
                p220->Msg [ i ] = 0x0u;
            }

            p220 -> Sig.TCS_TX = u8TCSVal;
            p220 -> Sig.AliveCounter = AliveCountTimer;
            p220 -> Sig.CheckSum = (u8TCSVal == 1) ? 8 : 0;
            }

    
    
}
void Can_Set_Buff_6EE(canlib_uint8_t CopyData[])
{
    CANMsg6EEUnion *p6EE;
    uint8_t i = 0;
    uint16_t Vspeed_tx = 0;
    uint16_t Fuel_tx = 0;
    uint32_t ODO_tx = Data_ODO_Read();    
    Vspeed_tx = Get_DispVechileSpeed_TX()/10;
    Fuel_tx = Get_Fuel_RES();
    p6EE = (CANMsg6EEUnion *)CopyData;
    
    if ( p6EE != ( void * )0 )
    {
        if(Power_KL30_Init_flag == 1)
        {
            for ( i = 0u; i < 8u; i++ )
            {
                p6EE->Msg [ i ] = 0x0u;
            }
            p6EE -> Sig.ODO_TX_H        = (ODO_tx >> 16) & 0xFF ;
            p6EE -> Sig.ODO_TX_M        = (ODO_tx >> 8) & 0xFF ;
            p6EE -> Sig.ODO_TX_L        = ODO_tx & 0xFF ;
            if(Fuel_tx > 255)
            {
                p6EE -> Sig.Fuel_Res_TX  = 0xFF ; 
            }
            else
            {
                p6EE -> Sig.Fuel_Res_TX  = Fuel_tx ; 
            }
        }
        else
        {
            for ( i = 0u; i < 8u; i++ )
            {
                p6EE->Msg [ i ] = INVALID_VALUE;
            }
        }
        
       
    } 
    //p6EE -> Sig.Vsppe_H3_TX     = (Vspeed_tx >> 8) & 0x7u ;
    //p6EE -> Sig.Vsppe_L8_TX     = Vspeed_tx & 0xFF ;
    
   // p6EE -> Sig.Uint_TX         = Get_Dis_KM_Unit() ;
   // p6EE -> Sig.Coolant_Seg_TX  = GET_DataCoolantTempSegDisp() ;
    //if (GET_DataCollantTempWarnflg() == 2)
    //{
    //    p6EE -> Sig.Coolant_Warn_TX = 1;
    //}
    //else
    //{
    //    p6EE -> Sig.Coolant_Warn_TX = 0;
    //}
    //p6EE -> Sig.Fuel_Seg_TX  = Get_CurFuelSetp() ;
    
    
}
void Can_Set_Buff_6EF(canlib_uint8_t CopyData[])
{
    CANMsg6EFUnion *p6EF;
    uint8_t i = 0;
    uint16_t Espeed_tx = 0;
    uint16_t TripA_tx = 0;
    Espeed_tx = Get_ActualEngineSpeed()/100;
    TripA_tx  = (uint16_t)Data_Read_Trip(EM_TRIP_A);
    p6EF = (CANMsg6EFUnion *)CopyData;
    if ( p6EF != ( void * )0 )
    {
        if(Power_KL30_Init_flag == 1)
        {
            for ( i = 0u; i < 8u; i++ )
            {
                p6EF->Msg [ i ] = 0x0u;
            }
            p6EF -> Sig.TripA_H    = (TripA_tx >> 8) & 0xFF;
            p6EF -> Sig.TripA_L    = TripA_tx  & 0xFF;
        }
        else
        {
            for ( i = 0u; i < 8u; i++ )
            {
                p6EF->Msg [ i ] = INVALID_VALUE;
            }
        }
        
    }
    //p6EF -> Sig.Espeed_TX  = Espeed_tx;
    
    //p6EF -> Sig.Coolant_TX = GET_DataCoolantTempValueDisp() + 40;
}
void Can_Set_Buff_450(canlib_uint8_t CopyData[])
{
    CANMsg450Union *p450;
    uint8_t i = 0;
    uint16_t u16FrontTpms = 0;
    uint16_t u16RearTpms = 0;

    uint16_t u16FrontTpmsValue = Get_Front_TPMS_TX();
    uint16_t u16RearTpmsValue = Get_Rear_TPMS_TX();    

    p450 = (CANMsg450Union *)CopyData;
    if ( p450 != ( void * )0 )
    {
        if(Power_KL30_Init_flag == 1)
        {
            for ( i = 0u; i < 8u; i++ )
            {
                p450->Msg [ i ] = 0x0u;
            }
            if(Get_Front_TPMS_Sig_Vaild() == 0\
                || Get_TPMS_Front_Learn() != 2 
                || CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x373_Msg_Count) == CAN_SIG_LOST\
                || Get_Front_TPMS_ID_Vaild() == 0)
            {
                p450 -> Sig.Front_Pressure_TX_H  = 0;
                p450 -> Sig.Front_Pressure_TX_L  = 0;
            }
            else
            {
                if((u16FrontTpmsValue + 146) <= 1000U)
                {
                    u16FrontTpms = (u16FrontTpmsValue + 146);
                }
                else
                {
                    u16FrontTpms = 1000U;
                }
                p450 -> Sig.Front_Pressure_TX_H  = ( u16FrontTpms >> 8) & 0xFF;
                p450 -> Sig.Front_Pressure_TX_L  = ( u16FrontTpms) & 0xFF;
            }
            if(Get_Rear_TPMS_Sig_Vaild() == 0\
                || Get_TPMS_Rear_Learn() != 2 
                || CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x373_Msg_Count) == CAN_SIG_LOST\
                || Get_Rear_TPMS_ID_Vaild() == 0)
            {
                p450 -> Sig.Rear_Pressure_TX_H   = 0;
                p450 -> Sig.Rear_Pressure_TX_L   = 0;
            }
            else
            {
                if((u16RearTpmsValue + 146) <= 1000U)
                {
                    u16RearTpms = (u16RearTpmsValue + 146);
                }
                else
                {
                    u16RearTpms = 1000U;
                }
                p450 -> Sig.Rear_Pressure_TX_H   = (u16RearTpms >> 8) & 0xFF;
                p450 -> Sig.Rear_Pressure_TX_L   = (u16RearTpms) & 0xFF;
            }
        }
        else
        {
            for ( i = 0u; i < 8u; i++ )
            {
                p450->Msg [ i ] = INVALID_VALUE;
            }
        }
        
        
    }
    
}
//uint8_t Can_580Send_flag = 0;
void Can_Set_Buff_580(canlib_uint8_t CopyData[])
{
    CANMsg580Union *p580;
    uint8_t i = 0;
    uint8_t u8TpmsFlag = Get_Tpms_TX_Flag() ;
    p580 = (CANMsg580Union *)CopyData;
    if ( p580 != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            p580->Msg [ i ] = 0x0u;
        }

        if(u8TpmsFlag == 1)
        {
            //Can_580Send_flag = 1;
            //if(CAN_TX_Count++ > 2)
            //{
            //    Tpms_TX_Flag = 0;
            //    CAN_TX_Count = 0;
            //    //Can_580Send_flag = 0;
            //}
            p580 -> Sig.TPMS_LEARN_CND_BYTE0 = 0x31;
            p580 -> Sig.TPMS_LEARN_CND_BYTE1 = 0x01;
            p580 -> Sig.TPMS_LEARN_CND_BYTE2 = 0x59;
            p580 -> Sig.TPMS_LEARN_CND_BYTE3 = 0x08;
            p580 -> Sig.TPMS_LEARN_CND_BYTE4 = 0x00;
            //if(Can_580Send_flag == 0)
            //{
            //    Can_580Send_flag = 1;
            //    CAN_TX_Count++;
            //}
        }
        else if(u8TpmsFlag == 2)
        {
            //Can_580Send_flag = 1;
            //if(CAN_TX_Count++ > 2)
            //{
            //    Tpms_TX_Flag = 0;
            //    CAN_TX_Count = 0;
            //    //Can_580Send_flag = 0;
            //}
            p580 -> Sig.TPMS_LEARN_CND_BYTE0 = 0x31;
            p580 -> Sig.TPMS_LEARN_CND_BYTE1 = 0x01;
            p580 -> Sig.TPMS_LEARN_CND_BYTE2 = 0x59;
            p580 -> Sig.TPMS_LEARN_CND_BYTE3 = 0x08;
            p580 -> Sig.TPMS_LEARN_CND_BYTE4 = 0x01;
            //if(Can_580Send_flag == 0)
            //{
            //    Can_580Send_flag = 1;
            //    CAN_TX_Count++;
            //}
        }
        else
        {
            //Can_580Send_flag = 0;
            //CAN_TX_Count = 0;
            //p580 -> Sig.TPMS_LEARN_CND_BYTE0 = 0x0;
            //p580 -> Sig.TPMS_LEARN_CND_BYTE1 = 0x0;
            //p580 -> Sig.TPMS_LEARN_CND_BYTE2 = 0x0;
            //p580 -> Sig.TPMS_LEARN_CND_BYTE3 = 0x0;
            //p580 -> Sig.TPMS_LEARN_CND_BYTE4 = 0x02;
        }
    }
    

}


