#ifndef __UART_DEMO_H__
#define __UART_DEMO_H__
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include "uart.h"
#include "gpio.h"
#include "isr.h"
#include "Application.h"
#define UART_MAX_RECV_LEN      256

extern unsigned char UART0_RX_BUF[UART_MAX_RECV_LEN];
extern unsigned short UART0_RX_STA ;
extern unsigned char UART0_TX_BUF[UART_MAX_RECV_LEN];

int8_t Uart0_Init(uint32_t bound);

void Uart0_Send(uint8_t ch);
char Uart0_Receive(void);

void Uart0_IntSend(uint8_t *tx_buf, uint16_t tx_num);
void uart0_interrupt_send(void *msg);
void uart0_interrupt_receive(void);
#endif
