
#include "Line_In\Line_In_user.h"
#include "Components.h"
#include "Application.h"


const Line_In_Attribute_st g_stLineInAttribute[LINE_IN_MAX] =
{
    {LEVEL_LOW,    LEVEL_HIGH,   LINE_IN_IG_ON,     20U,  20U,  Get_LINE_IN_TurnLeft,        },
    {LEVEL_LOW,    LEVEL_HIGH,   LINE_IN_IG_ON,     20U,  20U,  Get_LINE_IN_TurnRight,       },
    {LEVEL_HIGH,    LEVEL_LOW,   LINE_IN_IG_ON,     40U,  20U,  Get_LINE_IN_HighBeam,        },
    {LEVEL_HIGH,   LEVEL_LOW,    LINE_IN_IG_ON,     120U,  20U,  Get_LINE_IN_FAULT_ELECTROSPRAY, },
    {LEVEL_HIGH,   LEVEL_LOW,    LINE_IN_IG_ON,     170U,  20U,  Get_LINE_IN_Fault_ABS, },
    {LEVEL_HIGH,   LEVEL_LOW,    LINE_IN_IG_ON,     500U,  20U,  Get_LINE_IN_Oil_Pressure, },
    {LEVEL_HIGH,   LEVEL_LOW,    LINE_IN_IG_ON,     140U,  20U,  Get_LINE_IN_Auto_Start_Stop, },
    {LEVEL_LOW,    LEVEL_HIGH,   LINE_IN_IG_ON,     500U,  500U,  Get_LINE_IN_Little_Lamp, },
};

Linelib_uint8_t Get_LINE_IN_Little_Lamp(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(PositionBeam_P_IN))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}
Linelib_uint8_t Get_LINE_IN_TurnLeft(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(LeftTurn_P_In))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_TurnRight(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(RightTurn_P_In))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_HighBeam(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(HighBeam_P_In))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_FAULT_ELECTROSPRAY(void)
{
    Linelib_uint8_t ret = 0;
    if(RTE_GPIO_Get_Level(Fault_Diagnosis_IN))
    {
        ret = 1;
    }
    else
    {
        ret = 0;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_Fault_ABS(void)
{
    Linelib_uint8_t ret = 0;
    if(RTE_GPIO_Get_Level(Fault_ABS_IN))
    {
        ret = 1;
    }
    else
    {
        ret = 0;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_Oil_Pressure(void)
{
    Linelib_uint8_t ret = 0;
    if(RTE_GPIO_Get_Level(Oil_Pressure_IN))
    {
        ret = 1;
    }
    else
    {
        ret = 0;
    }
    return ret;
}


Linelib_uint8_t Get_LINE_IN_Auto_Start_Stop(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(Auto_StartStop_IN))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

__align(4)
Linelib_uint8_t LINE_IN_Men[LINE_IN_MAX * LINE_IN_BLOCK_SIZE];

static Linelib_uint16_t LINE_GET_PWR(void)
{
    Linelib_uint16_t Res;
    Res = Common_Get_IG_Sts() & 0x00FFu;
    return Res;
}

void LINE_IN_Init(void)
{
    memset(LINE_IN_Men, 0, sizeof(LINE_IN_Men));
    Line_In_KL30_WakeUp_Init(LINE_IN_Men, g_stLineInAttribute, LINE_IN_MAX, LINE_GET_PWR);
}
