#include "Application.h"
#include "Data_TPMS\Data_TPMS.h"

_TPMS_Display TPMS;
uint32_t LearnTime_Count = 0;
uint32_t LearnTime_Count1 = 0;
void Data_TPMS_KL30_Init ( void )
{
    uint8_t TPMS_L[2] = {0,0};
    Data_User_EEPROM_Read(EM_MenuData_TPMS_LEARN, (uint32_t*)TPMS_L, 1u);
    MenuData.TPMS_Front_Learn = TPMS_L[0];
    MenuData.TPMS_Rear_Learn  = TPMS_L[1];
    //MenuData.TPMS_Front_FirstLearn_Flag = TPMS_L[2];
    //MenuData.TPMS_Rear_FirstLearn_Flag  = TPMS_L[3];
    TPMS.Front_Press_Value = 0;
    TPMS.Rear_Press_Value  = 0;

    TPMS.Front_TPMS_Valid  = 0;
    TPMS.Rear_TPMS_Valid   = 0;
    TPMS.TPMS_Warning      = 0;
    //TPMS.TPMS_Unit         = Get_Dis_Tpms_Unit();
    TPMS.TPMS_Front_Learn  = MenuData.TPMS_Front_Learn;
    TPMS.TPMS_Rear_Learn   = MenuData.TPMS_Rear_Learn;
    TPMS.TPMS_Front_FirstLearn_Flag  = MenuData.TPMS_Front_FirstLearn_Flag;
    TPMS.TPMS_Rear_FirstLearn_Flag   = MenuData.TPMS_Rear_FirstLearn_Flag;

    TPMS.TPMS_LOST = 0;
    LearnTime_Count = 6001;
    LearnTime_Count1 = 6001;
}
void Data_TPMS_KL15_WAKE_UP_Init ( void )
{
    uint8_t TPMS_L[2] = {0,0};
    Data_User_EEPROM_Read(EM_MenuData_TPMS_LEARN, (uint32_t*)TPMS_L, 1);
    MenuData.TPMS_Front_Learn = TPMS_L[0];
    MenuData.TPMS_Rear_Learn  = TPMS_L[1];
    //MenuData.TPMS_Front_FirstLearn_Flag = TPMS_L[2];
    //MenuData.TPMS_Rear_FirstLearn_Flag  = TPMS_L[3];
    TPMS.TPMS_Front_Learn     = MenuData.TPMS_Front_Learn;
    TPMS.TPMS_Rear_Learn      = MenuData.TPMS_Rear_Learn;
    TPMS.TPMS_Front_FirstLearn_Flag  = MenuData.TPMS_Front_FirstLearn_Flag;
    TPMS.TPMS_Rear_FirstLearn_Flag   = MenuData.TPMS_Rear_FirstLearn_Flag;

    TPMS.TPMS_LOST = 0;
    LearnTime_Count = 6001;
    LearnTime_Count1 = 6001;
}

void Data_TPMS_Processing_Service ( void )
{
    uint16_t Front_TPMS = 0;
    uint16_t Rear_TPMS  = 0;
    uint8_t  TPMS_L[2] = {0,0};
    
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x341_Msg_Count) != CAN_SIG_LOST) 
    {
        TPMS.TPMS_Front_Learn = Get_CAN_CH0_ID_341_Sig_Front_LearningStatus();
        TPMS.TPMS_Rear_Learn = Get_CAN_CH0_ID_341_Sig_Rear_LearningStatus();
        TPMS.TPMS_LOST = 1;
    }
    else
    {
        TPMS.TPMS_Front_Learn = MenuData.TPMS_Front_Learn;
        TPMS.TPMS_Rear_Learn = MenuData.TPMS_Rear_Learn;
        TPMS.TPMS_LOST = 0;
    }
       
    
    if(TPMS.TPMS_Front_Learn == 0x0)
    {        
        //if(LearnTime_Count <= 6000)
        //{
        //    LearnTime_Count++;
            TPMS.TPMS_Front_Learn = Unstudied;
            LearnTime_Count = 0;
        //}
        //else
        //{
        //    if(TPMS.TPMS_Front_Timeclean == 1)
        //    {
        //        LearnTime_Count = 0;
        //    }
        //    TPMS.TPMS_Front_Timeclean = 0;  
        //    if ((MenuData.TPMS_Front_Learn != 0x2) && (MenuData.TPMS_Front_Learn != 0x3) ) 
        //    {
        //        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x341_Msg_Count) != CAN_SIG_LOST) 
        //        {
        //            TPMS.TPMS_Front_Learn = LearningFailure;
        //        }
        //        else
        //        {
        //            TPMS.TPMS_Front_Learn = MenuData.TPMS_Front_Learn;
        //        }
        //        
        //    }
        //    else
        //    {
        //        TPMS.TPMS_Front_Learn = MenuData.TPMS_Front_Learn;
        //    }
        //}
    }
    else if(TPMS.TPMS_Front_Learn == 0x1)
    { 
        //if(TPMS.TPMS_Front_Timeclean == 0)
        //{
        //    LearnTime_Count = 0;
        //}
        //TPMS.TPMS_Front_Timeclean = 1;        
        if(LearnTime_Count <= 6000)
        {
            LearnTime_Count++;
            TPMS.TPMS_Front_Learn = Learning;
        }
        else
        {
            if ((MenuData.TPMS_Front_Learn != 0x2) && (MenuData.TPMS_Front_Learn != 0x3) ) 
            {
                if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x341_Msg_Count) != CAN_SIG_LOST) 
                {
                    TPMS.TPMS_Front_Learn = LearningFailure;
                }
                else
                {
                    TPMS.TPMS_Front_Learn = MenuData.TPMS_Front_Learn;
                }
            }
            else
            {
                TPMS.TPMS_Front_Learn = MenuData.TPMS_Front_Learn;
            }
        }
    }
    else if (TPMS.TPMS_Front_Learn == 0x2)
    {
        LearnTime_Count = 0;
        if((Get_CAN_CH0_ID_373_Sig_Front_id() != 0) && (Get_CAN_CH0_ID_373_Sig_Front_id() != 0xFFFFFFFF))
        {
            TPMS.TPMS_Front_Learn = LearningCompletion;
        }
        else
        {
            ;
        }
        
    }
    else if (TPMS.TPMS_Front_Learn == 0x3)
    {
        LearnTime_Count = 0;
        TPMS.TPMS_Front_Learn = LearningFailure;
    }
    else
    {
        LearnTime_Count = 0;
        TPMS.TPMS_Front_Learn = MenuData.TPMS_Front_Learn;
    }

    if(TPMS.TPMS_Rear_Learn == 0x0)
    {        
        //if(LearnTime_Count1 <= 6000)
        //{
            LearnTime_Count1 = 0;
            TPMS.TPMS_Rear_Learn = Unstudied;
        //}
        //else
        //{
        //    if(TPMS.TPMS_Rear_Timeclean == 1)
        //    {
        //        LearnTime_Count1 = 0;
        //    }
        //    TPMS.TPMS_Rear_Timeclean = 0; 
        //    if ((MenuData.TPMS_Rear_Learn != 0x2) && (MenuData.TPMS_Rear_Learn != 0x3) ) 
        //    {
        //        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x341_Msg_Count) != CAN_SIG_LOST) 
        //        {
        //            TPMS.TPMS_Rear_Learn = LearningFailure;
        //        }
        //        else
        //        {
        //            TPMS.TPMS_Rear_Learn = MenuData.TPMS_Rear_Learn;
        //        }
        //    }
        //    else
        //    {
        //        TPMS.TPMS_Rear_Learn = MenuData.TPMS_Rear_Learn;
        //    }
        //}
    }
    else if(TPMS.TPMS_Rear_Learn == 0x1)
    {        
        if(LearnTime_Count1 <= 6000)
        {
            LearnTime_Count1++;
            TPMS.TPMS_Rear_Learn = Learning;
        }
        else
        {
            if(TPMS.TPMS_Rear_Timeclean == 0)
            {
                LearnTime_Count1 = 0;
            }
            TPMS.TPMS_Rear_Timeclean = 1; 
            if ((MenuData.TPMS_Rear_Learn != 0x2) && (MenuData.TPMS_Rear_Learn != 0x3) )
            {
                if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x341_Msg_Count) != CAN_SIG_LOST) 
                {
                    TPMS.TPMS_Rear_Learn = LearningFailure;
                }
                else
                {
                    TPMS.TPMS_Rear_Learn = MenuData.TPMS_Rear_Learn;
                }
            }
            else
            {
                TPMS.TPMS_Rear_Learn = MenuData.TPMS_Rear_Learn;
            }
        }
    }
    else if (TPMS.TPMS_Rear_Learn == 0x2)
    {
        LearnTime_Count1 = 0;
        if((Get_CAN_CH0_ID_373_Sig_Rear_id() != 0) && (Get_CAN_CH0_ID_373_Sig_Rear_id() != 0xFFFFFFFF))
        {
            TPMS.TPMS_Rear_Learn = LearningCompletion;
        }
        else
        {
            ;
        }
        
    }
    else if (TPMS.TPMS_Rear_Learn == 0x3)
    {
        LearnTime_Count1 = 0;
        TPMS.TPMS_Rear_Learn = LearningFailure;
    }
    else
    {
        LearnTime_Count1 = 0;
        TPMS.TPMS_Rear_Learn = MenuData.TPMS_Front_Learn;
    }
    

    if((TPMS.TPMS_Front_Learn != MenuData.TPMS_Front_Learn) || (TPMS.TPMS_Rear_Learn != MenuData.TPMS_Rear_Learn))
    {
        if(TPMS.TPMS_Front_Learn != MenuData.TPMS_Front_Learn)
        {
            TPMS.TPMS_Front_FirstLearn_Flag = 1;
        }
        if(TPMS.TPMS_Rear_Learn != MenuData.TPMS_Rear_Learn)
        {
            TPMS.TPMS_Rear_FirstLearn_Flag = 1;
        }
         
        if((TPMS.TPMS_Front_Learn == 0x2) || (TPMS.TPMS_Front_Learn == 0x3))
        {
            MenuData.TPMS_Front_Learn = TPMS.TPMS_Front_Learn;
        }
        if((TPMS.TPMS_Rear_Learn == 0x2) || (TPMS.TPMS_Rear_Learn == 0x3))
        {
            MenuData.TPMS_Rear_Learn  = TPMS.TPMS_Rear_Learn;
        }
        if((TPMS.TPMS_Front_Learn == 0x2) || (TPMS.TPMS_Front_Learn == 0x3) || (TPMS.TPMS_Rear_Learn == 0x2) || (TPMS.TPMS_Rear_Learn == 0x3))
        {
            TPMS_L[0] = MenuData.TPMS_Front_Learn;
            TPMS_L[1] = MenuData.TPMS_Rear_Learn;            
            Data_User_EEPROM_Write(EM_MenuData_TPMS_LEARN, (uint32_t*)TPMS_L, 1u); 
            
        }
        
    }

    //TPMS.TPMS_Unit      = Get_Dis_Tpms_Unit();
    Front_TPMS          = Get_CAN_CH0_ID_341_Sig_Front_Pressure();
    Rear_TPMS           = Get_CAN_CH0_ID_341_Sig_Rear_Pressure();

    if ( Common_Get_IG_Sts() == COMMON_POWER_ON )
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CAN_0x341_Msg_Count) == CAN_SIG_LOST)
        {
            TPMS.Front_TPMS_Valid  = 0;  //信号掉线，显示--
            TPMS.Rear_TPMS_Valid   = 0;  //信号掉线，显示--
            TPMS.Front_Press_Value = 0;
            TPMS.Rear_Press_Value  = 0;
            TPMS.TPMS_Warning      = 0;  //白灯
        }
        else
        {            
            if((Front_TPMS == 0xFF) || (Rear_TPMS == 0xFF))
            {
                
                if((Front_TPMS == 0xFF) && (Rear_TPMS != 0xFF))
                {
                    TPMS.Front_TPMS_Valid  = 0;
                    TPMS.Rear_TPMS_Valid   = 1;
                    TPMS.Front_Press_Value = 990;
                    TPMS.Rear_Press_Value  = Rear_TPMS * 2750;
                    TPMS.Rear_Press_Value  /= 102 ;
                    if(TPMS.Rear_Press_Value > 9900)
                    {
                        TPMS.Rear_Press_Value = 9900;
                    }
                    if(((TPMS.Rear_Press_Value + 50)< 1700) || ((TPMS.Rear_Press_Value + 50) > 2500))
                    {
                        TPMS.TPMS_Warning = 1;
                    }
                    else
                    {
                        TPMS.TPMS_Warning = 0;
                    }
                }
                else if ((Front_TPMS != 0xFF) && (Rear_TPMS == 0xFF))
                {
                    TPMS.Front_TPMS_Valid  = 1;
                    TPMS.Rear_TPMS_Valid   = 0;
                    TPMS.Rear_Press_Value  = 990;
                    TPMS.Front_Press_Value = Front_TPMS *2750 ;
                    TPMS.Front_Press_Value  /= 102 ;
                    if(TPMS.Front_Press_Value > 9900)
                    {
                        TPMS.Front_Press_Value = 9900;
                    }
                    if(((TPMS.Front_Press_Value + 50) < 1700) || ((TPMS.Front_Press_Value + 50) > 2300))
                    {
                        TPMS.TPMS_Warning = 1;
                    }
                    else
                    {
                        TPMS.TPMS_Warning = 0;
                    }
                }
                else
                {
                    TPMS.Front_Press_Value = 9900;
                    TPMS.Rear_Press_Value = 9900;
                    TPMS.TPMS_Warning = 0;
                    TPMS.Front_TPMS_Valid  = 0;
                    TPMS.Rear_TPMS_Valid   = 0;
                }
            }
            else
            {
                TPMS.Front_TPMS_Valid  = 1;
                TPMS.Rear_TPMS_Valid   = 1;
                TPMS.Front_Press_Value = Front_TPMS * 2750 ;                
                TPMS.Front_Press_Value  /= 102 ;
                if(TPMS.Front_Press_Value > 9900)
                {
                    TPMS.Front_Press_Value = 9900;
                }

                TPMS.Rear_Press_Value  = Rear_TPMS * 2750;                
                TPMS.Rear_Press_Value  /= 102 ;
                if(TPMS.Rear_Press_Value > 9900)
                {
                    TPMS.Rear_Press_Value = 9900;
                }
                if (((TPMS.Front_Press_Value + 50) < 1700) || ((TPMS.Front_Press_Value + 50) > 2300) || ((TPMS.Rear_Press_Value + 50) < 1700) || ((TPMS.Rear_Press_Value + 50) > 2500))
                {
                    TPMS.TPMS_Warning = 1;
                }
                else
                {
                    TPMS.TPMS_Warning = 0;
                }
            }
            
        }
        if(TPMS.TPMS_Front_Learn == Unstudied)
        {
            TPMS.TPMS_Front_FirstLearn_Flag = Unstudied;            
        }
        else if(TPMS.TPMS_Front_Learn == Learning)
        {
            TPMS.TPMS_Front_FirstLearn_Flag = Learning;            
        }
        else if(TPMS.TPMS_Front_Learn == LearningCompletion)
        {
            TPMS.TPMS_Front_FirstLearn_Flag = LearningCompletion;
            
        }
        else if(TPMS.TPMS_Front_Learn == LearningFailure)
        {
            TPMS.TPMS_Front_FirstLearn_Flag = LearningFailure;
            TPMS.Front_Press_Value = 9900;
        }
        else
        {
            ;
        }

        if(TPMS.TPMS_Rear_Learn == Unstudied)
        {
            TPMS.TPMS_Rear_FirstLearn_Flag = Unstudied;
        }
        else if(TPMS.TPMS_Rear_Learn == Learning)
        {
            TPMS.TPMS_Rear_FirstLearn_Flag = Learning;
        }
        else if(TPMS.TPMS_Rear_Learn == LearningCompletion)
        {
            TPMS.TPMS_Rear_FirstLearn_Flag = LearningCompletion;
            
        }
        else if(TPMS.TPMS_Rear_Learn == LearningFailure)
        {
            TPMS.TPMS_Rear_FirstLearn_Flag = LearningFailure;
            TPMS.Rear_Press_Value = 9900;
        }
        else
        {
            ;
        }

        //if ((MenuData.TPMS_Rear_Learn != LearningCompletion) && (MenuData.TPMS_Front_Learn != LearningCompletion))
        //{
        //    TPMS.TPMS_Warning = 0;
        //}

    }
    else
    {
        TPMS.Front_TPMS_Valid  = 0;
        TPMS.Rear_TPMS_Valid   = 0; 
        TPMS.Front_Press_Value = 0;
        TPMS.Rear_Press_Value  = 0;
        TPMS.TPMS_Warning      = 0; 
    }
}
uint32_t Data_Bar_To_Psi (uint32_t bar)
{
    uint32_t Bar = 0;
    Bar = bar * 145;
    Bar /= 10;
    //Bar += 5;
    // bar *= 145;
    // bar /= 10;
    // bar += 5;    
    return Bar;
}

/*指示灯报警信号  0：白色常亮   1：黄色常亮*/
uint8_t Get_Led_TPMS_Waring (void)
{
    return TPMS.TPMS_Warning;
}

/*0：无效，常显--  1：有效，按实际胎压数值显示  */
uint8_t Get_Front_TPMS_Sig_Vaild (void)
{
    return TPMS.Front_TPMS_Valid;
}
uint8_t Get_Rear_TPMS_Sig_Vaild (void)
{
    return TPMS.Rear_TPMS_Valid;
}
//10倍
uint16_t Get_Front_TPMS_Sig_Value (void)
{
    uint16_t value = 0;
    //if (TPMS.TPMS_Unit == 1)
    //{
    //    value = (Data_Bar_To_Psi(TPMS.Front_Press_Value) + 500) / 1000;
    //    if(value > 99)
    //    {
    //        value = 99;
    //    }
    //}
    //else
    {        
        value = TPMS.Front_Press_Value + 50;        
        value = value / 100;
    }
    return value;
}
uint16_t Get_Rear_TPMS_Sig_Value (void)
{
    uint16_t value = 0;
    //if (TPMS.TPMS_Unit == 1)
    //{
    //    value = (Data_Bar_To_Psi(TPMS.Rear_Press_Value) + 500) / 1000;
    //    if(value > 99)
    //    {
    //        value = 99;
    //    }
    //    
    //}
    //else
    {        
        value = TPMS.Rear_Press_Value + 50;        
        value = value / 100;        
    }
    return value;    
}
uint16_t Get_Rear_TPMS_TX (void)
{
    uint16_t value = 0;
    value = Data_Bar_To_Psi(TPMS.Rear_Press_Value) / 100;
    if(value > 990)
    {
        value = 990;
    }
    return value;
}
uint16_t Get_Front_TPMS_TX (void)
{
    uint16_t value = 0;
    value = Data_Bar_To_Psi(TPMS.Front_Press_Value) / 100;
    if(value > 990)
    {
        value = 990;
    }
    return value;
}

/*前轮胎压学习结果 0-未学习“--”常显  1-学习中“--”闪烁  2-学习成功，正常显示数值  3-学习失败，闪烁显示最大值99*/
uint8_t Get_Front_FirstLearn_Flag (void)
{
    return TPMS.TPMS_Front_FirstLearn_Flag;
}
/*后轮胎压学习结果 0-未学习“--”常显  1-学习中“--”闪烁  2-学习成功，正常显示数值  3-学习失败，闪烁显示最大值99*/
uint8_t Get_Rear_FirstLearn_Flag (void)
{
    return TPMS.TPMS_Rear_FirstLearn_Flag;
}

/*获取0x341是否掉线  0-掉线  “--”闪烁   1-在线  获取学习结果进行显示*/
uint8_t Get_TPMS_CAN_LOST (void)
{
    return TPMS.TPMS_LOST ;
}

