#ifndef _CAN_APP_H_
#define _CAN_APP_H_

#include "RTE.h"
#include "Application.h"
#include "Components.h"


typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint32_t Res0 : 3;
        uint32_t TCS_TX : 1;
        uint32_t Res1: 4;

        uint32_t Res2: 8;
        uint32_t Res3: 16;
        uint32_t Res4: 32;
       
    } Sig;
} CANMsg220Union;
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint32_t Coolant_Seg_TX  : 4;
        uint32_t Fuel_Seg_TX     : 4;

        uint32_t Res0            : 8;

        uint32_t Fuel_Res_TX     : 8;

        uint32_t Vsppe_H3_TX     : 3;
        uint32_t Res1            : 1;
        uint32_t Coolant_Warn_TX : 1;
        uint32_t Res2            : 2;
        uint32_t Uint_TX         : 1;

        uint32_t Vsppe_L8_TX     : 8;

        uint32_t ODO_TX_H        : 8;
        uint32_t ODO_TX_M        : 8;
        uint32_t ODO_TX_L        : 8;
       
    } Sig;
} CANMsg6EEUnion;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint32_t Espeed_TX       : 8;

        uint32_t Coolant_TX      : 8;

        uint32_t TripA_H         : 8;
        uint32_t TripA_L         : 8;

        uint32_t TripB           : 16;

        uint32_t Res1            : 16;        
       
    } Sig;
} CANMsg6EFUnion;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint16_t Front_Pressure_TX_H      : 8;
        uint16_t Front_Pressure_TX_L      : 8;
        uint16_t Rear_Pressure_TX_H       : 8;
        uint16_t Rear_Pressure_TX_L       : 8;
        //uint32_t Front_Air_Leakage_TX   : 1;
        //uint32_t Rear_Air_Leakage_TX    : 1;
        //uint32_t Front_Low_Voltage_TX   : 1;
        //uint32_t Rear_Low_Voltage_TX    : 1;
        //uint32_t Front_High_Temp_TX     : 1;
        //uint32_t Rear_High_Temp_TX      : 1;
        //uint32_t Res0                   : 2;

        uint32_t Res1                   : 32;
        
    } Sig;
} CANMsg450Union;




void Can_Set_Buff_220(canlib_uint8_t CopyData[]);
void Can_Set_Buff_6EE(canlib_uint8_t CopyData[]);
void Can_Set_Buff_6EF(canlib_uint8_t CopyData[]);
void Can_Set_Buff_450(canlib_uint8_t CopyData[]);


#endif
